/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides aggregated data for an Amazon Macie usage metric. The value for the metric reports estimated usage data for
 * an account for the preceding 30 days or the current calendar month to date, depending on the time period (timeRange)
 * specified in the request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UsageTotal implements SdkPojo, Serializable, ToCopyableBuilder<UsageTotal.Builder, UsageTotal> {
    private static final SdkField<String> CURRENCY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("currency").getter(getter(UsageTotal::currencyAsString)).setter(setter(Builder::currency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currency").build()).build();

    private static final SdkField<String> ESTIMATED_COST_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("estimatedCost").getter(getter(UsageTotal::estimatedCost)).setter(setter(Builder::estimatedCost))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("estimatedCost").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(UsageTotal::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CURRENCY_FIELD,
            ESTIMATED_COST_FIELD, TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String currency;

    private final String estimatedCost;

    private final String type;

    private UsageTotal(BuilderImpl builder) {
        this.currency = builder.currency;
        this.estimatedCost = builder.estimatedCost;
        this.type = builder.type;
    }

    /**
     * <p>
     * The type of currency that the value for the metric (estimatedCost) is reported in.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #currency} will
     * return {@link Currency#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #currencyAsString}.
     * </p>
     * 
     * @return The type of currency that the value for the metric (estimatedCost) is reported in.
     * @see Currency
     */
    public final Currency currency() {
        return Currency.fromValue(currency);
    }

    /**
     * <p>
     * The type of currency that the value for the metric (estimatedCost) is reported in.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #currency} will
     * return {@link Currency#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #currencyAsString}.
     * </p>
     * 
     * @return The type of currency that the value for the metric (estimatedCost) is reported in.
     * @see Currency
     */
    public final String currencyAsString() {
        return currency;
    }

    /**
     * <p>
     * The estimated value for the metric.
     * </p>
     * 
     * @return The estimated value for the metric.
     */
    public final String estimatedCost() {
        return estimatedCost;
    }

    /**
     * <p>
     * The name of the metric. Possible values are: DATA_INVENTORY_EVALUATION, for monitoring S3 buckets; and,
     * SENSITIVE_DATA_DISCOVERY, for analyzing S3 objects to detect sensitive data.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link UsageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The name of the metric. Possible values are: DATA_INVENTORY_EVALUATION, for monitoring S3 buckets; and,
     *         SENSITIVE_DATA_DISCOVERY, for analyzing S3 objects to detect sensitive data.
     * @see UsageType
     */
    public final UsageType type() {
        return UsageType.fromValue(type);
    }

    /**
     * <p>
     * The name of the metric. Possible values are: DATA_INVENTORY_EVALUATION, for monitoring S3 buckets; and,
     * SENSITIVE_DATA_DISCOVERY, for analyzing S3 objects to detect sensitive data.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link UsageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The name of the metric. Possible values are: DATA_INVENTORY_EVALUATION, for monitoring S3 buckets; and,
     *         SENSITIVE_DATA_DISCOVERY, for analyzing S3 objects to detect sensitive data.
     * @see UsageType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(currencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedCost());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UsageTotal)) {
            return false;
        }
        UsageTotal other = (UsageTotal) obj;
        return Objects.equals(currencyAsString(), other.currencyAsString())
                && Objects.equals(estimatedCost(), other.estimatedCost()) && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UsageTotal").add("Currency", currencyAsString()).add("EstimatedCost", estimatedCost())
                .add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "currency":
            return Optional.ofNullable(clazz.cast(currencyAsString()));
        case "estimatedCost":
            return Optional.ofNullable(clazz.cast(estimatedCost()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UsageTotal, T> g) {
        return obj -> g.apply((UsageTotal) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UsageTotal> {
        /**
         * <p>
         * The type of currency that the value for the metric (estimatedCost) is reported in.
         * </p>
         * 
         * @param currency
         *        The type of currency that the value for the metric (estimatedCost) is reported in.
         * @see Currency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Currency
         */
        Builder currency(String currency);

        /**
         * <p>
         * The type of currency that the value for the metric (estimatedCost) is reported in.
         * </p>
         * 
         * @param currency
         *        The type of currency that the value for the metric (estimatedCost) is reported in.
         * @see Currency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Currency
         */
        Builder currency(Currency currency);

        /**
         * <p>
         * The estimated value for the metric.
         * </p>
         * 
         * @param estimatedCost
         *        The estimated value for the metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedCost(String estimatedCost);

        /**
         * <p>
         * The name of the metric. Possible values are: DATA_INVENTORY_EVALUATION, for monitoring S3 buckets; and,
         * SENSITIVE_DATA_DISCOVERY, for analyzing S3 objects to detect sensitive data.
         * </p>
         * 
         * @param type
         *        The name of the metric. Possible values are: DATA_INVENTORY_EVALUATION, for monitoring S3 buckets;
         *        and, SENSITIVE_DATA_DISCOVERY, for analyzing S3 objects to detect sensitive data.
         * @see UsageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UsageType
         */
        Builder type(String type);

        /**
         * <p>
         * The name of the metric. Possible values are: DATA_INVENTORY_EVALUATION, for monitoring S3 buckets; and,
         * SENSITIVE_DATA_DISCOVERY, for analyzing S3 objects to detect sensitive data.
         * </p>
         * 
         * @param type
         *        The name of the metric. Possible values are: DATA_INVENTORY_EVALUATION, for monitoring S3 buckets;
         *        and, SENSITIVE_DATA_DISCOVERY, for analyzing S3 objects to detect sensitive data.
         * @see UsageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UsageType
         */
        Builder type(UsageType type);
    }

    static final class BuilderImpl implements Builder {
        private String currency;

        private String estimatedCost;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(UsageTotal model) {
            currency(model.currency);
            estimatedCost(model.estimatedCost);
            type(model.type);
        }

        public final String getCurrency() {
            return currency;
        }

        public final void setCurrency(String currency) {
            this.currency = currency;
        }

        @Override
        @Transient
        public final Builder currency(String currency) {
            this.currency = currency;
            return this;
        }

        @Override
        @Transient
        public final Builder currency(Currency currency) {
            this.currency(currency == null ? null : currency.toString());
            return this;
        }

        public final String getEstimatedCost() {
            return estimatedCost;
        }

        public final void setEstimatedCost(String estimatedCost) {
            this.estimatedCost = estimatedCost;
        }

        @Override
        @Transient
        public final Builder estimatedCost(String estimatedCost) {
            this.estimatedCost = estimatedCost;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        @Transient
        public final Builder type(UsageType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public UsageTotal build() {
            return new UsageTotal(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
