/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about an action that occurred for a resource and produced a policy finding.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FindingAction implements SdkPojo, Serializable, ToCopyableBuilder<FindingAction.Builder, FindingAction> {
    private static final SdkField<String> ACTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("actionType").getter(getter(FindingAction::actionTypeAsString)).setter(setter(Builder::actionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionType").build()).build();

    private static final SdkField<ApiCallDetails> API_CALL_DETAILS_FIELD = SdkField
            .<ApiCallDetails> builder(MarshallingType.SDK_POJO).memberName("apiCallDetails")
            .getter(getter(FindingAction::apiCallDetails)).setter(setter(Builder::apiCallDetails))
            .constructor(ApiCallDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiCallDetails").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_TYPE_FIELD,
            API_CALL_DETAILS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String actionType;

    private final ApiCallDetails apiCallDetails;

    private FindingAction(BuilderImpl builder) {
        this.actionType = builder.actionType;
        this.apiCallDetails = builder.apiCallDetails;
    }

    /**
     * <p>
     * The type of action that occurred for the affected resource. This value is typically AWS_API_CALL, which indicates
     * that an entity invoked an API operation for the resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #actionType} will
     * return {@link FindingActionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionTypeAsString}.
     * </p>
     * 
     * @return The type of action that occurred for the affected resource. This value is typically AWS_API_CALL, which
     *         indicates that an entity invoked an API operation for the resource.
     * @see FindingActionType
     */
    public final FindingActionType actionType() {
        return FindingActionType.fromValue(actionType);
    }

    /**
     * <p>
     * The type of action that occurred for the affected resource. This value is typically AWS_API_CALL, which indicates
     * that an entity invoked an API operation for the resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #actionType} will
     * return {@link FindingActionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionTypeAsString}.
     * </p>
     * 
     * @return The type of action that occurred for the affected resource. This value is typically AWS_API_CALL, which
     *         indicates that an entity invoked an API operation for the resource.
     * @see FindingActionType
     */
    public final String actionTypeAsString() {
        return actionType;
    }

    /**
     * <p>
     * The invocation details of the API operation that an entity invoked for the affected resource, if the value for
     * the actionType property is AWS_API_CALL.
     * </p>
     * 
     * @return The invocation details of the API operation that an entity invoked for the affected resource, if the
     *         value for the actionType property is AWS_API_CALL.
     */
    public final ApiCallDetails apiCallDetails() {
        return apiCallDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(apiCallDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FindingAction)) {
            return false;
        }
        FindingAction other = (FindingAction) obj;
        return Objects.equals(actionTypeAsString(), other.actionTypeAsString())
                && Objects.equals(apiCallDetails(), other.apiCallDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FindingAction").add("ActionType", actionTypeAsString()).add("ApiCallDetails", apiCallDetails())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "actionType":
            return Optional.ofNullable(clazz.cast(actionTypeAsString()));
        case "apiCallDetails":
            return Optional.ofNullable(clazz.cast(apiCallDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FindingAction, T> g) {
        return obj -> g.apply((FindingAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FindingAction> {
        /**
         * <p>
         * The type of action that occurred for the affected resource. This value is typically AWS_API_CALL, which
         * indicates that an entity invoked an API operation for the resource.
         * </p>
         * 
         * @param actionType
         *        The type of action that occurred for the affected resource. This value is typically AWS_API_CALL,
         *        which indicates that an entity invoked an API operation for the resource.
         * @see FindingActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FindingActionType
         */
        Builder actionType(String actionType);

        /**
         * <p>
         * The type of action that occurred for the affected resource. This value is typically AWS_API_CALL, which
         * indicates that an entity invoked an API operation for the resource.
         * </p>
         * 
         * @param actionType
         *        The type of action that occurred for the affected resource. This value is typically AWS_API_CALL,
         *        which indicates that an entity invoked an API operation for the resource.
         * @see FindingActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FindingActionType
         */
        Builder actionType(FindingActionType actionType);

        /**
         * <p>
         * The invocation details of the API operation that an entity invoked for the affected resource, if the value
         * for the actionType property is AWS_API_CALL.
         * </p>
         * 
         * @param apiCallDetails
         *        The invocation details of the API operation that an entity invoked for the affected resource, if the
         *        value for the actionType property is AWS_API_CALL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiCallDetails(ApiCallDetails apiCallDetails);

        /**
         * <p>
         * The invocation details of the API operation that an entity invoked for the affected resource, if the value
         * for the actionType property is AWS_API_CALL.
         * </p>
         * This is a convenience method that creates an instance of the {@link ApiCallDetails.Builder} avoiding the need
         * to create one manually via {@link ApiCallDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link ApiCallDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #apiCallDetails(ApiCallDetails)}.
         * 
         * @param apiCallDetails
         *        a consumer that will call methods on {@link ApiCallDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #apiCallDetails(ApiCallDetails)
         */
        default Builder apiCallDetails(Consumer<ApiCallDetails.Builder> apiCallDetails) {
            return apiCallDetails(ApiCallDetails.builder().applyMutation(apiCallDetails).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String actionType;

        private ApiCallDetails apiCallDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(FindingAction model) {
            actionType(model.actionType);
            apiCallDetails(model.apiCallDetails);
        }

        public final String getActionType() {
            return actionType;
        }

        public final void setActionType(String actionType) {
            this.actionType = actionType;
        }

        @Override
        public final Builder actionType(String actionType) {
            this.actionType = actionType;
            return this;
        }

        @Override
        public final Builder actionType(FindingActionType actionType) {
            this.actionType(actionType == null ? null : actionType.toString());
            return this;
        }

        public final ApiCallDetails.Builder getApiCallDetails() {
            return apiCallDetails != null ? apiCallDetails.toBuilder() : null;
        }

        public final void setApiCallDetails(ApiCallDetails.BuilderImpl apiCallDetails) {
            this.apiCallDetails = apiCallDetails != null ? apiCallDetails.build() : null;
        }

        @Override
        public final Builder apiCallDetails(ApiCallDetails apiCallDetails) {
            this.apiCallDetails = apiCallDetails;
            return this;
        }

        @Override
        public FindingAction build() {
            return new FindingAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
