/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies which S3 buckets contain the objects that a classification job analyzes, and the scope of that analysis.
 * The bucket specification can be static (bucketDefinitions) or dynamic (bucketCriteria). If it's static, the job
 * analyzes objects in the same predefined set of buckets each time the job runs. If it's dynamic, the job analyzes
 * objects in any buckets that match the specified criteria each time the job starts to run.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3JobDefinition implements SdkPojo, Serializable, ToCopyableBuilder<S3JobDefinition.Builder, S3JobDefinition> {
    private static final SdkField<List<S3BucketDefinitionForJob>> BUCKET_DEFINITIONS_FIELD = SdkField
            .<List<S3BucketDefinitionForJob>> builder(MarshallingType.LIST)
            .memberName("bucketDefinitions")
            .getter(getter(S3JobDefinition::bucketDefinitions))
            .setter(setter(Builder::bucketDefinitions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketDefinitions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<S3BucketDefinitionForJob> builder(MarshallingType.SDK_POJO)
                                            .constructor(S3BucketDefinitionForJob::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Scoping> SCOPING_FIELD = SdkField.<Scoping> builder(MarshallingType.SDK_POJO)
            .memberName("scoping").getter(getter(S3JobDefinition::scoping)).setter(setter(Builder::scoping))
            .constructor(Scoping::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scoping").build()).build();

    private static final SdkField<S3BucketCriteriaForJob> BUCKET_CRITERIA_FIELD = SdkField
            .<S3BucketCriteriaForJob> builder(MarshallingType.SDK_POJO).memberName("bucketCriteria")
            .getter(getter(S3JobDefinition::bucketCriteria)).setter(setter(Builder::bucketCriteria))
            .constructor(S3BucketCriteriaForJob::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketCriteria").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_DEFINITIONS_FIELD,
            SCOPING_FIELD, BUCKET_CRITERIA_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<S3BucketDefinitionForJob> bucketDefinitions;

    private final Scoping scoping;

    private final S3BucketCriteriaForJob bucketCriteria;

    private S3JobDefinition(BuilderImpl builder) {
        this.bucketDefinitions = builder.bucketDefinitions;
        this.scoping = builder.scoping;
        this.bucketCriteria = builder.bucketCriteria;
    }

    /**
     * For responses, this returns true if the service returned a value for the BucketDefinitions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBucketDefinitions() {
        return bucketDefinitions != null && !(bucketDefinitions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects, one for each Amazon Web Services account that owns specific S3 buckets to analyze. Each
     * object specifies the account ID for an account and one or more buckets to analyze for that account. A job's
     * definition can contain a bucketDefinitions array or a bucketCriteria object, not both.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBucketDefinitions} method.
     * </p>
     * 
     * @return An array of objects, one for each Amazon Web Services account that owns specific S3 buckets to analyze.
     *         Each object specifies the account ID for an account and one or more buckets to analyze for that account.
     *         A job's definition can contain a bucketDefinitions array or a bucketCriteria object, not both.
     */
    public final List<S3BucketDefinitionForJob> bucketDefinitions() {
        return bucketDefinitions;
    }

    /**
     * <p>
     * The property- and tag-based conditions that determine which S3 objects to include or exclude from the analysis.
     * Each time the job runs, the job uses these criteria to determine which objects to analyze.
     * </p>
     * 
     * @return The property- and tag-based conditions that determine which S3 objects to include or exclude from the
     *         analysis. Each time the job runs, the job uses these criteria to determine which objects to analyze.
     */
    public final Scoping scoping() {
        return scoping;
    }

    /**
     * <p>
     * The property- and tag-based conditions that determine which S3 buckets to include or exclude from the analysis.
     * Each time the job runs, the job uses these criteria to determine which buckets contain objects to analyze. A
     * job's definition can contain a bucketCriteria object or a bucketDefinitions array, not both.
     * </p>
     * 
     * @return The property- and tag-based conditions that determine which S3 buckets to include or exclude from the
     *         analysis. Each time the job runs, the job uses these criteria to determine which buckets contain objects
     *         to analyze. A job's definition can contain a bucketCriteria object or a bucketDefinitions array, not
     *         both.
     */
    public final S3BucketCriteriaForJob bucketCriteria() {
        return bucketCriteria;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasBucketDefinitions() ? bucketDefinitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(scoping());
        hashCode = 31 * hashCode + Objects.hashCode(bucketCriteria());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3JobDefinition)) {
            return false;
        }
        S3JobDefinition other = (S3JobDefinition) obj;
        return hasBucketDefinitions() == other.hasBucketDefinitions()
                && Objects.equals(bucketDefinitions(), other.bucketDefinitions()) && Objects.equals(scoping(), other.scoping())
                && Objects.equals(bucketCriteria(), other.bucketCriteria());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3JobDefinition").add("BucketDefinitions", hasBucketDefinitions() ? bucketDefinitions() : null)
                .add("Scoping", scoping()).add("BucketCriteria", bucketCriteria()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "bucketDefinitions":
            return Optional.ofNullable(clazz.cast(bucketDefinitions()));
        case "scoping":
            return Optional.ofNullable(clazz.cast(scoping()));
        case "bucketCriteria":
            return Optional.ofNullable(clazz.cast(bucketCriteria()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3JobDefinition, T> g) {
        return obj -> g.apply((S3JobDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3JobDefinition> {
        /**
         * <p>
         * An array of objects, one for each Amazon Web Services account that owns specific S3 buckets to analyze. Each
         * object specifies the account ID for an account and one or more buckets to analyze for that account. A job's
         * definition can contain a bucketDefinitions array or a bucketCriteria object, not both.
         * </p>
         * 
         * @param bucketDefinitions
         *        An array of objects, one for each Amazon Web Services account that owns specific S3 buckets to
         *        analyze. Each object specifies the account ID for an account and one or more buckets to analyze for
         *        that account. A job's definition can contain a bucketDefinitions array or a bucketCriteria object, not
         *        both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketDefinitions(Collection<S3BucketDefinitionForJob> bucketDefinitions);

        /**
         * <p>
         * An array of objects, one for each Amazon Web Services account that owns specific S3 buckets to analyze. Each
         * object specifies the account ID for an account and one or more buckets to analyze for that account. A job's
         * definition can contain a bucketDefinitions array or a bucketCriteria object, not both.
         * </p>
         * 
         * @param bucketDefinitions
         *        An array of objects, one for each Amazon Web Services account that owns specific S3 buckets to
         *        analyze. Each object specifies the account ID for an account and one or more buckets to analyze for
         *        that account. A job's definition can contain a bucketDefinitions array or a bucketCriteria object, not
         *        both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketDefinitions(S3BucketDefinitionForJob... bucketDefinitions);

        /**
         * <p>
         * An array of objects, one for each Amazon Web Services account that owns specific S3 buckets to analyze. Each
         * object specifies the account ID for an account and one or more buckets to analyze for that account. A job's
         * definition can contain a bucketDefinitions array or a bucketCriteria object, not both.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<S3BucketDefinitionForJob>.Builder}
         * avoiding the need to create one manually via {@link List<S3BucketDefinitionForJob>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<S3BucketDefinitionForJob>.Builder#build()} is called
         * immediately and its result is passed to {@link #bucketDefinitions(List<S3BucketDefinitionForJob>)}.
         * 
         * @param bucketDefinitions
         *        a consumer that will call methods on {@link List<S3BucketDefinitionForJob>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bucketDefinitions(List<S3BucketDefinitionForJob>)
         */
        Builder bucketDefinitions(Consumer<S3BucketDefinitionForJob.Builder>... bucketDefinitions);

        /**
         * <p>
         * The property- and tag-based conditions that determine which S3 objects to include or exclude from the
         * analysis. Each time the job runs, the job uses these criteria to determine which objects to analyze.
         * </p>
         * 
         * @param scoping
         *        The property- and tag-based conditions that determine which S3 objects to include or exclude from the
         *        analysis. Each time the job runs, the job uses these criteria to determine which objects to analyze.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scoping(Scoping scoping);

        /**
         * <p>
         * The property- and tag-based conditions that determine which S3 objects to include or exclude from the
         * analysis. Each time the job runs, the job uses these criteria to determine which objects to analyze.
         * </p>
         * This is a convenience method that creates an instance of the {@link Scoping.Builder} avoiding the need to
         * create one manually via {@link Scoping#builder()}.
         *
         * When the {@link Consumer} completes, {@link Scoping.Builder#build()} is called immediately and its result is
         * passed to {@link #scoping(Scoping)}.
         * 
         * @param scoping
         *        a consumer that will call methods on {@link Scoping.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scoping(Scoping)
         */
        default Builder scoping(Consumer<Scoping.Builder> scoping) {
            return scoping(Scoping.builder().applyMutation(scoping).build());
        }

        /**
         * <p>
         * The property- and tag-based conditions that determine which S3 buckets to include or exclude from the
         * analysis. Each time the job runs, the job uses these criteria to determine which buckets contain objects to
         * analyze. A job's definition can contain a bucketCriteria object or a bucketDefinitions array, not both.
         * </p>
         * 
         * @param bucketCriteria
         *        The property- and tag-based conditions that determine which S3 buckets to include or exclude from the
         *        analysis. Each time the job runs, the job uses these criteria to determine which buckets contain
         *        objects to analyze. A job's definition can contain a bucketCriteria object or a bucketDefinitions
         *        array, not both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketCriteria(S3BucketCriteriaForJob bucketCriteria);

        /**
         * <p>
         * The property- and tag-based conditions that determine which S3 buckets to include or exclude from the
         * analysis. Each time the job runs, the job uses these criteria to determine which buckets contain objects to
         * analyze. A job's definition can contain a bucketCriteria object or a bucketDefinitions array, not both.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3BucketCriteriaForJob.Builder} avoiding
         * the need to create one manually via {@link S3BucketCriteriaForJob#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3BucketCriteriaForJob.Builder#build()} is called immediately and
         * its result is passed to {@link #bucketCriteria(S3BucketCriteriaForJob)}.
         * 
         * @param bucketCriteria
         *        a consumer that will call methods on {@link S3BucketCriteriaForJob.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bucketCriteria(S3BucketCriteriaForJob)
         */
        default Builder bucketCriteria(Consumer<S3BucketCriteriaForJob.Builder> bucketCriteria) {
            return bucketCriteria(S3BucketCriteriaForJob.builder().applyMutation(bucketCriteria).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<S3BucketDefinitionForJob> bucketDefinitions = DefaultSdkAutoConstructList.getInstance();

        private Scoping scoping;

        private S3BucketCriteriaForJob bucketCriteria;

        private BuilderImpl() {
        }

        private BuilderImpl(S3JobDefinition model) {
            bucketDefinitions(model.bucketDefinitions);
            scoping(model.scoping);
            bucketCriteria(model.bucketCriteria);
        }

        public final List<S3BucketDefinitionForJob.Builder> getBucketDefinitions() {
            List<S3BucketDefinitionForJob.Builder> result = ___listOfS3BucketDefinitionForJobCopier
                    .copyToBuilder(this.bucketDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBucketDefinitions(Collection<S3BucketDefinitionForJob.BuilderImpl> bucketDefinitions) {
            this.bucketDefinitions = ___listOfS3BucketDefinitionForJobCopier.copyFromBuilder(bucketDefinitions);
        }

        @Override
        public final Builder bucketDefinitions(Collection<S3BucketDefinitionForJob> bucketDefinitions) {
            this.bucketDefinitions = ___listOfS3BucketDefinitionForJobCopier.copy(bucketDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bucketDefinitions(S3BucketDefinitionForJob... bucketDefinitions) {
            bucketDefinitions(Arrays.asList(bucketDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bucketDefinitions(Consumer<S3BucketDefinitionForJob.Builder>... bucketDefinitions) {
            bucketDefinitions(Stream.of(bucketDefinitions).map(c -> S3BucketDefinitionForJob.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Scoping.Builder getScoping() {
            return scoping != null ? scoping.toBuilder() : null;
        }

        public final void setScoping(Scoping.BuilderImpl scoping) {
            this.scoping = scoping != null ? scoping.build() : null;
        }

        @Override
        public final Builder scoping(Scoping scoping) {
            this.scoping = scoping;
            return this;
        }

        public final S3BucketCriteriaForJob.Builder getBucketCriteria() {
            return bucketCriteria != null ? bucketCriteria.toBuilder() : null;
        }

        public final void setBucketCriteria(S3BucketCriteriaForJob.BuilderImpl bucketCriteria) {
            this.bucketCriteria = bucketCriteria != null ? bucketCriteria.build() : null;
        }

        @Override
        public final Builder bucketCriteria(S3BucketCriteriaForJob bucketCriteria) {
            this.bucketCriteria = bucketCriteria;
            return this;
        }

        @Override
        public S3JobDefinition build() {
            return new S3JobDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
