/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutClassificationExportConfigurationRequest extends Macie2Request implements
        ToCopyableBuilder<PutClassificationExportConfigurationRequest.Builder, PutClassificationExportConfigurationRequest> {
    private static final SdkField<ClassificationExportConfiguration> CONFIGURATION_FIELD = SdkField
            .<ClassificationExportConfiguration> builder(MarshallingType.SDK_POJO).memberName("configuration")
            .getter(getter(PutClassificationExportConfigurationRequest::configuration)).setter(setter(Builder::configuration))
            .constructor(ClassificationExportConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_FIELD));

    private final ClassificationExportConfiguration configuration;

    private PutClassificationExportConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.configuration = builder.configuration;
    }

    /**
     * <p>
     * The location to store data classification results in, and the encryption settings to use when storing results in
     * that location.
     * </p>
     * 
     * @return The location to store data classification results in, and the encryption settings to use when storing
     *         results in that location.
     */
    public final ClassificationExportConfiguration configuration() {
        return configuration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutClassificationExportConfigurationRequest)) {
            return false;
        }
        PutClassificationExportConfigurationRequest other = (PutClassificationExportConfigurationRequest) obj;
        return Objects.equals(configuration(), other.configuration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutClassificationExportConfigurationRequest").add("Configuration", configuration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutClassificationExportConfigurationRequest, T> g) {
        return obj -> g.apply((PutClassificationExportConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Macie2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, PutClassificationExportConfigurationRequest> {
        /**
         * <p>
         * The location to store data classification results in, and the encryption settings to use when storing results
         * in that location.
         * </p>
         * 
         * @param configuration
         *        The location to store data classification results in, and the encryption settings to use when storing
         *        results in that location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(ClassificationExportConfiguration configuration);

        /**
         * <p>
         * The location to store data classification results in, and the encryption settings to use when storing results
         * in that location.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ClassificationExportConfiguration.Builder} avoiding the need to create one manually via
         * {@link ClassificationExportConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link ClassificationExportConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #configuration(ClassificationExportConfiguration)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link ClassificationExportConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(ClassificationExportConfiguration)
         */
        default Builder configuration(Consumer<ClassificationExportConfiguration.Builder> configuration) {
            return configuration(ClassificationExportConfiguration.builder().applyMutation(configuration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Macie2Request.BuilderImpl implements Builder {
        private ClassificationExportConfiguration configuration;

        private BuilderImpl() {
        }

        private BuilderImpl(PutClassificationExportConfigurationRequest model) {
            super(model);
            configuration(model.configuration);
        }

        public final ClassificationExportConfiguration.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        public final void setConfiguration(ClassificationExportConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(ClassificationExportConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutClassificationExportConfigurationRequest build() {
            return new PutClassificationExportConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
