/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the details of a finding.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Finding implements SdkPojo, Serializable, ToCopyableBuilder<Finding.Builder, Finding> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accountId").getter(getter(Finding::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()).build();

    private static final SdkField<Boolean> ARCHIVED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("archived").getter(getter(Finding::archived)).setter(setter(Builder::archived))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("archived").build()).build();

    private static final SdkField<String> CATEGORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("category").getter(getter(Finding::categoryAsString)).setter(setter(Builder::category))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("category").build()).build();

    private static final SdkField<ClassificationDetails> CLASSIFICATION_DETAILS_FIELD = SdkField
            .<ClassificationDetails> builder(MarshallingType.SDK_POJO).memberName("classificationDetails")
            .getter(getter(Finding::classificationDetails)).setter(setter(Builder::classificationDetails))
            .constructor(ClassificationDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("classificationDetails").build())
            .build();

    private static final SdkField<Long> COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("count")
            .getter(getter(Finding::count)).setter(setter(Builder::count))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("count").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(Finding::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(Finding::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(Finding::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> PARTITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("partition").getter(getter(Finding::partition)).setter(setter(Builder::partition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("partition").build()).build();

    private static final SdkField<PolicyDetails> POLICY_DETAILS_FIELD = SdkField
            .<PolicyDetails> builder(MarshallingType.SDK_POJO).memberName("policyDetails").getter(getter(Finding::policyDetails))
            .setter(setter(Builder::policyDetails)).constructor(PolicyDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyDetails").build()).build();

    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("region")
            .getter(getter(Finding::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()).build();

    private static final SdkField<ResourcesAffected> RESOURCES_AFFECTED_FIELD = SdkField
            .<ResourcesAffected> builder(MarshallingType.SDK_POJO).memberName("resourcesAffected")
            .getter(getter(Finding::resourcesAffected)).setter(setter(Builder::resourcesAffected))
            .constructor(ResourcesAffected::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourcesAffected").build()).build();

    private static final SdkField<Boolean> SAMPLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("sample").getter(getter(Finding::sample)).setter(setter(Builder::sample))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sample").build()).build();

    private static final SdkField<String> SCHEMA_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("schemaVersion").getter(getter(Finding::schemaVersion)).setter(setter(Builder::schemaVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schemaVersion").build()).build();

    private static final SdkField<Severity> SEVERITY_FIELD = SdkField.<Severity> builder(MarshallingType.SDK_POJO)
            .memberName("severity").getter(getter(Finding::severity)).setter(setter(Builder::severity))
            .constructor(Severity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("severity").build()).build();

    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("title")
            .getter(getter(Finding::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(Finding::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt")
            .getter(getter(Finding::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            ARCHIVED_FIELD, CATEGORY_FIELD, CLASSIFICATION_DETAILS_FIELD, COUNT_FIELD, CREATED_AT_FIELD, DESCRIPTION_FIELD,
            ID_FIELD, PARTITION_FIELD, POLICY_DETAILS_FIELD, REGION_FIELD, RESOURCES_AFFECTED_FIELD, SAMPLE_FIELD,
            SCHEMA_VERSION_FIELD, SEVERITY_FIELD, TITLE_FIELD, TYPE_FIELD, UPDATED_AT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String accountId;

    private final Boolean archived;

    private final String category;

    private final ClassificationDetails classificationDetails;

    private final Long count;

    private final Instant createdAt;

    private final String description;

    private final String id;

    private final String partition;

    private final PolicyDetails policyDetails;

    private final String region;

    private final ResourcesAffected resourcesAffected;

    private final Boolean sample;

    private final String schemaVersion;

    private final Severity severity;

    private final String title;

    private final String type;

    private final Instant updatedAt;

    private Finding(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.archived = builder.archived;
        this.category = builder.category;
        this.classificationDetails = builder.classificationDetails;
        this.count = builder.count;
        this.createdAt = builder.createdAt;
        this.description = builder.description;
        this.id = builder.id;
        this.partition = builder.partition;
        this.policyDetails = builder.policyDetails;
        this.region = builder.region;
        this.resourcesAffected = builder.resourcesAffected;
        this.sample = builder.sample;
        this.schemaVersion = builder.schemaVersion;
        this.severity = builder.severity;
        this.title = builder.title;
        this.type = builder.type;
        this.updatedAt = builder.updatedAt;
    }

    /**
     * <p>
     * The unique identifier for the Amazon Web Services account that the finding applies to. This is typically the
     * account that owns the affected resource.
     * </p>
     * 
     * @return The unique identifier for the Amazon Web Services account that the finding applies to. This is typically
     *         the account that owns the affected resource.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * Specifies whether the finding is archived (suppressed).
     * </p>
     * 
     * @return Specifies whether the finding is archived (suppressed).
     */
    public final Boolean archived() {
        return archived;
    }

    /**
     * <p>
     * The category of the finding. Possible values are: CLASSIFICATION, for a sensitive data finding; and, POLICY, for
     * a policy finding.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #category} will
     * return {@link FindingCategory#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #categoryAsString}.
     * </p>
     * 
     * @return The category of the finding. Possible values are: CLASSIFICATION, for a sensitive data finding; and,
     *         POLICY, for a policy finding.
     * @see FindingCategory
     */
    public final FindingCategory category() {
        return FindingCategory.fromValue(category);
    }

    /**
     * <p>
     * The category of the finding. Possible values are: CLASSIFICATION, for a sensitive data finding; and, POLICY, for
     * a policy finding.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #category} will
     * return {@link FindingCategory#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #categoryAsString}.
     * </p>
     * 
     * @return The category of the finding. Possible values are: CLASSIFICATION, for a sensitive data finding; and,
     *         POLICY, for a policy finding.
     * @see FindingCategory
     */
    public final String categoryAsString() {
        return category;
    }

    /**
     * <p>
     * The details of a sensitive data finding. This value is null for a policy finding.
     * </p>
     * 
     * @return The details of a sensitive data finding. This value is null for a policy finding.
     */
    public final ClassificationDetails classificationDetails() {
        return classificationDetails;
    }

    /**
     * <p>
     * The total number of occurrences of the finding. For sensitive data findings, this value is always 1. All
     * sensitive data findings are considered new (unique) because they derive from individual classification jobs.
     * </p>
     * 
     * @return The total number of occurrences of the finding. For sensitive data findings, this value is always 1. All
     *         sensitive data findings are considered new (unique) because they derive from individual classification
     *         jobs.
     */
    public final Long count() {
        return count;
    }

    /**
     * <p>
     * The date and time, in UTC and extended ISO 8601 format, when the finding was created.
     * </p>
     * 
     * @return The date and time, in UTC and extended ISO 8601 format, when the finding was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The description of the finding.
     * </p>
     * 
     * @return The description of the finding.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The unique identifier for the finding. This is a random string that Amazon Macie generates and assigns to a
     * finding when it creates the finding.
     * </p>
     * 
     * @return The unique identifier for the finding. This is a random string that Amazon Macie generates and assigns to
     *         a finding when it creates the finding.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The Amazon Web Services partition that Amazon Macie created the finding in.
     * </p>
     * 
     * @return The Amazon Web Services partition that Amazon Macie created the finding in.
     */
    public final String partition() {
        return partition;
    }

    /**
     * <p>
     * The details of a policy finding. This value is null for a sensitive data finding.
     * </p>
     * 
     * @return The details of a policy finding. This value is null for a sensitive data finding.
     */
    public final PolicyDetails policyDetails() {
        return policyDetails;
    }

    /**
     * <p>
     * The Amazon Web Services Region that Amazon Macie created the finding in.
     * </p>
     * 
     * @return The Amazon Web Services Region that Amazon Macie created the finding in.
     */
    public final String region() {
        return region;
    }

    /**
     * <p>
     * The resources that the finding applies to.
     * </p>
     * 
     * @return The resources that the finding applies to.
     */
    public final ResourcesAffected resourcesAffected() {
        return resourcesAffected;
    }

    /**
     * <p>
     * Specifies whether the finding is a sample finding. A <i>sample finding</i> is a finding that uses example data to
     * demonstrate what a finding might contain.
     * </p>
     * 
     * @return Specifies whether the finding is a sample finding. A <i>sample finding</i> is a finding that uses example
     *         data to demonstrate what a finding might contain.
     */
    public final Boolean sample() {
        return sample;
    }

    /**
     * <p>
     * The version of the schema that was used to define the data structures in the finding.
     * </p>
     * 
     * @return The version of the schema that was used to define the data structures in the finding.
     */
    public final String schemaVersion() {
        return schemaVersion;
    }

    /**
     * <p>
     * The severity level and score for the finding.
     * </p>
     * 
     * @return The severity level and score for the finding.
     */
    public final Severity severity() {
        return severity;
    }

    /**
     * <p>
     * The brief description of the finding.
     * </p>
     * 
     * @return The brief description of the finding.
     */
    public final String title() {
        return title;
    }

    /**
     * <p>
     * The type of the finding.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link FindingType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the finding.
     * @see FindingType
     */
    public final FindingType type() {
        return FindingType.fromValue(type);
    }

    /**
     * <p>
     * The type of the finding.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link FindingType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the finding.
     * @see FindingType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The date and time, in UTC and extended ISO 8601 format, when the finding was last updated. For sensitive data
     * findings, this value is the same as the value for the createdAt property. All sensitive data findings are
     * considered new (unique) because they derive from individual classification jobs.
     * </p>
     * 
     * @return The date and time, in UTC and extended ISO 8601 format, when the finding was last updated. For sensitive
     *         data findings, this value is the same as the value for the createdAt property. All sensitive data
     *         findings are considered new (unique) because they derive from individual classification jobs.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(archived());
        hashCode = 31 * hashCode + Objects.hashCode(categoryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(classificationDetails());
        hashCode = 31 * hashCode + Objects.hashCode(count());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(partition());
        hashCode = 31 * hashCode + Objects.hashCode(policyDetails());
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(resourcesAffected());
        hashCode = 31 * hashCode + Objects.hashCode(sample());
        hashCode = 31 * hashCode + Objects.hashCode(schemaVersion());
        hashCode = 31 * hashCode + Objects.hashCode(severity());
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Finding)) {
            return false;
        }
        Finding other = (Finding) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(archived(), other.archived())
                && Objects.equals(categoryAsString(), other.categoryAsString())
                && Objects.equals(classificationDetails(), other.classificationDetails())
                && Objects.equals(count(), other.count()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(description(), other.description()) && Objects.equals(id(), other.id())
                && Objects.equals(partition(), other.partition()) && Objects.equals(policyDetails(), other.policyDetails())
                && Objects.equals(region(), other.region()) && Objects.equals(resourcesAffected(), other.resourcesAffected())
                && Objects.equals(sample(), other.sample()) && Objects.equals(schemaVersion(), other.schemaVersion())
                && Objects.equals(severity(), other.severity()) && Objects.equals(title(), other.title())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(updatedAt(), other.updatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Finding").add("AccountId", accountId()).add("Archived", archived())
                .add("Category", categoryAsString()).add("ClassificationDetails", classificationDetails()).add("Count", count())
                .add("CreatedAt", createdAt()).add("Description", description()).add("Id", id()).add("Partition", partition())
                .add("PolicyDetails", policyDetails()).add("Region", region()).add("ResourcesAffected", resourcesAffected())
                .add("Sample", sample()).add("SchemaVersion", schemaVersion()).add("Severity", severity()).add("Title", title())
                .add("Type", typeAsString()).add("UpdatedAt", updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "archived":
            return Optional.ofNullable(clazz.cast(archived()));
        case "category":
            return Optional.ofNullable(clazz.cast(categoryAsString()));
        case "classificationDetails":
            return Optional.ofNullable(clazz.cast(classificationDetails()));
        case "count":
            return Optional.ofNullable(clazz.cast(count()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "partition":
            return Optional.ofNullable(clazz.cast(partition()));
        case "policyDetails":
            return Optional.ofNullable(clazz.cast(policyDetails()));
        case "region":
            return Optional.ofNullable(clazz.cast(region()));
        case "resourcesAffected":
            return Optional.ofNullable(clazz.cast(resourcesAffected()));
        case "sample":
            return Optional.ofNullable(clazz.cast(sample()));
        case "schemaVersion":
            return Optional.ofNullable(clazz.cast(schemaVersion()));
        case "severity":
            return Optional.ofNullable(clazz.cast(severity()));
        case "title":
            return Optional.ofNullable(clazz.cast(title()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Finding, T> g) {
        return obj -> g.apply((Finding) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Finding> {
        /**
         * <p>
         * The unique identifier for the Amazon Web Services account that the finding applies to. This is typically the
         * account that owns the affected resource.
         * </p>
         * 
         * @param accountId
         *        The unique identifier for the Amazon Web Services account that the finding applies to. This is
         *        typically the account that owns the affected resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * Specifies whether the finding is archived (suppressed).
         * </p>
         * 
         * @param archived
         *        Specifies whether the finding is archived (suppressed).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder archived(Boolean archived);

        /**
         * <p>
         * The category of the finding. Possible values are: CLASSIFICATION, for a sensitive data finding; and, POLICY,
         * for a policy finding.
         * </p>
         * 
         * @param category
         *        The category of the finding. Possible values are: CLASSIFICATION, for a sensitive data finding; and,
         *        POLICY, for a policy finding.
         * @see FindingCategory
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FindingCategory
         */
        Builder category(String category);

        /**
         * <p>
         * The category of the finding. Possible values are: CLASSIFICATION, for a sensitive data finding; and, POLICY,
         * for a policy finding.
         * </p>
         * 
         * @param category
         *        The category of the finding. Possible values are: CLASSIFICATION, for a sensitive data finding; and,
         *        POLICY, for a policy finding.
         * @see FindingCategory
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FindingCategory
         */
        Builder category(FindingCategory category);

        /**
         * <p>
         * The details of a sensitive data finding. This value is null for a policy finding.
         * </p>
         * 
         * @param classificationDetails
         *        The details of a sensitive data finding. This value is null for a policy finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder classificationDetails(ClassificationDetails classificationDetails);

        /**
         * <p>
         * The details of a sensitive data finding. This value is null for a policy finding.
         * </p>
         * This is a convenience method that creates an instance of the {@link ClassificationDetails.Builder} avoiding
         * the need to create one manually via {@link ClassificationDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link ClassificationDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #classificationDetails(ClassificationDetails)}.
         * 
         * @param classificationDetails
         *        a consumer that will call methods on {@link ClassificationDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #classificationDetails(ClassificationDetails)
         */
        default Builder classificationDetails(Consumer<ClassificationDetails.Builder> classificationDetails) {
            return classificationDetails(ClassificationDetails.builder().applyMutation(classificationDetails).build());
        }

        /**
         * <p>
         * The total number of occurrences of the finding. For sensitive data findings, this value is always 1. All
         * sensitive data findings are considered new (unique) because they derive from individual classification jobs.
         * </p>
         * 
         * @param count
         *        The total number of occurrences of the finding. For sensitive data findings, this value is always 1.
         *        All sensitive data findings are considered new (unique) because they derive from individual
         *        classification jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder count(Long count);

        /**
         * <p>
         * The date and time, in UTC and extended ISO 8601 format, when the finding was created.
         * </p>
         * 
         * @param createdAt
         *        The date and time, in UTC and extended ISO 8601 format, when the finding was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The description of the finding.
         * </p>
         * 
         * @param description
         *        The description of the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The unique identifier for the finding. This is a random string that Amazon Macie generates and assigns to a
         * finding when it creates the finding.
         * </p>
         * 
         * @param id
         *        The unique identifier for the finding. This is a random string that Amazon Macie generates and assigns
         *        to a finding when it creates the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The Amazon Web Services partition that Amazon Macie created the finding in.
         * </p>
         * 
         * @param partition
         *        The Amazon Web Services partition that Amazon Macie created the finding in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partition(String partition);

        /**
         * <p>
         * The details of a policy finding. This value is null for a sensitive data finding.
         * </p>
         * 
         * @param policyDetails
         *        The details of a policy finding. This value is null for a sensitive data finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyDetails(PolicyDetails policyDetails);

        /**
         * <p>
         * The details of a policy finding. This value is null for a sensitive data finding.
         * </p>
         * This is a convenience method that creates an instance of the {@link PolicyDetails.Builder} avoiding the need
         * to create one manually via {@link PolicyDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link PolicyDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #policyDetails(PolicyDetails)}.
         * 
         * @param policyDetails
         *        a consumer that will call methods on {@link PolicyDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #policyDetails(PolicyDetails)
         */
        default Builder policyDetails(Consumer<PolicyDetails.Builder> policyDetails) {
            return policyDetails(PolicyDetails.builder().applyMutation(policyDetails).build());
        }

        /**
         * <p>
         * The Amazon Web Services Region that Amazon Macie created the finding in.
         * </p>
         * 
         * @param region
         *        The Amazon Web Services Region that Amazon Macie created the finding in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * The resources that the finding applies to.
         * </p>
         * 
         * @param resourcesAffected
         *        The resources that the finding applies to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourcesAffected(ResourcesAffected resourcesAffected);

        /**
         * <p>
         * The resources that the finding applies to.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResourcesAffected.Builder} avoiding the
         * need to create one manually via {@link ResourcesAffected#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResourcesAffected.Builder#build()} is called immediately and its
         * result is passed to {@link #resourcesAffected(ResourcesAffected)}.
         * 
         * @param resourcesAffected
         *        a consumer that will call methods on {@link ResourcesAffected.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourcesAffected(ResourcesAffected)
         */
        default Builder resourcesAffected(Consumer<ResourcesAffected.Builder> resourcesAffected) {
            return resourcesAffected(ResourcesAffected.builder().applyMutation(resourcesAffected).build());
        }

        /**
         * <p>
         * Specifies whether the finding is a sample finding. A <i>sample finding</i> is a finding that uses example
         * data to demonstrate what a finding might contain.
         * </p>
         * 
         * @param sample
         *        Specifies whether the finding is a sample finding. A <i>sample finding</i> is a finding that uses
         *        example data to demonstrate what a finding might contain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sample(Boolean sample);

        /**
         * <p>
         * The version of the schema that was used to define the data structures in the finding.
         * </p>
         * 
         * @param schemaVersion
         *        The version of the schema that was used to define the data structures in the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaVersion(String schemaVersion);

        /**
         * <p>
         * The severity level and score for the finding.
         * </p>
         * 
         * @param severity
         *        The severity level and score for the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder severity(Severity severity);

        /**
         * <p>
         * The severity level and score for the finding.
         * </p>
         * This is a convenience method that creates an instance of the {@link Severity.Builder} avoiding the need to
         * create one manually via {@link Severity#builder()}.
         *
         * When the {@link Consumer} completes, {@link Severity.Builder#build()} is called immediately and its result is
         * passed to {@link #severity(Severity)}.
         * 
         * @param severity
         *        a consumer that will call methods on {@link Severity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #severity(Severity)
         */
        default Builder severity(Consumer<Severity.Builder> severity) {
            return severity(Severity.builder().applyMutation(severity).build());
        }

        /**
         * <p>
         * The brief description of the finding.
         * </p>
         * 
         * @param title
         *        The brief description of the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * The type of the finding.
         * </p>
         * 
         * @param type
         *        The type of the finding.
         * @see FindingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FindingType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the finding.
         * </p>
         * 
         * @param type
         *        The type of the finding.
         * @see FindingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FindingType
         */
        Builder type(FindingType type);

        /**
         * <p>
         * The date and time, in UTC and extended ISO 8601 format, when the finding was last updated. For sensitive data
         * findings, this value is the same as the value for the createdAt property. All sensitive data findings are
         * considered new (unique) because they derive from individual classification jobs.
         * </p>
         * 
         * @param updatedAt
         *        The date and time, in UTC and extended ISO 8601 format, when the finding was last updated. For
         *        sensitive data findings, this value is the same as the value for the createdAt property. All sensitive
         *        data findings are considered new (unique) because they derive from individual classification jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);
    }

    static final class BuilderImpl implements Builder {
        private String accountId;

        private Boolean archived;

        private String category;

        private ClassificationDetails classificationDetails;

        private Long count;

        private Instant createdAt;

        private String description;

        private String id;

        private String partition;

        private PolicyDetails policyDetails;

        private String region;

        private ResourcesAffected resourcesAffected;

        private Boolean sample;

        private String schemaVersion;

        private Severity severity;

        private String title;

        private String type;

        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(Finding model) {
            accountId(model.accountId);
            archived(model.archived);
            category(model.category);
            classificationDetails(model.classificationDetails);
            count(model.count);
            createdAt(model.createdAt);
            description(model.description);
            id(model.id);
            partition(model.partition);
            policyDetails(model.policyDetails);
            region(model.region);
            resourcesAffected(model.resourcesAffected);
            sample(model.sample);
            schemaVersion(model.schemaVersion);
            severity(model.severity);
            title(model.title);
            type(model.type);
            updatedAt(model.updatedAt);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final Boolean getArchived() {
            return archived;
        }

        public final void setArchived(Boolean archived) {
            this.archived = archived;
        }

        @Override
        public final Builder archived(Boolean archived) {
            this.archived = archived;
            return this;
        }

        public final String getCategory() {
            return category;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        @Override
        public final Builder category(FindingCategory category) {
            this.category(category == null ? null : category.toString());
            return this;
        }

        public final ClassificationDetails.Builder getClassificationDetails() {
            return classificationDetails != null ? classificationDetails.toBuilder() : null;
        }

        public final void setClassificationDetails(ClassificationDetails.BuilderImpl classificationDetails) {
            this.classificationDetails = classificationDetails != null ? classificationDetails.build() : null;
        }

        @Override
        public final Builder classificationDetails(ClassificationDetails classificationDetails) {
            this.classificationDetails = classificationDetails;
            return this;
        }

        public final Long getCount() {
            return count;
        }

        public final void setCount(Long count) {
            this.count = count;
        }

        @Override
        public final Builder count(Long count) {
            this.count = count;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getPartition() {
            return partition;
        }

        public final void setPartition(String partition) {
            this.partition = partition;
        }

        @Override
        public final Builder partition(String partition) {
            this.partition = partition;
            return this;
        }

        public final PolicyDetails.Builder getPolicyDetails() {
            return policyDetails != null ? policyDetails.toBuilder() : null;
        }

        public final void setPolicyDetails(PolicyDetails.BuilderImpl policyDetails) {
            this.policyDetails = policyDetails != null ? policyDetails.build() : null;
        }

        @Override
        public final Builder policyDetails(PolicyDetails policyDetails) {
            this.policyDetails = policyDetails;
            return this;
        }

        public final String getRegion() {
            return region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final ResourcesAffected.Builder getResourcesAffected() {
            return resourcesAffected != null ? resourcesAffected.toBuilder() : null;
        }

        public final void setResourcesAffected(ResourcesAffected.BuilderImpl resourcesAffected) {
            this.resourcesAffected = resourcesAffected != null ? resourcesAffected.build() : null;
        }

        @Override
        public final Builder resourcesAffected(ResourcesAffected resourcesAffected) {
            this.resourcesAffected = resourcesAffected;
            return this;
        }

        public final Boolean getSample() {
            return sample;
        }

        public final void setSample(Boolean sample) {
            this.sample = sample;
        }

        @Override
        public final Builder sample(Boolean sample) {
            this.sample = sample;
            return this;
        }

        public final String getSchemaVersion() {
            return schemaVersion;
        }

        public final void setSchemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
        }

        @Override
        public final Builder schemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        public final Severity.Builder getSeverity() {
            return severity != null ? severity.toBuilder() : null;
        }

        public final void setSeverity(Severity.BuilderImpl severity) {
            this.severity = severity != null ? severity.build() : null;
        }

        @Override
        public final Builder severity(Severity severity) {
            this.severity = severity;
            return this;
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(FindingType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public Finding build() {
            return new Finding(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
