/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about the number of S3 buckets that use certain types of server-side encryption by default or
 * don't encrypt new objects by default. For detailed information about these settings, see <a
 * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/bucket-encryption.html">Setting default server-side
 * encryption behavior for Amazon S3 buckets</a> in the <i>Amazon Simple Storage Service User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BucketCountByEncryptionType implements SdkPojo, Serializable,
        ToCopyableBuilder<BucketCountByEncryptionType.Builder, BucketCountByEncryptionType> {
    private static final SdkField<Long> KMS_MANAGED_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("kmsManaged").getter(getter(BucketCountByEncryptionType::kmsManaged)).setter(setter(Builder::kmsManaged))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsManaged").build()).build();

    private static final SdkField<Long> S3_MANAGED_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("s3Managed")
            .getter(getter(BucketCountByEncryptionType::s3Managed)).setter(setter(Builder::s3Managed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Managed").build()).build();

    private static final SdkField<Long> UNENCRYPTED_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("unencrypted").getter(getter(BucketCountByEncryptionType::unencrypted))
            .setter(setter(Builder::unencrypted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unencrypted").build()).build();

    private static final SdkField<Long> UNKNOWN_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("unknown")
            .getter(getter(BucketCountByEncryptionType::unknown)).setter(setter(Builder::unknown))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unknown").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KMS_MANAGED_FIELD,
            S3_MANAGED_FIELD, UNENCRYPTED_FIELD, UNKNOWN_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long kmsManaged;

    private final Long s3Managed;

    private final Long unencrypted;

    private final Long unknown;

    private BucketCountByEncryptionType(BuilderImpl builder) {
        this.kmsManaged = builder.kmsManaged;
        this.s3Managed = builder.s3Managed;
        this.unencrypted = builder.unencrypted;
        this.unknown = builder.unknown;
    }

    /**
     * <p>
     * The total number of buckets that use an KMS key to encrypt new objects by default, either an Amazon Web Services
     * managed key or a customer managed key. These buckets use KMS encryption (SSE-KMS) by default.
     * </p>
     * 
     * @return <p>
     *         The total number of buckets that use an KMS key to encrypt new objects by default, either an Amazon Web
     *         Services managed key or a customer managed key. These buckets use KMS encryption (SSE-KMS) by default.
     *         </p>
     */
    public final Long kmsManaged() {
        return kmsManaged;
    }

    /**
     * <p>
     * The total number of buckets that use an Amazon S3 managed key to encrypt new objects by default. These buckets
     * use Amazon S3 managed encryption (SSE-S3) by default.
     * </p>
     * 
     * @return The total number of buckets that use an Amazon S3 managed key to encrypt new objects by default. These
     *         buckets use Amazon S3 managed encryption (SSE-S3) by default.
     */
    public final Long s3Managed() {
        return s3Managed;
    }

    /**
     * <p>
     * The total number of buckets that don't encrypt new objects by default. Default encryption is disabled for these
     * buckets.
     * </p>
     * 
     * @return The total number of buckets that don't encrypt new objects by default. Default encryption is disabled for
     *         these buckets.
     */
    public final Long unencrypted() {
        return unencrypted;
    }

    /**
     * <p>
     * The total number of buckets that Amazon Macie doesn't have current encryption metadata for. Macie can't provide
     * current data about the default encryption settings for these buckets.
     * </p>
     * 
     * @return The total number of buckets that Amazon Macie doesn't have current encryption metadata for. Macie can't
     *         provide current data about the default encryption settings for these buckets.
     */
    public final Long unknown() {
        return unknown;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(kmsManaged());
        hashCode = 31 * hashCode + Objects.hashCode(s3Managed());
        hashCode = 31 * hashCode + Objects.hashCode(unencrypted());
        hashCode = 31 * hashCode + Objects.hashCode(unknown());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BucketCountByEncryptionType)) {
            return false;
        }
        BucketCountByEncryptionType other = (BucketCountByEncryptionType) obj;
        return Objects.equals(kmsManaged(), other.kmsManaged()) && Objects.equals(s3Managed(), other.s3Managed())
                && Objects.equals(unencrypted(), other.unencrypted()) && Objects.equals(unknown(), other.unknown());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BucketCountByEncryptionType").add("KmsManaged", kmsManaged()).add("S3Managed", s3Managed())
                .add("Unencrypted", unencrypted()).add("Unknown", unknown()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "kmsManaged":
            return Optional.ofNullable(clazz.cast(kmsManaged()));
        case "s3Managed":
            return Optional.ofNullable(clazz.cast(s3Managed()));
        case "unencrypted":
            return Optional.ofNullable(clazz.cast(unencrypted()));
        case "unknown":
            return Optional.ofNullable(clazz.cast(unknown()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BucketCountByEncryptionType, T> g) {
        return obj -> g.apply((BucketCountByEncryptionType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BucketCountByEncryptionType> {
        /**
         * <p>
         * The total number of buckets that use an KMS key to encrypt new objects by default, either an Amazon Web
         * Services managed key or a customer managed key. These buckets use KMS encryption (SSE-KMS) by default.
         * </p>
         * 
         * @param kmsManaged
         *        <p>
         *        The total number of buckets that use an KMS key to encrypt new objects by default, either an Amazon
         *        Web Services managed key or a customer managed key. These buckets use KMS encryption (SSE-KMS) by
         *        default.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsManaged(Long kmsManaged);

        /**
         * <p>
         * The total number of buckets that use an Amazon S3 managed key to encrypt new objects by default. These
         * buckets use Amazon S3 managed encryption (SSE-S3) by default.
         * </p>
         * 
         * @param s3Managed
         *        The total number of buckets that use an Amazon S3 managed key to encrypt new objects by default. These
         *        buckets use Amazon S3 managed encryption (SSE-S3) by default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Managed(Long s3Managed);

        /**
         * <p>
         * The total number of buckets that don't encrypt new objects by default. Default encryption is disabled for
         * these buckets.
         * </p>
         * 
         * @param unencrypted
         *        The total number of buckets that don't encrypt new objects by default. Default encryption is disabled
         *        for these buckets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unencrypted(Long unencrypted);

        /**
         * <p>
         * The total number of buckets that Amazon Macie doesn't have current encryption metadata for. Macie can't
         * provide current data about the default encryption settings for these buckets.
         * </p>
         * 
         * @param unknown
         *        The total number of buckets that Amazon Macie doesn't have current encryption metadata for. Macie
         *        can't provide current data about the default encryption settings for these buckets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unknown(Long unknown);
    }

    static final class BuilderImpl implements Builder {
        private Long kmsManaged;

        private Long s3Managed;

        private Long unencrypted;

        private Long unknown;

        private BuilderImpl() {
        }

        private BuilderImpl(BucketCountByEncryptionType model) {
            kmsManaged(model.kmsManaged);
            s3Managed(model.s3Managed);
            unencrypted(model.unencrypted);
            unknown(model.unknown);
        }

        public final Long getKmsManaged() {
            return kmsManaged;
        }

        public final void setKmsManaged(Long kmsManaged) {
            this.kmsManaged = kmsManaged;
        }

        @Override
        public final Builder kmsManaged(Long kmsManaged) {
            this.kmsManaged = kmsManaged;
            return this;
        }

        public final Long getS3Managed() {
            return s3Managed;
        }

        public final void setS3Managed(Long s3Managed) {
            this.s3Managed = s3Managed;
        }

        @Override
        public final Builder s3Managed(Long s3Managed) {
            this.s3Managed = s3Managed;
            return this;
        }

        public final Long getUnencrypted() {
            return unencrypted;
        }

        public final void setUnencrypted(Long unencrypted) {
            this.unencrypted = unencrypted;
        }

        @Override
        public final Builder unencrypted(Long unencrypted) {
            this.unencrypted = unencrypted;
            return this;
        }

        public final Long getUnknown() {
            return unknown;
        }

        public final void setUnknown(Long unknown) {
            this.unknown = unknown;
        }

        @Override
        public final Builder unknown(Long unknown) {
            this.unknown = unknown;
            return this;
        }

        @Override
        public BucketCountByEncryptionType build() {
            return new BucketCountByEncryptionType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
