/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about the bucket-level permissions settings for an S3 bucket.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BucketLevelPermissions implements SdkPojo, Serializable,
        ToCopyableBuilder<BucketLevelPermissions.Builder, BucketLevelPermissions> {
    private static final SdkField<AccessControlList> ACCESS_CONTROL_LIST_FIELD = SdkField
            .<AccessControlList> builder(MarshallingType.SDK_POJO).memberName("accessControlList")
            .getter(getter(BucketLevelPermissions::accessControlList)).setter(setter(Builder::accessControlList))
            .constructor(AccessControlList::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessControlList").build()).build();

    private static final SdkField<BlockPublicAccess> BLOCK_PUBLIC_ACCESS_FIELD = SdkField
            .<BlockPublicAccess> builder(MarshallingType.SDK_POJO).memberName("blockPublicAccess")
            .getter(getter(BucketLevelPermissions::blockPublicAccess)).setter(setter(Builder::blockPublicAccess))
            .constructor(BlockPublicAccess::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blockPublicAccess").build()).build();

    private static final SdkField<BucketPolicy> BUCKET_POLICY_FIELD = SdkField.<BucketPolicy> builder(MarshallingType.SDK_POJO)
            .memberName("bucketPolicy").getter(getter(BucketLevelPermissions::bucketPolicy))
            .setter(setter(Builder::bucketPolicy)).constructor(BucketPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketPolicy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_CONTROL_LIST_FIELD,
            BLOCK_PUBLIC_ACCESS_FIELD, BUCKET_POLICY_FIELD));

    private static final long serialVersionUID = 1L;

    private final AccessControlList accessControlList;

    private final BlockPublicAccess blockPublicAccess;

    private final BucketPolicy bucketPolicy;

    private BucketLevelPermissions(BuilderImpl builder) {
        this.accessControlList = builder.accessControlList;
        this.blockPublicAccess = builder.blockPublicAccess;
        this.bucketPolicy = builder.bucketPolicy;
    }

    /**
     * <p>
     * The permissions settings of the access control list (ACL) for the bucket. This value is null if an ACL hasn't
     * been defined for the bucket.
     * </p>
     * 
     * @return The permissions settings of the access control list (ACL) for the bucket. This value is null if an ACL
     *         hasn't been defined for the bucket.
     */
    public final AccessControlList accessControlList() {
        return accessControlList;
    }

    /**
     * <p>
     * The block public access settings for the bucket.
     * </p>
     * 
     * @return The block public access settings for the bucket.
     */
    public final BlockPublicAccess blockPublicAccess() {
        return blockPublicAccess;
    }

    /**
     * <p>
     * The permissions settings of the bucket policy for the bucket. This value is null if a bucket policy hasn't been
     * defined for the bucket.
     * </p>
     * 
     * @return The permissions settings of the bucket policy for the bucket. This value is null if a bucket policy
     *         hasn't been defined for the bucket.
     */
    public final BucketPolicy bucketPolicy() {
        return bucketPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accessControlList());
        hashCode = 31 * hashCode + Objects.hashCode(blockPublicAccess());
        hashCode = 31 * hashCode + Objects.hashCode(bucketPolicy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BucketLevelPermissions)) {
            return false;
        }
        BucketLevelPermissions other = (BucketLevelPermissions) obj;
        return Objects.equals(accessControlList(), other.accessControlList())
                && Objects.equals(blockPublicAccess(), other.blockPublicAccess())
                && Objects.equals(bucketPolicy(), other.bucketPolicy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BucketLevelPermissions").add("AccessControlList", accessControlList())
                .add("BlockPublicAccess", blockPublicAccess()).add("BucketPolicy", bucketPolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accessControlList":
            return Optional.ofNullable(clazz.cast(accessControlList()));
        case "blockPublicAccess":
            return Optional.ofNullable(clazz.cast(blockPublicAccess()));
        case "bucketPolicy":
            return Optional.ofNullable(clazz.cast(bucketPolicy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BucketLevelPermissions, T> g) {
        return obj -> g.apply((BucketLevelPermissions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BucketLevelPermissions> {
        /**
         * <p>
         * The permissions settings of the access control list (ACL) for the bucket. This value is null if an ACL hasn't
         * been defined for the bucket.
         * </p>
         * 
         * @param accessControlList
         *        The permissions settings of the access control list (ACL) for the bucket. This value is null if an ACL
         *        hasn't been defined for the bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessControlList(AccessControlList accessControlList);

        /**
         * <p>
         * The permissions settings of the access control list (ACL) for the bucket. This value is null if an ACL hasn't
         * been defined for the bucket.
         * </p>
         * This is a convenience method that creates an instance of the {@link AccessControlList.Builder} avoiding the
         * need to create one manually via {@link AccessControlList#builder()}.
         *
         * When the {@link Consumer} completes, {@link AccessControlList.Builder#build()} is called immediately and its
         * result is passed to {@link #accessControlList(AccessControlList)}.
         * 
         * @param accessControlList
         *        a consumer that will call methods on {@link AccessControlList.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accessControlList(AccessControlList)
         */
        default Builder accessControlList(Consumer<AccessControlList.Builder> accessControlList) {
            return accessControlList(AccessControlList.builder().applyMutation(accessControlList).build());
        }

        /**
         * <p>
         * The block public access settings for the bucket.
         * </p>
         * 
         * @param blockPublicAccess
         *        The block public access settings for the bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockPublicAccess(BlockPublicAccess blockPublicAccess);

        /**
         * <p>
         * The block public access settings for the bucket.
         * </p>
         * This is a convenience method that creates an instance of the {@link BlockPublicAccess.Builder} avoiding the
         * need to create one manually via {@link BlockPublicAccess#builder()}.
         *
         * When the {@link Consumer} completes, {@link BlockPublicAccess.Builder#build()} is called immediately and its
         * result is passed to {@link #blockPublicAccess(BlockPublicAccess)}.
         * 
         * @param blockPublicAccess
         *        a consumer that will call methods on {@link BlockPublicAccess.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #blockPublicAccess(BlockPublicAccess)
         */
        default Builder blockPublicAccess(Consumer<BlockPublicAccess.Builder> blockPublicAccess) {
            return blockPublicAccess(BlockPublicAccess.builder().applyMutation(blockPublicAccess).build());
        }

        /**
         * <p>
         * The permissions settings of the bucket policy for the bucket. This value is null if a bucket policy hasn't
         * been defined for the bucket.
         * </p>
         * 
         * @param bucketPolicy
         *        The permissions settings of the bucket policy for the bucket. This value is null if a bucket policy
         *        hasn't been defined for the bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketPolicy(BucketPolicy bucketPolicy);

        /**
         * <p>
         * The permissions settings of the bucket policy for the bucket. This value is null if a bucket policy hasn't
         * been defined for the bucket.
         * </p>
         * This is a convenience method that creates an instance of the {@link BucketPolicy.Builder} avoiding the need
         * to create one manually via {@link BucketPolicy#builder()}.
         *
         * When the {@link Consumer} completes, {@link BucketPolicy.Builder#build()} is called immediately and its
         * result is passed to {@link #bucketPolicy(BucketPolicy)}.
         * 
         * @param bucketPolicy
         *        a consumer that will call methods on {@link BucketPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bucketPolicy(BucketPolicy)
         */
        default Builder bucketPolicy(Consumer<BucketPolicy.Builder> bucketPolicy) {
            return bucketPolicy(BucketPolicy.builder().applyMutation(bucketPolicy).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AccessControlList accessControlList;

        private BlockPublicAccess blockPublicAccess;

        private BucketPolicy bucketPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(BucketLevelPermissions model) {
            accessControlList(model.accessControlList);
            blockPublicAccess(model.blockPublicAccess);
            bucketPolicy(model.bucketPolicy);
        }

        public final AccessControlList.Builder getAccessControlList() {
            return accessControlList != null ? accessControlList.toBuilder() : null;
        }

        public final void setAccessControlList(AccessControlList.BuilderImpl accessControlList) {
            this.accessControlList = accessControlList != null ? accessControlList.build() : null;
        }

        @Override
        public final Builder accessControlList(AccessControlList accessControlList) {
            this.accessControlList = accessControlList;
            return this;
        }

        public final BlockPublicAccess.Builder getBlockPublicAccess() {
            return blockPublicAccess != null ? blockPublicAccess.toBuilder() : null;
        }

        public final void setBlockPublicAccess(BlockPublicAccess.BuilderImpl blockPublicAccess) {
            this.blockPublicAccess = blockPublicAccess != null ? blockPublicAccess.build() : null;
        }

        @Override
        public final Builder blockPublicAccess(BlockPublicAccess blockPublicAccess) {
            this.blockPublicAccess = blockPublicAccess;
            return this;
        }

        public final BucketPolicy.Builder getBucketPolicy() {
            return bucketPolicy != null ? bucketPolicy.toBuilder() : null;
        }

        public final void setBucketPolicy(BucketPolicy.BuilderImpl bucketPolicy) {
            this.bucketPolicy = bucketPolicy != null ? bucketPolicy.build() : null;
        }

        @Override
        public final Builder bucketPolicy(BucketPolicy bucketPolicy) {
            this.bucketPolicy = bucketPolicy;
            return this;
        }

        @Override
        public BucketLevelPermissions build() {
            return new BucketLevelPermissions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
