/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeClassificationJobResponse extends Macie2Response implements
        ToCopyableBuilder<DescribeClassificationJobResponse.Builder, DescribeClassificationJobResponse> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(DescribeClassificationJobResponse::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(DescribeClassificationJobResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<List<String>> CUSTOM_DATA_IDENTIFIER_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("customDataIdentifierIds")
            .getter(getter(DescribeClassificationJobResponse::customDataIdentifierIds))
            .setter(setter(Builder::customDataIdentifierIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customDataIdentifierIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(DescribeClassificationJobResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Boolean> INITIAL_RUN_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("initialRun").getter(getter(DescribeClassificationJobResponse::initialRun))
            .setter(setter(Builder::initialRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("initialRun").build()).build();

    private static final SdkField<String> JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("jobArn")
            .getter(getter(DescribeClassificationJobResponse::jobArn)).setter(setter(Builder::jobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobArn").build()).build();

    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("jobId")
            .getter(getter(DescribeClassificationJobResponse::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()).build();

    private static final SdkField<String> JOB_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobStatus").getter(getter(DescribeClassificationJobResponse::jobStatusAsString))
            .setter(setter(Builder::jobStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobStatus").build()).build();

    private static final SdkField<String> JOB_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobType").getter(getter(DescribeClassificationJobResponse::jobTypeAsString))
            .setter(setter(Builder::jobType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobType").build()).build();

    private static final SdkField<LastRunErrorStatus> LAST_RUN_ERROR_STATUS_FIELD = SdkField
            .<LastRunErrorStatus> builder(MarshallingType.SDK_POJO).memberName("lastRunErrorStatus")
            .getter(getter(DescribeClassificationJobResponse::lastRunErrorStatus)).setter(setter(Builder::lastRunErrorStatus))
            .constructor(LastRunErrorStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastRunErrorStatus").build())
            .build();

    private static final SdkField<Instant> LAST_RUN_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastRunTime")
            .getter(getter(DescribeClassificationJobResponse::lastRunTime))
            .setter(setter(Builder::lastRunTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastRunTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<List<String>> MANAGED_DATA_IDENTIFIER_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("managedDataIdentifierIds")
            .getter(getter(DescribeClassificationJobResponse::managedDataIdentifierIds))
            .setter(setter(Builder::managedDataIdentifierIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managedDataIdentifierIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> MANAGED_DATA_IDENTIFIER_SELECTOR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("managedDataIdentifierSelector")
            .getter(getter(DescribeClassificationJobResponse::managedDataIdentifierSelectorAsString))
            .setter(setter(Builder::managedDataIdentifierSelector))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managedDataIdentifierSelector")
                    .build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(DescribeClassificationJobResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<S3JobDefinition> S3_JOB_DEFINITION_FIELD = SdkField
            .<S3JobDefinition> builder(MarshallingType.SDK_POJO).memberName("s3JobDefinition")
            .getter(getter(DescribeClassificationJobResponse::s3JobDefinition)).setter(setter(Builder::s3JobDefinition))
            .constructor(S3JobDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3JobDefinition").build()).build();

    private static final SdkField<Integer> SAMPLING_PERCENTAGE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("samplingPercentage").getter(getter(DescribeClassificationJobResponse::samplingPercentage))
            .setter(setter(Builder::samplingPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("samplingPercentage").build())
            .build();

    private static final SdkField<JobScheduleFrequency> SCHEDULE_FREQUENCY_FIELD = SdkField
            .<JobScheduleFrequency> builder(MarshallingType.SDK_POJO).memberName("scheduleFrequency")
            .getter(getter(DescribeClassificationJobResponse::scheduleFrequency)).setter(setter(Builder::scheduleFrequency))
            .constructor(JobScheduleFrequency::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheduleFrequency").build()).build();

    private static final SdkField<Statistics> STATISTICS_FIELD = SdkField.<Statistics> builder(MarshallingType.SDK_POJO)
            .memberName("statistics").getter(getter(DescribeClassificationJobResponse::statistics))
            .setter(setter(Builder::statistics)).constructor(Statistics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statistics").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(DescribeClassificationJobResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<UserPausedDetails> USER_PAUSED_DETAILS_FIELD = SdkField
            .<UserPausedDetails> builder(MarshallingType.SDK_POJO).memberName("userPausedDetails")
            .getter(getter(DescribeClassificationJobResponse::userPausedDetails)).setter(setter(Builder::userPausedDetails))
            .constructor(UserPausedDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userPausedDetails").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            CREATED_AT_FIELD, CUSTOM_DATA_IDENTIFIER_IDS_FIELD, DESCRIPTION_FIELD, INITIAL_RUN_FIELD, JOB_ARN_FIELD,
            JOB_ID_FIELD, JOB_STATUS_FIELD, JOB_TYPE_FIELD, LAST_RUN_ERROR_STATUS_FIELD, LAST_RUN_TIME_FIELD,
            MANAGED_DATA_IDENTIFIER_IDS_FIELD, MANAGED_DATA_IDENTIFIER_SELECTOR_FIELD, NAME_FIELD, S3_JOB_DEFINITION_FIELD,
            SAMPLING_PERCENTAGE_FIELD, SCHEDULE_FREQUENCY_FIELD, STATISTICS_FIELD, TAGS_FIELD, USER_PAUSED_DETAILS_FIELD));

    private final String clientToken;

    private final Instant createdAt;

    private final List<String> customDataIdentifierIds;

    private final String description;

    private final Boolean initialRun;

    private final String jobArn;

    private final String jobId;

    private final String jobStatus;

    private final String jobType;

    private final LastRunErrorStatus lastRunErrorStatus;

    private final Instant lastRunTime;

    private final List<String> managedDataIdentifierIds;

    private final String managedDataIdentifierSelector;

    private final String name;

    private final S3JobDefinition s3JobDefinition;

    private final Integer samplingPercentage;

    private final JobScheduleFrequency scheduleFrequency;

    private final Statistics statistics;

    private final Map<String, String> tags;

    private final UserPausedDetails userPausedDetails;

    private DescribeClassificationJobResponse(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.createdAt = builder.createdAt;
        this.customDataIdentifierIds = builder.customDataIdentifierIds;
        this.description = builder.description;
        this.initialRun = builder.initialRun;
        this.jobArn = builder.jobArn;
        this.jobId = builder.jobId;
        this.jobStatus = builder.jobStatus;
        this.jobType = builder.jobType;
        this.lastRunErrorStatus = builder.lastRunErrorStatus;
        this.lastRunTime = builder.lastRunTime;
        this.managedDataIdentifierIds = builder.managedDataIdentifierIds;
        this.managedDataIdentifierSelector = builder.managedDataIdentifierSelector;
        this.name = builder.name;
        this.s3JobDefinition = builder.s3JobDefinition;
        this.samplingPercentage = builder.samplingPercentage;
        this.scheduleFrequency = builder.scheduleFrequency;
        this.statistics = builder.statistics;
        this.tags = builder.tags;
        this.userPausedDetails = builder.userPausedDetails;
    }

    /**
     * <p>
     * The token that was provided to ensure the idempotency of the request to create the job.
     * </p>
     * 
     * @return The token that was provided to ensure the idempotency of the request to create the job.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The date and time, in UTC and extended ISO 8601 format, when the job was created.
     * </p>
     * 
     * @return The date and time, in UTC and extended ISO 8601 format, when the job was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * For responses, this returns true if the service returned a value for the CustomDataIdentifierIds property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCustomDataIdentifierIds() {
        return customDataIdentifierIds != null && !(customDataIdentifierIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of unique identifiers, one for each custom data identifier that the job uses to analyze data. This value
     * is null if the job uses only managed data identifiers to analyze data.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCustomDataIdentifierIds} method.
     * </p>
     * 
     * @return An array of unique identifiers, one for each custom data identifier that the job uses to analyze data.
     *         This value is null if the job uses only managed data identifiers to analyze data.
     */
    public final List<String> customDataIdentifierIds() {
        return customDataIdentifierIds;
    }

    /**
     * <p>
     * The custom description of the job.
     * </p>
     * 
     * @return The custom description of the job.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * For a recurring job, specifies whether you configured the job to analyze all existing, eligible objects
     * immediately after the job was created (true). If you configured the job to analyze only those objects that were
     * created or changed after the job was created and before the job's first scheduled run, this value is false. This
     * value is also false for a one-time job.
     * </p>
     * 
     * @return For a recurring job, specifies whether you configured the job to analyze all existing, eligible objects
     *         immediately after the job was created (true). If you configured the job to analyze only those objects
     *         that were created or changed after the job was created and before the job's first scheduled run, this
     *         value is false. This value is also false for a one-time job.
     */
    public final Boolean initialRun() {
        return initialRun;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the job.
     */
    public final String jobArn() {
        return jobArn;
    }

    /**
     * <p>
     * The unique identifier for the job.
     * </p>
     * 
     * @return The unique identifier for the job.
     */
    public final String jobId() {
        return jobId;
    }

    /**
     * <p>
     * The current status of the job. Possible values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * CANCELLED - You cancelled the job or, if it's a one-time job, you paused the job and didn't resume it within 30
     * days.
     * </p>
     * </li>
     * <li>
     * <p>
     * COMPLETE - For a one-time job, Amazon Macie finished processing the data specified for the job. This value
     * doesn't apply to recurring jobs.
     * </p>
     * </li>
     * <li>
     * <p>
     * IDLE - For a recurring job, the previous scheduled run is complete and the next scheduled run is pending. This
     * value doesn't apply to one-time jobs.
     * </p>
     * </li>
     * <li>
     * <p>
     * PAUSED - Macie started running the job but additional processing would exceed the monthly sensitive data
     * discovery quota for your account or one or more member accounts that the job analyzes data for.
     * </p>
     * </li>
     * <li>
     * <p>
     * RUNNING - For a one-time job, the job is in progress. For a recurring job, a scheduled run is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * USER_PAUSED - You paused the job. If you paused the job while it had a status of RUNNING and you don't resume it
     * within 30 days of pausing it, the job or job run will expire and be cancelled, depending on the job's type. To
     * check the expiration date, refer to the UserPausedDetails.jobExpiresAt property.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link JobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobStatusAsString}.
     * </p>
     * 
     * @return The current status of the job. Possible values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         CANCELLED - You cancelled the job or, if it's a one-time job, you paused the job and didn't resume it
     *         within 30 days.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         COMPLETE - For a one-time job, Amazon Macie finished processing the data specified for the job. This
     *         value doesn't apply to recurring jobs.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IDLE - For a recurring job, the previous scheduled run is complete and the next scheduled run is pending.
     *         This value doesn't apply to one-time jobs.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PAUSED - Macie started running the job but additional processing would exceed the monthly sensitive data
     *         discovery quota for your account or one or more member accounts that the job analyzes data for.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RUNNING - For a one-time job, the job is in progress. For a recurring job, a scheduled run is in
     *         progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         USER_PAUSED - You paused the job. If you paused the job while it had a status of RUNNING and you don't
     *         resume it within 30 days of pausing it, the job or job run will expire and be cancelled, depending on the
     *         job's type. To check the expiration date, refer to the UserPausedDetails.jobExpiresAt property.
     *         </p>
     *         </li>
     * @see JobStatus
     */
    public final JobStatus jobStatus() {
        return JobStatus.fromValue(jobStatus);
    }

    /**
     * <p>
     * The current status of the job. Possible values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * CANCELLED - You cancelled the job or, if it's a one-time job, you paused the job and didn't resume it within 30
     * days.
     * </p>
     * </li>
     * <li>
     * <p>
     * COMPLETE - For a one-time job, Amazon Macie finished processing the data specified for the job. This value
     * doesn't apply to recurring jobs.
     * </p>
     * </li>
     * <li>
     * <p>
     * IDLE - For a recurring job, the previous scheduled run is complete and the next scheduled run is pending. This
     * value doesn't apply to one-time jobs.
     * </p>
     * </li>
     * <li>
     * <p>
     * PAUSED - Macie started running the job but additional processing would exceed the monthly sensitive data
     * discovery quota for your account or one or more member accounts that the job analyzes data for.
     * </p>
     * </li>
     * <li>
     * <p>
     * RUNNING - For a one-time job, the job is in progress. For a recurring job, a scheduled run is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * USER_PAUSED - You paused the job. If you paused the job while it had a status of RUNNING and you don't resume it
     * within 30 days of pausing it, the job or job run will expire and be cancelled, depending on the job's type. To
     * check the expiration date, refer to the UserPausedDetails.jobExpiresAt property.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link JobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobStatusAsString}.
     * </p>
     * 
     * @return The current status of the job. Possible values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         CANCELLED - You cancelled the job or, if it's a one-time job, you paused the job and didn't resume it
     *         within 30 days.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         COMPLETE - For a one-time job, Amazon Macie finished processing the data specified for the job. This
     *         value doesn't apply to recurring jobs.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IDLE - For a recurring job, the previous scheduled run is complete and the next scheduled run is pending.
     *         This value doesn't apply to one-time jobs.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PAUSED - Macie started running the job but additional processing would exceed the monthly sensitive data
     *         discovery quota for your account or one or more member accounts that the job analyzes data for.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RUNNING - For a one-time job, the job is in progress. For a recurring job, a scheduled run is in
     *         progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         USER_PAUSED - You paused the job. If you paused the job while it had a status of RUNNING and you don't
     *         resume it within 30 days of pausing it, the job or job run will expire and be cancelled, depending on the
     *         job's type. To check the expiration date, refer to the UserPausedDetails.jobExpiresAt property.
     *         </p>
     *         </li>
     * @see JobStatus
     */
    public final String jobStatusAsString() {
        return jobStatus;
    }

    /**
     * <p>
     * The schedule for running the job. Possible values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * ONE_TIME - The job runs only once.
     * </p>
     * </li>
     * <li>
     * <p>
     * SCHEDULED - The job runs on a daily, weekly, or monthly basis. The scheduleFrequency property indicates the
     * recurrence pattern for the job.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobType} will
     * return {@link JobType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobTypeAsString}.
     * </p>
     * 
     * @return The schedule for running the job. Possible values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         ONE_TIME - The job runs only once.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SCHEDULED - The job runs on a daily, weekly, or monthly basis. The scheduleFrequency property indicates
     *         the recurrence pattern for the job.
     *         </p>
     *         </li>
     * @see JobType
     */
    public final JobType jobType() {
        return JobType.fromValue(jobType);
    }

    /**
     * <p>
     * The schedule for running the job. Possible values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * ONE_TIME - The job runs only once.
     * </p>
     * </li>
     * <li>
     * <p>
     * SCHEDULED - The job runs on a daily, weekly, or monthly basis. The scheduleFrequency property indicates the
     * recurrence pattern for the job.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobType} will
     * return {@link JobType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobTypeAsString}.
     * </p>
     * 
     * @return The schedule for running the job. Possible values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         ONE_TIME - The job runs only once.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SCHEDULED - The job runs on a daily, weekly, or monthly basis. The scheduleFrequency property indicates
     *         the recurrence pattern for the job.
     *         </p>
     *         </li>
     * @see JobType
     */
    public final String jobTypeAsString() {
        return jobType;
    }

    /**
     * <p>
     * Specifies whether any account- or bucket-level access errors occurred when the job ran. For a recurring job, this
     * value indicates the error status of the job's most recent run.
     * </p>
     * 
     * @return Specifies whether any account- or bucket-level access errors occurred when the job ran. For a recurring
     *         job, this value indicates the error status of the job's most recent run.
     */
    public final LastRunErrorStatus lastRunErrorStatus() {
        return lastRunErrorStatus;
    }

    /**
     * <p>
     * The date and time, in UTC and extended ISO 8601 format, when the job started. If the job is a recurring job, this
     * value indicates when the most recent run started or, if the job hasn't run yet, when the job was created.
     * </p>
     * 
     * @return The date and time, in UTC and extended ISO 8601 format, when the job started. If the job is a recurring
     *         job, this value indicates when the most recent run started or, if the job hasn't run yet, when the job
     *         was created.
     */
    public final Instant lastRunTime() {
        return lastRunTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the ManagedDataIdentifierIds property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasManagedDataIdentifierIds() {
        return managedDataIdentifierIds != null && !(managedDataIdentifierIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of unique identifiers, one for each managed data identifier that the job is explicitly configured to
     * include (use) or exclude (not use) when it analyzes data. Inclusion or exclusion depends on the managed data
     * identifier selection type specified for the job (managedDataIdentifierSelector). This value is null if the job's
     * managed data identifier selection type is ALL or the job uses only custom data identifiers
     * (customDataIdentifierIds) to analyze data.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasManagedDataIdentifierIds} method.
     * </p>
     * 
     * @return An array of unique identifiers, one for each managed data identifier that the job is explicitly
     *         configured to include (use) or exclude (not use) when it analyzes data. Inclusion or exclusion depends on
     *         the managed data identifier selection type specified for the job (managedDataIdentifierSelector). This
     *         value is null if the job's managed data identifier selection type is ALL or the job uses only custom data
     *         identifiers (customDataIdentifierIds) to analyze data.
     */
    public final List<String> managedDataIdentifierIds() {
        return managedDataIdentifierIds;
    }

    /**
     * <p>
     * The selection type that determines which managed data identifiers the job uses to analyze data. Possible values
     * are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * ALL - Use all the managed data identifiers that Amazon Macie provides.
     * </p>
     * </li>
     * <li>
     * <p>
     * EXCLUDE - Use all the managed data identifiers that Macie provides except the managed data identifiers specified
     * by the managedDataIdentifierIds property.
     * </p>
     * </li>
     * <li>
     * <p>
     * INCLUDE - Use only the managed data identifiers specified by the managedDataIdentifierIds property.
     * </p>
     * </li>
     * <li>
     * <p>
     * NONE - Don't use any managed data identifiers.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If this value is null, the job uses all managed data identifiers. If this value is null, ALL, or EXCLUDE for a
     * recurring job, the job also uses new managed data identifiers as they are released.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #managedDataIdentifierSelector} will return {@link ManagedDataIdentifierSelector#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #managedDataIdentifierSelectorAsString}.
     * </p>
     * 
     * @return The selection type that determines which managed data identifiers the job uses to analyze data. Possible
     *         values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         ALL - Use all the managed data identifiers that Amazon Macie provides.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         EXCLUDE - Use all the managed data identifiers that Macie provides except the managed data identifiers
     *         specified by the managedDataIdentifierIds property.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INCLUDE - Use only the managed data identifiers specified by the managedDataIdentifierIds property.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NONE - Don't use any managed data identifiers.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If this value is null, the job uses all managed data identifiers. If this value is null, ALL, or EXCLUDE
     *         for a recurring job, the job also uses new managed data identifiers as they are released.
     * @see ManagedDataIdentifierSelector
     */
    public final ManagedDataIdentifierSelector managedDataIdentifierSelector() {
        return ManagedDataIdentifierSelector.fromValue(managedDataIdentifierSelector);
    }

    /**
     * <p>
     * The selection type that determines which managed data identifiers the job uses to analyze data. Possible values
     * are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * ALL - Use all the managed data identifiers that Amazon Macie provides.
     * </p>
     * </li>
     * <li>
     * <p>
     * EXCLUDE - Use all the managed data identifiers that Macie provides except the managed data identifiers specified
     * by the managedDataIdentifierIds property.
     * </p>
     * </li>
     * <li>
     * <p>
     * INCLUDE - Use only the managed data identifiers specified by the managedDataIdentifierIds property.
     * </p>
     * </li>
     * <li>
     * <p>
     * NONE - Don't use any managed data identifiers.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If this value is null, the job uses all managed data identifiers. If this value is null, ALL, or EXCLUDE for a
     * recurring job, the job also uses new managed data identifiers as they are released.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #managedDataIdentifierSelector} will return {@link ManagedDataIdentifierSelector#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #managedDataIdentifierSelectorAsString}.
     * </p>
     * 
     * @return The selection type that determines which managed data identifiers the job uses to analyze data. Possible
     *         values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         ALL - Use all the managed data identifiers that Amazon Macie provides.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         EXCLUDE - Use all the managed data identifiers that Macie provides except the managed data identifiers
     *         specified by the managedDataIdentifierIds property.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INCLUDE - Use only the managed data identifiers specified by the managedDataIdentifierIds property.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NONE - Don't use any managed data identifiers.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If this value is null, the job uses all managed data identifiers. If this value is null, ALL, or EXCLUDE
     *         for a recurring job, the job also uses new managed data identifiers as they are released.
     * @see ManagedDataIdentifierSelector
     */
    public final String managedDataIdentifierSelectorAsString() {
        return managedDataIdentifierSelector;
    }

    /**
     * <p>
     * The custom name of the job.
     * </p>
     * 
     * @return The custom name of the job.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The S3 buckets that contain the objects to analyze, and the scope of that analysis.
     * </p>
     * 
     * @return The S3 buckets that contain the objects to analyze, and the scope of that analysis.
     */
    public final S3JobDefinition s3JobDefinition() {
        return s3JobDefinition;
    }

    /**
     * <p>
     * The sampling depth, as a percentage, that determines the percentage of eligible objects that the job analyzes.
     * </p>
     * 
     * @return The sampling depth, as a percentage, that determines the percentage of eligible objects that the job
     *         analyzes.
     */
    public final Integer samplingPercentage() {
        return samplingPercentage;
    }

    /**
     * <p>
     * The recurrence pattern for running the job. This value is null if the job is configured to run only once.
     * </p>
     * 
     * @return The recurrence pattern for running the job. This value is null if the job is configured to run only once.
     */
    public final JobScheduleFrequency scheduleFrequency() {
        return scheduleFrequency;
    }

    /**
     * <p>
     * The number of times that the job has run and processing statistics for the job's current run.
     * </p>
     * 
     * @return The number of times that the job has run and processing statistics for the job's current run.
     */
    public final Statistics statistics() {
        return statistics;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of key-value pairs that specifies which tags (keys and values) are associated with the classification job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A map of key-value pairs that specifies which tags (keys and values) are associated with the
     *         classification job.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * If the current status of the job is USER_PAUSED, specifies when the job was paused and when the job or job run
     * will expire and be cancelled if it isn't resumed. This value is present only if the value for jobStatus is
     * USER_PAUSED.
     * </p>
     * 
     * @return If the current status of the job is USER_PAUSED, specifies when the job was paused and when the job or
     *         job run will expire and be cancelled if it isn't resumed. This value is present only if the value for
     *         jobStatus is USER_PAUSED.
     */
    public final UserPausedDetails userPausedDetails() {
        return userPausedDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(hasCustomDataIdentifierIds() ? customDataIdentifierIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(initialRun());
        hashCode = 31 * hashCode + Objects.hashCode(jobArn());
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(jobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(jobTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastRunErrorStatus());
        hashCode = 31 * hashCode + Objects.hashCode(lastRunTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasManagedDataIdentifierIds() ? managedDataIdentifierIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(managedDataIdentifierSelectorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(s3JobDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(samplingPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(scheduleFrequency());
        hashCode = 31 * hashCode + Objects.hashCode(statistics());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(userPausedDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeClassificationJobResponse)) {
            return false;
        }
        DescribeClassificationJobResponse other = (DescribeClassificationJobResponse) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(createdAt(), other.createdAt())
                && hasCustomDataIdentifierIds() == other.hasCustomDataIdentifierIds()
                && Objects.equals(customDataIdentifierIds(), other.customDataIdentifierIds())
                && Objects.equals(description(), other.description()) && Objects.equals(initialRun(), other.initialRun())
                && Objects.equals(jobArn(), other.jobArn()) && Objects.equals(jobId(), other.jobId())
                && Objects.equals(jobStatusAsString(), other.jobStatusAsString())
                && Objects.equals(jobTypeAsString(), other.jobTypeAsString())
                && Objects.equals(lastRunErrorStatus(), other.lastRunErrorStatus())
                && Objects.equals(lastRunTime(), other.lastRunTime())
                && hasManagedDataIdentifierIds() == other.hasManagedDataIdentifierIds()
                && Objects.equals(managedDataIdentifierIds(), other.managedDataIdentifierIds())
                && Objects.equals(managedDataIdentifierSelectorAsString(), other.managedDataIdentifierSelectorAsString())
                && Objects.equals(name(), other.name()) && Objects.equals(s3JobDefinition(), other.s3JobDefinition())
                && Objects.equals(samplingPercentage(), other.samplingPercentage())
                && Objects.equals(scheduleFrequency(), other.scheduleFrequency())
                && Objects.equals(statistics(), other.statistics()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(userPausedDetails(), other.userPausedDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeClassificationJobResponse").add("ClientToken", clientToken())
                .add("CreatedAt", createdAt())
                .add("CustomDataIdentifierIds", hasCustomDataIdentifierIds() ? customDataIdentifierIds() : null)
                .add("Description", description()).add("InitialRun", initialRun()).add("JobArn", jobArn()).add("JobId", jobId())
                .add("JobStatus", jobStatusAsString()).add("JobType", jobTypeAsString())
                .add("LastRunErrorStatus", lastRunErrorStatus()).add("LastRunTime", lastRunTime())
                .add("ManagedDataIdentifierIds", hasManagedDataIdentifierIds() ? managedDataIdentifierIds() : null)
                .add("ManagedDataIdentifierSelector", managedDataIdentifierSelectorAsString()).add("Name", name())
                .add("S3JobDefinition", s3JobDefinition()).add("SamplingPercentage", samplingPercentage())
                .add("ScheduleFrequency", scheduleFrequency()).add("Statistics", statistics())
                .add("Tags", hasTags() ? tags() : null).add("UserPausedDetails", userPausedDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "customDataIdentifierIds":
            return Optional.ofNullable(clazz.cast(customDataIdentifierIds()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "initialRun":
            return Optional.ofNullable(clazz.cast(initialRun()));
        case "jobArn":
            return Optional.ofNullable(clazz.cast(jobArn()));
        case "jobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "jobStatus":
            return Optional.ofNullable(clazz.cast(jobStatusAsString()));
        case "jobType":
            return Optional.ofNullable(clazz.cast(jobTypeAsString()));
        case "lastRunErrorStatus":
            return Optional.ofNullable(clazz.cast(lastRunErrorStatus()));
        case "lastRunTime":
            return Optional.ofNullable(clazz.cast(lastRunTime()));
        case "managedDataIdentifierIds":
            return Optional.ofNullable(clazz.cast(managedDataIdentifierIds()));
        case "managedDataIdentifierSelector":
            return Optional.ofNullable(clazz.cast(managedDataIdentifierSelectorAsString()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "s3JobDefinition":
            return Optional.ofNullable(clazz.cast(s3JobDefinition()));
        case "samplingPercentage":
            return Optional.ofNullable(clazz.cast(samplingPercentage()));
        case "scheduleFrequency":
            return Optional.ofNullable(clazz.cast(scheduleFrequency()));
        case "statistics":
            return Optional.ofNullable(clazz.cast(statistics()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "userPausedDetails":
            return Optional.ofNullable(clazz.cast(userPausedDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeClassificationJobResponse, T> g) {
        return obj -> g.apply((DescribeClassificationJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Macie2Response.Builder, SdkPojo, CopyableBuilder<Builder, DescribeClassificationJobResponse> {
        /**
         * <p>
         * The token that was provided to ensure the idempotency of the request to create the job.
         * </p>
         * 
         * @param clientToken
         *        The token that was provided to ensure the idempotency of the request to create the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The date and time, in UTC and extended ISO 8601 format, when the job was created.
         * </p>
         * 
         * @param createdAt
         *        The date and time, in UTC and extended ISO 8601 format, when the job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * An array of unique identifiers, one for each custom data identifier that the job uses to analyze data. This
         * value is null if the job uses only managed data identifiers to analyze data.
         * </p>
         * 
         * @param customDataIdentifierIds
         *        An array of unique identifiers, one for each custom data identifier that the job uses to analyze data.
         *        This value is null if the job uses only managed data identifiers to analyze data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customDataIdentifierIds(Collection<String> customDataIdentifierIds);

        /**
         * <p>
         * An array of unique identifiers, one for each custom data identifier that the job uses to analyze data. This
         * value is null if the job uses only managed data identifiers to analyze data.
         * </p>
         * 
         * @param customDataIdentifierIds
         *        An array of unique identifiers, one for each custom data identifier that the job uses to analyze data.
         *        This value is null if the job uses only managed data identifiers to analyze data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customDataIdentifierIds(String... customDataIdentifierIds);

        /**
         * <p>
         * The custom description of the job.
         * </p>
         * 
         * @param description
         *        The custom description of the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * For a recurring job, specifies whether you configured the job to analyze all existing, eligible objects
         * immediately after the job was created (true). If you configured the job to analyze only those objects that
         * were created or changed after the job was created and before the job's first scheduled run, this value is
         * false. This value is also false for a one-time job.
         * </p>
         * 
         * @param initialRun
         *        For a recurring job, specifies whether you configured the job to analyze all existing, eligible
         *        objects immediately after the job was created (true). If you configured the job to analyze only those
         *        objects that were created or changed after the job was created and before the job's first scheduled
         *        run, this value is false. This value is also false for a one-time job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initialRun(Boolean initialRun);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the job.
         * </p>
         * 
         * @param jobArn
         *        The Amazon Resource Name (ARN) of the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobArn(String jobArn);

        /**
         * <p>
         * The unique identifier for the job.
         * </p>
         * 
         * @param jobId
         *        The unique identifier for the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The current status of the job. Possible values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * CANCELLED - You cancelled the job or, if it's a one-time job, you paused the job and didn't resume it within
         * 30 days.
         * </p>
         * </li>
         * <li>
         * <p>
         * COMPLETE - For a one-time job, Amazon Macie finished processing the data specified for the job. This value
         * doesn't apply to recurring jobs.
         * </p>
         * </li>
         * <li>
         * <p>
         * IDLE - For a recurring job, the previous scheduled run is complete and the next scheduled run is pending.
         * This value doesn't apply to one-time jobs.
         * </p>
         * </li>
         * <li>
         * <p>
         * PAUSED - Macie started running the job but additional processing would exceed the monthly sensitive data
         * discovery quota for your account or one or more member accounts that the job analyzes data for.
         * </p>
         * </li>
         * <li>
         * <p>
         * RUNNING - For a one-time job, the job is in progress. For a recurring job, a scheduled run is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * USER_PAUSED - You paused the job. If you paused the job while it had a status of RUNNING and you don't resume
         * it within 30 days of pausing it, the job or job run will expire and be cancelled, depending on the job's
         * type. To check the expiration date, refer to the UserPausedDetails.jobExpiresAt property.
         * </p>
         * </li>
         * </ul>
         * 
         * @param jobStatus
         *        The current status of the job. Possible values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        CANCELLED - You cancelled the job or, if it's a one-time job, you paused the job and didn't resume it
         *        within 30 days.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        COMPLETE - For a one-time job, Amazon Macie finished processing the data specified for the job. This
         *        value doesn't apply to recurring jobs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        IDLE - For a recurring job, the previous scheduled run is complete and the next scheduled run is
         *        pending. This value doesn't apply to one-time jobs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PAUSED - Macie started running the job but additional processing would exceed the monthly sensitive
         *        data discovery quota for your account or one or more member accounts that the job analyzes data for.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RUNNING - For a one-time job, the job is in progress. For a recurring job, a scheduled run is in
         *        progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        USER_PAUSED - You paused the job. If you paused the job while it had a status of RUNNING and you don't
         *        resume it within 30 days of pausing it, the job or job run will expire and be cancelled, depending on
         *        the job's type. To check the expiration date, refer to the UserPausedDetails.jobExpiresAt property.
         *        </p>
         *        </li>
         * @see JobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatus
         */
        Builder jobStatus(String jobStatus);

        /**
         * <p>
         * The current status of the job. Possible values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * CANCELLED - You cancelled the job or, if it's a one-time job, you paused the job and didn't resume it within
         * 30 days.
         * </p>
         * </li>
         * <li>
         * <p>
         * COMPLETE - For a one-time job, Amazon Macie finished processing the data specified for the job. This value
         * doesn't apply to recurring jobs.
         * </p>
         * </li>
         * <li>
         * <p>
         * IDLE - For a recurring job, the previous scheduled run is complete and the next scheduled run is pending.
         * This value doesn't apply to one-time jobs.
         * </p>
         * </li>
         * <li>
         * <p>
         * PAUSED - Macie started running the job but additional processing would exceed the monthly sensitive data
         * discovery quota for your account or one or more member accounts that the job analyzes data for.
         * </p>
         * </li>
         * <li>
         * <p>
         * RUNNING - For a one-time job, the job is in progress. For a recurring job, a scheduled run is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * USER_PAUSED - You paused the job. If you paused the job while it had a status of RUNNING and you don't resume
         * it within 30 days of pausing it, the job or job run will expire and be cancelled, depending on the job's
         * type. To check the expiration date, refer to the UserPausedDetails.jobExpiresAt property.
         * </p>
         * </li>
         * </ul>
         * 
         * @param jobStatus
         *        The current status of the job. Possible values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        CANCELLED - You cancelled the job or, if it's a one-time job, you paused the job and didn't resume it
         *        within 30 days.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        COMPLETE - For a one-time job, Amazon Macie finished processing the data specified for the job. This
         *        value doesn't apply to recurring jobs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        IDLE - For a recurring job, the previous scheduled run is complete and the next scheduled run is
         *        pending. This value doesn't apply to one-time jobs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PAUSED - Macie started running the job but additional processing would exceed the monthly sensitive
         *        data discovery quota for your account or one or more member accounts that the job analyzes data for.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RUNNING - For a one-time job, the job is in progress. For a recurring job, a scheduled run is in
         *        progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        USER_PAUSED - You paused the job. If you paused the job while it had a status of RUNNING and you don't
         *        resume it within 30 days of pausing it, the job or job run will expire and be cancelled, depending on
         *        the job's type. To check the expiration date, refer to the UserPausedDetails.jobExpiresAt property.
         *        </p>
         *        </li>
         * @see JobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatus
         */
        Builder jobStatus(JobStatus jobStatus);

        /**
         * <p>
         * The schedule for running the job. Possible values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * ONE_TIME - The job runs only once.
         * </p>
         * </li>
         * <li>
         * <p>
         * SCHEDULED - The job runs on a daily, weekly, or monthly basis. The scheduleFrequency property indicates the
         * recurrence pattern for the job.
         * </p>
         * </li>
         * </ul>
         * 
         * @param jobType
         *        The schedule for running the job. Possible values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        ONE_TIME - The job runs only once.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SCHEDULED - The job runs on a daily, weekly, or monthly basis. The scheduleFrequency property
         *        indicates the recurrence pattern for the job.
         *        </p>
         *        </li>
         * @see JobType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobType
         */
        Builder jobType(String jobType);

        /**
         * <p>
         * The schedule for running the job. Possible values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * ONE_TIME - The job runs only once.
         * </p>
         * </li>
         * <li>
         * <p>
         * SCHEDULED - The job runs on a daily, weekly, or monthly basis. The scheduleFrequency property indicates the
         * recurrence pattern for the job.
         * </p>
         * </li>
         * </ul>
         * 
         * @param jobType
         *        The schedule for running the job. Possible values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        ONE_TIME - The job runs only once.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SCHEDULED - The job runs on a daily, weekly, or monthly basis. The scheduleFrequency property
         *        indicates the recurrence pattern for the job.
         *        </p>
         *        </li>
         * @see JobType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobType
         */
        Builder jobType(JobType jobType);

        /**
         * <p>
         * Specifies whether any account- or bucket-level access errors occurred when the job ran. For a recurring job,
         * this value indicates the error status of the job's most recent run.
         * </p>
         * 
         * @param lastRunErrorStatus
         *        Specifies whether any account- or bucket-level access errors occurred when the job ran. For a
         *        recurring job, this value indicates the error status of the job's most recent run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastRunErrorStatus(LastRunErrorStatus lastRunErrorStatus);

        /**
         * <p>
         * Specifies whether any account- or bucket-level access errors occurred when the job ran. For a recurring job,
         * this value indicates the error status of the job's most recent run.
         * </p>
         * This is a convenience method that creates an instance of the {@link LastRunErrorStatus.Builder} avoiding the
         * need to create one manually via {@link LastRunErrorStatus#builder()}.
         *
         * When the {@link Consumer} completes, {@link LastRunErrorStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #lastRunErrorStatus(LastRunErrorStatus)}.
         * 
         * @param lastRunErrorStatus
         *        a consumer that will call methods on {@link LastRunErrorStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lastRunErrorStatus(LastRunErrorStatus)
         */
        default Builder lastRunErrorStatus(Consumer<LastRunErrorStatus.Builder> lastRunErrorStatus) {
            return lastRunErrorStatus(LastRunErrorStatus.builder().applyMutation(lastRunErrorStatus).build());
        }

        /**
         * <p>
         * The date and time, in UTC and extended ISO 8601 format, when the job started. If the job is a recurring job,
         * this value indicates when the most recent run started or, if the job hasn't run yet, when the job was
         * created.
         * </p>
         * 
         * @param lastRunTime
         *        The date and time, in UTC and extended ISO 8601 format, when the job started. If the job is a
         *        recurring job, this value indicates when the most recent run started or, if the job hasn't run yet,
         *        when the job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastRunTime(Instant lastRunTime);

        /**
         * <p>
         * An array of unique identifiers, one for each managed data identifier that the job is explicitly configured to
         * include (use) or exclude (not use) when it analyzes data. Inclusion or exclusion depends on the managed data
         * identifier selection type specified for the job (managedDataIdentifierSelector). This value is null if the
         * job's managed data identifier selection type is ALL or the job uses only custom data identifiers
         * (customDataIdentifierIds) to analyze data.
         * </p>
         * 
         * @param managedDataIdentifierIds
         *        An array of unique identifiers, one for each managed data identifier that the job is explicitly
         *        configured to include (use) or exclude (not use) when it analyzes data. Inclusion or exclusion depends
         *        on the managed data identifier selection type specified for the job (managedDataIdentifierSelector).
         *        This value is null if the job's managed data identifier selection type is ALL or the job uses only
         *        custom data identifiers (customDataIdentifierIds) to analyze data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedDataIdentifierIds(Collection<String> managedDataIdentifierIds);

        /**
         * <p>
         * An array of unique identifiers, one for each managed data identifier that the job is explicitly configured to
         * include (use) or exclude (not use) when it analyzes data. Inclusion or exclusion depends on the managed data
         * identifier selection type specified for the job (managedDataIdentifierSelector). This value is null if the
         * job's managed data identifier selection type is ALL or the job uses only custom data identifiers
         * (customDataIdentifierIds) to analyze data.
         * </p>
         * 
         * @param managedDataIdentifierIds
         *        An array of unique identifiers, one for each managed data identifier that the job is explicitly
         *        configured to include (use) or exclude (not use) when it analyzes data. Inclusion or exclusion depends
         *        on the managed data identifier selection type specified for the job (managedDataIdentifierSelector).
         *        This value is null if the job's managed data identifier selection type is ALL or the job uses only
         *        custom data identifiers (customDataIdentifierIds) to analyze data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedDataIdentifierIds(String... managedDataIdentifierIds);

        /**
         * <p>
         * The selection type that determines which managed data identifiers the job uses to analyze data. Possible
         * values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * ALL - Use all the managed data identifiers that Amazon Macie provides.
         * </p>
         * </li>
         * <li>
         * <p>
         * EXCLUDE - Use all the managed data identifiers that Macie provides except the managed data identifiers
         * specified by the managedDataIdentifierIds property.
         * </p>
         * </li>
         * <li>
         * <p>
         * INCLUDE - Use only the managed data identifiers specified by the managedDataIdentifierIds property.
         * </p>
         * </li>
         * <li>
         * <p>
         * NONE - Don't use any managed data identifiers.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If this value is null, the job uses all managed data identifiers. If this value is null, ALL, or EXCLUDE for
         * a recurring job, the job also uses new managed data identifiers as they are released.
         * </p>
         * 
         * @param managedDataIdentifierSelector
         *        The selection type that determines which managed data identifiers the job uses to analyze data.
         *        Possible values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        ALL - Use all the managed data identifiers that Amazon Macie provides.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        EXCLUDE - Use all the managed data identifiers that Macie provides except the managed data identifiers
         *        specified by the managedDataIdentifierIds property.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INCLUDE - Use only the managed data identifiers specified by the managedDataIdentifierIds property.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        NONE - Don't use any managed data identifiers.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If this value is null, the job uses all managed data identifiers. If this value is null, ALL, or
         *        EXCLUDE for a recurring job, the job also uses new managed data identifiers as they are released.
         * @see ManagedDataIdentifierSelector
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ManagedDataIdentifierSelector
         */
        Builder managedDataIdentifierSelector(String managedDataIdentifierSelector);

        /**
         * <p>
         * The selection type that determines which managed data identifiers the job uses to analyze data. Possible
         * values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * ALL - Use all the managed data identifiers that Amazon Macie provides.
         * </p>
         * </li>
         * <li>
         * <p>
         * EXCLUDE - Use all the managed data identifiers that Macie provides except the managed data identifiers
         * specified by the managedDataIdentifierIds property.
         * </p>
         * </li>
         * <li>
         * <p>
         * INCLUDE - Use only the managed data identifiers specified by the managedDataIdentifierIds property.
         * </p>
         * </li>
         * <li>
         * <p>
         * NONE - Don't use any managed data identifiers.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If this value is null, the job uses all managed data identifiers. If this value is null, ALL, or EXCLUDE for
         * a recurring job, the job also uses new managed data identifiers as they are released.
         * </p>
         * 
         * @param managedDataIdentifierSelector
         *        The selection type that determines which managed data identifiers the job uses to analyze data.
         *        Possible values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        ALL - Use all the managed data identifiers that Amazon Macie provides.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        EXCLUDE - Use all the managed data identifiers that Macie provides except the managed data identifiers
         *        specified by the managedDataIdentifierIds property.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INCLUDE - Use only the managed data identifiers specified by the managedDataIdentifierIds property.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        NONE - Don't use any managed data identifiers.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If this value is null, the job uses all managed data identifiers. If this value is null, ALL, or
         *        EXCLUDE for a recurring job, the job also uses new managed data identifiers as they are released.
         * @see ManagedDataIdentifierSelector
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ManagedDataIdentifierSelector
         */
        Builder managedDataIdentifierSelector(ManagedDataIdentifierSelector managedDataIdentifierSelector);

        /**
         * <p>
         * The custom name of the job.
         * </p>
         * 
         * @param name
         *        The custom name of the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The S3 buckets that contain the objects to analyze, and the scope of that analysis.
         * </p>
         * 
         * @param s3JobDefinition
         *        The S3 buckets that contain the objects to analyze, and the scope of that analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3JobDefinition(S3JobDefinition s3JobDefinition);

        /**
         * <p>
         * The S3 buckets that contain the objects to analyze, and the scope of that analysis.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3JobDefinition.Builder} avoiding the
         * need to create one manually via {@link S3JobDefinition#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3JobDefinition.Builder#build()} is called immediately and its
         * result is passed to {@link #s3JobDefinition(S3JobDefinition)}.
         * 
         * @param s3JobDefinition
         *        a consumer that will call methods on {@link S3JobDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3JobDefinition(S3JobDefinition)
         */
        default Builder s3JobDefinition(Consumer<S3JobDefinition.Builder> s3JobDefinition) {
            return s3JobDefinition(S3JobDefinition.builder().applyMutation(s3JobDefinition).build());
        }

        /**
         * <p>
         * The sampling depth, as a percentage, that determines the percentage of eligible objects that the job
         * analyzes.
         * </p>
         * 
         * @param samplingPercentage
         *        The sampling depth, as a percentage, that determines the percentage of eligible objects that the job
         *        analyzes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder samplingPercentage(Integer samplingPercentage);

        /**
         * <p>
         * The recurrence pattern for running the job. This value is null if the job is configured to run only once.
         * </p>
         * 
         * @param scheduleFrequency
         *        The recurrence pattern for running the job. This value is null if the job is configured to run only
         *        once.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleFrequency(JobScheduleFrequency scheduleFrequency);

        /**
         * <p>
         * The recurrence pattern for running the job. This value is null if the job is configured to run only once.
         * </p>
         * This is a convenience method that creates an instance of the {@link JobScheduleFrequency.Builder} avoiding
         * the need to create one manually via {@link JobScheduleFrequency#builder()}.
         *
         * When the {@link Consumer} completes, {@link JobScheduleFrequency.Builder#build()} is called immediately and
         * its result is passed to {@link #scheduleFrequency(JobScheduleFrequency)}.
         * 
         * @param scheduleFrequency
         *        a consumer that will call methods on {@link JobScheduleFrequency.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scheduleFrequency(JobScheduleFrequency)
         */
        default Builder scheduleFrequency(Consumer<JobScheduleFrequency.Builder> scheduleFrequency) {
            return scheduleFrequency(JobScheduleFrequency.builder().applyMutation(scheduleFrequency).build());
        }

        /**
         * <p>
         * The number of times that the job has run and processing statistics for the job's current run.
         * </p>
         * 
         * @param statistics
         *        The number of times that the job has run and processing statistics for the job's current run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statistics(Statistics statistics);

        /**
         * <p>
         * The number of times that the job has run and processing statistics for the job's current run.
         * </p>
         * This is a convenience method that creates an instance of the {@link Statistics.Builder} avoiding the need to
         * create one manually via {@link Statistics#builder()}.
         *
         * When the {@link Consumer} completes, {@link Statistics.Builder#build()} is called immediately and its result
         * is passed to {@link #statistics(Statistics)}.
         * 
         * @param statistics
         *        a consumer that will call methods on {@link Statistics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #statistics(Statistics)
         */
        default Builder statistics(Consumer<Statistics.Builder> statistics) {
            return statistics(Statistics.builder().applyMutation(statistics).build());
        }

        /**
         * <p>
         * A map of key-value pairs that specifies which tags (keys and values) are associated with the classification
         * job.
         * </p>
         * 
         * @param tags
         *        A map of key-value pairs that specifies which tags (keys and values) are associated with the
         *        classification job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * If the current status of the job is USER_PAUSED, specifies when the job was paused and when the job or job
         * run will expire and be cancelled if it isn't resumed. This value is present only if the value for jobStatus
         * is USER_PAUSED.
         * </p>
         * 
         * @param userPausedDetails
         *        If the current status of the job is USER_PAUSED, specifies when the job was paused and when the job or
         *        job run will expire and be cancelled if it isn't resumed. This value is present only if the value for
         *        jobStatus is USER_PAUSED.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userPausedDetails(UserPausedDetails userPausedDetails);

        /**
         * <p>
         * If the current status of the job is USER_PAUSED, specifies when the job was paused and when the job or job
         * run will expire and be cancelled if it isn't resumed. This value is present only if the value for jobStatus
         * is USER_PAUSED.
         * </p>
         * This is a convenience method that creates an instance of the {@link UserPausedDetails.Builder} avoiding the
         * need to create one manually via {@link UserPausedDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link UserPausedDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #userPausedDetails(UserPausedDetails)}.
         * 
         * @param userPausedDetails
         *        a consumer that will call methods on {@link UserPausedDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userPausedDetails(UserPausedDetails)
         */
        default Builder userPausedDetails(Consumer<UserPausedDetails.Builder> userPausedDetails) {
            return userPausedDetails(UserPausedDetails.builder().applyMutation(userPausedDetails).build());
        }
    }

    static final class BuilderImpl extends Macie2Response.BuilderImpl implements Builder {
        private String clientToken;

        private Instant createdAt;

        private List<String> customDataIdentifierIds = DefaultSdkAutoConstructList.getInstance();

        private String description;

        private Boolean initialRun;

        private String jobArn;

        private String jobId;

        private String jobStatus;

        private String jobType;

        private LastRunErrorStatus lastRunErrorStatus;

        private Instant lastRunTime;

        private List<String> managedDataIdentifierIds = DefaultSdkAutoConstructList.getInstance();

        private String managedDataIdentifierSelector;

        private String name;

        private S3JobDefinition s3JobDefinition;

        private Integer samplingPercentage;

        private JobScheduleFrequency scheduleFrequency;

        private Statistics statistics;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private UserPausedDetails userPausedDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeClassificationJobResponse model) {
            super(model);
            clientToken(model.clientToken);
            createdAt(model.createdAt);
            customDataIdentifierIds(model.customDataIdentifierIds);
            description(model.description);
            initialRun(model.initialRun);
            jobArn(model.jobArn);
            jobId(model.jobId);
            jobStatus(model.jobStatus);
            jobType(model.jobType);
            lastRunErrorStatus(model.lastRunErrorStatus);
            lastRunTime(model.lastRunTime);
            managedDataIdentifierIds(model.managedDataIdentifierIds);
            managedDataIdentifierSelector(model.managedDataIdentifierSelector);
            name(model.name);
            s3JobDefinition(model.s3JobDefinition);
            samplingPercentage(model.samplingPercentage);
            scheduleFrequency(model.scheduleFrequency);
            statistics(model.statistics);
            tags(model.tags);
            userPausedDetails(model.userPausedDetails);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Collection<String> getCustomDataIdentifierIds() {
            if (customDataIdentifierIds instanceof SdkAutoConstructList) {
                return null;
            }
            return customDataIdentifierIds;
        }

        public final void setCustomDataIdentifierIds(Collection<String> customDataIdentifierIds) {
            this.customDataIdentifierIds = ___listOf__stringCopier.copy(customDataIdentifierIds);
        }

        @Override
        public final Builder customDataIdentifierIds(Collection<String> customDataIdentifierIds) {
            this.customDataIdentifierIds = ___listOf__stringCopier.copy(customDataIdentifierIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customDataIdentifierIds(String... customDataIdentifierIds) {
            customDataIdentifierIds(Arrays.asList(customDataIdentifierIds));
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getInitialRun() {
            return initialRun;
        }

        public final void setInitialRun(Boolean initialRun) {
            this.initialRun = initialRun;
        }

        @Override
        public final Builder initialRun(Boolean initialRun) {
            this.initialRun = initialRun;
            return this;
        }

        public final String getJobArn() {
            return jobArn;
        }

        public final void setJobArn(String jobArn) {
            this.jobArn = jobArn;
        }

        @Override
        public final Builder jobArn(String jobArn) {
            this.jobArn = jobArn;
            return this;
        }

        public final String getJobId() {
            return jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getJobStatus() {
            return jobStatus;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        @Override
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        public final Builder jobStatus(JobStatus jobStatus) {
            this.jobStatus(jobStatus == null ? null : jobStatus.toString());
            return this;
        }

        public final String getJobType() {
            return jobType;
        }

        public final void setJobType(String jobType) {
            this.jobType = jobType;
        }

        @Override
        public final Builder jobType(String jobType) {
            this.jobType = jobType;
            return this;
        }

        @Override
        public final Builder jobType(JobType jobType) {
            this.jobType(jobType == null ? null : jobType.toString());
            return this;
        }

        public final LastRunErrorStatus.Builder getLastRunErrorStatus() {
            return lastRunErrorStatus != null ? lastRunErrorStatus.toBuilder() : null;
        }

        public final void setLastRunErrorStatus(LastRunErrorStatus.BuilderImpl lastRunErrorStatus) {
            this.lastRunErrorStatus = lastRunErrorStatus != null ? lastRunErrorStatus.build() : null;
        }

        @Override
        public final Builder lastRunErrorStatus(LastRunErrorStatus lastRunErrorStatus) {
            this.lastRunErrorStatus = lastRunErrorStatus;
            return this;
        }

        public final Instant getLastRunTime() {
            return lastRunTime;
        }

        public final void setLastRunTime(Instant lastRunTime) {
            this.lastRunTime = lastRunTime;
        }

        @Override
        public final Builder lastRunTime(Instant lastRunTime) {
            this.lastRunTime = lastRunTime;
            return this;
        }

        public final Collection<String> getManagedDataIdentifierIds() {
            if (managedDataIdentifierIds instanceof SdkAutoConstructList) {
                return null;
            }
            return managedDataIdentifierIds;
        }

        public final void setManagedDataIdentifierIds(Collection<String> managedDataIdentifierIds) {
            this.managedDataIdentifierIds = ___listOf__stringCopier.copy(managedDataIdentifierIds);
        }

        @Override
        public final Builder managedDataIdentifierIds(Collection<String> managedDataIdentifierIds) {
            this.managedDataIdentifierIds = ___listOf__stringCopier.copy(managedDataIdentifierIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder managedDataIdentifierIds(String... managedDataIdentifierIds) {
            managedDataIdentifierIds(Arrays.asList(managedDataIdentifierIds));
            return this;
        }

        public final String getManagedDataIdentifierSelector() {
            return managedDataIdentifierSelector;
        }

        public final void setManagedDataIdentifierSelector(String managedDataIdentifierSelector) {
            this.managedDataIdentifierSelector = managedDataIdentifierSelector;
        }

        @Override
        public final Builder managedDataIdentifierSelector(String managedDataIdentifierSelector) {
            this.managedDataIdentifierSelector = managedDataIdentifierSelector;
            return this;
        }

        @Override
        public final Builder managedDataIdentifierSelector(ManagedDataIdentifierSelector managedDataIdentifierSelector) {
            this.managedDataIdentifierSelector(managedDataIdentifierSelector == null ? null : managedDataIdentifierSelector
                    .toString());
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final S3JobDefinition.Builder getS3JobDefinition() {
            return s3JobDefinition != null ? s3JobDefinition.toBuilder() : null;
        }

        public final void setS3JobDefinition(S3JobDefinition.BuilderImpl s3JobDefinition) {
            this.s3JobDefinition = s3JobDefinition != null ? s3JobDefinition.build() : null;
        }

        @Override
        public final Builder s3JobDefinition(S3JobDefinition s3JobDefinition) {
            this.s3JobDefinition = s3JobDefinition;
            return this;
        }

        public final Integer getSamplingPercentage() {
            return samplingPercentage;
        }

        public final void setSamplingPercentage(Integer samplingPercentage) {
            this.samplingPercentage = samplingPercentage;
        }

        @Override
        public final Builder samplingPercentage(Integer samplingPercentage) {
            this.samplingPercentage = samplingPercentage;
            return this;
        }

        public final JobScheduleFrequency.Builder getScheduleFrequency() {
            return scheduleFrequency != null ? scheduleFrequency.toBuilder() : null;
        }

        public final void setScheduleFrequency(JobScheduleFrequency.BuilderImpl scheduleFrequency) {
            this.scheduleFrequency = scheduleFrequency != null ? scheduleFrequency.build() : null;
        }

        @Override
        public final Builder scheduleFrequency(JobScheduleFrequency scheduleFrequency) {
            this.scheduleFrequency = scheduleFrequency;
            return this;
        }

        public final Statistics.Builder getStatistics() {
            return statistics != null ? statistics.toBuilder() : null;
        }

        public final void setStatistics(Statistics.BuilderImpl statistics) {
            this.statistics = statistics != null ? statistics.build() : null;
        }

        @Override
        public final Builder statistics(Statistics statistics) {
            this.statistics = statistics;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final UserPausedDetails.Builder getUserPausedDetails() {
            return userPausedDetails != null ? userPausedDetails.toBuilder() : null;
        }

        public final void setUserPausedDetails(UserPausedDetails.BuilderImpl userPausedDetails) {
            this.userPausedDetails = userPausedDetails != null ? userPausedDetails.build() : null;
        }

        @Override
        public final Builder userPausedDetails(UserPausedDetails userPausedDetails) {
            this.userPausedDetails = userPausedDetails;
            return this;
        }

        @Override
        public DescribeClassificationJobResponse build() {
            return new DescribeClassificationJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
