/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSensitiveDataOccurrencesAvailabilityResponse extends Macie2Response
        implements
        ToCopyableBuilder<GetSensitiveDataOccurrencesAvailabilityResponse.Builder, GetSensitiveDataOccurrencesAvailabilityResponse> {
    private static final SdkField<String> CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("code")
            .getter(getter(GetSensitiveDataOccurrencesAvailabilityResponse::codeAsString)).setter(setter(Builder::code))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("code").build()).build();

    private static final SdkField<List<String>> REASONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("reasons")
            .getter(getter(GetSensitiveDataOccurrencesAvailabilityResponse::reasonsAsStrings))
            .setter(setter(Builder::reasonsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reasons").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_FIELD, REASONS_FIELD));

    private final String code;

    private final List<String> reasons;

    private GetSensitiveDataOccurrencesAvailabilityResponse(BuilderImpl builder) {
        super(builder);
        this.code = builder.code;
        this.reasons = builder.reasons;
    }

    /**
     * <p>
     * Specifies whether occurrences of sensitive data can be retrieved for the finding. Possible values are: AVAILABLE,
     * the sensitive data can be retrieved; and, UNAVAILABLE, the sensitive data can't be retrieved. If this value is
     * UNAVAILABLE, the reasons array indicates why the data can't be retrieved.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #code} will return
     * {@link AvailabilityCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #codeAsString}.
     * </p>
     * 
     * @return Specifies whether occurrences of sensitive data can be retrieved for the finding. Possible values are:
     *         AVAILABLE, the sensitive data can be retrieved; and, UNAVAILABLE, the sensitive data can't be retrieved.
     *         If this value is UNAVAILABLE, the reasons array indicates why the data can't be retrieved.
     * @see AvailabilityCode
     */
    public final AvailabilityCode code() {
        return AvailabilityCode.fromValue(code);
    }

    /**
     * <p>
     * Specifies whether occurrences of sensitive data can be retrieved for the finding. Possible values are: AVAILABLE,
     * the sensitive data can be retrieved; and, UNAVAILABLE, the sensitive data can't be retrieved. If this value is
     * UNAVAILABLE, the reasons array indicates why the data can't be retrieved.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #code} will return
     * {@link AvailabilityCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #codeAsString}.
     * </p>
     * 
     * @return Specifies whether occurrences of sensitive data can be retrieved for the finding. Possible values are:
     *         AVAILABLE, the sensitive data can be retrieved; and, UNAVAILABLE, the sensitive data can't be retrieved.
     *         If this value is UNAVAILABLE, the reasons array indicates why the data can't be retrieved.
     * @see AvailabilityCode
     */
    public final String codeAsString() {
        return code;
    }

    /**
     * <p>
     * Specifies why occurrences of sensitive data can't be retrieved for the finding. Possible values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * INVALID_CLASSIFICATION_RESULT - Amazon Macie can't verify the location of the sensitive data to retrieve. There
     * isn't a corresponding sensitive data discovery result for the finding. Or the sensitive data discovery result
     * specified by the ClassificationDetails.detailedResultsLocation field of the finding isn't available, is malformed
     * or corrupted, or uses an unsupported storage format.
     * </p>
     * </li>
     * <li>
     * <p>
     * OBJECT_EXCEEDS_SIZE_QUOTA - The storage size of the affected S3 object exceeds the size quota for retrieving
     * occurrences of sensitive data.
     * </p>
     * </li>
     * <li>
     * <p>
     * OBJECT_UNAVAILABLE - The affected S3 object isn't available. The object might have been renamed, moved, or
     * deleted. Or the object was changed after Amazon Macie created the finding.
     * </p>
     * </li>
     * <li>
     * <p>
     * UNSUPPORTED_FINDING_TYPE - The specified finding isn't a sensitive data finding.
     * </p>
     * </li>
     * <li>
     * <p>
     * UNSUPPORTED_OBJECT_TYPE - The affected S3 object uses a file or storage format that Macie doesn't support for
     * retrieving occurrences of sensitive data.
     * </p>
     * </li>
     * </ul>
     * <p>
     * This value is null if sensitive data can be retrieved for the finding.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReasons} method.
     * </p>
     * 
     * @return Specifies why occurrences of sensitive data can't be retrieved for the finding. Possible values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         INVALID_CLASSIFICATION_RESULT - Amazon Macie can't verify the location of the sensitive data to retrieve.
     *         There isn't a corresponding sensitive data discovery result for the finding. Or the sensitive data
     *         discovery result specified by the ClassificationDetails.detailedResultsLocation field of the finding
     *         isn't available, is malformed or corrupted, or uses an unsupported storage format.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OBJECT_EXCEEDS_SIZE_QUOTA - The storage size of the affected S3 object exceeds the size quota for
     *         retrieving occurrences of sensitive data.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OBJECT_UNAVAILABLE - The affected S3 object isn't available. The object might have been renamed, moved,
     *         or deleted. Or the object was changed after Amazon Macie created the finding.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UNSUPPORTED_FINDING_TYPE - The specified finding isn't a sensitive data finding.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UNSUPPORTED_OBJECT_TYPE - The affected S3 object uses a file or storage format that Macie doesn't support
     *         for retrieving occurrences of sensitive data.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         This value is null if sensitive data can be retrieved for the finding.
     */
    public final List<UnavailabilityReasonCode> reasons() {
        return ___listOfUnavailabilityReasonCodeCopier.copyStringToEnum(reasons);
    }

    /**
     * For responses, this returns true if the service returned a value for the Reasons property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasReasons() {
        return reasons != null && !(reasons instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies why occurrences of sensitive data can't be retrieved for the finding. Possible values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * INVALID_CLASSIFICATION_RESULT - Amazon Macie can't verify the location of the sensitive data to retrieve. There
     * isn't a corresponding sensitive data discovery result for the finding. Or the sensitive data discovery result
     * specified by the ClassificationDetails.detailedResultsLocation field of the finding isn't available, is malformed
     * or corrupted, or uses an unsupported storage format.
     * </p>
     * </li>
     * <li>
     * <p>
     * OBJECT_EXCEEDS_SIZE_QUOTA - The storage size of the affected S3 object exceeds the size quota for retrieving
     * occurrences of sensitive data.
     * </p>
     * </li>
     * <li>
     * <p>
     * OBJECT_UNAVAILABLE - The affected S3 object isn't available. The object might have been renamed, moved, or
     * deleted. Or the object was changed after Amazon Macie created the finding.
     * </p>
     * </li>
     * <li>
     * <p>
     * UNSUPPORTED_FINDING_TYPE - The specified finding isn't a sensitive data finding.
     * </p>
     * </li>
     * <li>
     * <p>
     * UNSUPPORTED_OBJECT_TYPE - The affected S3 object uses a file or storage format that Macie doesn't support for
     * retrieving occurrences of sensitive data.
     * </p>
     * </li>
     * </ul>
     * <p>
     * This value is null if sensitive data can be retrieved for the finding.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReasons} method.
     * </p>
     * 
     * @return Specifies why occurrences of sensitive data can't be retrieved for the finding. Possible values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         INVALID_CLASSIFICATION_RESULT - Amazon Macie can't verify the location of the sensitive data to retrieve.
     *         There isn't a corresponding sensitive data discovery result for the finding. Or the sensitive data
     *         discovery result specified by the ClassificationDetails.detailedResultsLocation field of the finding
     *         isn't available, is malformed or corrupted, or uses an unsupported storage format.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OBJECT_EXCEEDS_SIZE_QUOTA - The storage size of the affected S3 object exceeds the size quota for
     *         retrieving occurrences of sensitive data.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OBJECT_UNAVAILABLE - The affected S3 object isn't available. The object might have been renamed, moved,
     *         or deleted. Or the object was changed after Amazon Macie created the finding.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UNSUPPORTED_FINDING_TYPE - The specified finding isn't a sensitive data finding.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UNSUPPORTED_OBJECT_TYPE - The affected S3 object uses a file or storage format that Macie doesn't support
     *         for retrieving occurrences of sensitive data.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         This value is null if sensitive data can be retrieved for the finding.
     */
    public final List<String> reasonsAsStrings() {
        return reasons;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(codeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasReasons() ? reasonsAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSensitiveDataOccurrencesAvailabilityResponse)) {
            return false;
        }
        GetSensitiveDataOccurrencesAvailabilityResponse other = (GetSensitiveDataOccurrencesAvailabilityResponse) obj;
        return Objects.equals(codeAsString(), other.codeAsString()) && hasReasons() == other.hasReasons()
                && Objects.equals(reasonsAsStrings(), other.reasonsAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSensitiveDataOccurrencesAvailabilityResponse").add("Code", codeAsString())
                .add("Reasons", hasReasons() ? reasonsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "code":
            return Optional.ofNullable(clazz.cast(codeAsString()));
        case "reasons":
            return Optional.ofNullable(clazz.cast(reasonsAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSensitiveDataOccurrencesAvailabilityResponse, T> g) {
        return obj -> g.apply((GetSensitiveDataOccurrencesAvailabilityResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Macie2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, GetSensitiveDataOccurrencesAvailabilityResponse> {
        /**
         * <p>
         * Specifies whether occurrences of sensitive data can be retrieved for the finding. Possible values are:
         * AVAILABLE, the sensitive data can be retrieved; and, UNAVAILABLE, the sensitive data can't be retrieved. If
         * this value is UNAVAILABLE, the reasons array indicates why the data can't be retrieved.
         * </p>
         * 
         * @param code
         *        Specifies whether occurrences of sensitive data can be retrieved for the finding. Possible values are:
         *        AVAILABLE, the sensitive data can be retrieved; and, UNAVAILABLE, the sensitive data can't be
         *        retrieved. If this value is UNAVAILABLE, the reasons array indicates why the data can't be retrieved.
         * @see AvailabilityCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AvailabilityCode
         */
        Builder code(String code);

        /**
         * <p>
         * Specifies whether occurrences of sensitive data can be retrieved for the finding. Possible values are:
         * AVAILABLE, the sensitive data can be retrieved; and, UNAVAILABLE, the sensitive data can't be retrieved. If
         * this value is UNAVAILABLE, the reasons array indicates why the data can't be retrieved.
         * </p>
         * 
         * @param code
         *        Specifies whether occurrences of sensitive data can be retrieved for the finding. Possible values are:
         *        AVAILABLE, the sensitive data can be retrieved; and, UNAVAILABLE, the sensitive data can't be
         *        retrieved. If this value is UNAVAILABLE, the reasons array indicates why the data can't be retrieved.
         * @see AvailabilityCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AvailabilityCode
         */
        Builder code(AvailabilityCode code);

        /**
         * <p>
         * Specifies why occurrences of sensitive data can't be retrieved for the finding. Possible values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * INVALID_CLASSIFICATION_RESULT - Amazon Macie can't verify the location of the sensitive data to retrieve.
         * There isn't a corresponding sensitive data discovery result for the finding. Or the sensitive data discovery
         * result specified by the ClassificationDetails.detailedResultsLocation field of the finding isn't available,
         * is malformed or corrupted, or uses an unsupported storage format.
         * </p>
         * </li>
         * <li>
         * <p>
         * OBJECT_EXCEEDS_SIZE_QUOTA - The storage size of the affected S3 object exceeds the size quota for retrieving
         * occurrences of sensitive data.
         * </p>
         * </li>
         * <li>
         * <p>
         * OBJECT_UNAVAILABLE - The affected S3 object isn't available. The object might have been renamed, moved, or
         * deleted. Or the object was changed after Amazon Macie created the finding.
         * </p>
         * </li>
         * <li>
         * <p>
         * UNSUPPORTED_FINDING_TYPE - The specified finding isn't a sensitive data finding.
         * </p>
         * </li>
         * <li>
         * <p>
         * UNSUPPORTED_OBJECT_TYPE - The affected S3 object uses a file or storage format that Macie doesn't support for
         * retrieving occurrences of sensitive data.
         * </p>
         * </li>
         * </ul>
         * <p>
         * This value is null if sensitive data can be retrieved for the finding.
         * </p>
         * 
         * @param reasons
         *        Specifies why occurrences of sensitive data can't be retrieved for the finding. Possible values
         *        are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        INVALID_CLASSIFICATION_RESULT - Amazon Macie can't verify the location of the sensitive data to
         *        retrieve. There isn't a corresponding sensitive data discovery result for the finding. Or the
         *        sensitive data discovery result specified by the ClassificationDetails.detailedResultsLocation field
         *        of the finding isn't available, is malformed or corrupted, or uses an unsupported storage format.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        OBJECT_EXCEEDS_SIZE_QUOTA - The storage size of the affected S3 object exceeds the size quota for
         *        retrieving occurrences of sensitive data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        OBJECT_UNAVAILABLE - The affected S3 object isn't available. The object might have been renamed,
         *        moved, or deleted. Or the object was changed after Amazon Macie created the finding.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UNSUPPORTED_FINDING_TYPE - The specified finding isn't a sensitive data finding.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UNSUPPORTED_OBJECT_TYPE - The affected S3 object uses a file or storage format that Macie doesn't
         *        support for retrieving occurrences of sensitive data.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        This value is null if sensitive data can be retrieved for the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reasonsWithStrings(Collection<String> reasons);

        /**
         * <p>
         * Specifies why occurrences of sensitive data can't be retrieved for the finding. Possible values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * INVALID_CLASSIFICATION_RESULT - Amazon Macie can't verify the location of the sensitive data to retrieve.
         * There isn't a corresponding sensitive data discovery result for the finding. Or the sensitive data discovery
         * result specified by the ClassificationDetails.detailedResultsLocation field of the finding isn't available,
         * is malformed or corrupted, or uses an unsupported storage format.
         * </p>
         * </li>
         * <li>
         * <p>
         * OBJECT_EXCEEDS_SIZE_QUOTA - The storage size of the affected S3 object exceeds the size quota for retrieving
         * occurrences of sensitive data.
         * </p>
         * </li>
         * <li>
         * <p>
         * OBJECT_UNAVAILABLE - The affected S3 object isn't available. The object might have been renamed, moved, or
         * deleted. Or the object was changed after Amazon Macie created the finding.
         * </p>
         * </li>
         * <li>
         * <p>
         * UNSUPPORTED_FINDING_TYPE - The specified finding isn't a sensitive data finding.
         * </p>
         * </li>
         * <li>
         * <p>
         * UNSUPPORTED_OBJECT_TYPE - The affected S3 object uses a file or storage format that Macie doesn't support for
         * retrieving occurrences of sensitive data.
         * </p>
         * </li>
         * </ul>
         * <p>
         * This value is null if sensitive data can be retrieved for the finding.
         * </p>
         * 
         * @param reasons
         *        Specifies why occurrences of sensitive data can't be retrieved for the finding. Possible values
         *        are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        INVALID_CLASSIFICATION_RESULT - Amazon Macie can't verify the location of the sensitive data to
         *        retrieve. There isn't a corresponding sensitive data discovery result for the finding. Or the
         *        sensitive data discovery result specified by the ClassificationDetails.detailedResultsLocation field
         *        of the finding isn't available, is malformed or corrupted, or uses an unsupported storage format.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        OBJECT_EXCEEDS_SIZE_QUOTA - The storage size of the affected S3 object exceeds the size quota for
         *        retrieving occurrences of sensitive data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        OBJECT_UNAVAILABLE - The affected S3 object isn't available. The object might have been renamed,
         *        moved, or deleted. Or the object was changed after Amazon Macie created the finding.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UNSUPPORTED_FINDING_TYPE - The specified finding isn't a sensitive data finding.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UNSUPPORTED_OBJECT_TYPE - The affected S3 object uses a file or storage format that Macie doesn't
         *        support for retrieving occurrences of sensitive data.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        This value is null if sensitive data can be retrieved for the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reasonsWithStrings(String... reasons);

        /**
         * <p>
         * Specifies why occurrences of sensitive data can't be retrieved for the finding. Possible values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * INVALID_CLASSIFICATION_RESULT - Amazon Macie can't verify the location of the sensitive data to retrieve.
         * There isn't a corresponding sensitive data discovery result for the finding. Or the sensitive data discovery
         * result specified by the ClassificationDetails.detailedResultsLocation field of the finding isn't available,
         * is malformed or corrupted, or uses an unsupported storage format.
         * </p>
         * </li>
         * <li>
         * <p>
         * OBJECT_EXCEEDS_SIZE_QUOTA - The storage size of the affected S3 object exceeds the size quota for retrieving
         * occurrences of sensitive data.
         * </p>
         * </li>
         * <li>
         * <p>
         * OBJECT_UNAVAILABLE - The affected S3 object isn't available. The object might have been renamed, moved, or
         * deleted. Or the object was changed after Amazon Macie created the finding.
         * </p>
         * </li>
         * <li>
         * <p>
         * UNSUPPORTED_FINDING_TYPE - The specified finding isn't a sensitive data finding.
         * </p>
         * </li>
         * <li>
         * <p>
         * UNSUPPORTED_OBJECT_TYPE - The affected S3 object uses a file or storage format that Macie doesn't support for
         * retrieving occurrences of sensitive data.
         * </p>
         * </li>
         * </ul>
         * <p>
         * This value is null if sensitive data can be retrieved for the finding.
         * </p>
         * 
         * @param reasons
         *        Specifies why occurrences of sensitive data can't be retrieved for the finding. Possible values
         *        are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        INVALID_CLASSIFICATION_RESULT - Amazon Macie can't verify the location of the sensitive data to
         *        retrieve. There isn't a corresponding sensitive data discovery result for the finding. Or the
         *        sensitive data discovery result specified by the ClassificationDetails.detailedResultsLocation field
         *        of the finding isn't available, is malformed or corrupted, or uses an unsupported storage format.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        OBJECT_EXCEEDS_SIZE_QUOTA - The storage size of the affected S3 object exceeds the size quota for
         *        retrieving occurrences of sensitive data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        OBJECT_UNAVAILABLE - The affected S3 object isn't available. The object might have been renamed,
         *        moved, or deleted. Or the object was changed after Amazon Macie created the finding.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UNSUPPORTED_FINDING_TYPE - The specified finding isn't a sensitive data finding.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UNSUPPORTED_OBJECT_TYPE - The affected S3 object uses a file or storage format that Macie doesn't
         *        support for retrieving occurrences of sensitive data.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        This value is null if sensitive data can be retrieved for the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reasons(Collection<UnavailabilityReasonCode> reasons);

        /**
         * <p>
         * Specifies why occurrences of sensitive data can't be retrieved for the finding. Possible values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * INVALID_CLASSIFICATION_RESULT - Amazon Macie can't verify the location of the sensitive data to retrieve.
         * There isn't a corresponding sensitive data discovery result for the finding. Or the sensitive data discovery
         * result specified by the ClassificationDetails.detailedResultsLocation field of the finding isn't available,
         * is malformed or corrupted, or uses an unsupported storage format.
         * </p>
         * </li>
         * <li>
         * <p>
         * OBJECT_EXCEEDS_SIZE_QUOTA - The storage size of the affected S3 object exceeds the size quota for retrieving
         * occurrences of sensitive data.
         * </p>
         * </li>
         * <li>
         * <p>
         * OBJECT_UNAVAILABLE - The affected S3 object isn't available. The object might have been renamed, moved, or
         * deleted. Or the object was changed after Amazon Macie created the finding.
         * </p>
         * </li>
         * <li>
         * <p>
         * UNSUPPORTED_FINDING_TYPE - The specified finding isn't a sensitive data finding.
         * </p>
         * </li>
         * <li>
         * <p>
         * UNSUPPORTED_OBJECT_TYPE - The affected S3 object uses a file or storage format that Macie doesn't support for
         * retrieving occurrences of sensitive data.
         * </p>
         * </li>
         * </ul>
         * <p>
         * This value is null if sensitive data can be retrieved for the finding.
         * </p>
         * 
         * @param reasons
         *        Specifies why occurrences of sensitive data can't be retrieved for the finding. Possible values
         *        are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        INVALID_CLASSIFICATION_RESULT - Amazon Macie can't verify the location of the sensitive data to
         *        retrieve. There isn't a corresponding sensitive data discovery result for the finding. Or the
         *        sensitive data discovery result specified by the ClassificationDetails.detailedResultsLocation field
         *        of the finding isn't available, is malformed or corrupted, or uses an unsupported storage format.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        OBJECT_EXCEEDS_SIZE_QUOTA - The storage size of the affected S3 object exceeds the size quota for
         *        retrieving occurrences of sensitive data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        OBJECT_UNAVAILABLE - The affected S3 object isn't available. The object might have been renamed,
         *        moved, or deleted. Or the object was changed after Amazon Macie created the finding.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UNSUPPORTED_FINDING_TYPE - The specified finding isn't a sensitive data finding.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UNSUPPORTED_OBJECT_TYPE - The affected S3 object uses a file or storage format that Macie doesn't
         *        support for retrieving occurrences of sensitive data.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        This value is null if sensitive data can be retrieved for the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reasons(UnavailabilityReasonCode... reasons);
    }

    static final class BuilderImpl extends Macie2Response.BuilderImpl implements Builder {
        private String code;

        private List<String> reasons = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetSensitiveDataOccurrencesAvailabilityResponse model) {
            super(model);
            code(model.code);
            reasonsWithStrings(model.reasons);
        }

        public final String getCode() {
            return code;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        @Override
        public final Builder code(AvailabilityCode code) {
            this.code(code == null ? null : code.toString());
            return this;
        }

        public final Collection<String> getReasons() {
            if (reasons instanceof SdkAutoConstructList) {
                return null;
            }
            return reasons;
        }

        public final void setReasons(Collection<String> reasons) {
            this.reasons = ___listOfUnavailabilityReasonCodeCopier.copy(reasons);
        }

        @Override
        public final Builder reasonsWithStrings(Collection<String> reasons) {
            this.reasons = ___listOfUnavailabilityReasonCodeCopier.copy(reasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reasonsWithStrings(String... reasons) {
            reasonsWithStrings(Arrays.asList(reasons));
            return this;
        }

        @Override
        public final Builder reasons(Collection<UnavailabilityReasonCode> reasons) {
            this.reasons = ___listOfUnavailabilityReasonCodeCopier.copyEnumToString(reasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reasons(UnavailabilityReasonCode... reasons) {
            reasons(Arrays.asList(reasons));
            return this;
        }

        @Override
        public GetSensitiveDataOccurrencesAvailabilityResponse build() {
            return new GetSensitiveDataOccurrencesAvailabilityResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
