/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about an Identity and Access Management (IAM) user who performed an action on an affected
 * resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IamUser implements SdkPojo, Serializable, ToCopyableBuilder<IamUser.Builder, IamUser> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accountId").getter(getter(IamUser::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(IamUser::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> PRINCIPAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("principalId").getter(getter(IamUser::principalId)).setter(setter(Builder::principalId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principalId").build()).build();

    private static final SdkField<String> USER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("userName").getter(getter(IamUser::userName)).setter(setter(Builder::userName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, ARN_FIELD,
            PRINCIPAL_ID_FIELD, USER_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String accountId;

    private final String arn;

    private final String principalId;

    private final String userName;

    private IamUser(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.arn = builder.arn;
        this.principalId = builder.principalId;
        this.userName = builder.userName;
    }

    /**
     * <p>
     * The unique identifier for the Amazon Web Services account that's associated with the IAM user who performed the
     * action.
     * </p>
     * 
     * @return The unique identifier for the Amazon Web Services account that's associated with the IAM user who
     *         performed the action.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the principal that performed the action. The last section of the ARN contains
     * the name of the user who performed the action.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the principal that performed the action. The last section of the ARN
     *         contains the name of the user who performed the action.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The unique identifier for the IAM user who performed the action.
     * </p>
     * 
     * @return The unique identifier for the IAM user who performed the action.
     */
    public final String principalId() {
        return principalId;
    }

    /**
     * <p>
     * The user name of the IAM user who performed the action.
     * </p>
     * 
     * @return The user name of the IAM user who performed the action.
     */
    public final String userName() {
        return userName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(principalId());
        hashCode = 31 * hashCode + Objects.hashCode(userName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IamUser)) {
            return false;
        }
        IamUser other = (IamUser) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(arn(), other.arn())
                && Objects.equals(principalId(), other.principalId()) && Objects.equals(userName(), other.userName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IamUser").add("AccountId", accountId()).add("Arn", arn()).add("PrincipalId", principalId())
                .add("UserName", userName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "principalId":
            return Optional.ofNullable(clazz.cast(principalId()));
        case "userName":
            return Optional.ofNullable(clazz.cast(userName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IamUser, T> g) {
        return obj -> g.apply((IamUser) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IamUser> {
        /**
         * <p>
         * The unique identifier for the Amazon Web Services account that's associated with the IAM user who performed
         * the action.
         * </p>
         * 
         * @param accountId
         *        The unique identifier for the Amazon Web Services account that's associated with the IAM user who
         *        performed the action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the principal that performed the action. The last section of the ARN
         * contains the name of the user who performed the action.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the principal that performed the action. The last section of the ARN
         *        contains the name of the user who performed the action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The unique identifier for the IAM user who performed the action.
         * </p>
         * 
         * @param principalId
         *        The unique identifier for the IAM user who performed the action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principalId(String principalId);

        /**
         * <p>
         * The user name of the IAM user who performed the action.
         * </p>
         * 
         * @param userName
         *        The user name of the IAM user who performed the action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userName(String userName);
    }

    static final class BuilderImpl implements Builder {
        private String accountId;

        private String arn;

        private String principalId;

        private String userName;

        private BuilderImpl() {
        }

        private BuilderImpl(IamUser model) {
            accountId(model.accountId);
            arn(model.arn);
            principalId(model.principalId);
            userName(model.userName);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getPrincipalId() {
            return principalId;
        }

        public final void setPrincipalId(String principalId) {
            this.principalId = principalId;
        }

        @Override
        public final Builder principalId(String principalId) {
            this.principalId = principalId;
            return this;
        }

        public final String getUserName() {
            return userName;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        @Override
        public IamUser build() {
            return new IamUser(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
