/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies criteria for filtering the results of a request for information about classification jobs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListJobsFilterCriteria implements SdkPojo, Serializable,
        ToCopyableBuilder<ListJobsFilterCriteria.Builder, ListJobsFilterCriteria> {
    private static final SdkField<List<ListJobsFilterTerm>> EXCLUDES_FIELD = SdkField
            .<List<ListJobsFilterTerm>> builder(MarshallingType.LIST)
            .memberName("excludes")
            .getter(getter(ListJobsFilterCriteria::excludes))
            .setter(setter(Builder::excludes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("excludes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ListJobsFilterTerm> builder(MarshallingType.SDK_POJO)
                                            .constructor(ListJobsFilterTerm::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ListJobsFilterTerm>> INCLUDES_FIELD = SdkField
            .<List<ListJobsFilterTerm>> builder(MarshallingType.LIST)
            .memberName("includes")
            .getter(getter(ListJobsFilterCriteria::includes))
            .setter(setter(Builder::includes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ListJobsFilterTerm> builder(MarshallingType.SDK_POJO)
                                            .constructor(ListJobsFilterTerm::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(EXCLUDES_FIELD, INCLUDES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<ListJobsFilterTerm> excludes;

    private final List<ListJobsFilterTerm> includes;

    private ListJobsFilterCriteria(BuilderImpl builder) {
        this.excludes = builder.excludes;
        this.includes = builder.includes;
    }

    /**
     * For responses, this returns true if the service returned a value for the Excludes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasExcludes() {
        return excludes != null && !(excludes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects, one for each condition that determines which jobs to exclude from the results.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExcludes} method.
     * </p>
     * 
     * @return An array of objects, one for each condition that determines which jobs to exclude from the results.
     */
    public final List<ListJobsFilterTerm> excludes() {
        return excludes;
    }

    /**
     * For responses, this returns true if the service returned a value for the Includes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasIncludes() {
        return includes != null && !(includes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects, one for each condition that determines which jobs to include in the results.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIncludes} method.
     * </p>
     * 
     * @return An array of objects, one for each condition that determines which jobs to include in the results.
     */
    public final List<ListJobsFilterTerm> includes() {
        return includes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasExcludes() ? excludes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasIncludes() ? includes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListJobsFilterCriteria)) {
            return false;
        }
        ListJobsFilterCriteria other = (ListJobsFilterCriteria) obj;
        return hasExcludes() == other.hasExcludes() && Objects.equals(excludes(), other.excludes())
                && hasIncludes() == other.hasIncludes() && Objects.equals(includes(), other.includes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListJobsFilterCriteria").add("Excludes", hasExcludes() ? excludes() : null)
                .add("Includes", hasIncludes() ? includes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "excludes":
            return Optional.ofNullable(clazz.cast(excludes()));
        case "includes":
            return Optional.ofNullable(clazz.cast(includes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListJobsFilterCriteria, T> g) {
        return obj -> g.apply((ListJobsFilterCriteria) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ListJobsFilterCriteria> {
        /**
         * <p>
         * An array of objects, one for each condition that determines which jobs to exclude from the results.
         * </p>
         * 
         * @param excludes
         *        An array of objects, one for each condition that determines which jobs to exclude from the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludes(Collection<ListJobsFilterTerm> excludes);

        /**
         * <p>
         * An array of objects, one for each condition that determines which jobs to exclude from the results.
         * </p>
         * 
         * @param excludes
         *        An array of objects, one for each condition that determines which jobs to exclude from the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludes(ListJobsFilterTerm... excludes);

        /**
         * <p>
         * An array of objects, one for each condition that determines which jobs to exclude from the results.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<ListJobsFilterTerm>.Builder}
         * avoiding the need to create one manually via {@link List<ListJobsFilterTerm>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ListJobsFilterTerm>.Builder#build()} is called immediately
         * and its result is passed to {@link #excludes(List<ListJobsFilterTerm>)}.
         * 
         * @param excludes
         *        a consumer that will call methods on {@link List<ListJobsFilterTerm>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #excludes(List<ListJobsFilterTerm>)
         */
        Builder excludes(Consumer<ListJobsFilterTerm.Builder>... excludes);

        /**
         * <p>
         * An array of objects, one for each condition that determines which jobs to include in the results.
         * </p>
         * 
         * @param includes
         *        An array of objects, one for each condition that determines which jobs to include in the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includes(Collection<ListJobsFilterTerm> includes);

        /**
         * <p>
         * An array of objects, one for each condition that determines which jobs to include in the results.
         * </p>
         * 
         * @param includes
         *        An array of objects, one for each condition that determines which jobs to include in the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includes(ListJobsFilterTerm... includes);

        /**
         * <p>
         * An array of objects, one for each condition that determines which jobs to include in the results.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<ListJobsFilterTerm>.Builder}
         * avoiding the need to create one manually via {@link List<ListJobsFilterTerm>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ListJobsFilterTerm>.Builder#build()} is called immediately
         * and its result is passed to {@link #includes(List<ListJobsFilterTerm>)}.
         * 
         * @param includes
         *        a consumer that will call methods on {@link List<ListJobsFilterTerm>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #includes(List<ListJobsFilterTerm>)
         */
        Builder includes(Consumer<ListJobsFilterTerm.Builder>... includes);
    }

    static final class BuilderImpl implements Builder {
        private List<ListJobsFilterTerm> excludes = DefaultSdkAutoConstructList.getInstance();

        private List<ListJobsFilterTerm> includes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListJobsFilterCriteria model) {
            excludes(model.excludes);
            includes(model.includes);
        }

        public final List<ListJobsFilterTerm.Builder> getExcludes() {
            List<ListJobsFilterTerm.Builder> result = ___listOfListJobsFilterTermCopier.copyToBuilder(this.excludes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExcludes(Collection<ListJobsFilterTerm.BuilderImpl> excludes) {
            this.excludes = ___listOfListJobsFilterTermCopier.copyFromBuilder(excludes);
        }

        @Override
        public final Builder excludes(Collection<ListJobsFilterTerm> excludes) {
            this.excludes = ___listOfListJobsFilterTermCopier.copy(excludes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludes(ListJobsFilterTerm... excludes) {
            excludes(Arrays.asList(excludes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludes(Consumer<ListJobsFilterTerm.Builder>... excludes) {
            excludes(Stream.of(excludes).map(c -> ListJobsFilterTerm.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<ListJobsFilterTerm.Builder> getIncludes() {
            List<ListJobsFilterTerm.Builder> result = ___listOfListJobsFilterTermCopier.copyToBuilder(this.includes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIncludes(Collection<ListJobsFilterTerm.BuilderImpl> includes) {
            this.includes = ___listOfListJobsFilterTermCopier.copyFromBuilder(includes);
        }

        @Override
        public final Builder includes(Collection<ListJobsFilterTerm> includes) {
            this.includes = ___listOfListJobsFilterTermCopier.copy(includes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includes(ListJobsFilterTerm... includes) {
            includes(Arrays.asList(includes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includes(Consumer<ListJobsFilterTerm.Builder>... includes) {
            includes(Stream.of(includes).map(c -> ListJobsFilterTerm.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListJobsFilterCriteria build() {
            return new ListJobsFilterCriteria(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
