/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetCustomDataIdentifiersResponse extends Macie2Response implements
        ToCopyableBuilder<BatchGetCustomDataIdentifiersResponse.Builder, BatchGetCustomDataIdentifiersResponse> {
    private static final SdkField<List<BatchGetCustomDataIdentifierSummary>> CUSTOM_DATA_IDENTIFIERS_FIELD = SdkField
            .<List<BatchGetCustomDataIdentifierSummary>> builder(MarshallingType.LIST)
            .memberName("customDataIdentifiers")
            .getter(getter(BatchGetCustomDataIdentifiersResponse::customDataIdentifiers))
            .setter(setter(Builder::customDataIdentifiers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customDataIdentifiers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchGetCustomDataIdentifierSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchGetCustomDataIdentifierSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> NOT_FOUND_IDENTIFIER_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("notFoundIdentifierIds")
            .getter(getter(BatchGetCustomDataIdentifiersResponse::notFoundIdentifierIds))
            .setter(setter(Builder::notFoundIdentifierIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notFoundIdentifierIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOM_DATA_IDENTIFIERS_FIELD,
            NOT_FOUND_IDENTIFIER_IDS_FIELD));

    private final List<BatchGetCustomDataIdentifierSummary> customDataIdentifiers;

    private final List<String> notFoundIdentifierIds;

    private BatchGetCustomDataIdentifiersResponse(BuilderImpl builder) {
        super(builder);
        this.customDataIdentifiers = builder.customDataIdentifiers;
        this.notFoundIdentifierIds = builder.notFoundIdentifierIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the CustomDataIdentifiers property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCustomDataIdentifiers() {
        return customDataIdentifiers != null && !(customDataIdentifiers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects, one for each custom data identifier that meets the criteria specified in the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCustomDataIdentifiers} method.
     * </p>
     * 
     * @return An array of objects, one for each custom data identifier that meets the criteria specified in the
     *         request.
     */
    public final List<BatchGetCustomDataIdentifierSummary> customDataIdentifiers() {
        return customDataIdentifiers;
    }

    /**
     * For responses, this returns true if the service returned a value for the NotFoundIdentifierIds property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasNotFoundIdentifierIds() {
        return notFoundIdentifierIds != null && !(notFoundIdentifierIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of identifiers, one for each identifier that was specified in the request, but doesn't correlate to an
     * existing custom data identifier.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNotFoundIdentifierIds} method.
     * </p>
     * 
     * @return An array of identifiers, one for each identifier that was specified in the request, but doesn't correlate
     *         to an existing custom data identifier.
     */
    public final List<String> notFoundIdentifierIds() {
        return notFoundIdentifierIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasCustomDataIdentifiers() ? customDataIdentifiers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasNotFoundIdentifierIds() ? notFoundIdentifierIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetCustomDataIdentifiersResponse)) {
            return false;
        }
        BatchGetCustomDataIdentifiersResponse other = (BatchGetCustomDataIdentifiersResponse) obj;
        return hasCustomDataIdentifiers() == other.hasCustomDataIdentifiers()
                && Objects.equals(customDataIdentifiers(), other.customDataIdentifiers())
                && hasNotFoundIdentifierIds() == other.hasNotFoundIdentifierIds()
                && Objects.equals(notFoundIdentifierIds(), other.notFoundIdentifierIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetCustomDataIdentifiersResponse")
                .add("CustomDataIdentifiers", hasCustomDataIdentifiers() ? customDataIdentifiers() : null)
                .add("NotFoundIdentifierIds", hasNotFoundIdentifierIds() ? notFoundIdentifierIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "customDataIdentifiers":
            return Optional.ofNullable(clazz.cast(customDataIdentifiers()));
        case "notFoundIdentifierIds":
            return Optional.ofNullable(clazz.cast(notFoundIdentifierIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetCustomDataIdentifiersResponse, T> g) {
        return obj -> g.apply((BatchGetCustomDataIdentifiersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Macie2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchGetCustomDataIdentifiersResponse> {
        /**
         * <p>
         * An array of objects, one for each custom data identifier that meets the criteria specified in the request.
         * </p>
         * 
         * @param customDataIdentifiers
         *        An array of objects, one for each custom data identifier that meets the criteria specified in the
         *        request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customDataIdentifiers(Collection<BatchGetCustomDataIdentifierSummary> customDataIdentifiers);

        /**
         * <p>
         * An array of objects, one for each custom data identifier that meets the criteria specified in the request.
         * </p>
         * 
         * @param customDataIdentifiers
         *        An array of objects, one for each custom data identifier that meets the criteria specified in the
         *        request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customDataIdentifiers(BatchGetCustomDataIdentifierSummary... customDataIdentifiers);

        /**
         * <p>
         * An array of objects, one for each custom data identifier that meets the criteria specified in the request.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <BatchGetCustomDataIdentifierSummary>.Builder} avoiding the need to create one manually via {@link List
         * <BatchGetCustomDataIdentifierSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<BatchGetCustomDataIdentifierSummary>.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #customDataIdentifiers(List<BatchGetCustomDataIdentifierSummary>)}.
         * 
         * @param customDataIdentifiers
         *        a consumer that will call methods on {@link List<BatchGetCustomDataIdentifierSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customDataIdentifiers(List<BatchGetCustomDataIdentifierSummary>)
         */
        Builder customDataIdentifiers(Consumer<BatchGetCustomDataIdentifierSummary.Builder>... customDataIdentifiers);

        /**
         * <p>
         * An array of identifiers, one for each identifier that was specified in the request, but doesn't correlate to
         * an existing custom data identifier.
         * </p>
         * 
         * @param notFoundIdentifierIds
         *        An array of identifiers, one for each identifier that was specified in the request, but doesn't
         *        correlate to an existing custom data identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notFoundIdentifierIds(Collection<String> notFoundIdentifierIds);

        /**
         * <p>
         * An array of identifiers, one for each identifier that was specified in the request, but doesn't correlate to
         * an existing custom data identifier.
         * </p>
         * 
         * @param notFoundIdentifierIds
         *        An array of identifiers, one for each identifier that was specified in the request, but doesn't
         *        correlate to an existing custom data identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notFoundIdentifierIds(String... notFoundIdentifierIds);
    }

    static final class BuilderImpl extends Macie2Response.BuilderImpl implements Builder {
        private List<BatchGetCustomDataIdentifierSummary> customDataIdentifiers = DefaultSdkAutoConstructList.getInstance();

        private List<String> notFoundIdentifierIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetCustomDataIdentifiersResponse model) {
            super(model);
            customDataIdentifiers(model.customDataIdentifiers);
            notFoundIdentifierIds(model.notFoundIdentifierIds);
        }

        public final List<BatchGetCustomDataIdentifierSummary.Builder> getCustomDataIdentifiers() {
            List<BatchGetCustomDataIdentifierSummary.Builder> result = ___listOfBatchGetCustomDataIdentifierSummaryCopier
                    .copyToBuilder(this.customDataIdentifiers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCustomDataIdentifiers(
                Collection<BatchGetCustomDataIdentifierSummary.BuilderImpl> customDataIdentifiers) {
            this.customDataIdentifiers = ___listOfBatchGetCustomDataIdentifierSummaryCopier
                    .copyFromBuilder(customDataIdentifiers);
        }

        @Override
        @Transient
        public final Builder customDataIdentifiers(Collection<BatchGetCustomDataIdentifierSummary> customDataIdentifiers) {
            this.customDataIdentifiers = ___listOfBatchGetCustomDataIdentifierSummaryCopier.copy(customDataIdentifiers);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder customDataIdentifiers(BatchGetCustomDataIdentifierSummary... customDataIdentifiers) {
            customDataIdentifiers(Arrays.asList(customDataIdentifiers));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder customDataIdentifiers(Consumer<BatchGetCustomDataIdentifierSummary.Builder>... customDataIdentifiers) {
            customDataIdentifiers(Stream.of(customDataIdentifiers)
                    .map(c -> BatchGetCustomDataIdentifierSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getNotFoundIdentifierIds() {
            if (notFoundIdentifierIds instanceof SdkAutoConstructList) {
                return null;
            }
            return notFoundIdentifierIds;
        }

        public final void setNotFoundIdentifierIds(Collection<String> notFoundIdentifierIds) {
            this.notFoundIdentifierIds = ___listOf__stringCopier.copy(notFoundIdentifierIds);
        }

        @Override
        @Transient
        public final Builder notFoundIdentifierIds(Collection<String> notFoundIdentifierIds) {
            this.notFoundIdentifierIds = ___listOf__stringCopier.copy(notFoundIdentifierIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder notFoundIdentifierIds(String... notFoundIdentifierIds) {
            notFoundIdentifierIds(Arrays.asList(notFoundIdentifierIds));
            return this;
        }

        @Override
        public BatchGetCustomDataIdentifiersResponse build() {
            return new BatchGetCustomDataIdentifiersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
