/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the location of 1-15 occurrences of sensitive data that was detected by managed data identifiers or a
 * custom data identifier and produced a sensitive data finding.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Occurrences implements SdkPojo, Serializable, ToCopyableBuilder<Occurrences.Builder, Occurrences> {
    private static final SdkField<List<Cell>> CELLS_FIELD = SdkField
            .<List<Cell>> builder(MarshallingType.LIST)
            .memberName("cells")
            .getter(getter(Occurrences::cells))
            .setter(setter(Builder::cells))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cells").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Cell> builder(MarshallingType.SDK_POJO)
                                            .constructor(Cell::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Range>> LINE_RANGES_FIELD = SdkField
            .<List<Range>> builder(MarshallingType.LIST)
            .memberName("lineRanges")
            .getter(getter(Occurrences::lineRanges))
            .setter(setter(Builder::lineRanges))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lineRanges").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Range> builder(MarshallingType.SDK_POJO)
                                            .constructor(Range::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Range>> OFFSET_RANGES_FIELD = SdkField
            .<List<Range>> builder(MarshallingType.LIST)
            .memberName("offsetRanges")
            .getter(getter(Occurrences::offsetRanges))
            .setter(setter(Builder::offsetRanges))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("offsetRanges").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Range> builder(MarshallingType.SDK_POJO)
                                            .constructor(Range::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Page>> PAGES_FIELD = SdkField
            .<List<Page>> builder(MarshallingType.LIST)
            .memberName("pages")
            .getter(getter(Occurrences::pages))
            .setter(setter(Builder::pages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pages").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Page> builder(MarshallingType.SDK_POJO)
                                            .constructor(Page::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Record>> RECORDS_FIELD = SdkField
            .<List<Record>> builder(MarshallingType.LIST)
            .memberName("records")
            .getter(getter(Occurrences::records))
            .setter(setter(Builder::records))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("records").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Record> builder(MarshallingType.SDK_POJO)
                                            .constructor(Record::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CELLS_FIELD,
            LINE_RANGES_FIELD, OFFSET_RANGES_FIELD, PAGES_FIELD, RECORDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<Cell> cells;

    private final List<Range> lineRanges;

    private final List<Range> offsetRanges;

    private final List<Page> pages;

    private final List<Record> records;

    private Occurrences(BuilderImpl builder) {
        this.cells = builder.cells;
        this.lineRanges = builder.lineRanges;
        this.offsetRanges = builder.offsetRanges;
        this.pages = builder.pages;
        this.records = builder.records;
    }

    /**
     * For responses, this returns true if the service returned a value for the Cells property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasCells() {
        return cells != null && !(cells instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects, one for each occurrence of sensitive data in a Microsoft Excel workbook, CSV file, or TSV
     * file. This value is null for all other types of files.
     * </p>
     * <p>
     * Each Cell object specifies a cell or field that contains the sensitive data.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCells} method.
     * </p>
     * 
     * @return An array of objects, one for each occurrence of sensitive data in a Microsoft Excel workbook, CSV file,
     *         or TSV file. This value is null for all other types of files.</p>
     *         <p>
     *         Each Cell object specifies a cell or field that contains the sensitive data.
     */
    public final List<Cell> cells() {
        return cells;
    }

    /**
     * For responses, this returns true if the service returned a value for the LineRanges property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasLineRanges() {
        return lineRanges != null && !(lineRanges instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects, one for each occurrence of sensitive data in a non-binary text file, such as an HTML, TXT,
     * or XML file. Each Range object specifies a line or inclusive range of lines that contains the sensitive data, and
     * the position of the data on the specified line or lines.
     * </p>
     * <p>
     * This value is often null for file types that are supported by Cell, Page, or Record objects. Exceptions are the
     * location of sensitive data in: unstructured sections of an otherwise structured file, such as a comment in a
     * file; a malformed file that Amazon Macie analyzes as plain text; and, a CSV or TSV file that has any column names
     * that contain sensitive data.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLineRanges} method.
     * </p>
     * 
     * @return An array of objects, one for each occurrence of sensitive data in a non-binary text file, such as an
     *         HTML, TXT, or XML file. Each Range object specifies a line or inclusive range of lines that contains the
     *         sensitive data, and the position of the data on the specified line or lines.</p>
     *         <p>
     *         This value is often null for file types that are supported by Cell, Page, or Record objects. Exceptions
     *         are the location of sensitive data in: unstructured sections of an otherwise structured file, such as a
     *         comment in a file; a malformed file that Amazon Macie analyzes as plain text; and, a CSV or TSV file that
     *         has any column names that contain sensitive data.
     */
    public final List<Range> lineRanges() {
        return lineRanges;
    }

    /**
     * For responses, this returns true if the service returned a value for the OffsetRanges property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOffsetRanges() {
        return offsetRanges != null && !(offsetRanges instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Reserved for future use.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOffsetRanges} method.
     * </p>
     * 
     * @return <p>
     *         Reserved for future use.
     *         </p>
     */
    public final List<Range> offsetRanges() {
        return offsetRanges;
    }

    /**
     * For responses, this returns true if the service returned a value for the Pages property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasPages() {
        return pages != null && !(pages instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects, one for each occurrence of sensitive data in an Adobe Portable Document Format file. This
     * value is null for all other types of files.
     * </p>
     * <p>
     * Each Page object specifies a page that contains the sensitive data.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPages} method.
     * </p>
     * 
     * @return An array of objects, one for each occurrence of sensitive data in an Adobe Portable Document Format file.
     *         This value is null for all other types of files.</p>
     *         <p>
     *         Each Page object specifies a page that contains the sensitive data.
     */
    public final List<Page> pages() {
        return pages;
    }

    /**
     * For responses, this returns true if the service returned a value for the Records property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRecords() {
        return records != null && !(records instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects, one for each occurrence of sensitive data in an Apache Avro object container, Apache Parquet
     * file, JSON file, or JSON Lines file. This value is null for all other types of files.
     * </p>
     * <p>
     * For an Avro object container or Parquet file, each Record object specifies a record index and the path to a field
     * in a record that contains the sensitive data. For a JSON or JSON Lines file, each Record object specifies the
     * path to a field or array that contains the sensitive data. For a JSON Lines file, it also specifies the index of
     * the line that contains the data.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRecords} method.
     * </p>
     * 
     * @return An array of objects, one for each occurrence of sensitive data in an Apache Avro object container, Apache
     *         Parquet file, JSON file, or JSON Lines file. This value is null for all other types of files.</p>
     *         <p>
     *         For an Avro object container or Parquet file, each Record object specifies a record index and the path to
     *         a field in a record that contains the sensitive data. For a JSON or JSON Lines file, each Record object
     *         specifies the path to a field or array that contains the sensitive data. For a JSON Lines file, it also
     *         specifies the index of the line that contains the data.
     */
    public final List<Record> records() {
        return records;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasCells() ? cells() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasLineRanges() ? lineRanges() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasOffsetRanges() ? offsetRanges() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPages() ? pages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRecords() ? records() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Occurrences)) {
            return false;
        }
        Occurrences other = (Occurrences) obj;
        return hasCells() == other.hasCells() && Objects.equals(cells(), other.cells())
                && hasLineRanges() == other.hasLineRanges() && Objects.equals(lineRanges(), other.lineRanges())
                && hasOffsetRanges() == other.hasOffsetRanges() && Objects.equals(offsetRanges(), other.offsetRanges())
                && hasPages() == other.hasPages() && Objects.equals(pages(), other.pages()) && hasRecords() == other.hasRecords()
                && Objects.equals(records(), other.records());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Occurrences").add("Cells", hasCells() ? cells() : null)
                .add("LineRanges", hasLineRanges() ? lineRanges() : null)
                .add("OffsetRanges", hasOffsetRanges() ? offsetRanges() : null).add("Pages", hasPages() ? pages() : null)
                .add("Records", hasRecords() ? records() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cells":
            return Optional.ofNullable(clazz.cast(cells()));
        case "lineRanges":
            return Optional.ofNullable(clazz.cast(lineRanges()));
        case "offsetRanges":
            return Optional.ofNullable(clazz.cast(offsetRanges()));
        case "pages":
            return Optional.ofNullable(clazz.cast(pages()));
        case "records":
            return Optional.ofNullable(clazz.cast(records()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Occurrences, T> g) {
        return obj -> g.apply((Occurrences) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Occurrences> {
        /**
         * <p>
         * An array of objects, one for each occurrence of sensitive data in a Microsoft Excel workbook, CSV file, or
         * TSV file. This value is null for all other types of files.
         * </p>
         * <p>
         * Each Cell object specifies a cell or field that contains the sensitive data.
         * </p>
         * 
         * @param cells
         *        An array of objects, one for each occurrence of sensitive data in a Microsoft Excel workbook, CSV
         *        file, or TSV file. This value is null for all other types of files.</p>
         *        <p>
         *        Each Cell object specifies a cell or field that contains the sensitive data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cells(Collection<Cell> cells);

        /**
         * <p>
         * An array of objects, one for each occurrence of sensitive data in a Microsoft Excel workbook, CSV file, or
         * TSV file. This value is null for all other types of files.
         * </p>
         * <p>
         * Each Cell object specifies a cell or field that contains the sensitive data.
         * </p>
         * 
         * @param cells
         *        An array of objects, one for each occurrence of sensitive data in a Microsoft Excel workbook, CSV
         *        file, or TSV file. This value is null for all other types of files.</p>
         *        <p>
         *        Each Cell object specifies a cell or field that contains the sensitive data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cells(Cell... cells);

        /**
         * <p>
         * An array of objects, one for each occurrence of sensitive data in a Microsoft Excel workbook, CSV file, or
         * TSV file. This value is null for all other types of files.
         * </p>
         * <p>
         * Each Cell object specifies a cell or field that contains the sensitive data.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Cell>.Builder} avoiding the need to create
         * one manually via {@link List<Cell>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Cell>.Builder#build()} is called immediately and its result
         * is passed to {@link #cells(List<Cell>)}.
         * 
         * @param cells
         *        a consumer that will call methods on {@link List<Cell>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cells(List<Cell>)
         */
        Builder cells(Consumer<Cell.Builder>... cells);

        /**
         * <p>
         * An array of objects, one for each occurrence of sensitive data in a non-binary text file, such as an HTML,
         * TXT, or XML file. Each Range object specifies a line or inclusive range of lines that contains the sensitive
         * data, and the position of the data on the specified line or lines.
         * </p>
         * <p>
         * This value is often null for file types that are supported by Cell, Page, or Record objects. Exceptions are
         * the location of sensitive data in: unstructured sections of an otherwise structured file, such as a comment
         * in a file; a malformed file that Amazon Macie analyzes as plain text; and, a CSV or TSV file that has any
         * column names that contain sensitive data.
         * </p>
         * 
         * @param lineRanges
         *        An array of objects, one for each occurrence of sensitive data in a non-binary text file, such as an
         *        HTML, TXT, or XML file. Each Range object specifies a line or inclusive range of lines that contains
         *        the sensitive data, and the position of the data on the specified line or lines.</p>
         *        <p>
         *        This value is often null for file types that are supported by Cell, Page, or Record objects.
         *        Exceptions are the location of sensitive data in: unstructured sections of an otherwise structured
         *        file, such as a comment in a file; a malformed file that Amazon Macie analyzes as plain text; and, a
         *        CSV or TSV file that has any column names that contain sensitive data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lineRanges(Collection<Range> lineRanges);

        /**
         * <p>
         * An array of objects, one for each occurrence of sensitive data in a non-binary text file, such as an HTML,
         * TXT, or XML file. Each Range object specifies a line or inclusive range of lines that contains the sensitive
         * data, and the position of the data on the specified line or lines.
         * </p>
         * <p>
         * This value is often null for file types that are supported by Cell, Page, or Record objects. Exceptions are
         * the location of sensitive data in: unstructured sections of an otherwise structured file, such as a comment
         * in a file; a malformed file that Amazon Macie analyzes as plain text; and, a CSV or TSV file that has any
         * column names that contain sensitive data.
         * </p>
         * 
         * @param lineRanges
         *        An array of objects, one for each occurrence of sensitive data in a non-binary text file, such as an
         *        HTML, TXT, or XML file. Each Range object specifies a line or inclusive range of lines that contains
         *        the sensitive data, and the position of the data on the specified line or lines.</p>
         *        <p>
         *        This value is often null for file types that are supported by Cell, Page, or Record objects.
         *        Exceptions are the location of sensitive data in: unstructured sections of an otherwise structured
         *        file, such as a comment in a file; a malformed file that Amazon Macie analyzes as plain text; and, a
         *        CSV or TSV file that has any column names that contain sensitive data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lineRanges(Range... lineRanges);

        /**
         * <p>
         * An array of objects, one for each occurrence of sensitive data in a non-binary text file, such as an HTML,
         * TXT, or XML file. Each Range object specifies a line or inclusive range of lines that contains the sensitive
         * data, and the position of the data on the specified line or lines.
         * </p>
         * <p>
         * This value is often null for file types that are supported by Cell, Page, or Record objects. Exceptions are
         * the location of sensitive data in: unstructured sections of an otherwise structured file, such as a comment
         * in a file; a malformed file that Amazon Macie analyzes as plain text; and, a CSV or TSV file that has any
         * column names that contain sensitive data.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Range>.Builder} avoiding the need to create
         * one manually via {@link List<Range>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Range>.Builder#build()} is called immediately and its result
         * is passed to {@link #lineRanges(List<Range>)}.
         * 
         * @param lineRanges
         *        a consumer that will call methods on {@link List<Range>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lineRanges(List<Range>)
         */
        Builder lineRanges(Consumer<Range.Builder>... lineRanges);

        /**
         * <p>
         * Reserved for future use.
         * </p>
         * 
         * @param offsetRanges
         *        <p>
         *        Reserved for future use.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offsetRanges(Collection<Range> offsetRanges);

        /**
         * <p>
         * Reserved for future use.
         * </p>
         * 
         * @param offsetRanges
         *        <p>
         *        Reserved for future use.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offsetRanges(Range... offsetRanges);

        /**
         * <p>
         * Reserved for future use.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Range>.Builder} avoiding the need to create
         * one manually via {@link List<Range>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Range>.Builder#build()} is called immediately and its result
         * is passed to {@link #offsetRanges(List<Range>)}.
         * 
         * @param offsetRanges
         *        a consumer that will call methods on {@link List<Range>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #offsetRanges(List<Range>)
         */
        Builder offsetRanges(Consumer<Range.Builder>... offsetRanges);

        /**
         * <p>
         * An array of objects, one for each occurrence of sensitive data in an Adobe Portable Document Format file.
         * This value is null for all other types of files.
         * </p>
         * <p>
         * Each Page object specifies a page that contains the sensitive data.
         * </p>
         * 
         * @param pages
         *        An array of objects, one for each occurrence of sensitive data in an Adobe Portable Document Format
         *        file. This value is null for all other types of files.</p>
         *        <p>
         *        Each Page object specifies a page that contains the sensitive data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pages(Collection<Page> pages);

        /**
         * <p>
         * An array of objects, one for each occurrence of sensitive data in an Adobe Portable Document Format file.
         * This value is null for all other types of files.
         * </p>
         * <p>
         * Each Page object specifies a page that contains the sensitive data.
         * </p>
         * 
         * @param pages
         *        An array of objects, one for each occurrence of sensitive data in an Adobe Portable Document Format
         *        file. This value is null for all other types of files.</p>
         *        <p>
         *        Each Page object specifies a page that contains the sensitive data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pages(Page... pages);

        /**
         * <p>
         * An array of objects, one for each occurrence of sensitive data in an Adobe Portable Document Format file.
         * This value is null for all other types of files.
         * </p>
         * <p>
         * Each Page object specifies a page that contains the sensitive data.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Page>.Builder} avoiding the need to create
         * one manually via {@link List<Page>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Page>.Builder#build()} is called immediately and its result
         * is passed to {@link #pages(List<Page>)}.
         * 
         * @param pages
         *        a consumer that will call methods on {@link List<Page>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pages(List<Page>)
         */
        Builder pages(Consumer<Page.Builder>... pages);

        /**
         * <p>
         * An array of objects, one for each occurrence of sensitive data in an Apache Avro object container, Apache
         * Parquet file, JSON file, or JSON Lines file. This value is null for all other types of files.
         * </p>
         * <p>
         * For an Avro object container or Parquet file, each Record object specifies a record index and the path to a
         * field in a record that contains the sensitive data. For a JSON or JSON Lines file, each Record object
         * specifies the path to a field or array that contains the sensitive data. For a JSON Lines file, it also
         * specifies the index of the line that contains the data.
         * </p>
         * 
         * @param records
         *        An array of objects, one for each occurrence of sensitive data in an Apache Avro object container,
         *        Apache Parquet file, JSON file, or JSON Lines file. This value is null for all other types of
         *        files.</p>
         *        <p>
         *        For an Avro object container or Parquet file, each Record object specifies a record index and the path
         *        to a field in a record that contains the sensitive data. For a JSON or JSON Lines file, each Record
         *        object specifies the path to a field or array that contains the sensitive data. For a JSON Lines file,
         *        it also specifies the index of the line that contains the data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder records(Collection<Record> records);

        /**
         * <p>
         * An array of objects, one for each occurrence of sensitive data in an Apache Avro object container, Apache
         * Parquet file, JSON file, or JSON Lines file. This value is null for all other types of files.
         * </p>
         * <p>
         * For an Avro object container or Parquet file, each Record object specifies a record index and the path to a
         * field in a record that contains the sensitive data. For a JSON or JSON Lines file, each Record object
         * specifies the path to a field or array that contains the sensitive data. For a JSON Lines file, it also
         * specifies the index of the line that contains the data.
         * </p>
         * 
         * @param records
         *        An array of objects, one for each occurrence of sensitive data in an Apache Avro object container,
         *        Apache Parquet file, JSON file, or JSON Lines file. This value is null for all other types of
         *        files.</p>
         *        <p>
         *        For an Avro object container or Parquet file, each Record object specifies a record index and the path
         *        to a field in a record that contains the sensitive data. For a JSON or JSON Lines file, each Record
         *        object specifies the path to a field or array that contains the sensitive data. For a JSON Lines file,
         *        it also specifies the index of the line that contains the data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder records(Record... records);

        /**
         * <p>
         * An array of objects, one for each occurrence of sensitive data in an Apache Avro object container, Apache
         * Parquet file, JSON file, or JSON Lines file. This value is null for all other types of files.
         * </p>
         * <p>
         * For an Avro object container or Parquet file, each Record object specifies a record index and the path to a
         * field in a record that contains the sensitive data. For a JSON or JSON Lines file, each Record object
         * specifies the path to a field or array that contains the sensitive data. For a JSON Lines file, it also
         * specifies the index of the line that contains the data.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Record>.Builder} avoiding the need to
         * create one manually via {@link List<Record>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Record>.Builder#build()} is called immediately and its
         * result is passed to {@link #records(List<Record>)}.
         * 
         * @param records
         *        a consumer that will call methods on {@link List<Record>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #records(List<Record>)
         */
        Builder records(Consumer<Record.Builder>... records);
    }

    static final class BuilderImpl implements Builder {
        private List<Cell> cells = DefaultSdkAutoConstructList.getInstance();

        private List<Range> lineRanges = DefaultSdkAutoConstructList.getInstance();

        private List<Range> offsetRanges = DefaultSdkAutoConstructList.getInstance();

        private List<Page> pages = DefaultSdkAutoConstructList.getInstance();

        private List<Record> records = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Occurrences model) {
            cells(model.cells);
            lineRanges(model.lineRanges);
            offsetRanges(model.offsetRanges);
            pages(model.pages);
            records(model.records);
        }

        public final List<Cell.Builder> getCells() {
            List<Cell.Builder> result = CellsCopier.copyToBuilder(this.cells);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCells(Collection<Cell.BuilderImpl> cells) {
            this.cells = CellsCopier.copyFromBuilder(cells);
        }

        @Override
        @Transient
        public final Builder cells(Collection<Cell> cells) {
            this.cells = CellsCopier.copy(cells);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder cells(Cell... cells) {
            cells(Arrays.asList(cells));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder cells(Consumer<Cell.Builder>... cells) {
            cells(Stream.of(cells).map(c -> Cell.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Range.Builder> getLineRanges() {
            List<Range.Builder> result = RangesCopier.copyToBuilder(this.lineRanges);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLineRanges(Collection<Range.BuilderImpl> lineRanges) {
            this.lineRanges = RangesCopier.copyFromBuilder(lineRanges);
        }

        @Override
        @Transient
        public final Builder lineRanges(Collection<Range> lineRanges) {
            this.lineRanges = RangesCopier.copy(lineRanges);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder lineRanges(Range... lineRanges) {
            lineRanges(Arrays.asList(lineRanges));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder lineRanges(Consumer<Range.Builder>... lineRanges) {
            lineRanges(Stream.of(lineRanges).map(c -> Range.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Range.Builder> getOffsetRanges() {
            List<Range.Builder> result = RangesCopier.copyToBuilder(this.offsetRanges);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOffsetRanges(Collection<Range.BuilderImpl> offsetRanges) {
            this.offsetRanges = RangesCopier.copyFromBuilder(offsetRanges);
        }

        @Override
        @Transient
        public final Builder offsetRanges(Collection<Range> offsetRanges) {
            this.offsetRanges = RangesCopier.copy(offsetRanges);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder offsetRanges(Range... offsetRanges) {
            offsetRanges(Arrays.asList(offsetRanges));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder offsetRanges(Consumer<Range.Builder>... offsetRanges) {
            offsetRanges(Stream.of(offsetRanges).map(c -> Range.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Page.Builder> getPages() {
            List<Page.Builder> result = PagesCopier.copyToBuilder(this.pages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPages(Collection<Page.BuilderImpl> pages) {
            this.pages = PagesCopier.copyFromBuilder(pages);
        }

        @Override
        @Transient
        public final Builder pages(Collection<Page> pages) {
            this.pages = PagesCopier.copy(pages);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder pages(Page... pages) {
            pages(Arrays.asList(pages));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder pages(Consumer<Page.Builder>... pages) {
            pages(Stream.of(pages).map(c -> Page.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Record.Builder> getRecords() {
            List<Record.Builder> result = RecordsCopier.copyToBuilder(this.records);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecords(Collection<Record.BuilderImpl> records) {
            this.records = RecordsCopier.copyFromBuilder(records);
        }

        @Override
        @Transient
        public final Builder records(Collection<Record> records) {
            this.records = RecordsCopier.copy(records);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder records(Record... records) {
            records(Arrays.asList(records));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder records(Consumer<Record.Builder>... records) {
            records(Stream.of(records).map(c -> Record.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Occurrences build() {
            return new Occurrences(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
