/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies a property-based condition that determines whether an S3 object is included or excluded from a
 * classification job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SimpleScopeTerm implements SdkPojo, Serializable, ToCopyableBuilder<SimpleScopeTerm.Builder, SimpleScopeTerm> {
    private static final SdkField<String> COMPARATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("comparator").getter(getter(SimpleScopeTerm::comparatorAsString)).setter(setter(Builder::comparator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("comparator").build()).build();

    private static final SdkField<String> KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("key")
            .getter(getter(SimpleScopeTerm::keyAsString)).setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("key").build()).build();

    private static final SdkField<List<String>> VALUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("values")
            .getter(getter(SimpleScopeTerm::values))
            .setter(setter(Builder::values))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("values").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPARATOR_FIELD, KEY_FIELD,
            VALUES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String comparator;

    private final String key;

    private final List<String> values;

    private SimpleScopeTerm(BuilderImpl builder) {
        this.comparator = builder.comparator;
        this.key = builder.key;
        this.values = builder.values;
    }

    /**
     * <p>
     * The operator to use in the condition. Valid values for each supported property (key) are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * OBJECT_EXTENSION - EQ (equals) or NE (not equals)
     * </p>
     * </li>
     * <li>
     * <p>
     * OBJECT_KEY - STARTS_WITH
     * </p>
     * </li>
     * <li>
     * <p>
     * OBJECT_LAST_MODIFIED_DATE - Any operator except CONTAINS
     * </p>
     * </li>
     * <li>
     * <p>
     * OBJECT_SIZE - Any operator except CONTAINS
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #comparator} will
     * return {@link JobComparator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #comparatorAsString}.
     * </p>
     * 
     * @return The operator to use in the condition. Valid values for each supported property (key) are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         OBJECT_EXTENSION - EQ (equals) or NE (not equals)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OBJECT_KEY - STARTS_WITH
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OBJECT_LAST_MODIFIED_DATE - Any operator except CONTAINS
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OBJECT_SIZE - Any operator except CONTAINS
     *         </p>
     *         </li>
     * @see JobComparator
     */
    public final JobComparator comparator() {
        return JobComparator.fromValue(comparator);
    }

    /**
     * <p>
     * The operator to use in the condition. Valid values for each supported property (key) are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * OBJECT_EXTENSION - EQ (equals) or NE (not equals)
     * </p>
     * </li>
     * <li>
     * <p>
     * OBJECT_KEY - STARTS_WITH
     * </p>
     * </li>
     * <li>
     * <p>
     * OBJECT_LAST_MODIFIED_DATE - Any operator except CONTAINS
     * </p>
     * </li>
     * <li>
     * <p>
     * OBJECT_SIZE - Any operator except CONTAINS
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #comparator} will
     * return {@link JobComparator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #comparatorAsString}.
     * </p>
     * 
     * @return The operator to use in the condition. Valid values for each supported property (key) are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         OBJECT_EXTENSION - EQ (equals) or NE (not equals)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OBJECT_KEY - STARTS_WITH
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OBJECT_LAST_MODIFIED_DATE - Any operator except CONTAINS
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OBJECT_SIZE - Any operator except CONTAINS
     *         </p>
     *         </li>
     * @see JobComparator
     */
    public final String comparatorAsString() {
        return comparator;
    }

    /**
     * <p>
     * The object property to use in the condition.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #key} will return
     * {@link ScopeFilterKey#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #keyAsString}.
     * </p>
     * 
     * @return The object property to use in the condition.
     * @see ScopeFilterKey
     */
    public final ScopeFilterKey key() {
        return ScopeFilterKey.fromValue(key);
    }

    /**
     * <p>
     * The object property to use in the condition.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #key} will return
     * {@link ScopeFilterKey#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #keyAsString}.
     * </p>
     * 
     * @return The object property to use in the condition.
     * @see ScopeFilterKey
     */
    public final String keyAsString() {
        return key;
    }

    /**
     * For responses, this returns true if the service returned a value for the Values property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasValues() {
        return values != null && !(values instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array that lists the values to use in the condition. If the value for the key property is OBJECT_EXTENSION or
     * OBJECT_KEY, this array can specify multiple values and Amazon Macie uses OR logic to join the values. Otherwise,
     * this array can specify only one value.
     * </p>
     * <p>
     * Valid values for each supported property (key) are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * OBJECT_EXTENSION - A string that represents the file name extension of an object. For example: docx or pdf
     * </p>
     * </li>
     * <li>
     * <p>
     * OBJECT_KEY - A string that represents the key prefix (folder name or path) of an object. For example: logs or
     * awslogs/eventlogs. This value applies a condition to objects whose keys (names) begin with the specified value.
     * </p>
     * </li>
     * <li>
     * <p>
     * OBJECT_LAST_MODIFIED_DATE - The date and time (in UTC and extended ISO 8601 format) when an object was created or
     * last changed, whichever is latest. For example: 2020-09-28T14:31:13Z
     * </p>
     * </li>
     * <li>
     * <p>
     * OBJECT_SIZE - An integer that represents the storage size (in bytes) of an object.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Macie doesn't support use of wildcard characters in these values. Also, string values are case sensitive.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasValues} method.
     * </p>
     * 
     * @return An array that lists the values to use in the condition. If the value for the key property is
     *         OBJECT_EXTENSION or OBJECT_KEY, this array can specify multiple values and Amazon Macie uses OR logic to
     *         join the values. Otherwise, this array can specify only one value.</p>
     *         <p>
     *         Valid values for each supported property (key) are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         OBJECT_EXTENSION - A string that represents the file name extension of an object. For example: docx or
     *         pdf
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OBJECT_KEY - A string that represents the key prefix (folder name or path) of an object. For example:
     *         logs or awslogs/eventlogs. This value applies a condition to objects whose keys (names) begin with the
     *         specified value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OBJECT_LAST_MODIFIED_DATE - The date and time (in UTC and extended ISO 8601 format) when an object was
     *         created or last changed, whichever is latest. For example: 2020-09-28T14:31:13Z
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OBJECT_SIZE - An integer that represents the storage size (in bytes) of an object.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Macie doesn't support use of wildcard characters in these values. Also, string values are case sensitive.
     */
    public final List<String> values() {
        return values;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(comparatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(keyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasValues() ? values() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SimpleScopeTerm)) {
            return false;
        }
        SimpleScopeTerm other = (SimpleScopeTerm) obj;
        return Objects.equals(comparatorAsString(), other.comparatorAsString())
                && Objects.equals(keyAsString(), other.keyAsString()) && hasValues() == other.hasValues()
                && Objects.equals(values(), other.values());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SimpleScopeTerm").add("Comparator", comparatorAsString()).add("Key", keyAsString())
                .add("Values", hasValues() ? values() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "comparator":
            return Optional.ofNullable(clazz.cast(comparatorAsString()));
        case "key":
            return Optional.ofNullable(clazz.cast(keyAsString()));
        case "values":
            return Optional.ofNullable(clazz.cast(values()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SimpleScopeTerm, T> g) {
        return obj -> g.apply((SimpleScopeTerm) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SimpleScopeTerm> {
        /**
         * <p>
         * The operator to use in the condition. Valid values for each supported property (key) are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * OBJECT_EXTENSION - EQ (equals) or NE (not equals)
         * </p>
         * </li>
         * <li>
         * <p>
         * OBJECT_KEY - STARTS_WITH
         * </p>
         * </li>
         * <li>
         * <p>
         * OBJECT_LAST_MODIFIED_DATE - Any operator except CONTAINS
         * </p>
         * </li>
         * <li>
         * <p>
         * OBJECT_SIZE - Any operator except CONTAINS
         * </p>
         * </li>
         * </ul>
         * 
         * @param comparator
         *        The operator to use in the condition. Valid values for each supported property (key) are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        OBJECT_EXTENSION - EQ (equals) or NE (not equals)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        OBJECT_KEY - STARTS_WITH
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        OBJECT_LAST_MODIFIED_DATE - Any operator except CONTAINS
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        OBJECT_SIZE - Any operator except CONTAINS
         *        </p>
         *        </li>
         * @see JobComparator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobComparator
         */
        Builder comparator(String comparator);

        /**
         * <p>
         * The operator to use in the condition. Valid values for each supported property (key) are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * OBJECT_EXTENSION - EQ (equals) or NE (not equals)
         * </p>
         * </li>
         * <li>
         * <p>
         * OBJECT_KEY - STARTS_WITH
         * </p>
         * </li>
         * <li>
         * <p>
         * OBJECT_LAST_MODIFIED_DATE - Any operator except CONTAINS
         * </p>
         * </li>
         * <li>
         * <p>
         * OBJECT_SIZE - Any operator except CONTAINS
         * </p>
         * </li>
         * </ul>
         * 
         * @param comparator
         *        The operator to use in the condition. Valid values for each supported property (key) are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        OBJECT_EXTENSION - EQ (equals) or NE (not equals)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        OBJECT_KEY - STARTS_WITH
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        OBJECT_LAST_MODIFIED_DATE - Any operator except CONTAINS
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        OBJECT_SIZE - Any operator except CONTAINS
         *        </p>
         *        </li>
         * @see JobComparator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobComparator
         */
        Builder comparator(JobComparator comparator);

        /**
         * <p>
         * The object property to use in the condition.
         * </p>
         * 
         * @param key
         *        The object property to use in the condition.
         * @see ScopeFilterKey
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScopeFilterKey
         */
        Builder key(String key);

        /**
         * <p>
         * The object property to use in the condition.
         * </p>
         * 
         * @param key
         *        The object property to use in the condition.
         * @see ScopeFilterKey
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScopeFilterKey
         */
        Builder key(ScopeFilterKey key);

        /**
         * <p>
         * An array that lists the values to use in the condition. If the value for the key property is OBJECT_EXTENSION
         * or OBJECT_KEY, this array can specify multiple values and Amazon Macie uses OR logic to join the values.
         * Otherwise, this array can specify only one value.
         * </p>
         * <p>
         * Valid values for each supported property (key) are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * OBJECT_EXTENSION - A string that represents the file name extension of an object. For example: docx or pdf
         * </p>
         * </li>
         * <li>
         * <p>
         * OBJECT_KEY - A string that represents the key prefix (folder name or path) of an object. For example: logs or
         * awslogs/eventlogs. This value applies a condition to objects whose keys (names) begin with the specified
         * value.
         * </p>
         * </li>
         * <li>
         * <p>
         * OBJECT_LAST_MODIFIED_DATE - The date and time (in UTC and extended ISO 8601 format) when an object was
         * created or last changed, whichever is latest. For example: 2020-09-28T14:31:13Z
         * </p>
         * </li>
         * <li>
         * <p>
         * OBJECT_SIZE - An integer that represents the storage size (in bytes) of an object.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Macie doesn't support use of wildcard characters in these values. Also, string values are case sensitive.
         * </p>
         * 
         * @param values
         *        An array that lists the values to use in the condition. If the value for the key property is
         *        OBJECT_EXTENSION or OBJECT_KEY, this array can specify multiple values and Amazon Macie uses OR logic
         *        to join the values. Otherwise, this array can specify only one value.</p>
         *        <p>
         *        Valid values for each supported property (key) are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        OBJECT_EXTENSION - A string that represents the file name extension of an object. For example: docx or
         *        pdf
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        OBJECT_KEY - A string that represents the key prefix (folder name or path) of an object. For example:
         *        logs or awslogs/eventlogs. This value applies a condition to objects whose keys (names) begin with the
         *        specified value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        OBJECT_LAST_MODIFIED_DATE - The date and time (in UTC and extended ISO 8601 format) when an object was
         *        created or last changed, whichever is latest. For example: 2020-09-28T14:31:13Z
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        OBJECT_SIZE - An integer that represents the storage size (in bytes) of an object.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Macie doesn't support use of wildcard characters in these values. Also, string values are case
         *        sensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(Collection<String> values);

        /**
         * <p>
         * An array that lists the values to use in the condition. If the value for the key property is OBJECT_EXTENSION
         * or OBJECT_KEY, this array can specify multiple values and Amazon Macie uses OR logic to join the values.
         * Otherwise, this array can specify only one value.
         * </p>
         * <p>
         * Valid values for each supported property (key) are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * OBJECT_EXTENSION - A string that represents the file name extension of an object. For example: docx or pdf
         * </p>
         * </li>
         * <li>
         * <p>
         * OBJECT_KEY - A string that represents the key prefix (folder name or path) of an object. For example: logs or
         * awslogs/eventlogs. This value applies a condition to objects whose keys (names) begin with the specified
         * value.
         * </p>
         * </li>
         * <li>
         * <p>
         * OBJECT_LAST_MODIFIED_DATE - The date and time (in UTC and extended ISO 8601 format) when an object was
         * created or last changed, whichever is latest. For example: 2020-09-28T14:31:13Z
         * </p>
         * </li>
         * <li>
         * <p>
         * OBJECT_SIZE - An integer that represents the storage size (in bytes) of an object.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Macie doesn't support use of wildcard characters in these values. Also, string values are case sensitive.
         * </p>
         * 
         * @param values
         *        An array that lists the values to use in the condition. If the value for the key property is
         *        OBJECT_EXTENSION or OBJECT_KEY, this array can specify multiple values and Amazon Macie uses OR logic
         *        to join the values. Otherwise, this array can specify only one value.</p>
         *        <p>
         *        Valid values for each supported property (key) are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        OBJECT_EXTENSION - A string that represents the file name extension of an object. For example: docx or
         *        pdf
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        OBJECT_KEY - A string that represents the key prefix (folder name or path) of an object. For example:
         *        logs or awslogs/eventlogs. This value applies a condition to objects whose keys (names) begin with the
         *        specified value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        OBJECT_LAST_MODIFIED_DATE - The date and time (in UTC and extended ISO 8601 format) when an object was
         *        created or last changed, whichever is latest. For example: 2020-09-28T14:31:13Z
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        OBJECT_SIZE - An integer that represents the storage size (in bytes) of an object.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Macie doesn't support use of wildcard characters in these values. Also, string values are case
         *        sensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(String... values);
    }

    static final class BuilderImpl implements Builder {
        private String comparator;

        private String key;

        private List<String> values = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SimpleScopeTerm model) {
            comparator(model.comparator);
            key(model.key);
            values(model.values);
        }

        public final String getComparator() {
            return comparator;
        }

        public final void setComparator(String comparator) {
            this.comparator = comparator;
        }

        @Override
        @Transient
        public final Builder comparator(String comparator) {
            this.comparator = comparator;
            return this;
        }

        @Override
        @Transient
        public final Builder comparator(JobComparator comparator) {
            this.comparator(comparator == null ? null : comparator.toString());
            return this;
        }

        public final String getKey() {
            return key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        @Transient
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        @Override
        @Transient
        public final Builder key(ScopeFilterKey key) {
            this.key(key == null ? null : key.toString());
            return this;
        }

        public final Collection<String> getValues() {
            if (values instanceof SdkAutoConstructList) {
                return null;
            }
            return values;
        }

        public final void setValues(Collection<String> values) {
            this.values = ___listOf__stringCopier.copy(values);
        }

        @Override
        @Transient
        public final Builder values(Collection<String> values) {
            this.values = ___listOf__stringCopier.copy(values);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder values(String... values) {
            values(Arrays.asList(values));
            return this;
        }

        @Override
        public SimpleScopeTerm build() {
            return new SimpleScopeTerm(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
