/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class TestCustomDataIdentifierRequest extends Macie2Request implements
        ToCopyableBuilder<TestCustomDataIdentifierRequest.Builder, TestCustomDataIdentifierRequest> {
    private static final SdkField<List<String>> IGNORE_WORDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ignoreWords")
            .getter(getter(TestCustomDataIdentifierRequest::ignoreWords))
            .setter(setter(Builder::ignoreWords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ignoreWords").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> KEYWORDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("keywords")
            .getter(getter(TestCustomDataIdentifierRequest::keywords))
            .setter(setter(Builder::keywords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keywords").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAXIMUM_MATCH_DISTANCE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maximumMatchDistance").getter(getter(TestCustomDataIdentifierRequest::maximumMatchDistance))
            .setter(setter(Builder::maximumMatchDistance))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maximumMatchDistance").build())
            .build();

    private static final SdkField<String> REGEX_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("regex")
            .getter(getter(TestCustomDataIdentifierRequest::regex)).setter(setter(Builder::regex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regex").build()).build();

    private static final SdkField<String> SAMPLE_TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sampleText").getter(getter(TestCustomDataIdentifierRequest::sampleText))
            .setter(setter(Builder::sampleText))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sampleText").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IGNORE_WORDS_FIELD,
            KEYWORDS_FIELD, MAXIMUM_MATCH_DISTANCE_FIELD, REGEX_FIELD, SAMPLE_TEXT_FIELD));

    private final List<String> ignoreWords;

    private final List<String> keywords;

    private final Integer maximumMatchDistance;

    private final String regex;

    private final String sampleText;

    private TestCustomDataIdentifierRequest(BuilderImpl builder) {
        super(builder);
        this.ignoreWords = builder.ignoreWords;
        this.keywords = builder.keywords;
        this.maximumMatchDistance = builder.maximumMatchDistance;
        this.regex = builder.regex;
        this.sampleText = builder.sampleText;
    }

    /**
     * For responses, this returns true if the service returned a value for the IgnoreWords property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIgnoreWords() {
        return ignoreWords != null && !(ignoreWords instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array that lists specific character sequences (ignore words) to exclude from the results. If the text matched
     * by the regular expression is the same as any string in this array, Amazon Macie ignores it. The array can contain
     * as many as 10 ignore words. Each ignore word can contain 4-90 characters. Ignore words are case sensitive.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIgnoreWords} method.
     * </p>
     * 
     * @return An array that lists specific character sequences (ignore words) to exclude from the results. If the text
     *         matched by the regular expression is the same as any string in this array, Amazon Macie ignores it. The
     *         array can contain as many as 10 ignore words. Each ignore word can contain 4-90 characters. Ignore words
     *         are case sensitive.
     */
    public final List<String> ignoreWords() {
        return ignoreWords;
    }

    /**
     * For responses, this returns true if the service returned a value for the Keywords property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasKeywords() {
        return keywords != null && !(keywords instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array that lists specific character sequences (keywords), one of which must be within proximity
     * (maximumMatchDistance) of the regular expression to match. The array can contain as many as 50 keywords. Each
     * keyword can contain 3-90 characters. Keywords aren't case sensitive.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasKeywords} method.
     * </p>
     * 
     * @return An array that lists specific character sequences (keywords), one of which must be within proximity
     *         (maximumMatchDistance) of the regular expression to match. The array can contain as many as 50 keywords.
     *         Each keyword can contain 3-90 characters. Keywords aren't case sensitive.
     */
    public final List<String> keywords() {
        return keywords;
    }

    /**
     * <p>
     * The maximum number of characters that can exist between text that matches the regex pattern and the character
     * sequences specified by the keywords array. Macie includes or excludes a result based on the proximity of a
     * keyword to text that matches the regex pattern. The distance can be 1-300 characters. The default value is 50.
     * </p>
     * 
     * @return The maximum number of characters that can exist between text that matches the regex pattern and the
     *         character sequences specified by the keywords array. Macie includes or excludes a result based on the
     *         proximity of a keyword to text that matches the regex pattern. The distance can be 1-300 characters. The
     *         default value is 50.
     */
    public final Integer maximumMatchDistance() {
        return maximumMatchDistance;
    }

    /**
     * <p>
     * The regular expression (<i>regex</i>) that defines the pattern to match. The expression can contain as many as
     * 512 characters.
     * </p>
     * 
     * @return The regular expression (<i>regex</i>) that defines the pattern to match. The expression can contain as
     *         many as 512 characters.
     */
    public final String regex() {
        return regex;
    }

    /**
     * <p>
     * The sample text to inspect by using the custom data identifier. The text can contain as many as 1,000 characters.
     * </p>
     * 
     * @return The sample text to inspect by using the custom data identifier. The text can contain as many as 1,000
     *         characters.
     */
    public final String sampleText() {
        return sampleText;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasIgnoreWords() ? ignoreWords() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasKeywords() ? keywords() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maximumMatchDistance());
        hashCode = 31 * hashCode + Objects.hashCode(regex());
        hashCode = 31 * hashCode + Objects.hashCode(sampleText());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestCustomDataIdentifierRequest)) {
            return false;
        }
        TestCustomDataIdentifierRequest other = (TestCustomDataIdentifierRequest) obj;
        return hasIgnoreWords() == other.hasIgnoreWords() && Objects.equals(ignoreWords(), other.ignoreWords())
                && hasKeywords() == other.hasKeywords() && Objects.equals(keywords(), other.keywords())
                && Objects.equals(maximumMatchDistance(), other.maximumMatchDistance()) && Objects.equals(regex(), other.regex())
                && Objects.equals(sampleText(), other.sampleText());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TestCustomDataIdentifierRequest").add("IgnoreWords", hasIgnoreWords() ? ignoreWords() : null)
                .add("Keywords", hasKeywords() ? keywords() : null).add("MaximumMatchDistance", maximumMatchDistance())
                .add("Regex", regex()).add("SampleText", sampleText()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ignoreWords":
            return Optional.ofNullable(clazz.cast(ignoreWords()));
        case "keywords":
            return Optional.ofNullable(clazz.cast(keywords()));
        case "maximumMatchDistance":
            return Optional.ofNullable(clazz.cast(maximumMatchDistance()));
        case "regex":
            return Optional.ofNullable(clazz.cast(regex()));
        case "sampleText":
            return Optional.ofNullable(clazz.cast(sampleText()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TestCustomDataIdentifierRequest, T> g) {
        return obj -> g.apply((TestCustomDataIdentifierRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Macie2Request.Builder, SdkPojo, CopyableBuilder<Builder, TestCustomDataIdentifierRequest> {
        /**
         * <p>
         * An array that lists specific character sequences (ignore words) to exclude from the results. If the text
         * matched by the regular expression is the same as any string in this array, Amazon Macie ignores it. The array
         * can contain as many as 10 ignore words. Each ignore word can contain 4-90 characters. Ignore words are case
         * sensitive.
         * </p>
         * 
         * @param ignoreWords
         *        An array that lists specific character sequences (ignore words) to exclude from the results. If the
         *        text matched by the regular expression is the same as any string in this array, Amazon Macie ignores
         *        it. The array can contain as many as 10 ignore words. Each ignore word can contain 4-90 characters.
         *        Ignore words are case sensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ignoreWords(Collection<String> ignoreWords);

        /**
         * <p>
         * An array that lists specific character sequences (ignore words) to exclude from the results. If the text
         * matched by the regular expression is the same as any string in this array, Amazon Macie ignores it. The array
         * can contain as many as 10 ignore words. Each ignore word can contain 4-90 characters. Ignore words are case
         * sensitive.
         * </p>
         * 
         * @param ignoreWords
         *        An array that lists specific character sequences (ignore words) to exclude from the results. If the
         *        text matched by the regular expression is the same as any string in this array, Amazon Macie ignores
         *        it. The array can contain as many as 10 ignore words. Each ignore word can contain 4-90 characters.
         *        Ignore words are case sensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ignoreWords(String... ignoreWords);

        /**
         * <p>
         * An array that lists specific character sequences (keywords), one of which must be within proximity
         * (maximumMatchDistance) of the regular expression to match. The array can contain as many as 50 keywords. Each
         * keyword can contain 3-90 characters. Keywords aren't case sensitive.
         * </p>
         * 
         * @param keywords
         *        An array that lists specific character sequences (keywords), one of which must be within proximity
         *        (maximumMatchDistance) of the regular expression to match. The array can contain as many as 50
         *        keywords. Each keyword can contain 3-90 characters. Keywords aren't case sensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keywords(Collection<String> keywords);

        /**
         * <p>
         * An array that lists specific character sequences (keywords), one of which must be within proximity
         * (maximumMatchDistance) of the regular expression to match. The array can contain as many as 50 keywords. Each
         * keyword can contain 3-90 characters. Keywords aren't case sensitive.
         * </p>
         * 
         * @param keywords
         *        An array that lists specific character sequences (keywords), one of which must be within proximity
         *        (maximumMatchDistance) of the regular expression to match. The array can contain as many as 50
         *        keywords. Each keyword can contain 3-90 characters. Keywords aren't case sensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keywords(String... keywords);

        /**
         * <p>
         * The maximum number of characters that can exist between text that matches the regex pattern and the character
         * sequences specified by the keywords array. Macie includes or excludes a result based on the proximity of a
         * keyword to text that matches the regex pattern. The distance can be 1-300 characters. The default value is
         * 50.
         * </p>
         * 
         * @param maximumMatchDistance
         *        The maximum number of characters that can exist between text that matches the regex pattern and the
         *        character sequences specified by the keywords array. Macie includes or excludes a result based on the
         *        proximity of a keyword to text that matches the regex pattern. The distance can be 1-300 characters.
         *        The default value is 50.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumMatchDistance(Integer maximumMatchDistance);

        /**
         * <p>
         * The regular expression (<i>regex</i>) that defines the pattern to match. The expression can contain as many
         * as 512 characters.
         * </p>
         * 
         * @param regex
         *        The regular expression (<i>regex</i>) that defines the pattern to match. The expression can contain as
         *        many as 512 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regex(String regex);

        /**
         * <p>
         * The sample text to inspect by using the custom data identifier. The text can contain as many as 1,000
         * characters.
         * </p>
         * 
         * @param sampleText
         *        The sample text to inspect by using the custom data identifier. The text can contain as many as 1,000
         *        characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sampleText(String sampleText);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Macie2Request.BuilderImpl implements Builder {
        private List<String> ignoreWords = DefaultSdkAutoConstructList.getInstance();

        private List<String> keywords = DefaultSdkAutoConstructList.getInstance();

        private Integer maximumMatchDistance;

        private String regex;

        private String sampleText;

        private BuilderImpl() {
        }

        private BuilderImpl(TestCustomDataIdentifierRequest model) {
            super(model);
            ignoreWords(model.ignoreWords);
            keywords(model.keywords);
            maximumMatchDistance(model.maximumMatchDistance);
            regex(model.regex);
            sampleText(model.sampleText);
        }

        public final Collection<String> getIgnoreWords() {
            if (ignoreWords instanceof SdkAutoConstructList) {
                return null;
            }
            return ignoreWords;
        }

        public final void setIgnoreWords(Collection<String> ignoreWords) {
            this.ignoreWords = ___listOf__stringCopier.copy(ignoreWords);
        }

        @Override
        @Transient
        public final Builder ignoreWords(Collection<String> ignoreWords) {
            this.ignoreWords = ___listOf__stringCopier.copy(ignoreWords);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder ignoreWords(String... ignoreWords) {
            ignoreWords(Arrays.asList(ignoreWords));
            return this;
        }

        public final Collection<String> getKeywords() {
            if (keywords instanceof SdkAutoConstructList) {
                return null;
            }
            return keywords;
        }

        public final void setKeywords(Collection<String> keywords) {
            this.keywords = ___listOf__stringCopier.copy(keywords);
        }

        @Override
        @Transient
        public final Builder keywords(Collection<String> keywords) {
            this.keywords = ___listOf__stringCopier.copy(keywords);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder keywords(String... keywords) {
            keywords(Arrays.asList(keywords));
            return this;
        }

        public final Integer getMaximumMatchDistance() {
            return maximumMatchDistance;
        }

        public final void setMaximumMatchDistance(Integer maximumMatchDistance) {
            this.maximumMatchDistance = maximumMatchDistance;
        }

        @Override
        @Transient
        public final Builder maximumMatchDistance(Integer maximumMatchDistance) {
            this.maximumMatchDistance = maximumMatchDistance;
            return this;
        }

        public final String getRegex() {
            return regex;
        }

        public final void setRegex(String regex) {
            this.regex = regex;
        }

        @Override
        @Transient
        public final Builder regex(String regex) {
            this.regex = regex;
            return this;
        }

        public final String getSampleText() {
            return sampleText;
        }

        public final void setSampleText(String sampleText) {
            this.sampleText = sampleText;
        }

        @Override
        @Transient
        public final Builder sampleText(String sampleText) {
            this.sampleText = sampleText;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public TestCustomDataIdentifierRequest build() {
            return new TestCustomDataIdentifierRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
