/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about the total storage size (in bytes) or number of objects that Amazon Macie can't analyze in
 * one or more S3 buckets. In a BucketMetadata or MatchingBucket object, this data is for a specific bucket. In a
 * GetBucketStatisticsResponse object, this data is aggregated for all the buckets in the query results. If versioning
 * is enabled for a bucket, total storage size values are based on the size of the latest version of each applicable
 * object in the bucket.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ObjectLevelStatistics implements SdkPojo, Serializable,
        ToCopyableBuilder<ObjectLevelStatistics.Builder, ObjectLevelStatistics> {
    private static final SdkField<Long> FILE_TYPE_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("fileType")
            .getter(getter(ObjectLevelStatistics::fileType)).setter(setter(Builder::fileType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileType").build()).build();

    private static final SdkField<Long> STORAGE_CLASS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("storageClass").getter(getter(ObjectLevelStatistics::storageClass)).setter(setter(Builder::storageClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageClass").build()).build();

    private static final SdkField<Long> TOTAL_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("total")
            .getter(getter(ObjectLevelStatistics::total)).setter(setter(Builder::total))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("total").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_TYPE_FIELD,
            STORAGE_CLASS_FIELD, TOTAL_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long fileType;

    private final Long storageClass;

    private final Long total;

    private ObjectLevelStatistics(BuilderImpl builder) {
        this.fileType = builder.fileType;
        this.storageClass = builder.storageClass;
        this.total = builder.total;
    }

    /**
     * <p>
     * The total storage size (in bytes) or number of objects that Amazon Macie can't analyze because the objects don't
     * have a file name extension for a supported file or storage format.
     * </p>
     * 
     * @return The total storage size (in bytes) or number of objects that Amazon Macie can't analyze because the
     *         objects don't have a file name extension for a supported file or storage format.
     */
    public final Long fileType() {
        return fileType;
    }

    /**
     * <p>
     * The total storage size (in bytes) or number of objects that Amazon Macie can't analyze because the objects use an
     * unsupported storage class.
     * </p>
     * 
     * @return The total storage size (in bytes) or number of objects that Amazon Macie can't analyze because the
     *         objects use an unsupported storage class.
     */
    public final Long storageClass() {
        return storageClass;
    }

    /**
     * <p>
     * The total storage size (in bytes) or number of objects that Amazon Macie can't analyze because the objects use an
     * unsupported storage class or don't have a file name extension for a supported file or storage format.
     * </p>
     * 
     * @return The total storage size (in bytes) or number of objects that Amazon Macie can't analyze because the
     *         objects use an unsupported storage class or don't have a file name extension for a supported file or
     *         storage format.
     */
    public final Long total() {
        return total;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fileType());
        hashCode = 31 * hashCode + Objects.hashCode(storageClass());
        hashCode = 31 * hashCode + Objects.hashCode(total());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ObjectLevelStatistics)) {
            return false;
        }
        ObjectLevelStatistics other = (ObjectLevelStatistics) obj;
        return Objects.equals(fileType(), other.fileType()) && Objects.equals(storageClass(), other.storageClass())
                && Objects.equals(total(), other.total());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ObjectLevelStatistics").add("FileType", fileType()).add("StorageClass", storageClass())
                .add("Total", total()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "fileType":
            return Optional.ofNullable(clazz.cast(fileType()));
        case "storageClass":
            return Optional.ofNullable(clazz.cast(storageClass()));
        case "total":
            return Optional.ofNullable(clazz.cast(total()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ObjectLevelStatistics, T> g) {
        return obj -> g.apply((ObjectLevelStatistics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ObjectLevelStatistics> {
        /**
         * <p>
         * The total storage size (in bytes) or number of objects that Amazon Macie can't analyze because the objects
         * don't have a file name extension for a supported file or storage format.
         * </p>
         * 
         * @param fileType
         *        The total storage size (in bytes) or number of objects that Amazon Macie can't analyze because the
         *        objects don't have a file name extension for a supported file or storage format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileType(Long fileType);

        /**
         * <p>
         * The total storage size (in bytes) or number of objects that Amazon Macie can't analyze because the objects
         * use an unsupported storage class.
         * </p>
         * 
         * @param storageClass
         *        The total storage size (in bytes) or number of objects that Amazon Macie can't analyze because the
         *        objects use an unsupported storage class.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageClass(Long storageClass);

        /**
         * <p>
         * The total storage size (in bytes) or number of objects that Amazon Macie can't analyze because the objects
         * use an unsupported storage class or don't have a file name extension for a supported file or storage format.
         * </p>
         * 
         * @param total
         *        The total storage size (in bytes) or number of objects that Amazon Macie can't analyze because the
         *        objects use an unsupported storage class or don't have a file name extension for a supported file or
         *        storage format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder total(Long total);
    }

    static final class BuilderImpl implements Builder {
        private Long fileType;

        private Long storageClass;

        private Long total;

        private BuilderImpl() {
        }

        private BuilderImpl(ObjectLevelStatistics model) {
            fileType(model.fileType);
            storageClass(model.storageClass);
            total(model.total);
        }

        public final Long getFileType() {
            return fileType;
        }

        public final void setFileType(Long fileType) {
            this.fileType = fileType;
        }

        @Override
        @Transient
        public final Builder fileType(Long fileType) {
            this.fileType = fileType;
            return this;
        }

        public final Long getStorageClass() {
            return storageClass;
        }

        public final void setStorageClass(Long storageClass) {
            this.storageClass = storageClass;
        }

        @Override
        @Transient
        public final Builder storageClass(Long storageClass) {
            this.storageClass = storageClass;
            return this;
        }

        public final Long getTotal() {
            return total;
        }

        public final void setTotal(Long total) {
            this.total = total;
        }

        @Override
        @Transient
        public final Builder total(Long total) {
            this.total = total;
            return this;
        }

        @Override
        public ObjectLevelStatistics build() {
            return new ObjectLevelStatistics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
