/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies one or more property- and tag-based conditions that define criteria for including or excluding S3 objects
 * from a classification job. Exclude conditions take precedence over include conditions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Scoping implements SdkPojo, Serializable, ToCopyableBuilder<Scoping.Builder, Scoping> {
    private static final SdkField<JobScopingBlock> EXCLUDES_FIELD = SdkField.<JobScopingBlock> builder(MarshallingType.SDK_POJO)
            .memberName("excludes").getter(getter(Scoping::excludes)).setter(setter(Builder::excludes))
            .constructor(JobScopingBlock::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("excludes").build()).build();

    private static final SdkField<JobScopingBlock> INCLUDES_FIELD = SdkField.<JobScopingBlock> builder(MarshallingType.SDK_POJO)
            .memberName("includes").getter(getter(Scoping::includes)).setter(setter(Builder::includes))
            .constructor(JobScopingBlock::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includes").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(EXCLUDES_FIELD, INCLUDES_FIELD));

    private static final long serialVersionUID = 1L;

    private final JobScopingBlock excludes;

    private final JobScopingBlock includes;

    private Scoping(BuilderImpl builder) {
        this.excludes = builder.excludes;
        this.includes = builder.includes;
    }

    /**
     * <p>
     * The property- and tag-based conditions that determine which objects to exclude from the analysis.
     * </p>
     * 
     * @return The property- and tag-based conditions that determine which objects to exclude from the analysis.
     */
    public final JobScopingBlock excludes() {
        return excludes;
    }

    /**
     * <p>
     * The property- and tag-based conditions that determine which objects to include in the analysis.
     * </p>
     * 
     * @return The property- and tag-based conditions that determine which objects to include in the analysis.
     */
    public final JobScopingBlock includes() {
        return includes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(excludes());
        hashCode = 31 * hashCode + Objects.hashCode(includes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Scoping)) {
            return false;
        }
        Scoping other = (Scoping) obj;
        return Objects.equals(excludes(), other.excludes()) && Objects.equals(includes(), other.includes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Scoping").add("Excludes", excludes()).add("Includes", includes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "excludes":
            return Optional.ofNullable(clazz.cast(excludes()));
        case "includes":
            return Optional.ofNullable(clazz.cast(includes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Scoping, T> g) {
        return obj -> g.apply((Scoping) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Scoping> {
        /**
         * <p>
         * The property- and tag-based conditions that determine which objects to exclude from the analysis.
         * </p>
         * 
         * @param excludes
         *        The property- and tag-based conditions that determine which objects to exclude from the analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludes(JobScopingBlock excludes);

        /**
         * <p>
         * The property- and tag-based conditions that determine which objects to exclude from the analysis.
         * </p>
         * This is a convenience that creates an instance of the {@link JobScopingBlock.Builder} avoiding the need to
         * create one manually via {@link JobScopingBlock#builder()}.
         *
         * When the {@link Consumer} completes, {@link JobScopingBlock.Builder#build()} is called immediately and its
         * result is passed to {@link #excludes(JobScopingBlock)}.
         * 
         * @param excludes
         *        a consumer that will call methods on {@link JobScopingBlock.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #excludes(JobScopingBlock)
         */
        default Builder excludes(Consumer<JobScopingBlock.Builder> excludes) {
            return excludes(JobScopingBlock.builder().applyMutation(excludes).build());
        }

        /**
         * <p>
         * The property- and tag-based conditions that determine which objects to include in the analysis.
         * </p>
         * 
         * @param includes
         *        The property- and tag-based conditions that determine which objects to include in the analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includes(JobScopingBlock includes);

        /**
         * <p>
         * The property- and tag-based conditions that determine which objects to include in the analysis.
         * </p>
         * This is a convenience that creates an instance of the {@link JobScopingBlock.Builder} avoiding the need to
         * create one manually via {@link JobScopingBlock#builder()}.
         *
         * When the {@link Consumer} completes, {@link JobScopingBlock.Builder#build()} is called immediately and its
         * result is passed to {@link #includes(JobScopingBlock)}.
         * 
         * @param includes
         *        a consumer that will call methods on {@link JobScopingBlock.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #includes(JobScopingBlock)
         */
        default Builder includes(Consumer<JobScopingBlock.Builder> includes) {
            return includes(JobScopingBlock.builder().applyMutation(includes).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private JobScopingBlock excludes;

        private JobScopingBlock includes;

        private BuilderImpl() {
        }

        private BuilderImpl(Scoping model) {
            excludes(model.excludes);
            includes(model.includes);
        }

        public final JobScopingBlock.Builder getExcludes() {
            return excludes != null ? excludes.toBuilder() : null;
        }

        public final void setExcludes(JobScopingBlock.BuilderImpl excludes) {
            this.excludes = excludes != null ? excludes.build() : null;
        }

        @Override
        @Transient
        public final Builder excludes(JobScopingBlock excludes) {
            this.excludes = excludes;
            return this;
        }

        public final JobScopingBlock.Builder getIncludes() {
            return includes != null ? includes.toBuilder() : null;
        }

        public final void setIncludes(JobScopingBlock.BuilderImpl includes) {
            this.includes = includes != null ? includes.build() : null;
        }

        @Override
        @Transient
        public final Builder includes(JobScopingBlock includes) {
            this.includes = includes;
            return this;
        }

        @Override
        public Scoping build() {
            return new Scoping(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
