/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateFindingsFilterRequest extends Macie2Request implements
        ToCopyableBuilder<UpdateFindingsFilterRequest.Builder, UpdateFindingsFilterRequest> {
    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("action")
            .getter(getter(UpdateFindingsFilterRequest::actionAsString)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateFindingsFilterRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<FindingCriteria> FINDING_CRITERIA_FIELD = SdkField
            .<FindingCriteria> builder(MarshallingType.SDK_POJO).memberName("findingCriteria")
            .getter(getter(UpdateFindingsFilterRequest::findingCriteria)).setter(setter(Builder::findingCriteria))
            .constructor(FindingCriteria::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingCriteria").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(UpdateFindingsFilterRequest::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateFindingsFilterRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Integer> POSITION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("position").getter(getter(UpdateFindingsFilterRequest::position)).setter(setter(Builder::position))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("position").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(UpdateFindingsFilterRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD,
            DESCRIPTION_FIELD, FINDING_CRITERIA_FIELD, ID_FIELD, NAME_FIELD, POSITION_FIELD, CLIENT_TOKEN_FIELD));

    private final String action;

    private final String description;

    private final FindingCriteria findingCriteria;

    private final String id;

    private final String name;

    private final Integer position;

    private final String clientToken;

    private UpdateFindingsFilterRequest(BuilderImpl builder) {
        super(builder);
        this.action = builder.action;
        this.description = builder.description;
        this.findingCriteria = builder.findingCriteria;
        this.id = builder.id;
        this.name = builder.name;
        this.position = builder.position;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The action to perform on findings that meet the filter criteria (findingCriteria). Valid values are: ARCHIVE,
     * suppress (automatically archive) the findings; and, NOOP, don't perform any action on the findings.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link FindingsFilterAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #actionAsString}.
     * </p>
     * 
     * @return The action to perform on findings that meet the filter criteria (findingCriteria). Valid values are:
     *         ARCHIVE, suppress (automatically archive) the findings; and, NOOP, don't perform any action on the
     *         findings.
     * @see FindingsFilterAction
     */
    public final FindingsFilterAction action() {
        return FindingsFilterAction.fromValue(action);
    }

    /**
     * <p>
     * The action to perform on findings that meet the filter criteria (findingCriteria). Valid values are: ARCHIVE,
     * suppress (automatically archive) the findings; and, NOOP, don't perform any action on the findings.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link FindingsFilterAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #actionAsString}.
     * </p>
     * 
     * @return The action to perform on findings that meet the filter criteria (findingCriteria). Valid values are:
     *         ARCHIVE, suppress (automatically archive) the findings; and, NOOP, don't perform any action on the
     *         findings.
     * @see FindingsFilterAction
     */
    public final String actionAsString() {
        return action;
    }

    /**
     * <p>
     * A custom description of the filter. The description can contain as many as 512 characters.
     * </p>
     * <p>
     * We strongly recommend that you avoid including any sensitive data in the description of a filter. Other users
     * might be able to see the filter's description, depending on the actions that they're allowed to perform in Amazon
     * Macie.
     * </p>
     * 
     * @return A custom description of the filter. The description can contain as many as 512 characters.</p>
     *         <p>
     *         We strongly recommend that you avoid including any sensitive data in the description of a filter. Other
     *         users might be able to see the filter's description, depending on the actions that they're allowed to
     *         perform in Amazon Macie.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The criteria to use to filter findings.
     * </p>
     * 
     * @return The criteria to use to filter findings.
     */
    public final FindingCriteria findingCriteria() {
        return findingCriteria;
    }

    /**
     * <p>
     * The unique identifier for the Amazon Macie resource or account that the request applies to.
     * </p>
     * 
     * @return The unique identifier for the Amazon Macie resource or account that the request applies to.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * A custom name for the filter. The name must contain at least 3 characters and can contain as many as 64
     * characters.
     * </p>
     * <p>
     * We strongly recommend that you avoid including any sensitive data in the name of a filter. Other users might be
     * able to see the filter's name, depending on the actions that they're allowed to perform in Amazon Macie.
     * </p>
     * 
     * @return A custom name for the filter. The name must contain at least 3 characters and can contain as many as 64
     *         characters.</p>
     *         <p>
     *         We strongly recommend that you avoid including any sensitive data in the name of a filter. Other users
     *         might be able to see the filter's name, depending on the actions that they're allowed to perform in
     *         Amazon Macie.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The position of the filter in the list of saved filters on the Amazon Macie console. This value also determines
     * the order in which the filter is applied to findings, relative to other filters that are also applied to the
     * findings.
     * </p>
     * 
     * @return The position of the filter in the list of saved filters on the Amazon Macie console. This value also
     *         determines the order in which the filter is applied to findings, relative to other filters that are also
     *         applied to the findings.
     */
    public final Integer position() {
        return position;
    }

    /**
     * <p>
     * A unique, case-sensitive token that you provide to ensure the idempotency of the request.
     * </p>
     * 
     * @return A unique, case-sensitive token that you provide to ensure the idempotency of the request.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(findingCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(position());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFindingsFilterRequest)) {
            return false;
        }
        UpdateFindingsFilterRequest other = (UpdateFindingsFilterRequest) obj;
        return Objects.equals(actionAsString(), other.actionAsString()) && Objects.equals(description(), other.description())
                && Objects.equals(findingCriteria(), other.findingCriteria()) && Objects.equals(id(), other.id())
                && Objects.equals(name(), other.name()) && Objects.equals(position(), other.position())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateFindingsFilterRequest").add("Action", actionAsString()).add("Description", description())
                .add("FindingCriteria", findingCriteria()).add("Id", id()).add("Name", name()).add("Position", position())
                .add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "action":
            return Optional.ofNullable(clazz.cast(actionAsString()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "findingCriteria":
            return Optional.ofNullable(clazz.cast(findingCriteria()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "position":
            return Optional.ofNullable(clazz.cast(position()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateFindingsFilterRequest, T> g) {
        return obj -> g.apply((UpdateFindingsFilterRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Macie2Request.Builder, SdkPojo, CopyableBuilder<Builder, UpdateFindingsFilterRequest> {
        /**
         * <p>
         * The action to perform on findings that meet the filter criteria (findingCriteria). Valid values are: ARCHIVE,
         * suppress (automatically archive) the findings; and, NOOP, don't perform any action on the findings.
         * </p>
         * 
         * @param action
         *        The action to perform on findings that meet the filter criteria (findingCriteria). Valid values are:
         *        ARCHIVE, suppress (automatically archive) the findings; and, NOOP, don't perform any action on the
         *        findings.
         * @see FindingsFilterAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FindingsFilterAction
         */
        Builder action(String action);

        /**
         * <p>
         * The action to perform on findings that meet the filter criteria (findingCriteria). Valid values are: ARCHIVE,
         * suppress (automatically archive) the findings; and, NOOP, don't perform any action on the findings.
         * </p>
         * 
         * @param action
         *        The action to perform on findings that meet the filter criteria (findingCriteria). Valid values are:
         *        ARCHIVE, suppress (automatically archive) the findings; and, NOOP, don't perform any action on the
         *        findings.
         * @see FindingsFilterAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FindingsFilterAction
         */
        Builder action(FindingsFilterAction action);

        /**
         * <p>
         * A custom description of the filter. The description can contain as many as 512 characters.
         * </p>
         * <p>
         * We strongly recommend that you avoid including any sensitive data in the description of a filter. Other users
         * might be able to see the filter's description, depending on the actions that they're allowed to perform in
         * Amazon Macie.
         * </p>
         * 
         * @param description
         *        A custom description of the filter. The description can contain as many as 512 characters.</p>
         *        <p>
         *        We strongly recommend that you avoid including any sensitive data in the description of a filter.
         *        Other users might be able to see the filter's description, depending on the actions that they're
         *        allowed to perform in Amazon Macie.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The criteria to use to filter findings.
         * </p>
         * 
         * @param findingCriteria
         *        The criteria to use to filter findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingCriteria(FindingCriteria findingCriteria);

        /**
         * <p>
         * The criteria to use to filter findings.
         * </p>
         * This is a convenience that creates an instance of the {@link FindingCriteria.Builder} avoiding the need to
         * create one manually via {@link FindingCriteria#builder()}.
         *
         * When the {@link Consumer} completes, {@link FindingCriteria.Builder#build()} is called immediately and its
         * result is passed to {@link #findingCriteria(FindingCriteria)}.
         * 
         * @param findingCriteria
         *        a consumer that will call methods on {@link FindingCriteria.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #findingCriteria(FindingCriteria)
         */
        default Builder findingCriteria(Consumer<FindingCriteria.Builder> findingCriteria) {
            return findingCriteria(FindingCriteria.builder().applyMutation(findingCriteria).build());
        }

        /**
         * <p>
         * The unique identifier for the Amazon Macie resource or account that the request applies to.
         * </p>
         * 
         * @param id
         *        The unique identifier for the Amazon Macie resource or account that the request applies to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * A custom name for the filter. The name must contain at least 3 characters and can contain as many as 64
         * characters.
         * </p>
         * <p>
         * We strongly recommend that you avoid including any sensitive data in the name of a filter. Other users might
         * be able to see the filter's name, depending on the actions that they're allowed to perform in Amazon Macie.
         * </p>
         * 
         * @param name
         *        A custom name for the filter. The name must contain at least 3 characters and can contain as many as
         *        64 characters.</p>
         *        <p>
         *        We strongly recommend that you avoid including any sensitive data in the name of a filter. Other users
         *        might be able to see the filter's name, depending on the actions that they're allowed to perform in
         *        Amazon Macie.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The position of the filter in the list of saved filters on the Amazon Macie console. This value also
         * determines the order in which the filter is applied to findings, relative to other filters that are also
         * applied to the findings.
         * </p>
         * 
         * @param position
         *        The position of the filter in the list of saved filters on the Amazon Macie console. This value also
         *        determines the order in which the filter is applied to findings, relative to other filters that are
         *        also applied to the findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder position(Integer position);

        /**
         * <p>
         * A unique, case-sensitive token that you provide to ensure the idempotency of the request.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive token that you provide to ensure the idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Macie2Request.BuilderImpl implements Builder {
        private String action;

        private String description;

        private FindingCriteria findingCriteria;

        private String id;

        private String name;

        private Integer position;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFindingsFilterRequest model) {
            super(model);
            action(model.action);
            description(model.description);
            findingCriteria(model.findingCriteria);
            id(model.id);
            name(model.name);
            position(model.position);
            clientToken(model.clientToken);
        }

        public final String getAction() {
            return action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        @Transient
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        @Transient
        public final Builder action(FindingsFilterAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final FindingCriteria.Builder getFindingCriteria() {
            return findingCriteria != null ? findingCriteria.toBuilder() : null;
        }

        public final void setFindingCriteria(FindingCriteria.BuilderImpl findingCriteria) {
            this.findingCriteria = findingCriteria != null ? findingCriteria.build() : null;
        }

        @Override
        @Transient
        public final Builder findingCriteria(FindingCriteria findingCriteria) {
            this.findingCriteria = findingCriteria;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        @Transient
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Integer getPosition() {
            return position;
        }

        public final void setPosition(Integer position) {
            this.position = position;
        }

        @Override
        @Transient
        public final Builder position(Integer position) {
            this.position = position;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        @Transient
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateFindingsFilterRequest build() {
            return new UpdateFindingsFilterRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
