/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies, as a map, one or more property-based conditions that filter the results of a query for findings.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FindingCriteria implements SdkPojo, Serializable, ToCopyableBuilder<FindingCriteria.Builder, FindingCriteria> {
    private static final SdkField<Map<String, CriterionAdditionalProperties>> CRITERION_FIELD = SdkField
            .<Map<String, CriterionAdditionalProperties>> builder(MarshallingType.MAP)
            .memberName("criterion")
            .getter(getter(FindingCriteria::criterion))
            .setter(setter(Builder::criterion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("criterion").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<CriterionAdditionalProperties> builder(MarshallingType.SDK_POJO)
                                            .constructor(CriterionAdditionalProperties::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CRITERION_FIELD));

    private static final long serialVersionUID = 1L;

    private final Map<String, CriterionAdditionalProperties> criterion;

    private FindingCriteria(BuilderImpl builder) {
        this.criterion = builder.criterion;
    }

    /**
     * For responses, this returns true if the service returned a value for the Criterion property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasCriterion() {
        return criterion != null && !(criterion instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A condition that specifies the property, operator, and one or more values to use to filter the results.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCriterion} method.
     * </p>
     * 
     * @return A condition that specifies the property, operator, and one or more values to use to filter the results.
     */
    public final Map<String, CriterionAdditionalProperties> criterion() {
        return criterion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasCriterion() ? criterion() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FindingCriteria)) {
            return false;
        }
        FindingCriteria other = (FindingCriteria) obj;
        return hasCriterion() == other.hasCriterion() && Objects.equals(criterion(), other.criterion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FindingCriteria").add("Criterion", hasCriterion() ? criterion() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "criterion":
            return Optional.ofNullable(clazz.cast(criterion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FindingCriteria, T> g) {
        return obj -> g.apply((FindingCriteria) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FindingCriteria> {
        /**
         * <p>
         * A condition that specifies the property, operator, and one or more values to use to filter the results.
         * </p>
         * 
         * @param criterion
         *        A condition that specifies the property, operator, and one or more values to use to filter the
         *        results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder criterion(Map<String, CriterionAdditionalProperties> criterion);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, CriterionAdditionalProperties> criterion = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FindingCriteria model) {
            criterion(model.criterion);
        }

        public final Map<String, CriterionAdditionalProperties.Builder> getCriterion() {
            Map<String, CriterionAdditionalProperties.Builder> result = CriterionCopier.copyToBuilder(this.criterion);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setCriterion(Map<String, CriterionAdditionalProperties.BuilderImpl> criterion) {
            this.criterion = CriterionCopier.copyFromBuilder(criterion);
        }

        @Override
        @Transient
        public final Builder criterion(Map<String, CriterionAdditionalProperties> criterion) {
            this.criterion = CriterionCopier.copy(criterion);
            return this;
        }

        @Override
        public FindingCriteria build() {
            return new FindingCriteria(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
