/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnableMacieRequest extends Macie2Request implements
        ToCopyableBuilder<EnableMacieRequest.Builder, EnableMacieRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(EnableMacieRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> FINDING_PUBLISHING_FREQUENCY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("findingPublishingFrequency")
            .getter(getter(EnableMacieRequest::findingPublishingFrequencyAsString))
            .setter(setter(Builder::findingPublishingFrequency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingPublishingFrequency").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(EnableMacieRequest::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            FINDING_PUBLISHING_FREQUENCY_FIELD, STATUS_FIELD));

    private final String clientToken;

    private final String findingPublishingFrequency;

    private final String status;

    private EnableMacieRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.findingPublishingFrequency = builder.findingPublishingFrequency;
        this.status = builder.status;
    }

    /**
     * <p>
     * A unique, case-sensitive token that you provide to ensure the idempotency of the request.
     * </p>
     * 
     * @return A unique, case-sensitive token that you provide to ensure the idempotency of the request.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * Specifies how often to publish updates to policy findings for the account. This includes publishing updates to
     * Security Hub and Amazon EventBridge (formerly called Amazon CloudWatch Events).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #findingPublishingFrequency} will return {@link FindingPublishingFrequency#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #findingPublishingFrequencyAsString}.
     * </p>
     * 
     * @return Specifies how often to publish updates to policy findings for the account. This includes publishing
     *         updates to Security Hub and Amazon EventBridge (formerly called Amazon CloudWatch Events).
     * @see FindingPublishingFrequency
     */
    public final FindingPublishingFrequency findingPublishingFrequency() {
        return FindingPublishingFrequency.fromValue(findingPublishingFrequency);
    }

    /**
     * <p>
     * Specifies how often to publish updates to policy findings for the account. This includes publishing updates to
     * Security Hub and Amazon EventBridge (formerly called Amazon CloudWatch Events).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #findingPublishingFrequency} will return {@link FindingPublishingFrequency#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #findingPublishingFrequencyAsString}.
     * </p>
     * 
     * @return Specifies how often to publish updates to policy findings for the account. This includes publishing
     *         updates to Security Hub and Amazon EventBridge (formerly called Amazon CloudWatch Events).
     * @see FindingPublishingFrequency
     */
    public final String findingPublishingFrequencyAsString() {
        return findingPublishingFrequency;
    }

    /**
     * <p>
     * Specifies the new status for the account. To enable Amazon Macie and start all Macie activities for the account,
     * set this value to ENABLED.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link MacieStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Specifies the new status for the account. To enable Amazon Macie and start all Macie activities for the
     *         account, set this value to ENABLED.
     * @see MacieStatus
     */
    public final MacieStatus status() {
        return MacieStatus.fromValue(status);
    }

    /**
     * <p>
     * Specifies the new status for the account. To enable Amazon Macie and start all Macie activities for the account,
     * set this value to ENABLED.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link MacieStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Specifies the new status for the account. To enable Amazon Macie and start all Macie activities for the
     *         account, set this value to ENABLED.
     * @see MacieStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(findingPublishingFrequencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnableMacieRequest)) {
            return false;
        }
        EnableMacieRequest other = (EnableMacieRequest) obj;
        return Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(findingPublishingFrequencyAsString(), other.findingPublishingFrequencyAsString())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EnableMacieRequest").add("ClientToken", clientToken())
                .add("FindingPublishingFrequency", findingPublishingFrequencyAsString()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "findingPublishingFrequency":
            return Optional.ofNullable(clazz.cast(findingPublishingFrequencyAsString()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EnableMacieRequest, T> g) {
        return obj -> g.apply((EnableMacieRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Macie2Request.Builder, SdkPojo, CopyableBuilder<Builder, EnableMacieRequest> {
        /**
         * <p>
         * A unique, case-sensitive token that you provide to ensure the idempotency of the request.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive token that you provide to ensure the idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Specifies how often to publish updates to policy findings for the account. This includes publishing updates
         * to Security Hub and Amazon EventBridge (formerly called Amazon CloudWatch Events).
         * </p>
         * 
         * @param findingPublishingFrequency
         *        Specifies how often to publish updates to policy findings for the account. This includes publishing
         *        updates to Security Hub and Amazon EventBridge (formerly called Amazon CloudWatch Events).
         * @see FindingPublishingFrequency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FindingPublishingFrequency
         */
        Builder findingPublishingFrequency(String findingPublishingFrequency);

        /**
         * <p>
         * Specifies how often to publish updates to policy findings for the account. This includes publishing updates
         * to Security Hub and Amazon EventBridge (formerly called Amazon CloudWatch Events).
         * </p>
         * 
         * @param findingPublishingFrequency
         *        Specifies how often to publish updates to policy findings for the account. This includes publishing
         *        updates to Security Hub and Amazon EventBridge (formerly called Amazon CloudWatch Events).
         * @see FindingPublishingFrequency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FindingPublishingFrequency
         */
        Builder findingPublishingFrequency(FindingPublishingFrequency findingPublishingFrequency);

        /**
         * <p>
         * Specifies the new status for the account. To enable Amazon Macie and start all Macie activities for the
         * account, set this value to ENABLED.
         * </p>
         * 
         * @param status
         *        Specifies the new status for the account. To enable Amazon Macie and start all Macie activities for
         *        the account, set this value to ENABLED.
         * @see MacieStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MacieStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Specifies the new status for the account. To enable Amazon Macie and start all Macie activities for the
         * account, set this value to ENABLED.
         * </p>
         * 
         * @param status
         *        Specifies the new status for the account. To enable Amazon Macie and start all Macie activities for
         *        the account, set this value to ENABLED.
         * @see MacieStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MacieStatus
         */
        Builder status(MacieStatus status);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Macie2Request.BuilderImpl implements Builder {
        private String clientToken;

        private String findingPublishingFrequency;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(EnableMacieRequest model) {
            super(model);
            clientToken(model.clientToken);
            findingPublishingFrequency(model.findingPublishingFrequency);
            status(model.status);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        @Transient
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getFindingPublishingFrequency() {
            return findingPublishingFrequency;
        }

        public final void setFindingPublishingFrequency(String findingPublishingFrequency) {
            this.findingPublishingFrequency = findingPublishingFrequency;
        }

        @Override
        @Transient
        public final Builder findingPublishingFrequency(String findingPublishingFrequency) {
            this.findingPublishingFrequency = findingPublishingFrequency;
            return this;
        }

        @Override
        @Transient
        public final Builder findingPublishingFrequency(FindingPublishingFrequency findingPublishingFrequency) {
            this.findingPublishingFrequency(findingPublishingFrequency == null ? null : findingPublishingFrequency.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(MacieStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public EnableMacieRequest build() {
            return new EnableMacieRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
