/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.util.VersionInfo;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.macie2.model.AcceptInvitationRequest;
import software.amazon.awssdk.services.macie2.model.AcceptInvitationResponse;
import software.amazon.awssdk.services.macie2.model.AccessDeniedException;
import software.amazon.awssdk.services.macie2.model.BatchGetCustomDataIdentifiersRequest;
import software.amazon.awssdk.services.macie2.model.BatchGetCustomDataIdentifiersResponse;
import software.amazon.awssdk.services.macie2.model.ConflictException;
import software.amazon.awssdk.services.macie2.model.CreateAllowListRequest;
import software.amazon.awssdk.services.macie2.model.CreateAllowListResponse;
import software.amazon.awssdk.services.macie2.model.CreateClassificationJobRequest;
import software.amazon.awssdk.services.macie2.model.CreateClassificationJobResponse;
import software.amazon.awssdk.services.macie2.model.CreateCustomDataIdentifierRequest;
import software.amazon.awssdk.services.macie2.model.CreateCustomDataIdentifierResponse;
import software.amazon.awssdk.services.macie2.model.CreateFindingsFilterRequest;
import software.amazon.awssdk.services.macie2.model.CreateFindingsFilterResponse;
import software.amazon.awssdk.services.macie2.model.CreateInvitationsRequest;
import software.amazon.awssdk.services.macie2.model.CreateInvitationsResponse;
import software.amazon.awssdk.services.macie2.model.CreateMemberRequest;
import software.amazon.awssdk.services.macie2.model.CreateMemberResponse;
import software.amazon.awssdk.services.macie2.model.CreateSampleFindingsRequest;
import software.amazon.awssdk.services.macie2.model.CreateSampleFindingsResponse;
import software.amazon.awssdk.services.macie2.model.DeclineInvitationsRequest;
import software.amazon.awssdk.services.macie2.model.DeclineInvitationsResponse;
import software.amazon.awssdk.services.macie2.model.DeleteAllowListRequest;
import software.amazon.awssdk.services.macie2.model.DeleteAllowListResponse;
import software.amazon.awssdk.services.macie2.model.DeleteCustomDataIdentifierRequest;
import software.amazon.awssdk.services.macie2.model.DeleteCustomDataIdentifierResponse;
import software.amazon.awssdk.services.macie2.model.DeleteFindingsFilterRequest;
import software.amazon.awssdk.services.macie2.model.DeleteFindingsFilterResponse;
import software.amazon.awssdk.services.macie2.model.DeleteInvitationsRequest;
import software.amazon.awssdk.services.macie2.model.DeleteInvitationsResponse;
import software.amazon.awssdk.services.macie2.model.DeleteMemberRequest;
import software.amazon.awssdk.services.macie2.model.DeleteMemberResponse;
import software.amazon.awssdk.services.macie2.model.DescribeBucketsRequest;
import software.amazon.awssdk.services.macie2.model.DescribeBucketsResponse;
import software.amazon.awssdk.services.macie2.model.DescribeClassificationJobRequest;
import software.amazon.awssdk.services.macie2.model.DescribeClassificationJobResponse;
import software.amazon.awssdk.services.macie2.model.DescribeOrganizationConfigurationRequest;
import software.amazon.awssdk.services.macie2.model.DescribeOrganizationConfigurationResponse;
import software.amazon.awssdk.services.macie2.model.DisableMacieRequest;
import software.amazon.awssdk.services.macie2.model.DisableMacieResponse;
import software.amazon.awssdk.services.macie2.model.DisableOrganizationAdminAccountRequest;
import software.amazon.awssdk.services.macie2.model.DisableOrganizationAdminAccountResponse;
import software.amazon.awssdk.services.macie2.model.DisassociateFromAdministratorAccountRequest;
import software.amazon.awssdk.services.macie2.model.DisassociateFromAdministratorAccountResponse;
import software.amazon.awssdk.services.macie2.model.DisassociateFromMasterAccountRequest;
import software.amazon.awssdk.services.macie2.model.DisassociateFromMasterAccountResponse;
import software.amazon.awssdk.services.macie2.model.DisassociateMemberRequest;
import software.amazon.awssdk.services.macie2.model.DisassociateMemberResponse;
import software.amazon.awssdk.services.macie2.model.EnableMacieRequest;
import software.amazon.awssdk.services.macie2.model.EnableMacieResponse;
import software.amazon.awssdk.services.macie2.model.EnableOrganizationAdminAccountRequest;
import software.amazon.awssdk.services.macie2.model.EnableOrganizationAdminAccountResponse;
import software.amazon.awssdk.services.macie2.model.GetAdministratorAccountRequest;
import software.amazon.awssdk.services.macie2.model.GetAdministratorAccountResponse;
import software.amazon.awssdk.services.macie2.model.GetAllowListRequest;
import software.amazon.awssdk.services.macie2.model.GetAllowListResponse;
import software.amazon.awssdk.services.macie2.model.GetAutomatedDiscoveryConfigurationRequest;
import software.amazon.awssdk.services.macie2.model.GetAutomatedDiscoveryConfigurationResponse;
import software.amazon.awssdk.services.macie2.model.GetBucketStatisticsRequest;
import software.amazon.awssdk.services.macie2.model.GetBucketStatisticsResponse;
import software.amazon.awssdk.services.macie2.model.GetClassificationExportConfigurationRequest;
import software.amazon.awssdk.services.macie2.model.GetClassificationExportConfigurationResponse;
import software.amazon.awssdk.services.macie2.model.GetClassificationScopeRequest;
import software.amazon.awssdk.services.macie2.model.GetClassificationScopeResponse;
import software.amazon.awssdk.services.macie2.model.GetCustomDataIdentifierRequest;
import software.amazon.awssdk.services.macie2.model.GetCustomDataIdentifierResponse;
import software.amazon.awssdk.services.macie2.model.GetFindingStatisticsRequest;
import software.amazon.awssdk.services.macie2.model.GetFindingStatisticsResponse;
import software.amazon.awssdk.services.macie2.model.GetFindingsFilterRequest;
import software.amazon.awssdk.services.macie2.model.GetFindingsFilterResponse;
import software.amazon.awssdk.services.macie2.model.GetFindingsPublicationConfigurationRequest;
import software.amazon.awssdk.services.macie2.model.GetFindingsPublicationConfigurationResponse;
import software.amazon.awssdk.services.macie2.model.GetFindingsRequest;
import software.amazon.awssdk.services.macie2.model.GetFindingsResponse;
import software.amazon.awssdk.services.macie2.model.GetInvitationsCountRequest;
import software.amazon.awssdk.services.macie2.model.GetInvitationsCountResponse;
import software.amazon.awssdk.services.macie2.model.GetMacieSessionRequest;
import software.amazon.awssdk.services.macie2.model.GetMacieSessionResponse;
import software.amazon.awssdk.services.macie2.model.GetMasterAccountRequest;
import software.amazon.awssdk.services.macie2.model.GetMasterAccountResponse;
import software.amazon.awssdk.services.macie2.model.GetMemberRequest;
import software.amazon.awssdk.services.macie2.model.GetMemberResponse;
import software.amazon.awssdk.services.macie2.model.GetResourceProfileRequest;
import software.amazon.awssdk.services.macie2.model.GetResourceProfileResponse;
import software.amazon.awssdk.services.macie2.model.GetRevealConfigurationRequest;
import software.amazon.awssdk.services.macie2.model.GetRevealConfigurationResponse;
import software.amazon.awssdk.services.macie2.model.GetSensitiveDataOccurrencesAvailabilityRequest;
import software.amazon.awssdk.services.macie2.model.GetSensitiveDataOccurrencesAvailabilityResponse;
import software.amazon.awssdk.services.macie2.model.GetSensitiveDataOccurrencesRequest;
import software.amazon.awssdk.services.macie2.model.GetSensitiveDataOccurrencesResponse;
import software.amazon.awssdk.services.macie2.model.GetSensitivityInspectionTemplateRequest;
import software.amazon.awssdk.services.macie2.model.GetSensitivityInspectionTemplateResponse;
import software.amazon.awssdk.services.macie2.model.GetUsageStatisticsRequest;
import software.amazon.awssdk.services.macie2.model.GetUsageStatisticsResponse;
import software.amazon.awssdk.services.macie2.model.GetUsageTotalsRequest;
import software.amazon.awssdk.services.macie2.model.GetUsageTotalsResponse;
import software.amazon.awssdk.services.macie2.model.InternalServerException;
import software.amazon.awssdk.services.macie2.model.ListAllowListsRequest;
import software.amazon.awssdk.services.macie2.model.ListAllowListsResponse;
import software.amazon.awssdk.services.macie2.model.ListClassificationJobsRequest;
import software.amazon.awssdk.services.macie2.model.ListClassificationJobsResponse;
import software.amazon.awssdk.services.macie2.model.ListClassificationScopesRequest;
import software.amazon.awssdk.services.macie2.model.ListClassificationScopesResponse;
import software.amazon.awssdk.services.macie2.model.ListCustomDataIdentifiersRequest;
import software.amazon.awssdk.services.macie2.model.ListCustomDataIdentifiersResponse;
import software.amazon.awssdk.services.macie2.model.ListFindingsFiltersRequest;
import software.amazon.awssdk.services.macie2.model.ListFindingsFiltersResponse;
import software.amazon.awssdk.services.macie2.model.ListFindingsRequest;
import software.amazon.awssdk.services.macie2.model.ListFindingsResponse;
import software.amazon.awssdk.services.macie2.model.ListInvitationsRequest;
import software.amazon.awssdk.services.macie2.model.ListInvitationsResponse;
import software.amazon.awssdk.services.macie2.model.ListManagedDataIdentifiersRequest;
import software.amazon.awssdk.services.macie2.model.ListManagedDataIdentifiersResponse;
import software.amazon.awssdk.services.macie2.model.ListMembersRequest;
import software.amazon.awssdk.services.macie2.model.ListMembersResponse;
import software.amazon.awssdk.services.macie2.model.ListOrganizationAdminAccountsRequest;
import software.amazon.awssdk.services.macie2.model.ListOrganizationAdminAccountsResponse;
import software.amazon.awssdk.services.macie2.model.ListResourceProfileArtifactsRequest;
import software.amazon.awssdk.services.macie2.model.ListResourceProfileArtifactsResponse;
import software.amazon.awssdk.services.macie2.model.ListResourceProfileDetectionsRequest;
import software.amazon.awssdk.services.macie2.model.ListResourceProfileDetectionsResponse;
import software.amazon.awssdk.services.macie2.model.ListSensitivityInspectionTemplatesRequest;
import software.amazon.awssdk.services.macie2.model.ListSensitivityInspectionTemplatesResponse;
import software.amazon.awssdk.services.macie2.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.macie2.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.macie2.model.Macie2Exception;
import software.amazon.awssdk.services.macie2.model.Macie2Request;
import software.amazon.awssdk.services.macie2.model.PutClassificationExportConfigurationRequest;
import software.amazon.awssdk.services.macie2.model.PutClassificationExportConfigurationResponse;
import software.amazon.awssdk.services.macie2.model.PutFindingsPublicationConfigurationRequest;
import software.amazon.awssdk.services.macie2.model.PutFindingsPublicationConfigurationResponse;
import software.amazon.awssdk.services.macie2.model.ResourceNotFoundException;
import software.amazon.awssdk.services.macie2.model.SearchResourcesRequest;
import software.amazon.awssdk.services.macie2.model.SearchResourcesResponse;
import software.amazon.awssdk.services.macie2.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.macie2.model.TagResourceRequest;
import software.amazon.awssdk.services.macie2.model.TagResourceResponse;
import software.amazon.awssdk.services.macie2.model.TestCustomDataIdentifierRequest;
import software.amazon.awssdk.services.macie2.model.TestCustomDataIdentifierResponse;
import software.amazon.awssdk.services.macie2.model.ThrottlingException;
import software.amazon.awssdk.services.macie2.model.UnprocessableEntityException;
import software.amazon.awssdk.services.macie2.model.UntagResourceRequest;
import software.amazon.awssdk.services.macie2.model.UntagResourceResponse;
import software.amazon.awssdk.services.macie2.model.UpdateAllowListRequest;
import software.amazon.awssdk.services.macie2.model.UpdateAllowListResponse;
import software.amazon.awssdk.services.macie2.model.UpdateAutomatedDiscoveryConfigurationRequest;
import software.amazon.awssdk.services.macie2.model.UpdateAutomatedDiscoveryConfigurationResponse;
import software.amazon.awssdk.services.macie2.model.UpdateClassificationJobRequest;
import software.amazon.awssdk.services.macie2.model.UpdateClassificationJobResponse;
import software.amazon.awssdk.services.macie2.model.UpdateClassificationScopeRequest;
import software.amazon.awssdk.services.macie2.model.UpdateClassificationScopeResponse;
import software.amazon.awssdk.services.macie2.model.UpdateFindingsFilterRequest;
import software.amazon.awssdk.services.macie2.model.UpdateFindingsFilterResponse;
import software.amazon.awssdk.services.macie2.model.UpdateMacieSessionRequest;
import software.amazon.awssdk.services.macie2.model.UpdateMacieSessionResponse;
import software.amazon.awssdk.services.macie2.model.UpdateMemberSessionRequest;
import software.amazon.awssdk.services.macie2.model.UpdateMemberSessionResponse;
import software.amazon.awssdk.services.macie2.model.UpdateOrganizationConfigurationRequest;
import software.amazon.awssdk.services.macie2.model.UpdateOrganizationConfigurationResponse;
import software.amazon.awssdk.services.macie2.model.UpdateResourceProfileDetectionsRequest;
import software.amazon.awssdk.services.macie2.model.UpdateResourceProfileDetectionsResponse;
import software.amazon.awssdk.services.macie2.model.UpdateResourceProfileRequest;
import software.amazon.awssdk.services.macie2.model.UpdateResourceProfileResponse;
import software.amazon.awssdk.services.macie2.model.UpdateRevealConfigurationRequest;
import software.amazon.awssdk.services.macie2.model.UpdateRevealConfigurationResponse;
import software.amazon.awssdk.services.macie2.model.UpdateSensitivityInspectionTemplateRequest;
import software.amazon.awssdk.services.macie2.model.UpdateSensitivityInspectionTemplateResponse;
import software.amazon.awssdk.services.macie2.model.ValidationException;
import software.amazon.awssdk.services.macie2.paginators.DescribeBucketsPublisher;
import software.amazon.awssdk.services.macie2.paginators.GetUsageStatisticsPublisher;
import software.amazon.awssdk.services.macie2.paginators.ListAllowListsPublisher;
import software.amazon.awssdk.services.macie2.paginators.ListClassificationJobsPublisher;
import software.amazon.awssdk.services.macie2.paginators.ListClassificationScopesPublisher;
import software.amazon.awssdk.services.macie2.paginators.ListCustomDataIdentifiersPublisher;
import software.amazon.awssdk.services.macie2.paginators.ListFindingsFiltersPublisher;
import software.amazon.awssdk.services.macie2.paginators.ListFindingsPublisher;
import software.amazon.awssdk.services.macie2.paginators.ListInvitationsPublisher;
import software.amazon.awssdk.services.macie2.paginators.ListManagedDataIdentifiersPublisher;
import software.amazon.awssdk.services.macie2.paginators.ListMembersPublisher;
import software.amazon.awssdk.services.macie2.paginators.ListOrganizationAdminAccountsPublisher;
import software.amazon.awssdk.services.macie2.paginators.ListResourceProfileArtifactsPublisher;
import software.amazon.awssdk.services.macie2.paginators.ListResourceProfileDetectionsPublisher;
import software.amazon.awssdk.services.macie2.paginators.ListSensitivityInspectionTemplatesPublisher;
import software.amazon.awssdk.services.macie2.paginators.SearchResourcesPublisher;
import software.amazon.awssdk.services.macie2.transform.AcceptInvitationRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.BatchGetCustomDataIdentifiersRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.CreateAllowListRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.CreateClassificationJobRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.CreateCustomDataIdentifierRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.CreateFindingsFilterRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.CreateInvitationsRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.CreateMemberRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.CreateSampleFindingsRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.DeclineInvitationsRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.DeleteAllowListRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.DeleteCustomDataIdentifierRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.DeleteFindingsFilterRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.DeleteInvitationsRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.DeleteMemberRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.DescribeBucketsRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.DescribeClassificationJobRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.DescribeOrganizationConfigurationRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.DisableMacieRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.DisableOrganizationAdminAccountRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.DisassociateFromAdministratorAccountRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.DisassociateFromMasterAccountRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.DisassociateMemberRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.EnableMacieRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.EnableOrganizationAdminAccountRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.GetAdministratorAccountRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.GetAllowListRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.GetAutomatedDiscoveryConfigurationRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.GetBucketStatisticsRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.GetClassificationExportConfigurationRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.GetClassificationScopeRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.GetCustomDataIdentifierRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.GetFindingStatisticsRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.GetFindingsFilterRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.GetFindingsPublicationConfigurationRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.GetFindingsRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.GetInvitationsCountRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.GetMacieSessionRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.GetMasterAccountRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.GetMemberRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.GetResourceProfileRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.GetRevealConfigurationRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.GetSensitiveDataOccurrencesAvailabilityRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.GetSensitiveDataOccurrencesRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.GetSensitivityInspectionTemplateRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.GetUsageStatisticsRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.GetUsageTotalsRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.ListAllowListsRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.ListClassificationJobsRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.ListClassificationScopesRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.ListCustomDataIdentifiersRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.ListFindingsFiltersRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.ListFindingsRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.ListInvitationsRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.ListManagedDataIdentifiersRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.ListMembersRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.ListOrganizationAdminAccountsRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.ListResourceProfileArtifactsRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.ListResourceProfileDetectionsRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.ListSensitivityInspectionTemplatesRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.PutClassificationExportConfigurationRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.PutFindingsPublicationConfigurationRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.SearchResourcesRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.TestCustomDataIdentifierRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.UpdateAllowListRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.UpdateAutomatedDiscoveryConfigurationRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.UpdateClassificationJobRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.UpdateClassificationScopeRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.UpdateFindingsFilterRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.UpdateMacieSessionRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.UpdateMemberSessionRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.UpdateOrganizationConfigurationRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.UpdateResourceProfileDetectionsRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.UpdateResourceProfileRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.UpdateRevealConfigurationRequestMarshaller;
import software.amazon.awssdk.services.macie2.transform.UpdateSensitivityInspectionTemplateRequestMarshaller;
import software.amazon.awssdk.services.macie2.waiters.Macie2AsyncWaiter;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link Macie2AsyncClient}.
 *
 * @see Macie2AsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultMacie2AsyncClient implements Macie2AsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultMacie2AsyncClient.class);

    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    private final ScheduledExecutorService executorService;

    protected DefaultMacie2AsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
        this.executorService = clientConfiguration.option(SdkClientOption.SCHEDULED_EXECUTOR_SERVICE);
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    /**
     * <p>
     * Accepts an Amazon Macie membership invitation that was received from a specific account.
     * </p>
     *
     * @param acceptInvitationRequest
     * @return A Java Future containing the result of the AcceptInvitation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because the input doesn't satisfy the constraints specified by
     *         the service.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.AcceptInvitation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/AcceptInvitation" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<AcceptInvitationResponse> acceptInvitation(AcceptInvitationRequest acceptInvitationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, acceptInvitationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AcceptInvitation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AcceptInvitationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AcceptInvitationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AcceptInvitationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AcceptInvitationRequest, AcceptInvitationResponse>()
                            .withOperationName("AcceptInvitation")
                            .withMarshaller(new AcceptInvitationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(acceptInvitationRequest));
            CompletableFuture<AcceptInvitationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about one or more custom data identifiers.
     * </p>
     *
     * @param batchGetCustomDataIdentifiersRequest
     * @return A Java Future containing the result of the BatchGetCustomDataIdentifiers operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because the input doesn't satisfy the constraints specified by
     *         the service.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.BatchGetCustomDataIdentifiers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/BatchGetCustomDataIdentifiers"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchGetCustomDataIdentifiersResponse> batchGetCustomDataIdentifiers(
            BatchGetCustomDataIdentifiersRequest batchGetCustomDataIdentifiersRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                batchGetCustomDataIdentifiersRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchGetCustomDataIdentifiers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchGetCustomDataIdentifiersResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, BatchGetCustomDataIdentifiersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<BatchGetCustomDataIdentifiersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchGetCustomDataIdentifiersRequest, BatchGetCustomDataIdentifiersResponse>()
                            .withOperationName("BatchGetCustomDataIdentifiers")
                            .withMarshaller(new BatchGetCustomDataIdentifiersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(batchGetCustomDataIdentifiersRequest));
            CompletableFuture<BatchGetCustomDataIdentifiersResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates and defines the settings for an allow list.
     * </p>
     *
     * @param createAllowListRequest
     * @return A Java Future containing the result of the CreateAllowList operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because the input doesn't satisfy the constraints specified by
     *         the service.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.CreateAllowList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/CreateAllowList" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateAllowListResponse> createAllowList(CreateAllowListRequest createAllowListRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAllowListRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAllowList");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateAllowListResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateAllowListResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateAllowListResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateAllowListRequest, CreateAllowListResponse>()
                            .withOperationName("CreateAllowList")
                            .withMarshaller(new CreateAllowListRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createAllowListRequest));
            CompletableFuture<CreateAllowListResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates and defines the settings for a classification job.
     * </p>
     *
     * @param createClassificationJobRequest
     * @return A Java Future containing the result of the CreateClassificationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because the input doesn't satisfy the constraints specified by
     *         the service.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.CreateClassificationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/CreateClassificationJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateClassificationJobResponse> createClassificationJob(
            CreateClassificationJobRequest createClassificationJobRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createClassificationJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateClassificationJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateClassificationJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateClassificationJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateClassificationJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateClassificationJobRequest, CreateClassificationJobResponse>()
                            .withOperationName("CreateClassificationJob")
                            .withMarshaller(new CreateClassificationJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createClassificationJobRequest));
            CompletableFuture<CreateClassificationJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates and defines the criteria and other settings for a custom data identifier.
     * </p>
     *
     * @param createCustomDataIdentifierRequest
     * @return A Java Future containing the result of the CreateCustomDataIdentifier operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because the input doesn't satisfy the constraints specified by
     *         the service.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.CreateCustomDataIdentifier
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/CreateCustomDataIdentifier"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateCustomDataIdentifierResponse> createCustomDataIdentifier(
            CreateCustomDataIdentifierRequest createCustomDataIdentifierRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createCustomDataIdentifierRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCustomDataIdentifier");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateCustomDataIdentifierResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateCustomDataIdentifierResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateCustomDataIdentifierResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateCustomDataIdentifierRequest, CreateCustomDataIdentifierResponse>()
                            .withOperationName("CreateCustomDataIdentifier")
                            .withMarshaller(new CreateCustomDataIdentifierRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createCustomDataIdentifierRequest));
            CompletableFuture<CreateCustomDataIdentifierResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates and defines the criteria and other settings for a findings filter.
     * </p>
     *
     * @param createFindingsFilterRequest
     * @return A Java Future containing the result of the CreateFindingsFilter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because the input doesn't satisfy the constraints specified by
     *         the service.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.CreateFindingsFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/CreateFindingsFilter" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateFindingsFilterResponse> createFindingsFilter(
            CreateFindingsFilterRequest createFindingsFilterRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createFindingsFilterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateFindingsFilter");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateFindingsFilterResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateFindingsFilterResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateFindingsFilterResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateFindingsFilterRequest, CreateFindingsFilterResponse>()
                            .withOperationName("CreateFindingsFilter")
                            .withMarshaller(new CreateFindingsFilterRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createFindingsFilterRequest));
            CompletableFuture<CreateFindingsFilterResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Sends an Amazon Macie membership invitation to one or more accounts.
     * </p>
     *
     * @param createInvitationsRequest
     * @return A Java Future containing the result of the CreateInvitations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because the input doesn't satisfy the constraints specified by
     *         the service.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.CreateInvitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/CreateInvitations" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateInvitationsResponse> createInvitations(CreateInvitationsRequest createInvitationsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createInvitationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateInvitations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateInvitationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateInvitationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateInvitationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateInvitationsRequest, CreateInvitationsResponse>()
                            .withOperationName("CreateInvitations")
                            .withMarshaller(new CreateInvitationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createInvitationsRequest));
            CompletableFuture<CreateInvitationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Associates an account with an Amazon Macie administrator account.
     * </p>
     *
     * @param createMemberRequest
     * @return A Java Future containing the result of the CreateMember operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because the input doesn't satisfy the constraints specified by
     *         the service.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.CreateMember
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/CreateMember" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateMemberResponse> createMember(CreateMemberRequest createMemberRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createMemberRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateMember");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateMemberResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateMemberResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateMemberResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateMemberRequest, CreateMemberResponse>()
                            .withOperationName("CreateMember").withMarshaller(new CreateMemberRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createMemberRequest));
            CompletableFuture<CreateMemberResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates sample findings.
     * </p>
     *
     * @param createSampleFindingsRequest
     * @return A Java Future containing the result of the CreateSampleFindings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because the input doesn't satisfy the constraints specified by
     *         the service.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.CreateSampleFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/CreateSampleFindings" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateSampleFindingsResponse> createSampleFindings(
            CreateSampleFindingsRequest createSampleFindingsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createSampleFindingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateSampleFindings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateSampleFindingsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateSampleFindingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateSampleFindingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateSampleFindingsRequest, CreateSampleFindingsResponse>()
                            .withOperationName("CreateSampleFindings")
                            .withMarshaller(new CreateSampleFindingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createSampleFindingsRequest));
            CompletableFuture<CreateSampleFindingsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Declines Amazon Macie membership invitations that were received from specific accounts.
     * </p>
     *
     * @param declineInvitationsRequest
     * @return A Java Future containing the result of the DeclineInvitations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because the input doesn't satisfy the constraints specified by
     *         the service.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.DeclineInvitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/DeclineInvitations" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeclineInvitationsResponse> declineInvitations(DeclineInvitationsRequest declineInvitationsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, declineInvitationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeclineInvitations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeclineInvitationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeclineInvitationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeclineInvitationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeclineInvitationsRequest, DeclineInvitationsResponse>()
                            .withOperationName("DeclineInvitations")
                            .withMarshaller(new DeclineInvitationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(declineInvitationsRequest));
            CompletableFuture<DeclineInvitationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an allow list.
     * </p>
     *
     * @param deleteAllowListRequest
     * @return A Java Future containing the result of the DeleteAllowList operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ValidationException The request failed because the input doesn't satisfy the constraints specified by
     *         the service.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.DeleteAllowList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/DeleteAllowList" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteAllowListResponse> deleteAllowList(DeleteAllowListRequest deleteAllowListRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAllowListRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAllowList");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteAllowListResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteAllowListResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteAllowListResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteAllowListRequest, DeleteAllowListResponse>()
                            .withOperationName("DeleteAllowList")
                            .withMarshaller(new DeleteAllowListRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteAllowListRequest));
            CompletableFuture<DeleteAllowListResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Soft deletes a custom data identifier.
     * </p>
     *
     * @param deleteCustomDataIdentifierRequest
     * @return A Java Future containing the result of the DeleteCustomDataIdentifier operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because the input doesn't satisfy the constraints specified by
     *         the service.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.DeleteCustomDataIdentifier
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/DeleteCustomDataIdentifier"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteCustomDataIdentifierResponse> deleteCustomDataIdentifier(
            DeleteCustomDataIdentifierRequest deleteCustomDataIdentifierRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteCustomDataIdentifierRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCustomDataIdentifier");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteCustomDataIdentifierResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteCustomDataIdentifierResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteCustomDataIdentifierResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteCustomDataIdentifierRequest, DeleteCustomDataIdentifierResponse>()
                            .withOperationName("DeleteCustomDataIdentifier")
                            .withMarshaller(new DeleteCustomDataIdentifierRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteCustomDataIdentifierRequest));
            CompletableFuture<DeleteCustomDataIdentifierResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a findings filter.
     * </p>
     *
     * @param deleteFindingsFilterRequest
     * @return A Java Future containing the result of the DeleteFindingsFilter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because the input doesn't satisfy the constraints specified by
     *         the service.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.DeleteFindingsFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/DeleteFindingsFilter" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteFindingsFilterResponse> deleteFindingsFilter(
            DeleteFindingsFilterRequest deleteFindingsFilterRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteFindingsFilterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteFindingsFilter");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteFindingsFilterResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteFindingsFilterResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteFindingsFilterResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteFindingsFilterRequest, DeleteFindingsFilterResponse>()
                            .withOperationName("DeleteFindingsFilter")
                            .withMarshaller(new DeleteFindingsFilterRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteFindingsFilterRequest));
            CompletableFuture<DeleteFindingsFilterResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes Amazon Macie membership invitations that were received from specific accounts.
     * </p>
     *
     * @param deleteInvitationsRequest
     * @return A Java Future containing the result of the DeleteInvitations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because the input doesn't satisfy the constraints specified by
     *         the service.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.DeleteInvitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/DeleteInvitations" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteInvitationsResponse> deleteInvitations(DeleteInvitationsRequest deleteInvitationsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteInvitationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteInvitations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteInvitationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteInvitationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteInvitationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteInvitationsRequest, DeleteInvitationsResponse>()
                            .withOperationName("DeleteInvitations")
                            .withMarshaller(new DeleteInvitationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteInvitationsRequest));
            CompletableFuture<DeleteInvitationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the association between an Amazon Macie administrator account and an account.
     * </p>
     *
     * @param deleteMemberRequest
     * @return A Java Future containing the result of the DeleteMember operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because the input doesn't satisfy the constraints specified by
     *         the service.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.DeleteMember
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/DeleteMember" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteMemberResponse> deleteMember(DeleteMemberRequest deleteMemberRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteMemberRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteMember");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteMemberResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteMemberResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteMemberResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteMemberRequest, DeleteMemberResponse>()
                            .withOperationName("DeleteMember").withMarshaller(new DeleteMemberRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteMemberRequest));
            CompletableFuture<DeleteMemberResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves (queries) statistical data and other information about one or more S3 buckets that Amazon Macie
     * monitors and analyzes for an account.
     * </p>
     *
     * @param describeBucketsRequest
     * @return A Java Future containing the result of the DescribeBuckets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because the input doesn't satisfy the constraints specified by
     *         the service.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.DescribeBuckets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/DescribeBuckets" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeBucketsResponse> describeBuckets(DescribeBucketsRequest describeBucketsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeBucketsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeBuckets");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeBucketsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeBucketsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeBucketsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeBucketsRequest, DescribeBucketsResponse>()
                            .withOperationName("DescribeBuckets")
                            .withMarshaller(new DescribeBucketsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeBucketsRequest));
            CompletableFuture<DescribeBucketsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves (queries) statistical data and other information about one or more S3 buckets that Amazon Macie
     * monitors and analyzes for an account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeBuckets(software.amazon.awssdk.services.macie2.model.DescribeBucketsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.macie2.paginators.DescribeBucketsPublisher publisher = client.describeBucketsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.macie2.paginators.DescribeBucketsPublisher publisher = client.describeBucketsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.macie2.model.DescribeBucketsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.macie2.model.DescribeBucketsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeBuckets(software.amazon.awssdk.services.macie2.model.DescribeBucketsRequest)} operation.</b>
     * </p>
     *
     * @param describeBucketsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because the input doesn't satisfy the constraints specified by
     *         the service.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.DescribeBuckets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/DescribeBuckets" target="_top">AWS API
     *      Documentation</a>
     */
    public DescribeBucketsPublisher describeBucketsPaginator(DescribeBucketsRequest describeBucketsRequest) {
        return new DescribeBucketsPublisher(this, applyPaginatorUserAgent(describeBucketsRequest));
    }

    /**
     * <p>
     * Retrieves the status and settings for a classification job.
     * </p>
     *
     * @param describeClassificationJobRequest
     * @return A Java Future containing the result of the DescribeClassificationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because the input doesn't satisfy the constraints specified by
     *         the service.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.DescribeClassificationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/DescribeClassificationJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeClassificationJobResponse> describeClassificationJob(
            DescribeClassificationJobRequest describeClassificationJobRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeClassificationJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeClassificationJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeClassificationJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeClassificationJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeClassificationJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeClassificationJobRequest, DescribeClassificationJobResponse>()
                            .withOperationName("DescribeClassificationJob")
                            .withMarshaller(new DescribeClassificationJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeClassificationJobRequest));
            CompletableFuture<DescribeClassificationJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the Amazon Macie configuration settings for an organization in Organizations.
     * </p>
     *
     * @param describeOrganizationConfigurationRequest
     * @return A Java Future containing the result of the DescribeOrganizationConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because the input doesn't satisfy the constraints specified by
     *         the service.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.DescribeOrganizationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/DescribeOrganizationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeOrganizationConfigurationResponse> describeOrganizationConfiguration(
            DescribeOrganizationConfigurationRequest describeOrganizationConfigurationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeOrganizationConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeOrganizationConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeOrganizationConfigurationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeOrganizationConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeOrganizationConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeOrganizationConfigurationRequest, DescribeOrganizationConfigurationResponse>()
                            .withOperationName("DescribeOrganizationConfiguration")
                            .withMarshaller(new DescribeOrganizationConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeOrganizationConfigurationRequest));
            CompletableFuture<DescribeOrganizationConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disables Amazon Macie and deletes all settings and resources for a Macie account.
     * </p>
     *
     * @param disableMacieRequest
     * @return A Java Future containing the result of the DisableMacie operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because the input doesn't satisfy the constraints specified by
     *         the service.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.DisableMacie
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/DisableMacie" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DisableMacieResponse> disableMacie(DisableMacieRequest disableMacieRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disableMacieRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisableMacie");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisableMacieResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DisableMacieResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DisableMacieResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisableMacieRequest, DisableMacieResponse>()
                            .withOperationName("DisableMacie").withMarshaller(new DisableMacieRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(disableMacieRequest));
            CompletableFuture<DisableMacieResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disables an account as the delegated Amazon Macie administrator account for an organization in Organizations.
     * </p>
     *
     * @param disableOrganizationAdminAccountRequest
     * @return A Java Future containing the result of the DisableOrganizationAdminAccount operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because the input doesn't satisfy the constraints specified by
     *         the service.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.DisableOrganizationAdminAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/DisableOrganizationAdminAccount"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DisableOrganizationAdminAccountResponse> disableOrganizationAdminAccount(
            DisableOrganizationAdminAccountRequest disableOrganizationAdminAccountRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                disableOrganizationAdminAccountRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisableOrganizationAdminAccount");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisableOrganizationAdminAccountResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DisableOrganizationAdminAccountResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DisableOrganizationAdminAccountResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisableOrganizationAdminAccountRequest, DisableOrganizationAdminAccountResponse>()
                            .withOperationName("DisableOrganizationAdminAccount")
                            .withMarshaller(new DisableOrganizationAdminAccountRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(disableOrganizationAdminAccountRequest));
            CompletableFuture<DisableOrganizationAdminAccountResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disassociates a member account from its Amazon Macie administrator account.
     * </p>
     *
     * @param disassociateFromAdministratorAccountRequest
     * @return A Java Future containing the result of the DisassociateFromAdministratorAccount operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because the input doesn't satisfy the constraints specified by
     *         the service.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.DisassociateFromAdministratorAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/DisassociateFromAdministratorAccount"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DisassociateFromAdministratorAccountResponse> disassociateFromAdministratorAccount(
            DisassociateFromAdministratorAccountRequest disassociateFromAdministratorAccountRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                disassociateFromAdministratorAccountRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateFromAdministratorAccount");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisassociateFromAdministratorAccountResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DisassociateFromAdministratorAccountResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DisassociateFromAdministratorAccountResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisassociateFromAdministratorAccountRequest, DisassociateFromAdministratorAccountResponse>()
                            .withOperationName("DisassociateFromAdministratorAccount")
                            .withMarshaller(new DisassociateFromAdministratorAccountRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(disassociateFromAdministratorAccountRequest));
            CompletableFuture<DisassociateFromAdministratorAccountResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * (Deprecated) Disassociates a member account from its Amazon Macie administrator account. This operation has been
     * replaced by the <link linkend="DisassociateFromAdministratorAccount">DisassociateFromAdministratorAccount</link>
     * operation.
     * </p>
     *
     * @param disassociateFromMasterAccountRequest
     * @return A Java Future containing the result of the DisassociateFromMasterAccount operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because the input doesn't satisfy the constraints specified by
     *         the service.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.DisassociateFromMasterAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/DisassociateFromMasterAccount"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DisassociateFromMasterAccountResponse> disassociateFromMasterAccount(
            DisassociateFromMasterAccountRequest disassociateFromMasterAccountRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                disassociateFromMasterAccountRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateFromMasterAccount");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisassociateFromMasterAccountResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DisassociateFromMasterAccountResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DisassociateFromMasterAccountResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisassociateFromMasterAccountRequest, DisassociateFromMasterAccountResponse>()
                            .withOperationName("DisassociateFromMasterAccount")
                            .withMarshaller(new DisassociateFromMasterAccountRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(disassociateFromMasterAccountRequest));
            CompletableFuture<DisassociateFromMasterAccountResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disassociates an Amazon Macie administrator account from a member account.
     * </p>
     *
     * @param disassociateMemberRequest
     * @return A Java Future containing the result of the DisassociateMember operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because the input doesn't satisfy the constraints specified by
     *         the service.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.DisassociateMember
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/DisassociateMember" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DisassociateMemberResponse> disassociateMember(DisassociateMemberRequest disassociateMemberRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disassociateMemberRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateMember");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisassociateMemberResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DisassociateMemberResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DisassociateMemberResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisassociateMemberRequest, DisassociateMemberResponse>()
                            .withOperationName("DisassociateMember")
                            .withMarshaller(new DisassociateMemberRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(disassociateMemberRequest));
            CompletableFuture<DisassociateMemberResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Enables Amazon Macie and specifies the configuration settings for a Macie account.
     * </p>
     *
     * @param enableMacieRequest
     * @return A Java Future containing the result of the EnableMacie operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because the input doesn't satisfy the constraints specified by
     *         the service.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.EnableMacie
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/EnableMacie" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<EnableMacieResponse> enableMacie(EnableMacieRequest enableMacieRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, enableMacieRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "EnableMacie");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<EnableMacieResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    EnableMacieResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<EnableMacieResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<EnableMacieRequest, EnableMacieResponse>()
                            .withOperationName("EnableMacie").withMarshaller(new EnableMacieRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(enableMacieRequest));
            CompletableFuture<EnableMacieResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Designates an account as the delegated Amazon Macie administrator account for an organization in Organizations.
     * </p>
     *
     * @param enableOrganizationAdminAccountRequest
     * @return A Java Future containing the result of the EnableOrganizationAdminAccount operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because the input doesn't satisfy the constraints specified by
     *         the service.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.EnableOrganizationAdminAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/EnableOrganizationAdminAccount"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<EnableOrganizationAdminAccountResponse> enableOrganizationAdminAccount(
            EnableOrganizationAdminAccountRequest enableOrganizationAdminAccountRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                enableOrganizationAdminAccountRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "EnableOrganizationAdminAccount");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<EnableOrganizationAdminAccountResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, EnableOrganizationAdminAccountResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<EnableOrganizationAdminAccountResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<EnableOrganizationAdminAccountRequest, EnableOrganizationAdminAccountResponse>()
                            .withOperationName("EnableOrganizationAdminAccount")
                            .withMarshaller(new EnableOrganizationAdminAccountRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(enableOrganizationAdminAccountRequest));
            CompletableFuture<EnableOrganizationAdminAccountResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the Amazon Macie administrator account for an account.
     * </p>
     *
     * @param getAdministratorAccountRequest
     * @return A Java Future containing the result of the GetAdministratorAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because the input doesn't satisfy the constraints specified by
     *         the service.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.GetAdministratorAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetAdministratorAccount"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetAdministratorAccountResponse> getAdministratorAccount(
            GetAdministratorAccountRequest getAdministratorAccountRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAdministratorAccountRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAdministratorAccount");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetAdministratorAccountResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetAdministratorAccountResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetAdministratorAccountResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetAdministratorAccountRequest, GetAdministratorAccountResponse>()
                            .withOperationName("GetAdministratorAccount")
                            .withMarshaller(new GetAdministratorAccountRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getAdministratorAccountRequest));
            CompletableFuture<GetAdministratorAccountResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the settings and status of an allow list.
     * </p>
     *
     * @param getAllowListRequest
     * @return A Java Future containing the result of the GetAllowList operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ValidationException The request failed because the input doesn't satisfy the constraints specified by
     *         the service.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.GetAllowList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetAllowList" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetAllowListResponse> getAllowList(GetAllowListRequest getAllowListRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAllowListRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAllowList");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetAllowListResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetAllowListResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetAllowListResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetAllowListRequest, GetAllowListResponse>()
                            .withOperationName("GetAllowList").withMarshaller(new GetAllowListRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getAllowListRequest));
            CompletableFuture<GetAllowListResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the configuration settings and status of automated sensitive data discovery for an account.
     * </p>
     *
     * @param getAutomatedDiscoveryConfigurationRequest
     * @return A Java Future containing the result of the GetAutomatedDiscoveryConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ValidationException The request failed because the input doesn't satisfy the constraints specified by
     *         the service.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.GetAutomatedDiscoveryConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetAutomatedDiscoveryConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetAutomatedDiscoveryConfigurationResponse> getAutomatedDiscoveryConfiguration(
            GetAutomatedDiscoveryConfigurationRequest getAutomatedDiscoveryConfigurationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getAutomatedDiscoveryConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAutomatedDiscoveryConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetAutomatedDiscoveryConfigurationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, GetAutomatedDiscoveryConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetAutomatedDiscoveryConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetAutomatedDiscoveryConfigurationRequest, GetAutomatedDiscoveryConfigurationResponse>()
                            .withOperationName("GetAutomatedDiscoveryConfiguration")
                            .withMarshaller(new GetAutomatedDiscoveryConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getAutomatedDiscoveryConfigurationRequest));
            CompletableFuture<GetAutomatedDiscoveryConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves (queries) aggregated statistical data about all the S3 buckets that Amazon Macie monitors and analyzes
     * for an account.
     * </p>
     *
     * @param getBucketStatisticsRequest
     * @return A Java Future containing the result of the GetBucketStatistics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because the input doesn't satisfy the constraints specified by
     *         the service.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.GetBucketStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetBucketStatistics" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetBucketStatisticsResponse> getBucketStatistics(
            GetBucketStatisticsRequest getBucketStatisticsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getBucketStatisticsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetBucketStatistics");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetBucketStatisticsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetBucketStatisticsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetBucketStatisticsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetBucketStatisticsRequest, GetBucketStatisticsResponse>()
                            .withOperationName("GetBucketStatistics")
                            .withMarshaller(new GetBucketStatisticsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getBucketStatisticsRequest));
            CompletableFuture<GetBucketStatisticsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the configuration settings for storing data classification results.
     * </p>
     *
     * @param getClassificationExportConfigurationRequest
     * @return A Java Future containing the result of the GetClassificationExportConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because the input doesn't satisfy the constraints specified by
     *         the service.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.GetClassificationExportConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetClassificationExportConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetClassificationExportConfigurationResponse> getClassificationExportConfiguration(
            GetClassificationExportConfigurationRequest getClassificationExportConfigurationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getClassificationExportConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetClassificationExportConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetClassificationExportConfigurationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, GetClassificationExportConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetClassificationExportConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetClassificationExportConfigurationRequest, GetClassificationExportConfigurationResponse>()
                            .withOperationName("GetClassificationExportConfiguration")
                            .withMarshaller(new GetClassificationExportConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getClassificationExportConfigurationRequest));
            CompletableFuture<GetClassificationExportConfigurationResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the classification scope settings for an account.
     * </p>
     *
     * @param getClassificationScopeRequest
     * @return A Java Future containing the result of the GetClassificationScope operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ValidationException The request failed because the input doesn't satisfy the constraints specified by
     *         the service.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.GetClassificationScope
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetClassificationScope" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetClassificationScopeResponse> getClassificationScope(
            GetClassificationScopeRequest getClassificationScopeRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getClassificationScopeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetClassificationScope");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetClassificationScopeResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetClassificationScopeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetClassificationScopeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetClassificationScopeRequest, GetClassificationScopeResponse>()
                            .withOperationName("GetClassificationScope")
                            .withMarshaller(new GetClassificationScopeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getClassificationScopeRequest));
            CompletableFuture<GetClassificationScopeResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the criteria and other settings for a custom data identifier.
     * </p>
     *
     * @param getCustomDataIdentifierRequest
     * @return A Java Future containing the result of the GetCustomDataIdentifier operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because the input doesn't satisfy the constraints specified by
     *         the service.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.GetCustomDataIdentifier
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetCustomDataIdentifier"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetCustomDataIdentifierResponse> getCustomDataIdentifier(
            GetCustomDataIdentifierRequest getCustomDataIdentifierRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getCustomDataIdentifierRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCustomDataIdentifier");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetCustomDataIdentifierResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetCustomDataIdentifierResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetCustomDataIdentifierResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetCustomDataIdentifierRequest, GetCustomDataIdentifierResponse>()
                            .withOperationName("GetCustomDataIdentifier")
                            .withMarshaller(new GetCustomDataIdentifierRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getCustomDataIdentifierRequest));
            CompletableFuture<GetCustomDataIdentifierResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves (queries) aggregated statistical data about findings.
     * </p>
     *
     * @param getFindingStatisticsRequest
     * @return A Java Future containing the result of the GetFindingStatistics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because the input doesn't satisfy the constraints specified by
     *         the service.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.GetFindingStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetFindingStatistics" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetFindingStatisticsResponse> getFindingStatistics(
            GetFindingStatisticsRequest getFindingStatisticsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getFindingStatisticsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetFindingStatistics");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetFindingStatisticsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetFindingStatisticsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetFindingStatisticsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetFindingStatisticsRequest, GetFindingStatisticsResponse>()
                            .withOperationName("GetFindingStatistics")
                            .withMarshaller(new GetFindingStatisticsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getFindingStatisticsRequest));
            CompletableFuture<GetFindingStatisticsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the details of one or more findings.
     * </p>
     *
     * @param getFindingsRequest
     * @return A Java Future containing the result of the GetFindings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because the input doesn't satisfy the constraints specified by
     *         the service.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.GetFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetFindings" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetFindingsResponse> getFindings(GetFindingsRequest getFindingsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getFindingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetFindings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetFindingsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetFindingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetFindingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetFindingsRequest, GetFindingsResponse>()
                            .withOperationName("GetFindings").withMarshaller(new GetFindingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getFindingsRequest));
            CompletableFuture<GetFindingsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the criteria and other settings for a findings filter.
     * </p>
     *
     * @param getFindingsFilterRequest
     * @return A Java Future containing the result of the GetFindingsFilter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because the input doesn't satisfy the constraints specified by
     *         the service.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.GetFindingsFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetFindingsFilter" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetFindingsFilterResponse> getFindingsFilter(GetFindingsFilterRequest getFindingsFilterRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getFindingsFilterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetFindingsFilter");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetFindingsFilterResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetFindingsFilterResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetFindingsFilterResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetFindingsFilterRequest, GetFindingsFilterResponse>()
                            .withOperationName("GetFindingsFilter")
                            .withMarshaller(new GetFindingsFilterRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getFindingsFilterRequest));
            CompletableFuture<GetFindingsFilterResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the configuration settings for publishing findings to Security Hub.
     * </p>
     *
     * @param getFindingsPublicationConfigurationRequest
     * @return A Java Future containing the result of the GetFindingsPublicationConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because the input doesn't satisfy the constraints specified by
     *         the service.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.GetFindingsPublicationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetFindingsPublicationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetFindingsPublicationConfigurationResponse> getFindingsPublicationConfiguration(
            GetFindingsPublicationConfigurationRequest getFindingsPublicationConfigurationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getFindingsPublicationConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetFindingsPublicationConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetFindingsPublicationConfigurationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, GetFindingsPublicationConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetFindingsPublicationConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetFindingsPublicationConfigurationRequest, GetFindingsPublicationConfigurationResponse>()
                            .withOperationName("GetFindingsPublicationConfiguration")
                            .withMarshaller(new GetFindingsPublicationConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getFindingsPublicationConfigurationRequest));
            CompletableFuture<GetFindingsPublicationConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the count of Amazon Macie membership invitations that were received by an account.
     * </p>
     *
     * @param getInvitationsCountRequest
     * @return A Java Future containing the result of the GetInvitationsCount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because the input doesn't satisfy the constraints specified by
     *         the service.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.GetInvitationsCount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetInvitationsCount" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetInvitationsCountResponse> getInvitationsCount(
            GetInvitationsCountRequest getInvitationsCountRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getInvitationsCountRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetInvitationsCount");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetInvitationsCountResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetInvitationsCountResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetInvitationsCountResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetInvitationsCountRequest, GetInvitationsCountResponse>()
                            .withOperationName("GetInvitationsCount")
                            .withMarshaller(new GetInvitationsCountRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getInvitationsCountRequest));
            CompletableFuture<GetInvitationsCountResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the status and configuration settings for an Amazon Macie account.
     * </p>
     *
     * @param getMacieSessionRequest
     * @return A Java Future containing the result of the GetMacieSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because the input doesn't satisfy the constraints specified by
     *         the service.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.GetMacieSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetMacieSession" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetMacieSessionResponse> getMacieSession(GetMacieSessionRequest getMacieSessionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getMacieSessionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetMacieSession");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetMacieSessionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetMacieSessionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetMacieSessionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetMacieSessionRequest, GetMacieSessionResponse>()
                            .withOperationName("GetMacieSession")
                            .withMarshaller(new GetMacieSessionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getMacieSessionRequest));
            CompletableFuture<GetMacieSessionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * (Deprecated) Retrieves information about the Amazon Macie administrator account for an account. This operation
     * has been replaced by the <link linkend="GetAdministratorAccount">GetAdministratorAccount</link> operation.
     * </p>
     *
     * @param getMasterAccountRequest
     * @return A Java Future containing the result of the GetMasterAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because the input doesn't satisfy the constraints specified by
     *         the service.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.GetMasterAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetMasterAccount" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetMasterAccountResponse> getMasterAccount(GetMasterAccountRequest getMasterAccountRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getMasterAccountRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetMasterAccount");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetMasterAccountResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetMasterAccountResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetMasterAccountResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetMasterAccountRequest, GetMasterAccountResponse>()
                            .withOperationName("GetMasterAccount")
                            .withMarshaller(new GetMasterAccountRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getMasterAccountRequest));
            CompletableFuture<GetMasterAccountResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about an account that's associated with an Amazon Macie administrator account.
     * </p>
     *
     * @param getMemberRequest
     * @return A Java Future containing the result of the GetMember operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because the input doesn't satisfy the constraints specified by
     *         the service.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.GetMember
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetMember" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetMemberResponse> getMember(GetMemberRequest getMemberRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getMemberRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetMember");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetMemberResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetMemberResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetMemberResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetMemberRequest, GetMemberResponse>().withOperationName("GetMember")
                            .withMarshaller(new GetMemberRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(getMemberRequest));
            CompletableFuture<GetMemberResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves (queries) sensitive data discovery statistics and the sensitivity score for an S3 bucket.
     * </p>
     *
     * @param getResourceProfileRequest
     * @return A Java Future containing the result of the GetResourceProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because the input doesn't satisfy the constraints specified by
     *         the service.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.GetResourceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetResourceProfile" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetResourceProfileResponse> getResourceProfile(GetResourceProfileRequest getResourceProfileRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getResourceProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetResourceProfile");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetResourceProfileResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetResourceProfileResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetResourceProfileResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetResourceProfileRequest, GetResourceProfileResponse>()
                            .withOperationName("GetResourceProfile")
                            .withMarshaller(new GetResourceProfileRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getResourceProfileRequest));
            CompletableFuture<GetResourceProfileResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the status and configuration settings for retrieving occurrences of sensitive data reported by
     * findings.
     * </p>
     *
     * @param getRevealConfigurationRequest
     * @return A Java Future containing the result of the GetRevealConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ValidationException The request failed because the input doesn't satisfy the constraints specified by
     *         the service.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.GetRevealConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetRevealConfiguration" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetRevealConfigurationResponse> getRevealConfiguration(
            GetRevealConfigurationRequest getRevealConfigurationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getRevealConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRevealConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetRevealConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetRevealConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetRevealConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetRevealConfigurationRequest, GetRevealConfigurationResponse>()
                            .withOperationName("GetRevealConfiguration")
                            .withMarshaller(new GetRevealConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getRevealConfigurationRequest));
            CompletableFuture<GetRevealConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves occurrences of sensitive data reported by a finding.
     * </p>
     *
     * @param getSensitiveDataOccurrencesRequest
     * @return A Java Future containing the result of the GetSensitiveDataOccurrences operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnprocessableEntityException The request failed because it contains instructions that Amazon Macie
     *         can't process (Unprocessable Entity).</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.GetSensitiveDataOccurrences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetSensitiveDataOccurrences"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetSensitiveDataOccurrencesResponse> getSensitiveDataOccurrences(
            GetSensitiveDataOccurrencesRequest getSensitiveDataOccurrencesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSensitiveDataOccurrencesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSensitiveDataOccurrences");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetSensitiveDataOccurrencesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetSensitiveDataOccurrencesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetSensitiveDataOccurrencesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetSensitiveDataOccurrencesRequest, GetSensitiveDataOccurrencesResponse>()
                            .withOperationName("GetSensitiveDataOccurrences")
                            .withMarshaller(new GetSensitiveDataOccurrencesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getSensitiveDataOccurrencesRequest));
            CompletableFuture<GetSensitiveDataOccurrencesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Checks whether occurrences of sensitive data can be retrieved for a finding.
     * </p>
     *
     * @param getSensitiveDataOccurrencesAvailabilityRequest
     * @return A Java Future containing the result of the GetSensitiveDataOccurrencesAvailability operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.GetSensitiveDataOccurrencesAvailability
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetSensitiveDataOccurrencesAvailability"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetSensitiveDataOccurrencesAvailabilityResponse> getSensitiveDataOccurrencesAvailability(
            GetSensitiveDataOccurrencesAvailabilityRequest getSensitiveDataOccurrencesAvailabilityRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getSensitiveDataOccurrencesAvailabilityRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSensitiveDataOccurrencesAvailability");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetSensitiveDataOccurrencesAvailabilityResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, GetSensitiveDataOccurrencesAvailabilityResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetSensitiveDataOccurrencesAvailabilityResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetSensitiveDataOccurrencesAvailabilityRequest, GetSensitiveDataOccurrencesAvailabilityResponse>()
                            .withOperationName("GetSensitiveDataOccurrencesAvailability")
                            .withMarshaller(new GetSensitiveDataOccurrencesAvailabilityRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .withInput(getSensitiveDataOccurrencesAvailabilityRequest));
            CompletableFuture<GetSensitiveDataOccurrencesAvailabilityResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the settings for the sensitivity inspection template for an account.
     * </p>
     *
     * @param getSensitivityInspectionTemplateRequest
     * @return A Java Future containing the result of the GetSensitivityInspectionTemplate operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ValidationException The request failed because the input doesn't satisfy the constraints specified by
     *         the service.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.GetSensitivityInspectionTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetSensitivityInspectionTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetSensitivityInspectionTemplateResponse> getSensitivityInspectionTemplate(
            GetSensitivityInspectionTemplateRequest getSensitivityInspectionTemplateRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getSensitivityInspectionTemplateRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSensitivityInspectionTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetSensitivityInspectionTemplateResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, GetSensitivityInspectionTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetSensitivityInspectionTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetSensitivityInspectionTemplateRequest, GetSensitivityInspectionTemplateResponse>()
                            .withOperationName("GetSensitivityInspectionTemplate")
                            .withMarshaller(new GetSensitivityInspectionTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getSensitivityInspectionTemplateRequest));
            CompletableFuture<GetSensitivityInspectionTemplateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves (queries) quotas and aggregated usage data for one or more accounts.
     * </p>
     *
     * @param getUsageStatisticsRequest
     * @return A Java Future containing the result of the GetUsageStatistics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because the input doesn't satisfy the constraints specified by
     *         the service.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.GetUsageStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetUsageStatistics" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetUsageStatisticsResponse> getUsageStatistics(GetUsageStatisticsRequest getUsageStatisticsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getUsageStatisticsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetUsageStatistics");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetUsageStatisticsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetUsageStatisticsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetUsageStatisticsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetUsageStatisticsRequest, GetUsageStatisticsResponse>()
                            .withOperationName("GetUsageStatistics")
                            .withMarshaller(new GetUsageStatisticsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getUsageStatisticsRequest));
            CompletableFuture<GetUsageStatisticsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves (queries) quotas and aggregated usage data for one or more accounts.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getUsageStatistics(software.amazon.awssdk.services.macie2.model.GetUsageStatisticsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.macie2.paginators.GetUsageStatisticsPublisher publisher = client.getUsageStatisticsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.macie2.paginators.GetUsageStatisticsPublisher publisher = client.getUsageStatisticsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.macie2.model.GetUsageStatisticsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.macie2.model.GetUsageStatisticsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getUsageStatistics(software.amazon.awssdk.services.macie2.model.GetUsageStatisticsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getUsageStatisticsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because the input doesn't satisfy the constraints specified by
     *         the service.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.GetUsageStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetUsageStatistics" target="_top">AWS API
     *      Documentation</a>
     */
    public GetUsageStatisticsPublisher getUsageStatisticsPaginator(GetUsageStatisticsRequest getUsageStatisticsRequest) {
        return new GetUsageStatisticsPublisher(this, applyPaginatorUserAgent(getUsageStatisticsRequest));
    }

    /**
     * <p>
     * Retrieves (queries) aggregated usage data for an account.
     * </p>
     *
     * @param getUsageTotalsRequest
     * @return A Java Future containing the result of the GetUsageTotals operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because the input doesn't satisfy the constraints specified by
     *         the service.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.GetUsageTotals
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetUsageTotals" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetUsageTotalsResponse> getUsageTotals(GetUsageTotalsRequest getUsageTotalsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getUsageTotalsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetUsageTotals");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetUsageTotalsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetUsageTotalsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetUsageTotalsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetUsageTotalsRequest, GetUsageTotalsResponse>()
                            .withOperationName("GetUsageTotals")
                            .withMarshaller(new GetUsageTotalsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getUsageTotalsRequest));
            CompletableFuture<GetUsageTotalsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves a subset of information about all the allow lists for an account.
     * </p>
     *
     * @param listAllowListsRequest
     * @return A Java Future containing the result of the ListAllowLists operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ValidationException The request failed because the input doesn't satisfy the constraints specified by
     *         the service.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.ListAllowLists
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/ListAllowLists" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListAllowListsResponse> listAllowLists(ListAllowListsRequest listAllowListsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAllowListsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAllowLists");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListAllowListsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListAllowListsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListAllowListsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListAllowListsRequest, ListAllowListsResponse>()
                            .withOperationName("ListAllowLists")
                            .withMarshaller(new ListAllowListsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listAllowListsRequest));
            CompletableFuture<ListAllowListsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves a subset of information about all the allow lists for an account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listAllowLists(software.amazon.awssdk.services.macie2.model.ListAllowListsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.macie2.paginators.ListAllowListsPublisher publisher = client.listAllowListsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.macie2.paginators.ListAllowListsPublisher publisher = client.listAllowListsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.macie2.model.ListAllowListsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.macie2.model.ListAllowListsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAllowLists(software.amazon.awssdk.services.macie2.model.ListAllowListsRequest)} operation.</b>
     * </p>
     *
     * @param listAllowListsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ValidationException The request failed because the input doesn't satisfy the constraints specified by
     *         the service.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.ListAllowLists
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/ListAllowLists" target="_top">AWS API
     *      Documentation</a>
     */
    public ListAllowListsPublisher listAllowListsPaginator(ListAllowListsRequest listAllowListsRequest) {
        return new ListAllowListsPublisher(this, applyPaginatorUserAgent(listAllowListsRequest));
    }

    /**
     * <p>
     * Retrieves a subset of information about one or more classification jobs.
     * </p>
     *
     * @param listClassificationJobsRequest
     * @return A Java Future containing the result of the ListClassificationJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because the input doesn't satisfy the constraints specified by
     *         the service.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.ListClassificationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/ListClassificationJobs" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListClassificationJobsResponse> listClassificationJobs(
            ListClassificationJobsRequest listClassificationJobsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listClassificationJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListClassificationJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListClassificationJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListClassificationJobsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListClassificationJobsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListClassificationJobsRequest, ListClassificationJobsResponse>()
                            .withOperationName("ListClassificationJobs")
                            .withMarshaller(new ListClassificationJobsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listClassificationJobsRequest));
            CompletableFuture<ListClassificationJobsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves a subset of information about one or more classification jobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listClassificationJobs(software.amazon.awssdk.services.macie2.model.ListClassificationJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.macie2.paginators.ListClassificationJobsPublisher publisher = client.listClassificationJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.macie2.paginators.ListClassificationJobsPublisher publisher = client.listClassificationJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.macie2.model.ListClassificationJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.macie2.model.ListClassificationJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listClassificationJobs(software.amazon.awssdk.services.macie2.model.ListClassificationJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listClassificationJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because the input doesn't satisfy the constraints specified by
     *         the service.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.ListClassificationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/ListClassificationJobs" target="_top">AWS
     *      API Documentation</a>
     */
    public ListClassificationJobsPublisher listClassificationJobsPaginator(
            ListClassificationJobsRequest listClassificationJobsRequest) {
        return new ListClassificationJobsPublisher(this, applyPaginatorUserAgent(listClassificationJobsRequest));
    }

    /**
     * <p>
     * Retrieves a subset of information about the classification scope for an account.
     * </p>
     *
     * @param listClassificationScopesRequest
     * @return A Java Future containing the result of the ListClassificationScopes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ValidationException The request failed because the input doesn't satisfy the constraints specified by
     *         the service.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.ListClassificationScopes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/ListClassificationScopes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListClassificationScopesResponse> listClassificationScopes(
            ListClassificationScopesRequest listClassificationScopesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listClassificationScopesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListClassificationScopes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListClassificationScopesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListClassificationScopesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListClassificationScopesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListClassificationScopesRequest, ListClassificationScopesResponse>()
                            .withOperationName("ListClassificationScopes")
                            .withMarshaller(new ListClassificationScopesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listClassificationScopesRequest));
            CompletableFuture<ListClassificationScopesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves a subset of information about the classification scope for an account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listClassificationScopes(software.amazon.awssdk.services.macie2.model.ListClassificationScopesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.macie2.paginators.ListClassificationScopesPublisher publisher = client.listClassificationScopesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.macie2.paginators.ListClassificationScopesPublisher publisher = client.listClassificationScopesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.macie2.model.ListClassificationScopesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.macie2.model.ListClassificationScopesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listClassificationScopes(software.amazon.awssdk.services.macie2.model.ListClassificationScopesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listClassificationScopesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ValidationException The request failed because the input doesn't satisfy the constraints specified by
     *         the service.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.ListClassificationScopes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/ListClassificationScopes"
     *      target="_top">AWS API Documentation</a>
     */
    public ListClassificationScopesPublisher listClassificationScopesPaginator(
            ListClassificationScopesRequest listClassificationScopesRequest) {
        return new ListClassificationScopesPublisher(this, applyPaginatorUserAgent(listClassificationScopesRequest));
    }

    /**
     * <p>
     * Retrieves a subset of information about all the custom data identifiers for an account.
     * </p>
     *
     * @param listCustomDataIdentifiersRequest
     * @return A Java Future containing the result of the ListCustomDataIdentifiers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because the input doesn't satisfy the constraints specified by
     *         the service.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.ListCustomDataIdentifiers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/ListCustomDataIdentifiers"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListCustomDataIdentifiersResponse> listCustomDataIdentifiers(
            ListCustomDataIdentifiersRequest listCustomDataIdentifiersRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listCustomDataIdentifiersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCustomDataIdentifiers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListCustomDataIdentifiersResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListCustomDataIdentifiersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListCustomDataIdentifiersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListCustomDataIdentifiersRequest, ListCustomDataIdentifiersResponse>()
                            .withOperationName("ListCustomDataIdentifiers")
                            .withMarshaller(new ListCustomDataIdentifiersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listCustomDataIdentifiersRequest));
            CompletableFuture<ListCustomDataIdentifiersResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves a subset of information about all the custom data identifiers for an account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCustomDataIdentifiers(software.amazon.awssdk.services.macie2.model.ListCustomDataIdentifiersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.macie2.paginators.ListCustomDataIdentifiersPublisher publisher = client.listCustomDataIdentifiersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.macie2.paginators.ListCustomDataIdentifiersPublisher publisher = client.listCustomDataIdentifiersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.macie2.model.ListCustomDataIdentifiersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.macie2.model.ListCustomDataIdentifiersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCustomDataIdentifiers(software.amazon.awssdk.services.macie2.model.ListCustomDataIdentifiersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCustomDataIdentifiersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because the input doesn't satisfy the constraints specified by
     *         the service.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.ListCustomDataIdentifiers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/ListCustomDataIdentifiers"
     *      target="_top">AWS API Documentation</a>
     */
    public ListCustomDataIdentifiersPublisher listCustomDataIdentifiersPaginator(
            ListCustomDataIdentifiersRequest listCustomDataIdentifiersRequest) {
        return new ListCustomDataIdentifiersPublisher(this, applyPaginatorUserAgent(listCustomDataIdentifiersRequest));
    }

    /**
     * <p>
     * Retrieves a subset of information about one or more findings.
     * </p>
     *
     * @param listFindingsRequest
     * @return A Java Future containing the result of the ListFindings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because the input doesn't satisfy the constraints specified by
     *         the service.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.ListFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/ListFindings" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListFindingsResponse> listFindings(ListFindingsRequest listFindingsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listFindingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListFindings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListFindingsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListFindingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListFindingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListFindingsRequest, ListFindingsResponse>()
                            .withOperationName("ListFindings").withMarshaller(new ListFindingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listFindingsRequest));
            CompletableFuture<ListFindingsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves a subset of information about all the findings filters for an account.
     * </p>
     *
     * @param listFindingsFiltersRequest
     * @return A Java Future containing the result of the ListFindingsFilters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because the input doesn't satisfy the constraints specified by
     *         the service.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.ListFindingsFilters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/ListFindingsFilters" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListFindingsFiltersResponse> listFindingsFilters(
            ListFindingsFiltersRequest listFindingsFiltersRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listFindingsFiltersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListFindingsFilters");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListFindingsFiltersResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListFindingsFiltersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListFindingsFiltersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListFindingsFiltersRequest, ListFindingsFiltersResponse>()
                            .withOperationName("ListFindingsFilters")
                            .withMarshaller(new ListFindingsFiltersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listFindingsFiltersRequest));
            CompletableFuture<ListFindingsFiltersResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves a subset of information about all the findings filters for an account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listFindingsFilters(software.amazon.awssdk.services.macie2.model.ListFindingsFiltersRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.macie2.paginators.ListFindingsFiltersPublisher publisher = client.listFindingsFiltersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.macie2.paginators.ListFindingsFiltersPublisher publisher = client.listFindingsFiltersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.macie2.model.ListFindingsFiltersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.macie2.model.ListFindingsFiltersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFindingsFilters(software.amazon.awssdk.services.macie2.model.ListFindingsFiltersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listFindingsFiltersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because the input doesn't satisfy the constraints specified by
     *         the service.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.ListFindingsFilters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/ListFindingsFilters" target="_top">AWS
     *      API Documentation</a>
     */
    public ListFindingsFiltersPublisher listFindingsFiltersPaginator(ListFindingsFiltersRequest listFindingsFiltersRequest) {
        return new ListFindingsFiltersPublisher(this, applyPaginatorUserAgent(listFindingsFiltersRequest));
    }

    /**
     * <p>
     * Retrieves a subset of information about one or more findings.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listFindings(software.amazon.awssdk.services.macie2.model.ListFindingsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.macie2.paginators.ListFindingsPublisher publisher = client.listFindingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.macie2.paginators.ListFindingsPublisher publisher = client.listFindingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.macie2.model.ListFindingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.macie2.model.ListFindingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFindings(software.amazon.awssdk.services.macie2.model.ListFindingsRequest)} operation.</b>
     * </p>
     *
     * @param listFindingsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because the input doesn't satisfy the constraints specified by
     *         the service.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.ListFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/ListFindings" target="_top">AWS API
     *      Documentation</a>
     */
    public ListFindingsPublisher listFindingsPaginator(ListFindingsRequest listFindingsRequest) {
        return new ListFindingsPublisher(this, applyPaginatorUserAgent(listFindingsRequest));
    }

    /**
     * <p>
     * Retrieves information about the Amazon Macie membership invitations that were received by an account.
     * </p>
     *
     * @param listInvitationsRequest
     * @return A Java Future containing the result of the ListInvitations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because the input doesn't satisfy the constraints specified by
     *         the service.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.ListInvitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/ListInvitations" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListInvitationsResponse> listInvitations(ListInvitationsRequest listInvitationsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listInvitationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListInvitations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListInvitationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListInvitationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListInvitationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListInvitationsRequest, ListInvitationsResponse>()
                            .withOperationName("ListInvitations")
                            .withMarshaller(new ListInvitationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listInvitationsRequest));
            CompletableFuture<ListInvitationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the Amazon Macie membership invitations that were received by an account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listInvitations(software.amazon.awssdk.services.macie2.model.ListInvitationsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.macie2.paginators.ListInvitationsPublisher publisher = client.listInvitationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.macie2.paginators.ListInvitationsPublisher publisher = client.listInvitationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.macie2.model.ListInvitationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.macie2.model.ListInvitationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInvitations(software.amazon.awssdk.services.macie2.model.ListInvitationsRequest)} operation.</b>
     * </p>
     *
     * @param listInvitationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because the input doesn't satisfy the constraints specified by
     *         the service.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.ListInvitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/ListInvitations" target="_top">AWS API
     *      Documentation</a>
     */
    public ListInvitationsPublisher listInvitationsPaginator(ListInvitationsRequest listInvitationsRequest) {
        return new ListInvitationsPublisher(this, applyPaginatorUserAgent(listInvitationsRequest));
    }

    /**
     * <p>
     * Retrieves information about all the managed data identifiers that Amazon Macie currently provides.
     * </p>
     *
     * @param listManagedDataIdentifiersRequest
     * @return A Java Future containing the result of the ListManagedDataIdentifiers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.ListManagedDataIdentifiers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/ListManagedDataIdentifiers"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListManagedDataIdentifiersResponse> listManagedDataIdentifiers(
            ListManagedDataIdentifiersRequest listManagedDataIdentifiersRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listManagedDataIdentifiersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListManagedDataIdentifiers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListManagedDataIdentifiersResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListManagedDataIdentifiersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListManagedDataIdentifiersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListManagedDataIdentifiersRequest, ListManagedDataIdentifiersResponse>()
                            .withOperationName("ListManagedDataIdentifiers")
                            .withMarshaller(new ListManagedDataIdentifiersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listManagedDataIdentifiersRequest));
            CompletableFuture<ListManagedDataIdentifiersResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about all the managed data identifiers that Amazon Macie currently provides.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listManagedDataIdentifiers(software.amazon.awssdk.services.macie2.model.ListManagedDataIdentifiersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.macie2.paginators.ListManagedDataIdentifiersPublisher publisher = client.listManagedDataIdentifiersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.macie2.paginators.ListManagedDataIdentifiersPublisher publisher = client.listManagedDataIdentifiersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.macie2.model.ListManagedDataIdentifiersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.macie2.model.ListManagedDataIdentifiersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listManagedDataIdentifiers(software.amazon.awssdk.services.macie2.model.ListManagedDataIdentifiersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listManagedDataIdentifiersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.ListManagedDataIdentifiers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/ListManagedDataIdentifiers"
     *      target="_top">AWS API Documentation</a>
     */
    public ListManagedDataIdentifiersPublisher listManagedDataIdentifiersPaginator(
            ListManagedDataIdentifiersRequest listManagedDataIdentifiersRequest) {
        return new ListManagedDataIdentifiersPublisher(this, applyPaginatorUserAgent(listManagedDataIdentifiersRequest));
    }

    /**
     * <p>
     * Retrieves information about the accounts that are associated with an Amazon Macie administrator account.
     * </p>
     *
     * @param listMembersRequest
     * @return A Java Future containing the result of the ListMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because the input doesn't satisfy the constraints specified by
     *         the service.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.ListMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/ListMembers" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListMembersResponse> listMembers(ListMembersRequest listMembersRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listMembersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListMembers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListMembersResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListMembersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListMembersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListMembersRequest, ListMembersResponse>()
                            .withOperationName("ListMembers").withMarshaller(new ListMembersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listMembersRequest));
            CompletableFuture<ListMembersResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the accounts that are associated with an Amazon Macie administrator account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listMembers(software.amazon.awssdk.services.macie2.model.ListMembersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.macie2.paginators.ListMembersPublisher publisher = client.listMembersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.macie2.paginators.ListMembersPublisher publisher = client.listMembersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.macie2.model.ListMembersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.macie2.model.ListMembersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMembers(software.amazon.awssdk.services.macie2.model.ListMembersRequest)} operation.</b>
     * </p>
     *
     * @param listMembersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because the input doesn't satisfy the constraints specified by
     *         the service.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.ListMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/ListMembers" target="_top">AWS API
     *      Documentation</a>
     */
    public ListMembersPublisher listMembersPaginator(ListMembersRequest listMembersRequest) {
        return new ListMembersPublisher(this, applyPaginatorUserAgent(listMembersRequest));
    }

    /**
     * <p>
     * Retrieves information about the delegated Amazon Macie administrator account for an organization in
     * Organizations.
     * </p>
     *
     * @param listOrganizationAdminAccountsRequest
     * @return A Java Future containing the result of the ListOrganizationAdminAccounts operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because the input doesn't satisfy the constraints specified by
     *         the service.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.ListOrganizationAdminAccounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/ListOrganizationAdminAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListOrganizationAdminAccountsResponse> listOrganizationAdminAccounts(
            ListOrganizationAdminAccountsRequest listOrganizationAdminAccountsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listOrganizationAdminAccountsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListOrganizationAdminAccounts");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListOrganizationAdminAccountsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListOrganizationAdminAccountsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListOrganizationAdminAccountsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListOrganizationAdminAccountsRequest, ListOrganizationAdminAccountsResponse>()
                            .withOperationName("ListOrganizationAdminAccounts")
                            .withMarshaller(new ListOrganizationAdminAccountsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listOrganizationAdminAccountsRequest));
            CompletableFuture<ListOrganizationAdminAccountsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the delegated Amazon Macie administrator account for an organization in
     * Organizations.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listOrganizationAdminAccounts(software.amazon.awssdk.services.macie2.model.ListOrganizationAdminAccountsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.macie2.paginators.ListOrganizationAdminAccountsPublisher publisher = client.listOrganizationAdminAccountsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.macie2.paginators.ListOrganizationAdminAccountsPublisher publisher = client.listOrganizationAdminAccountsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.macie2.model.ListOrganizationAdminAccountsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.macie2.model.ListOrganizationAdminAccountsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOrganizationAdminAccounts(software.amazon.awssdk.services.macie2.model.ListOrganizationAdminAccountsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listOrganizationAdminAccountsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because the input doesn't satisfy the constraints specified by
     *         the service.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.ListOrganizationAdminAccounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/ListOrganizationAdminAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    public ListOrganizationAdminAccountsPublisher listOrganizationAdminAccountsPaginator(
            ListOrganizationAdminAccountsRequest listOrganizationAdminAccountsRequest) {
        return new ListOrganizationAdminAccountsPublisher(this, applyPaginatorUserAgent(listOrganizationAdminAccountsRequest));
    }

    /**
     * <p>
     * Retrieves information about objects that were selected from an S3 bucket for automated sensitive data discovery.
     * </p>
     *
     * @param listResourceProfileArtifactsRequest
     * @return A Java Future containing the result of the ListResourceProfileArtifacts operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ValidationException The request failed because the input doesn't satisfy the constraints specified by
     *         the service.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.ListResourceProfileArtifacts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/ListResourceProfileArtifacts"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListResourceProfileArtifactsResponse> listResourceProfileArtifacts(
            ListResourceProfileArtifactsRequest listResourceProfileArtifactsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listResourceProfileArtifactsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListResourceProfileArtifacts");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListResourceProfileArtifactsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListResourceProfileArtifactsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListResourceProfileArtifactsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListResourceProfileArtifactsRequest, ListResourceProfileArtifactsResponse>()
                            .withOperationName("ListResourceProfileArtifacts")
                            .withMarshaller(new ListResourceProfileArtifactsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listResourceProfileArtifactsRequest));
            CompletableFuture<ListResourceProfileArtifactsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about objects that were selected from an S3 bucket for automated sensitive data discovery.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResourceProfileArtifacts(software.amazon.awssdk.services.macie2.model.ListResourceProfileArtifactsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.macie2.paginators.ListResourceProfileArtifactsPublisher publisher = client.listResourceProfileArtifactsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.macie2.paginators.ListResourceProfileArtifactsPublisher publisher = client.listResourceProfileArtifactsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.macie2.model.ListResourceProfileArtifactsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.macie2.model.ListResourceProfileArtifactsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResourceProfileArtifacts(software.amazon.awssdk.services.macie2.model.ListResourceProfileArtifactsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listResourceProfileArtifactsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ValidationException The request failed because the input doesn't satisfy the constraints specified by
     *         the service.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.ListResourceProfileArtifacts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/ListResourceProfileArtifacts"
     *      target="_top">AWS API Documentation</a>
     */
    public ListResourceProfileArtifactsPublisher listResourceProfileArtifactsPaginator(
            ListResourceProfileArtifactsRequest listResourceProfileArtifactsRequest) {
        return new ListResourceProfileArtifactsPublisher(this, applyPaginatorUserAgent(listResourceProfileArtifactsRequest));
    }

    /**
     * <p>
     * Retrieves information about the types and amount of sensitive data that Amazon Macie found in an S3 bucket.
     * </p>
     *
     * @param listResourceProfileDetectionsRequest
     * @return A Java Future containing the result of the ListResourceProfileDetections operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because the input doesn't satisfy the constraints specified by
     *         the service.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.ListResourceProfileDetections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/ListResourceProfileDetections"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListResourceProfileDetectionsResponse> listResourceProfileDetections(
            ListResourceProfileDetectionsRequest listResourceProfileDetectionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listResourceProfileDetectionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListResourceProfileDetections");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListResourceProfileDetectionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListResourceProfileDetectionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListResourceProfileDetectionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListResourceProfileDetectionsRequest, ListResourceProfileDetectionsResponse>()
                            .withOperationName("ListResourceProfileDetections")
                            .withMarshaller(new ListResourceProfileDetectionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listResourceProfileDetectionsRequest));
            CompletableFuture<ListResourceProfileDetectionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the types and amount of sensitive data that Amazon Macie found in an S3 bucket.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResourceProfileDetections(software.amazon.awssdk.services.macie2.model.ListResourceProfileDetectionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.macie2.paginators.ListResourceProfileDetectionsPublisher publisher = client.listResourceProfileDetectionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.macie2.paginators.ListResourceProfileDetectionsPublisher publisher = client.listResourceProfileDetectionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.macie2.model.ListResourceProfileDetectionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.macie2.model.ListResourceProfileDetectionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResourceProfileDetections(software.amazon.awssdk.services.macie2.model.ListResourceProfileDetectionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listResourceProfileDetectionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because the input doesn't satisfy the constraints specified by
     *         the service.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.ListResourceProfileDetections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/ListResourceProfileDetections"
     *      target="_top">AWS API Documentation</a>
     */
    public ListResourceProfileDetectionsPublisher listResourceProfileDetectionsPaginator(
            ListResourceProfileDetectionsRequest listResourceProfileDetectionsRequest) {
        return new ListResourceProfileDetectionsPublisher(this, applyPaginatorUserAgent(listResourceProfileDetectionsRequest));
    }

    /**
     * <p>
     * Retrieves a subset of information about the sensitivity inspection template for an account.
     * </p>
     *
     * @param listSensitivityInspectionTemplatesRequest
     * @return A Java Future containing the result of the ListSensitivityInspectionTemplates operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ValidationException The request failed because the input doesn't satisfy the constraints specified by
     *         the service.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.ListSensitivityInspectionTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/ListSensitivityInspectionTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListSensitivityInspectionTemplatesResponse> listSensitivityInspectionTemplates(
            ListSensitivityInspectionTemplatesRequest listSensitivityInspectionTemplatesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listSensitivityInspectionTemplatesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListSensitivityInspectionTemplates");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListSensitivityInspectionTemplatesResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, ListSensitivityInspectionTemplatesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListSensitivityInspectionTemplatesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListSensitivityInspectionTemplatesRequest, ListSensitivityInspectionTemplatesResponse>()
                            .withOperationName("ListSensitivityInspectionTemplates")
                            .withMarshaller(new ListSensitivityInspectionTemplatesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listSensitivityInspectionTemplatesRequest));
            CompletableFuture<ListSensitivityInspectionTemplatesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves a subset of information about the sensitivity inspection template for an account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSensitivityInspectionTemplates(software.amazon.awssdk.services.macie2.model.ListSensitivityInspectionTemplatesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.macie2.paginators.ListSensitivityInspectionTemplatesPublisher publisher = client.listSensitivityInspectionTemplatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.macie2.paginators.ListSensitivityInspectionTemplatesPublisher publisher = client.listSensitivityInspectionTemplatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.macie2.model.ListSensitivityInspectionTemplatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.macie2.model.ListSensitivityInspectionTemplatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSensitivityInspectionTemplates(software.amazon.awssdk.services.macie2.model.ListSensitivityInspectionTemplatesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSensitivityInspectionTemplatesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ValidationException The request failed because the input doesn't satisfy the constraints specified by
     *         the service.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.ListSensitivityInspectionTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/ListSensitivityInspectionTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    public ListSensitivityInspectionTemplatesPublisher listSensitivityInspectionTemplatesPaginator(
            ListSensitivityInspectionTemplatesRequest listSensitivityInspectionTemplatesRequest) {
        return new ListSensitivityInspectionTemplatesPublisher(this,
                applyPaginatorUserAgent(listSensitivityInspectionTemplatesRequest));
    }

    /**
     * <p>
     * Retrieves the tags (keys and values) that are associated with an Amazon Macie resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTagsForResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListTagsForResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                            .withOperationName("ListTagsForResource")
                            .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listTagsForResourceRequest));
            CompletableFuture<ListTagsForResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates or updates the configuration settings for storing data classification results.
     * </p>
     *
     * @param putClassificationExportConfigurationRequest
     * @return A Java Future containing the result of the PutClassificationExportConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because the input doesn't satisfy the constraints specified by
     *         the service.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.PutClassificationExportConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/PutClassificationExportConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutClassificationExportConfigurationResponse> putClassificationExportConfiguration(
            PutClassificationExportConfigurationRequest putClassificationExportConfigurationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                putClassificationExportConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutClassificationExportConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutClassificationExportConfigurationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, PutClassificationExportConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutClassificationExportConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutClassificationExportConfigurationRequest, PutClassificationExportConfigurationResponse>()
                            .withOperationName("PutClassificationExportConfiguration")
                            .withMarshaller(new PutClassificationExportConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(putClassificationExportConfigurationRequest));
            CompletableFuture<PutClassificationExportConfigurationResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the configuration settings for publishing findings to Security Hub.
     * </p>
     *
     * @param putFindingsPublicationConfigurationRequest
     * @return A Java Future containing the result of the PutFindingsPublicationConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because the input doesn't satisfy the constraints specified by
     *         the service.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.PutFindingsPublicationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/PutFindingsPublicationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutFindingsPublicationConfigurationResponse> putFindingsPublicationConfiguration(
            PutFindingsPublicationConfigurationRequest putFindingsPublicationConfigurationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                putFindingsPublicationConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutFindingsPublicationConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutFindingsPublicationConfigurationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, PutFindingsPublicationConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutFindingsPublicationConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutFindingsPublicationConfigurationRequest, PutFindingsPublicationConfigurationResponse>()
                            .withOperationName("PutFindingsPublicationConfiguration")
                            .withMarshaller(new PutFindingsPublicationConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(putFindingsPublicationConfigurationRequest));
            CompletableFuture<PutFindingsPublicationConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves (queries) statistical data and other information about Amazon Web Services resources that Amazon Macie
     * monitors and analyzes.
     * </p>
     *
     * @param searchResourcesRequest
     * @return A Java Future containing the result of the SearchResources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because the input doesn't satisfy the constraints specified by
     *         the service.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.SearchResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/SearchResources" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<SearchResourcesResponse> searchResources(SearchResourcesRequest searchResourcesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, searchResourcesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SearchResources");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SearchResourcesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, SearchResourcesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<SearchResourcesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SearchResourcesRequest, SearchResourcesResponse>()
                            .withOperationName("SearchResources")
                            .withMarshaller(new SearchResourcesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(searchResourcesRequest));
            CompletableFuture<SearchResourcesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves (queries) statistical data and other information about Amazon Web Services resources that Amazon Macie
     * monitors and analyzes.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchResources(software.amazon.awssdk.services.macie2.model.SearchResourcesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.macie2.paginators.SearchResourcesPublisher publisher = client.searchResourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.macie2.paginators.SearchResourcesPublisher publisher = client.searchResourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.macie2.model.SearchResourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.macie2.model.SearchResourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchResources(software.amazon.awssdk.services.macie2.model.SearchResourcesRequest)} operation.</b>
     * </p>
     *
     * @param searchResourcesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because the input doesn't satisfy the constraints specified by
     *         the service.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.SearchResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/SearchResources" target="_top">AWS API
     *      Documentation</a>
     */
    public SearchResourcesPublisher searchResourcesPaginator(SearchResourcesRequest searchResourcesRequest) {
        return new SearchResourcesPublisher(this, applyPaginatorUserAgent(searchResourcesRequest));
    }

    /**
     * <p>
     * Adds or updates one or more tags (keys and values) that are associated with an Amazon Macie resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    TagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<TagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                            .withOperationName("TagResource").withMarshaller(new TagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(tagResourceRequest));
            CompletableFuture<TagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Tests a custom data identifier.
     * </p>
     *
     * @param testCustomDataIdentifierRequest
     * @return A Java Future containing the result of the TestCustomDataIdentifier operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because the input doesn't satisfy the constraints specified by
     *         the service.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.TestCustomDataIdentifier
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/TestCustomDataIdentifier"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<TestCustomDataIdentifierResponse> testCustomDataIdentifier(
            TestCustomDataIdentifierRequest testCustomDataIdentifierRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, testCustomDataIdentifierRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TestCustomDataIdentifier");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<TestCustomDataIdentifierResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, TestCustomDataIdentifierResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<TestCustomDataIdentifierResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TestCustomDataIdentifierRequest, TestCustomDataIdentifierResponse>()
                            .withOperationName("TestCustomDataIdentifier")
                            .withMarshaller(new TestCustomDataIdentifierRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(testCustomDataIdentifierRequest));
            CompletableFuture<TestCustomDataIdentifierResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes one or more tags (keys and values) from an Amazon Macie resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UntagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UntagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                            .withOperationName("UntagResource")
                            .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(untagResourceRequest));
            CompletableFuture<UntagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the settings for an allow list.
     * </p>
     *
     * @param updateAllowListRequest
     * @return A Java Future containing the result of the UpdateAllowList operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ValidationException The request failed because the input doesn't satisfy the constraints specified by
     *         the service.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.UpdateAllowList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/UpdateAllowList" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateAllowListResponse> updateAllowList(UpdateAllowListRequest updateAllowListRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateAllowListRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAllowList");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateAllowListResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateAllowListResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateAllowListResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateAllowListRequest, UpdateAllowListResponse>()
                            .withOperationName("UpdateAllowList")
                            .withMarshaller(new UpdateAllowListRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateAllowListRequest));
            CompletableFuture<UpdateAllowListResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Enables or disables automated sensitive data discovery for an account.
     * </p>
     *
     * @param updateAutomatedDiscoveryConfigurationRequest
     * @return A Java Future containing the result of the UpdateAutomatedDiscoveryConfiguration operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ValidationException The request failed because the input doesn't satisfy the constraints specified by
     *         the service.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.UpdateAutomatedDiscoveryConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/UpdateAutomatedDiscoveryConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateAutomatedDiscoveryConfigurationResponse> updateAutomatedDiscoveryConfiguration(
            UpdateAutomatedDiscoveryConfigurationRequest updateAutomatedDiscoveryConfigurationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateAutomatedDiscoveryConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAutomatedDiscoveryConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateAutomatedDiscoveryConfigurationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, UpdateAutomatedDiscoveryConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateAutomatedDiscoveryConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateAutomatedDiscoveryConfigurationRequest, UpdateAutomatedDiscoveryConfigurationResponse>()
                            .withOperationName("UpdateAutomatedDiscoveryConfiguration")
                            .withMarshaller(new UpdateAutomatedDiscoveryConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateAutomatedDiscoveryConfigurationRequest));
            CompletableFuture<UpdateAutomatedDiscoveryConfigurationResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Changes the status of a classification job.
     * </p>
     *
     * @param updateClassificationJobRequest
     * @return A Java Future containing the result of the UpdateClassificationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because the input doesn't satisfy the constraints specified by
     *         the service.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.UpdateClassificationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/UpdateClassificationJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateClassificationJobResponse> updateClassificationJob(
            UpdateClassificationJobRequest updateClassificationJobRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateClassificationJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateClassificationJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateClassificationJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateClassificationJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateClassificationJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateClassificationJobRequest, UpdateClassificationJobResponse>()
                            .withOperationName("UpdateClassificationJob")
                            .withMarshaller(new UpdateClassificationJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateClassificationJobRequest));
            CompletableFuture<UpdateClassificationJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the classification scope settings for an account.
     * </p>
     *
     * @param updateClassificationScopeRequest
     * @return A Java Future containing the result of the UpdateClassificationScope operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ValidationException The request failed because the input doesn't satisfy the constraints specified by
     *         the service.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.UpdateClassificationScope
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/UpdateClassificationScope"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateClassificationScopeResponse> updateClassificationScope(
            UpdateClassificationScopeRequest updateClassificationScopeRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateClassificationScopeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateClassificationScope");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateClassificationScopeResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateClassificationScopeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateClassificationScopeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateClassificationScopeRequest, UpdateClassificationScopeResponse>()
                            .withOperationName("UpdateClassificationScope")
                            .withMarshaller(new UpdateClassificationScopeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateClassificationScopeRequest));
            CompletableFuture<UpdateClassificationScopeResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the criteria and other settings for a findings filter.
     * </p>
     *
     * @param updateFindingsFilterRequest
     * @return A Java Future containing the result of the UpdateFindingsFilter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because the input doesn't satisfy the constraints specified by
     *         the service.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.UpdateFindingsFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/UpdateFindingsFilter" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateFindingsFilterResponse> updateFindingsFilter(
            UpdateFindingsFilterRequest updateFindingsFilterRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateFindingsFilterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateFindingsFilter");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateFindingsFilterResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateFindingsFilterResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateFindingsFilterResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateFindingsFilterRequest, UpdateFindingsFilterResponse>()
                            .withOperationName("UpdateFindingsFilter")
                            .withMarshaller(new UpdateFindingsFilterRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateFindingsFilterRequest));
            CompletableFuture<UpdateFindingsFilterResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Suspends or re-enables Amazon Macie, or updates the configuration settings for a Macie account.
     * </p>
     *
     * @param updateMacieSessionRequest
     * @return A Java Future containing the result of the UpdateMacieSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because the input doesn't satisfy the constraints specified by
     *         the service.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.UpdateMacieSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/UpdateMacieSession" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateMacieSessionResponse> updateMacieSession(UpdateMacieSessionRequest updateMacieSessionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateMacieSessionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateMacieSession");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateMacieSessionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateMacieSessionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateMacieSessionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateMacieSessionRequest, UpdateMacieSessionResponse>()
                            .withOperationName("UpdateMacieSession")
                            .withMarshaller(new UpdateMacieSessionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateMacieSessionRequest));
            CompletableFuture<UpdateMacieSessionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Enables an Amazon Macie administrator to suspend or re-enable Macie for a member account.
     * </p>
     *
     * @param updateMemberSessionRequest
     * @return A Java Future containing the result of the UpdateMemberSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because the input doesn't satisfy the constraints specified by
     *         the service.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.UpdateMemberSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/UpdateMemberSession" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateMemberSessionResponse> updateMemberSession(
            UpdateMemberSessionRequest updateMemberSessionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateMemberSessionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateMemberSession");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateMemberSessionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateMemberSessionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateMemberSessionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateMemberSessionRequest, UpdateMemberSessionResponse>()
                            .withOperationName("UpdateMemberSession")
                            .withMarshaller(new UpdateMemberSessionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateMemberSessionRequest));
            CompletableFuture<UpdateMemberSessionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the Amazon Macie configuration settings for an organization in Organizations.
     * </p>
     *
     * @param updateOrganizationConfigurationRequest
     * @return A Java Future containing the result of the UpdateOrganizationConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because the input doesn't satisfy the constraints specified by
     *         the service.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ConflictException The request failed because it conflicts with the current state of the specified
     *         resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.UpdateOrganizationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/UpdateOrganizationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateOrganizationConfigurationResponse> updateOrganizationConfiguration(
            UpdateOrganizationConfigurationRequest updateOrganizationConfigurationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateOrganizationConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateOrganizationConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateOrganizationConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateOrganizationConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateOrganizationConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateOrganizationConfigurationRequest, UpdateOrganizationConfigurationResponse>()
                            .withOperationName("UpdateOrganizationConfiguration")
                            .withMarshaller(new UpdateOrganizationConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateOrganizationConfigurationRequest));
            CompletableFuture<UpdateOrganizationConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the sensitivity score for an S3 bucket.
     * </p>
     *
     * @param updateResourceProfileRequest
     * @return A Java Future containing the result of the UpdateResourceProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because the input doesn't satisfy the constraints specified by
     *         the service.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.UpdateResourceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/UpdateResourceProfile" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateResourceProfileResponse> updateResourceProfile(
            UpdateResourceProfileRequest updateResourceProfileRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateResourceProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateResourceProfile");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateResourceProfileResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateResourceProfileResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateResourceProfileResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateResourceProfileRequest, UpdateResourceProfileResponse>()
                            .withOperationName("UpdateResourceProfile")
                            .withMarshaller(new UpdateResourceProfileRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateResourceProfileRequest));
            CompletableFuture<UpdateResourceProfileResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the sensitivity scoring settings for an S3 bucket.
     * </p>
     *
     * @param updateResourceProfileDetectionsRequest
     * @return A Java Future containing the result of the UpdateResourceProfileDetections operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request failed because the input doesn't satisfy the constraints specified by
     *         the service.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>ServiceQuotaExceededException The request failed because fulfilling the request would exceed one or
     *         more service quotas for your account.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.UpdateResourceProfileDetections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/UpdateResourceProfileDetections"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateResourceProfileDetectionsResponse> updateResourceProfileDetections(
            UpdateResourceProfileDetectionsRequest updateResourceProfileDetectionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateResourceProfileDetectionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateResourceProfileDetections");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateResourceProfileDetectionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateResourceProfileDetectionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateResourceProfileDetectionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateResourceProfileDetectionsRequest, UpdateResourceProfileDetectionsResponse>()
                            .withOperationName("UpdateResourceProfileDetections")
                            .withMarshaller(new UpdateResourceProfileDetectionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateResourceProfileDetectionsRequest));
            CompletableFuture<UpdateResourceProfileDetectionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the status and configuration settings for retrieving occurrences of sensitive data reported by findings.
     * </p>
     *
     * @param updateRevealConfigurationRequest
     * @return A Java Future containing the result of the UpdateRevealConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ValidationException The request failed because the input doesn't satisfy the constraints specified by
     *         the service.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.UpdateRevealConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/UpdateRevealConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateRevealConfigurationResponse> updateRevealConfiguration(
            UpdateRevealConfigurationRequest updateRevealConfigurationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateRevealConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateRevealConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateRevealConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateRevealConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateRevealConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateRevealConfigurationRequest, UpdateRevealConfigurationResponse>()
                            .withOperationName("UpdateRevealConfiguration")
                            .withMarshaller(new UpdateRevealConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateRevealConfigurationRequest));
            CompletableFuture<UpdateRevealConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the settings for the sensitivity inspection template for an account.
     * </p>
     *
     * @param updateSensitivityInspectionTemplateRequest
     * @return A Java Future containing the result of the UpdateSensitivityInspectionTemplate operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The request failed because the specified resource wasn't found.</li>
     *         <li>ThrottlingException The request failed because you sent too many requests during a certain amount of
     *         time.</li>
     *         <li>ValidationException The request failed because the input doesn't satisfy the constraints specified by
     *         the service.</li>
     *         <li>InternalServerException The request failed due to an unknown internal server error, exception, or
     *         failure.</li>
     *         <li>AccessDeniedException The request was denied because you don't have sufficient access to the
     *         specified resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Macie2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Macie2AsyncClient.UpdateSensitivityInspectionTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/UpdateSensitivityInspectionTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateSensitivityInspectionTemplateResponse> updateSensitivityInspectionTemplate(
            UpdateSensitivityInspectionTemplateRequest updateSensitivityInspectionTemplateRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateSensitivityInspectionTemplateRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Macie2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateSensitivityInspectionTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateSensitivityInspectionTemplateResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, UpdateSensitivityInspectionTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateSensitivityInspectionTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateSensitivityInspectionTemplateRequest, UpdateSensitivityInspectionTemplateResponse>()
                            .withOperationName("UpdateSensitivityInspectionTemplate")
                            .withMarshaller(new UpdateSensitivityInspectionTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateSensitivityInspectionTemplateRequest));
            CompletableFuture<UpdateSensitivityInspectionTemplateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public void close() {
        clientHandler.close();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(Macie2Exception::builder)
                .protocol(AwsJsonProtocol.REST_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException")
                                .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(402).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalServerException")
                                .exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundException")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ValidationException")
                                .exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ThrottlingException")
                                .exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(429).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AccessDeniedException")
                                .exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(403).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConflictException")
                                .exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UnprocessableEntityException")
                                .exceptionBuilderSupplier(UnprocessableEntityException::builder).httpStatusCode(422).build());
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private <T extends Macie2Request> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder()
                .version(VersionInfo.SDK_VERSION).name("PAGINATED").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration()
                .map(c -> c.toBuilder().applyMutation(userAgentApplier).build())
                .orElse((AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier).build()));
        return (T) request.toBuilder().overrideConfiguration(overrideConfiguration).build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    @Override
    public Macie2AsyncWaiter waiter() {
        return Macie2AsyncWaiter.builder().client(this).scheduledExecutorService(executorService).build();
    }
}
