/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about an Amazon Web Service that performed an action on an affected resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsService implements SdkPojo, Serializable, ToCopyableBuilder<AwsService.Builder, AwsService> {
    private static final SdkField<String> INVOKED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("invokedBy").getter(getter(AwsService::invokedBy)).setter(setter(Builder::invokedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invokedBy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INVOKED_BY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String invokedBy;

    private AwsService(BuilderImpl builder) {
        this.invokedBy = builder.invokedBy;
    }

    /**
     * <p>
     * The name of the Amazon Web Service that performed the action.
     * </p>
     * 
     * @return The name of the Amazon Web Service that performed the action.
     */
    public final String invokedBy() {
        return invokedBy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(invokedBy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsService)) {
            return false;
        }
        AwsService other = (AwsService) obj;
        return Objects.equals(invokedBy(), other.invokedBy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsService").add("InvokedBy", invokedBy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "invokedBy":
            return Optional.ofNullable(clazz.cast(invokedBy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsService, T> g) {
        return obj -> g.apply((AwsService) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsService> {
        /**
         * <p>
         * The name of the Amazon Web Service that performed the action.
         * </p>
         * 
         * @param invokedBy
         *        The name of the Amazon Web Service that performed the action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invokedBy(String invokedBy);
    }

    static final class BuilderImpl implements Builder {
        private String invokedBy;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsService model) {
            invokedBy(model.invokedBy);
        }

        public final String getInvokedBy() {
            return invokedBy;
        }

        public final void setInvokedBy(String invokedBy) {
            this.invokedBy = invokedBy;
        }

        @Override
        public final Builder invokedBy(String invokedBy) {
            this.invokedBy = invokedBy;
            return this;
        }

        @Override
        public AwsService build() {
            return new AwsService(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
