/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about the source and type of temporary security credentials that were issued to an entity.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SessionIssuer implements SdkPojo, Serializable, ToCopyableBuilder<SessionIssuer.Builder, SessionIssuer> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accountId").getter(getter(SessionIssuer::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(SessionIssuer::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> PRINCIPAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("principalId").getter(getter(SessionIssuer::principalId)).setter(setter(Builder::principalId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principalId").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(SessionIssuer::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> USER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("userName").getter(getter(SessionIssuer::userName)).setter(setter(Builder::userName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, ARN_FIELD,
            PRINCIPAL_ID_FIELD, TYPE_FIELD, USER_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String accountId;

    private final String arn;

    private final String principalId;

    private final String type;

    private final String userName;

    private SessionIssuer(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.arn = builder.arn;
        this.principalId = builder.principalId;
        this.type = builder.type;
        this.userName = builder.userName;
    }

    /**
     * <p>
     * The unique identifier for the Amazon Web Services account that owns the entity that was used to get the
     * credentials.
     * </p>
     * 
     * @return The unique identifier for the Amazon Web Services account that owns the entity that was used to get the
     *         credentials.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the source account, IAM user, or role that was used to get the credentials.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the source account, IAM user, or role that was used to get the
     *         credentials.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The unique identifier for the entity that was used to get the credentials.
     * </p>
     * 
     * @return The unique identifier for the entity that was used to get the credentials.
     */
    public final String principalId() {
        return principalId;
    }

    /**
     * <p>
     * The source of the temporary security credentials, such as Root, IAMUser, or Role.
     * </p>
     * 
     * @return The source of the temporary security credentials, such as Root, IAMUser, or Role.
     */
    public final String type() {
        return type;
    }

    /**
     * <p>
     * The name or alias of the user or role that issued the session. This value is null if the credentials were
     * obtained from a root account that doesn't have an alias.
     * </p>
     * 
     * @return The name or alias of the user or role that issued the session. This value is null if the credentials were
     *         obtained from a root account that doesn't have an alias.
     */
    public final String userName() {
        return userName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(principalId());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(userName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SessionIssuer)) {
            return false;
        }
        SessionIssuer other = (SessionIssuer) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(arn(), other.arn())
                && Objects.equals(principalId(), other.principalId()) && Objects.equals(type(), other.type())
                && Objects.equals(userName(), other.userName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SessionIssuer").add("AccountId", accountId()).add("Arn", arn())
                .add("PrincipalId", principalId()).add("Type", type()).add("UserName", userName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "principalId":
            return Optional.ofNullable(clazz.cast(principalId()));
        case "type":
            return Optional.ofNullable(clazz.cast(type()));
        case "userName":
            return Optional.ofNullable(clazz.cast(userName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SessionIssuer, T> g) {
        return obj -> g.apply((SessionIssuer) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SessionIssuer> {
        /**
         * <p>
         * The unique identifier for the Amazon Web Services account that owns the entity that was used to get the
         * credentials.
         * </p>
         * 
         * @param accountId
         *        The unique identifier for the Amazon Web Services account that owns the entity that was used to get
         *        the credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the source account, IAM user, or role that was used to get the credentials.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the source account, IAM user, or role that was used to get the
         *        credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The unique identifier for the entity that was used to get the credentials.
         * </p>
         * 
         * @param principalId
         *        The unique identifier for the entity that was used to get the credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principalId(String principalId);

        /**
         * <p>
         * The source of the temporary security credentials, such as Root, IAMUser, or Role.
         * </p>
         * 
         * @param type
         *        The source of the temporary security credentials, such as Root, IAMUser, or Role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * The name or alias of the user or role that issued the session. This value is null if the credentials were
         * obtained from a root account that doesn't have an alias.
         * </p>
         * 
         * @param userName
         *        The name or alias of the user or role that issued the session. This value is null if the credentials
         *        were obtained from a root account that doesn't have an alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userName(String userName);
    }

    static final class BuilderImpl implements Builder {
        private String accountId;

        private String arn;

        private String principalId;

        private String type;

        private String userName;

        private BuilderImpl() {
        }

        private BuilderImpl(SessionIssuer model) {
            accountId(model.accountId);
            arn(model.arn);
            principalId(model.principalId);
            type(model.type);
            userName(model.userName);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getPrincipalId() {
            return principalId;
        }

        public final void setPrincipalId(String principalId) {
            this.principalId = principalId;
        }

        @Override
        public final Builder principalId(String principalId) {
            this.principalId = principalId;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final String getUserName() {
            return userName;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        @Override
        public SessionIssuer build() {
            return new SessionIssuer(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
