/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.macie2.Macie2Client;
import software.amazon.awssdk.services.macie2.model.AllowListSummary;
import software.amazon.awssdk.services.macie2.model.ListAllowListsRequest;
import software.amazon.awssdk.services.macie2.model.ListAllowListsResponse;

public class ListAllowListsIterable
implements SdkIterable<ListAllowListsResponse> {
    private final Macie2Client client;
    private final ListAllowListsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAllowListsIterable(Macie2Client client, ListAllowListsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListAllowListsResponseFetcher();
    }

    public Iterator<ListAllowListsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AllowListSummary> allowLists() {
        Function<ListAllowListsResponse, Iterator> getIterator = response -> {
            if (response != null && response.allowLists() != null) {
                return response.allowLists().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAllowListsResponseFetcher
    implements SyncPageFetcher<ListAllowListsResponse> {
        private ListAllowListsResponseFetcher() {
        }

        public boolean hasNextPage(ListAllowListsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAllowListsResponse nextPage(ListAllowListsResponse previousPage) {
            if (previousPage == null) {
                return ListAllowListsIterable.this.client.listAllowLists(ListAllowListsIterable.this.firstRequest);
            }
            return ListAllowListsIterable.this.client.listAllowLists((ListAllowListsRequest)((Object)ListAllowListsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

