/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies a tag-based condition that determines whether an S3 object is included or excluded from a classification
 * job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TagScopeTerm implements SdkPojo, Serializable, ToCopyableBuilder<TagScopeTerm.Builder, TagScopeTerm> {
    private static final SdkField<String> COMPARATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("comparator").getter(getter(TagScopeTerm::comparatorAsString)).setter(setter(Builder::comparator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("comparator").build()).build();

    private static final SdkField<String> KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("key")
            .getter(getter(TagScopeTerm::key)).setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("key").build()).build();

    private static final SdkField<List<TagValuePair>> TAG_VALUES_FIELD = SdkField
            .<List<TagValuePair>> builder(MarshallingType.LIST)
            .memberName("tagValues")
            .getter(getter(TagScopeTerm::tagValues))
            .setter(setter(Builder::tagValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tagValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TagValuePair> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagValuePair::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TARGET_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("target")
            .getter(getter(TagScopeTerm::targetAsString)).setter(setter(Builder::target))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("target").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPARATOR_FIELD, KEY_FIELD,
            TAG_VALUES_FIELD, TARGET_FIELD));

    private static final long serialVersionUID = 1L;

    private final String comparator;

    private final String key;

    private final List<TagValuePair> tagValues;

    private final String target;

    private TagScopeTerm(BuilderImpl builder) {
        this.comparator = builder.comparator;
        this.key = builder.key;
        this.tagValues = builder.tagValues;
        this.target = builder.target;
    }

    /**
     * <p>
     * The operator to use in the condition. Valid values are EQ (equals) or NE (not equals).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #comparator} will
     * return {@link JobComparator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #comparatorAsString}.
     * </p>
     * 
     * @return The operator to use in the condition. Valid values are EQ (equals) or NE (not equals).
     * @see JobComparator
     */
    public final JobComparator comparator() {
        return JobComparator.fromValue(comparator);
    }

    /**
     * <p>
     * The operator to use in the condition. Valid values are EQ (equals) or NE (not equals).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #comparator} will
     * return {@link JobComparator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #comparatorAsString}.
     * </p>
     * 
     * @return The operator to use in the condition. Valid values are EQ (equals) or NE (not equals).
     * @see JobComparator
     */
    public final String comparatorAsString() {
        return comparator;
    }

    /**
     * <p>
     * The object property to use in the condition. The only valid value is TAG.
     * </p>
     * 
     * @return The object property to use in the condition. The only valid value is TAG.
     */
    public final String key() {
        return key;
    }

    /**
     * For responses, this returns true if the service returned a value for the TagValues property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTagValues() {
        return tagValues != null && !(tagValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tag keys or tag key and value pairs to use in the condition. To specify only tag keys in a condition, specify
     * the keys in this array and set the value for each associated tag value to an empty string.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTagValues} method.
     * </p>
     * 
     * @return The tag keys or tag key and value pairs to use in the condition. To specify only tag keys in a condition,
     *         specify the keys in this array and set the value for each associated tag value to an empty string.
     */
    public final List<TagValuePair> tagValues() {
        return tagValues;
    }

    /**
     * <p>
     * The type of object to apply the condition to.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #target} will
     * return {@link TagTarget#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #targetAsString}.
     * </p>
     * 
     * @return The type of object to apply the condition to.
     * @see TagTarget
     */
    public final TagTarget target() {
        return TagTarget.fromValue(target);
    }

    /**
     * <p>
     * The type of object to apply the condition to.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #target} will
     * return {@link TagTarget#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #targetAsString}.
     * </p>
     * 
     * @return The type of object to apply the condition to.
     * @see TagTarget
     */
    public final String targetAsString() {
        return target;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(comparatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(key());
        hashCode = 31 * hashCode + Objects.hashCode(hasTagValues() ? tagValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(targetAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TagScopeTerm)) {
            return false;
        }
        TagScopeTerm other = (TagScopeTerm) obj;
        return Objects.equals(comparatorAsString(), other.comparatorAsString()) && Objects.equals(key(), other.key())
                && hasTagValues() == other.hasTagValues() && Objects.equals(tagValues(), other.tagValues())
                && Objects.equals(targetAsString(), other.targetAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TagScopeTerm").add("Comparator", comparatorAsString()).add("Key", key())
                .add("TagValues", hasTagValues() ? tagValues() : null).add("Target", targetAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "comparator":
            return Optional.ofNullable(clazz.cast(comparatorAsString()));
        case "key":
            return Optional.ofNullable(clazz.cast(key()));
        case "tagValues":
            return Optional.ofNullable(clazz.cast(tagValues()));
        case "target":
            return Optional.ofNullable(clazz.cast(targetAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TagScopeTerm, T> g) {
        return obj -> g.apply((TagScopeTerm) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TagScopeTerm> {
        /**
         * <p>
         * The operator to use in the condition. Valid values are EQ (equals) or NE (not equals).
         * </p>
         * 
         * @param comparator
         *        The operator to use in the condition. Valid values are EQ (equals) or NE (not equals).
         * @see JobComparator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobComparator
         */
        Builder comparator(String comparator);

        /**
         * <p>
         * The operator to use in the condition. Valid values are EQ (equals) or NE (not equals).
         * </p>
         * 
         * @param comparator
         *        The operator to use in the condition. Valid values are EQ (equals) or NE (not equals).
         * @see JobComparator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobComparator
         */
        Builder comparator(JobComparator comparator);

        /**
         * <p>
         * The object property to use in the condition. The only valid value is TAG.
         * </p>
         * 
         * @param key
         *        The object property to use in the condition. The only valid value is TAG.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * <p>
         * The tag keys or tag key and value pairs to use in the condition. To specify only tag keys in a condition,
         * specify the keys in this array and set the value for each associated tag value to an empty string.
         * </p>
         * 
         * @param tagValues
         *        The tag keys or tag key and value pairs to use in the condition. To specify only tag keys in a
         *        condition, specify the keys in this array and set the value for each associated tag value to an empty
         *        string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagValues(Collection<TagValuePair> tagValues);

        /**
         * <p>
         * The tag keys or tag key and value pairs to use in the condition. To specify only tag keys in a condition,
         * specify the keys in this array and set the value for each associated tag value to an empty string.
         * </p>
         * 
         * @param tagValues
         *        The tag keys or tag key and value pairs to use in the condition. To specify only tag keys in a
         *        condition, specify the keys in this array and set the value for each associated tag value to an empty
         *        string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagValues(TagValuePair... tagValues);

        /**
         * <p>
         * The tag keys or tag key and value pairs to use in the condition. To specify only tag keys in a condition,
         * specify the keys in this array and set the value for each associated tag value to an empty string.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.macie2.model.TagValuePair.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.macie2.model.TagValuePair#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.macie2.model.TagValuePair.Builder#build()} is called immediately and
         * its result is passed to {@link #tagValues(List<TagValuePair>)}.
         * 
         * @param tagValues
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.macie2.model.TagValuePair.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagValues(java.util.Collection<TagValuePair>)
         */
        Builder tagValues(Consumer<TagValuePair.Builder>... tagValues);

        /**
         * <p>
         * The type of object to apply the condition to.
         * </p>
         * 
         * @param target
         *        The type of object to apply the condition to.
         * @see TagTarget
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TagTarget
         */
        Builder target(String target);

        /**
         * <p>
         * The type of object to apply the condition to.
         * </p>
         * 
         * @param target
         *        The type of object to apply the condition to.
         * @see TagTarget
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TagTarget
         */
        Builder target(TagTarget target);
    }

    static final class BuilderImpl implements Builder {
        private String comparator;

        private String key;

        private List<TagValuePair> tagValues = DefaultSdkAutoConstructList.getInstance();

        private String target;

        private BuilderImpl() {
        }

        private BuilderImpl(TagScopeTerm model) {
            comparator(model.comparator);
            key(model.key);
            tagValues(model.tagValues);
            target(model.target);
        }

        public final String getComparator() {
            return comparator;
        }

        public final void setComparator(String comparator) {
            this.comparator = comparator;
        }

        @Override
        public final Builder comparator(String comparator) {
            this.comparator = comparator;
            return this;
        }

        @Override
        public final Builder comparator(JobComparator comparator) {
            this.comparator(comparator == null ? null : comparator.toString());
            return this;
        }

        public final String getKey() {
            return key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final List<TagValuePair.Builder> getTagValues() {
            List<TagValuePair.Builder> result = ___listOfTagValuePairCopier.copyToBuilder(this.tagValues);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagValues(Collection<TagValuePair.BuilderImpl> tagValues) {
            this.tagValues = ___listOfTagValuePairCopier.copyFromBuilder(tagValues);
        }

        @Override
        public final Builder tagValues(Collection<TagValuePair> tagValues) {
            this.tagValues = ___listOfTagValuePairCopier.copy(tagValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagValues(TagValuePair... tagValues) {
            tagValues(Arrays.asList(tagValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagValues(Consumer<TagValuePair.Builder>... tagValues) {
            tagValues(Stream.of(tagValues).map(c -> TagValuePair.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getTarget() {
            return target;
        }

        public final void setTarget(String target) {
            this.target = target;
        }

        @Override
        public final Builder target(String target) {
            this.target = target;
            return this;
        }

        @Override
        public final Builder target(TagTarget target) {
            this.target(target == null ? null : target.toString());
            return this;
        }

        @Override
        public TagScopeTerm build() {
            return new TagScopeTerm(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
