/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.macie2.Macie2Client;
import software.amazon.awssdk.services.macie2.model.ListSensitivityInspectionTemplatesRequest;
import software.amazon.awssdk.services.macie2.model.ListSensitivityInspectionTemplatesResponse;
import software.amazon.awssdk.services.macie2.model.SensitivityInspectionTemplatesEntry;

public class ListSensitivityInspectionTemplatesIterable
implements SdkIterable<ListSensitivityInspectionTemplatesResponse> {
    private final Macie2Client client;
    private final ListSensitivityInspectionTemplatesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSensitivityInspectionTemplatesIterable(Macie2Client client, ListSensitivityInspectionTemplatesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListSensitivityInspectionTemplatesResponseFetcher();
    }

    public Iterator<ListSensitivityInspectionTemplatesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SensitivityInspectionTemplatesEntry> sensitivityInspectionTemplates() {
        Function<ListSensitivityInspectionTemplatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.sensitivityInspectionTemplates() != null) {
                return response.sensitivityInspectionTemplates().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListSensitivityInspectionTemplatesResponseFetcher
    implements SyncPageFetcher<ListSensitivityInspectionTemplatesResponse> {
        private ListSensitivityInspectionTemplatesResponseFetcher() {
        }

        public boolean hasNextPage(ListSensitivityInspectionTemplatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSensitivityInspectionTemplatesResponse nextPage(ListSensitivityInspectionTemplatesResponse previousPage) {
            if (previousPage == null) {
                return ListSensitivityInspectionTemplatesIterable.this.client.listSensitivityInspectionTemplates(ListSensitivityInspectionTemplatesIterable.this.firstRequest);
            }
            return ListSensitivityInspectionTemplatesIterable.this.client.listSensitivityInspectionTemplates((ListSensitivityInspectionTemplatesRequest)((Object)ListSensitivityInspectionTemplatesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

