/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides aggregated statistical data for sensitive data discovery metrics that apply to S3 buckets, grouped by bucket
 * sensitivity score (sensitivityScore). If automated sensitive data discovery is currently disabled for your account,
 * the value for each metric is 0.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BucketStatisticsBySensitivity implements SdkPojo, Serializable,
        ToCopyableBuilder<BucketStatisticsBySensitivity.Builder, BucketStatisticsBySensitivity> {
    private static final SdkField<SensitivityAggregations> CLASSIFICATION_ERROR_FIELD = SdkField
            .<SensitivityAggregations> builder(MarshallingType.SDK_POJO).memberName("classificationError")
            .getter(getter(BucketStatisticsBySensitivity::classificationError)).setter(setter(Builder::classificationError))
            .constructor(SensitivityAggregations::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("classificationError").build())
            .build();

    private static final SdkField<SensitivityAggregations> NOT_CLASSIFIED_FIELD = SdkField
            .<SensitivityAggregations> builder(MarshallingType.SDK_POJO).memberName("notClassified")
            .getter(getter(BucketStatisticsBySensitivity::notClassified)).setter(setter(Builder::notClassified))
            .constructor(SensitivityAggregations::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notClassified").build()).build();

    private static final SdkField<SensitivityAggregations> NOT_SENSITIVE_FIELD = SdkField
            .<SensitivityAggregations> builder(MarshallingType.SDK_POJO).memberName("notSensitive")
            .getter(getter(BucketStatisticsBySensitivity::notSensitive)).setter(setter(Builder::notSensitive))
            .constructor(SensitivityAggregations::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notSensitive").build()).build();

    private static final SdkField<SensitivityAggregations> SENSITIVE_FIELD = SdkField
            .<SensitivityAggregations> builder(MarshallingType.SDK_POJO).memberName("sensitive")
            .getter(getter(BucketStatisticsBySensitivity::sensitive)).setter(setter(Builder::sensitive))
            .constructor(SensitivityAggregations::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sensitive").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLASSIFICATION_ERROR_FIELD,
            NOT_CLASSIFIED_FIELD, NOT_SENSITIVE_FIELD, SENSITIVE_FIELD));

    private static final long serialVersionUID = 1L;

    private final SensitivityAggregations classificationError;

    private final SensitivityAggregations notClassified;

    private final SensitivityAggregations notSensitive;

    private final SensitivityAggregations sensitive;

    private BucketStatisticsBySensitivity(BuilderImpl builder) {
        this.classificationError = builder.classificationError;
        this.notClassified = builder.notClassified;
        this.notSensitive = builder.notSensitive;
        this.sensitive = builder.sensitive;
    }

    /**
     * <p>
     * The aggregated statistical data for all buckets that have a sensitivity score of -1.
     * </p>
     * 
     * @return The aggregated statistical data for all buckets that have a sensitivity score of -1.
     */
    public final SensitivityAggregations classificationError() {
        return classificationError;
    }

    /**
     * <p>
     * The aggregated statistical data for all buckets that have a sensitivity score of 50.
     * </p>
     * 
     * @return The aggregated statistical data for all buckets that have a sensitivity score of 50.
     */
    public final SensitivityAggregations notClassified() {
        return notClassified;
    }

    /**
     * <p>
     * The aggregated statistical data for all buckets that have a sensitivity score of 0-49.
     * </p>
     * 
     * @return The aggregated statistical data for all buckets that have a sensitivity score of 0-49.
     */
    public final SensitivityAggregations notSensitive() {
        return notSensitive;
    }

    /**
     * <p>
     * The aggregated statistical data for all buckets that have a sensitivity score of 51-100.
     * </p>
     * 
     * @return The aggregated statistical data for all buckets that have a sensitivity score of 51-100.
     */
    public final SensitivityAggregations sensitive() {
        return sensitive;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(classificationError());
        hashCode = 31 * hashCode + Objects.hashCode(notClassified());
        hashCode = 31 * hashCode + Objects.hashCode(notSensitive());
        hashCode = 31 * hashCode + Objects.hashCode(sensitive());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BucketStatisticsBySensitivity)) {
            return false;
        }
        BucketStatisticsBySensitivity other = (BucketStatisticsBySensitivity) obj;
        return Objects.equals(classificationError(), other.classificationError())
                && Objects.equals(notClassified(), other.notClassified()) && Objects.equals(notSensitive(), other.notSensitive())
                && Objects.equals(sensitive(), other.sensitive());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BucketStatisticsBySensitivity").add("ClassificationError", classificationError())
                .add("NotClassified", notClassified()).add("NotSensitive", notSensitive()).add("Sensitive", sensitive()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "classificationError":
            return Optional.ofNullable(clazz.cast(classificationError()));
        case "notClassified":
            return Optional.ofNullable(clazz.cast(notClassified()));
        case "notSensitive":
            return Optional.ofNullable(clazz.cast(notSensitive()));
        case "sensitive":
            return Optional.ofNullable(clazz.cast(sensitive()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BucketStatisticsBySensitivity, T> g) {
        return obj -> g.apply((BucketStatisticsBySensitivity) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BucketStatisticsBySensitivity> {
        /**
         * <p>
         * The aggregated statistical data for all buckets that have a sensitivity score of -1.
         * </p>
         * 
         * @param classificationError
         *        The aggregated statistical data for all buckets that have a sensitivity score of -1.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder classificationError(SensitivityAggregations classificationError);

        /**
         * <p>
         * The aggregated statistical data for all buckets that have a sensitivity score of -1.
         * </p>
         * This is a convenience method that creates an instance of the {@link SensitivityAggregations.Builder} avoiding
         * the need to create one manually via {@link SensitivityAggregations#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SensitivityAggregations.Builder#build()} is called immediately
         * and its result is passed to {@link #classificationError(SensitivityAggregations)}.
         * 
         * @param classificationError
         *        a consumer that will call methods on {@link SensitivityAggregations.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #classificationError(SensitivityAggregations)
         */
        default Builder classificationError(Consumer<SensitivityAggregations.Builder> classificationError) {
            return classificationError(SensitivityAggregations.builder().applyMutation(classificationError).build());
        }

        /**
         * <p>
         * The aggregated statistical data for all buckets that have a sensitivity score of 50.
         * </p>
         * 
         * @param notClassified
         *        The aggregated statistical data for all buckets that have a sensitivity score of 50.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notClassified(SensitivityAggregations notClassified);

        /**
         * <p>
         * The aggregated statistical data for all buckets that have a sensitivity score of 50.
         * </p>
         * This is a convenience method that creates an instance of the {@link SensitivityAggregations.Builder} avoiding
         * the need to create one manually via {@link SensitivityAggregations#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SensitivityAggregations.Builder#build()} is called immediately
         * and its result is passed to {@link #notClassified(SensitivityAggregations)}.
         * 
         * @param notClassified
         *        a consumer that will call methods on {@link SensitivityAggregations.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #notClassified(SensitivityAggregations)
         */
        default Builder notClassified(Consumer<SensitivityAggregations.Builder> notClassified) {
            return notClassified(SensitivityAggregations.builder().applyMutation(notClassified).build());
        }

        /**
         * <p>
         * The aggregated statistical data for all buckets that have a sensitivity score of 0-49.
         * </p>
         * 
         * @param notSensitive
         *        The aggregated statistical data for all buckets that have a sensitivity score of 0-49.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notSensitive(SensitivityAggregations notSensitive);

        /**
         * <p>
         * The aggregated statistical data for all buckets that have a sensitivity score of 0-49.
         * </p>
         * This is a convenience method that creates an instance of the {@link SensitivityAggregations.Builder} avoiding
         * the need to create one manually via {@link SensitivityAggregations#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SensitivityAggregations.Builder#build()} is called immediately
         * and its result is passed to {@link #notSensitive(SensitivityAggregations)}.
         * 
         * @param notSensitive
         *        a consumer that will call methods on {@link SensitivityAggregations.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #notSensitive(SensitivityAggregations)
         */
        default Builder notSensitive(Consumer<SensitivityAggregations.Builder> notSensitive) {
            return notSensitive(SensitivityAggregations.builder().applyMutation(notSensitive).build());
        }

        /**
         * <p>
         * The aggregated statistical data for all buckets that have a sensitivity score of 51-100.
         * </p>
         * 
         * @param sensitive
         *        The aggregated statistical data for all buckets that have a sensitivity score of 51-100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sensitive(SensitivityAggregations sensitive);

        /**
         * <p>
         * The aggregated statistical data for all buckets that have a sensitivity score of 51-100.
         * </p>
         * This is a convenience method that creates an instance of the {@link SensitivityAggregations.Builder} avoiding
         * the need to create one manually via {@link SensitivityAggregations#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SensitivityAggregations.Builder#build()} is called immediately
         * and its result is passed to {@link #sensitive(SensitivityAggregations)}.
         * 
         * @param sensitive
         *        a consumer that will call methods on {@link SensitivityAggregations.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sensitive(SensitivityAggregations)
         */
        default Builder sensitive(Consumer<SensitivityAggregations.Builder> sensitive) {
            return sensitive(SensitivityAggregations.builder().applyMutation(sensitive).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SensitivityAggregations classificationError;

        private SensitivityAggregations notClassified;

        private SensitivityAggregations notSensitive;

        private SensitivityAggregations sensitive;

        private BuilderImpl() {
        }

        private BuilderImpl(BucketStatisticsBySensitivity model) {
            classificationError(model.classificationError);
            notClassified(model.notClassified);
            notSensitive(model.notSensitive);
            sensitive(model.sensitive);
        }

        public final SensitivityAggregations.Builder getClassificationError() {
            return classificationError != null ? classificationError.toBuilder() : null;
        }

        public final void setClassificationError(SensitivityAggregations.BuilderImpl classificationError) {
            this.classificationError = classificationError != null ? classificationError.build() : null;
        }

        @Override
        public final Builder classificationError(SensitivityAggregations classificationError) {
            this.classificationError = classificationError;
            return this;
        }

        public final SensitivityAggregations.Builder getNotClassified() {
            return notClassified != null ? notClassified.toBuilder() : null;
        }

        public final void setNotClassified(SensitivityAggregations.BuilderImpl notClassified) {
            this.notClassified = notClassified != null ? notClassified.build() : null;
        }

        @Override
        public final Builder notClassified(SensitivityAggregations notClassified) {
            this.notClassified = notClassified;
            return this;
        }

        public final SensitivityAggregations.Builder getNotSensitive() {
            return notSensitive != null ? notSensitive.toBuilder() : null;
        }

        public final void setNotSensitive(SensitivityAggregations.BuilderImpl notSensitive) {
            this.notSensitive = notSensitive != null ? notSensitive.build() : null;
        }

        @Override
        public final Builder notSensitive(SensitivityAggregations notSensitive) {
            this.notSensitive = notSensitive;
            return this;
        }

        public final SensitivityAggregations.Builder getSensitive() {
            return sensitive != null ? sensitive.toBuilder() : null;
        }

        public final void setSensitive(SensitivityAggregations.BuilderImpl sensitive) {
            this.sensitive = sensitive != null ? sensitive.build() : null;
        }

        @Override
        public final Builder sensitive(SensitivityAggregations sensitive) {
            this.sensitive = sensitive;
            return this;
        }

        @Override
        public BucketStatisticsBySensitivity build() {
            return new BucketStatisticsBySensitivity(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
