/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.services.macie2.auth.scheme.Macie2AuthSchemeProvider;
import software.amazon.awssdk.services.macie2.endpoints.Macie2EndpointProvider;

/**
 * This includes configuration specific to Amazon Macie 2 that is supported by both {@link Macie2ClientBuilder} and
 * {@link Macie2AsyncClientBuilder}.
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
public interface Macie2BaseClientBuilder<B extends Macie2BaseClientBuilder<B, C>, C> extends AwsClientBuilder<B, C> {
    /**
     * Set the {@link Macie2EndpointProvider} implementation that will be used by the client to determine the endpoint
     * for each request. This is optional; if none is provided a default implementation will be used the SDK.
     */
    default B endpointProvider(Macie2EndpointProvider endpointProvider) {
        throw new UnsupportedOperationException();
    }

    /**
     * Set the {@link Macie2AuthSchemeProvider} implementation that will be used by the client to resolve the auth
     * scheme for each request. This is optional; if none is provided a default implementation will be used the SDK.
     */
    default B authSchemeProvider(Macie2AuthSchemeProvider authSchemeProvider) {
        throw new UnsupportedOperationException();
    }
}
