/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateClassificationJobRequest extends Macie2Request implements
        ToCopyableBuilder<CreateClassificationJobRequest.Builder, CreateClassificationJobRequest> {
    private static final SdkField<List<String>> ALLOW_LIST_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("allowListIds")
            .getter(getter(CreateClassificationJobRequest::allowListIds))
            .setter(setter(Builder::allowListIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowListIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateClassificationJobRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<List<String>> CUSTOM_DATA_IDENTIFIER_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("customDataIdentifierIds")
            .getter(getter(CreateClassificationJobRequest::customDataIdentifierIds))
            .setter(setter(Builder::customDataIdentifierIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customDataIdentifierIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateClassificationJobRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Boolean> INITIAL_RUN_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("initialRun").getter(getter(CreateClassificationJobRequest::initialRun))
            .setter(setter(Builder::initialRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("initialRun").build()).build();

    private static final SdkField<String> JOB_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobType").getter(getter(CreateClassificationJobRequest::jobTypeAsString))
            .setter(setter(Builder::jobType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobType").build()).build();

    private static final SdkField<List<String>> MANAGED_DATA_IDENTIFIER_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("managedDataIdentifierIds")
            .getter(getter(CreateClassificationJobRequest::managedDataIdentifierIds))
            .setter(setter(Builder::managedDataIdentifierIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managedDataIdentifierIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> MANAGED_DATA_IDENTIFIER_SELECTOR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("managedDataIdentifierSelector")
            .getter(getter(CreateClassificationJobRequest::managedDataIdentifierSelectorAsString))
            .setter(setter(Builder::managedDataIdentifierSelector))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managedDataIdentifierSelector")
                    .build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateClassificationJobRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<S3JobDefinition> S3_JOB_DEFINITION_FIELD = SdkField
            .<S3JobDefinition> builder(MarshallingType.SDK_POJO).memberName("s3JobDefinition")
            .getter(getter(CreateClassificationJobRequest::s3JobDefinition)).setter(setter(Builder::s3JobDefinition))
            .constructor(S3JobDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3JobDefinition").build()).build();

    private static final SdkField<Integer> SAMPLING_PERCENTAGE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("samplingPercentage").getter(getter(CreateClassificationJobRequest::samplingPercentage))
            .setter(setter(Builder::samplingPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("samplingPercentage").build())
            .build();

    private static final SdkField<JobScheduleFrequency> SCHEDULE_FREQUENCY_FIELD = SdkField
            .<JobScheduleFrequency> builder(MarshallingType.SDK_POJO).memberName("scheduleFrequency")
            .getter(getter(CreateClassificationJobRequest::scheduleFrequency)).setter(setter(Builder::scheduleFrequency))
            .constructor(JobScheduleFrequency::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheduleFrequency").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateClassificationJobRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOW_LIST_IDS_FIELD,
            CLIENT_TOKEN_FIELD, CUSTOM_DATA_IDENTIFIER_IDS_FIELD, DESCRIPTION_FIELD, INITIAL_RUN_FIELD, JOB_TYPE_FIELD,
            MANAGED_DATA_IDENTIFIER_IDS_FIELD, MANAGED_DATA_IDENTIFIER_SELECTOR_FIELD, NAME_FIELD, S3_JOB_DEFINITION_FIELD,
            SAMPLING_PERCENTAGE_FIELD, SCHEDULE_FREQUENCY_FIELD, TAGS_FIELD));

    private final List<String> allowListIds;

    private final String clientToken;

    private final List<String> customDataIdentifierIds;

    private final String description;

    private final Boolean initialRun;

    private final String jobType;

    private final List<String> managedDataIdentifierIds;

    private final String managedDataIdentifierSelector;

    private final String name;

    private final S3JobDefinition s3JobDefinition;

    private final Integer samplingPercentage;

    private final JobScheduleFrequency scheduleFrequency;

    private final Map<String, String> tags;

    private CreateClassificationJobRequest(BuilderImpl builder) {
        super(builder);
        this.allowListIds = builder.allowListIds;
        this.clientToken = builder.clientToken;
        this.customDataIdentifierIds = builder.customDataIdentifierIds;
        this.description = builder.description;
        this.initialRun = builder.initialRun;
        this.jobType = builder.jobType;
        this.managedDataIdentifierIds = builder.managedDataIdentifierIds;
        this.managedDataIdentifierSelector = builder.managedDataIdentifierSelector;
        this.name = builder.name;
        this.s3JobDefinition = builder.s3JobDefinition;
        this.samplingPercentage = builder.samplingPercentage;
        this.scheduleFrequency = builder.scheduleFrequency;
        this.tags = builder.tags;
    }

    /**
     * For responses, this returns true if the service returned a value for the AllowListIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAllowListIds() {
        return allowListIds != null && !(allowListIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of unique identifiers, one for each allow list for the job to use when it analyzes data.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAllowListIds} method.
     * </p>
     * 
     * @return An array of unique identifiers, one for each allow list for the job to use when it analyzes data.
     */
    public final List<String> allowListIds() {
        return allowListIds;
    }

    /**
     * <p>
     * A unique, case-sensitive token that you provide to ensure the idempotency of the request.
     * </p>
     * 
     * @return A unique, case-sensitive token that you provide to ensure the idempotency of the request.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the CustomDataIdentifierIds property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCustomDataIdentifierIds() {
        return customDataIdentifierIds != null && !(customDataIdentifierIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of unique identifiers, one for each custom data identifier for the job to use when it analyzes data. To
     * use only managed data identifiers, don't specify a value for this property and specify a value other than NONE
     * for the managedDataIdentifierSelector property.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCustomDataIdentifierIds} method.
     * </p>
     * 
     * @return An array of unique identifiers, one for each custom data identifier for the job to use when it analyzes
     *         data. To use only managed data identifiers, don't specify a value for this property and specify a value
     *         other than NONE for the managedDataIdentifierSelector property.
     */
    public final List<String> customDataIdentifierIds() {
        return customDataIdentifierIds;
    }

    /**
     * <p>
     * A custom description of the job. The description can contain as many as 200 characters.
     * </p>
     * 
     * @return A custom description of the job. The description can contain as many as 200 characters.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * For a recurring job, specifies whether to analyze all existing, eligible objects immediately after the job is
     * created (true). To analyze only those objects that are created or changed after you create the job and before the
     * job's first scheduled run, set this value to false.
     * </p>
     * <p>
     * If you configure the job to run only once, don't specify a value for this property.
     * </p>
     * 
     * @return For a recurring job, specifies whether to analyze all existing, eligible objects immediately after the
     *         job is created (true). To analyze only those objects that are created or changed after you create the job
     *         and before the job's first scheduled run, set this value to false.</p>
     *         <p>
     *         If you configure the job to run only once, don't specify a value for this property.
     */
    public final Boolean initialRun() {
        return initialRun;
    }

    /**
     * <p>
     * The schedule for running the job. Valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * ONE_TIME - Run the job only once. If you specify this value, don't specify a value for the scheduleFrequency
     * property.
     * </p>
     * </li>
     * <li>
     * <p>
     * SCHEDULED - Run the job on a daily, weekly, or monthly basis. If you specify this value, use the
     * scheduleFrequency property to define the recurrence pattern for the job.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobType} will
     * return {@link JobType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobTypeAsString}.
     * </p>
     * 
     * @return The schedule for running the job. Valid values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         ONE_TIME - Run the job only once. If you specify this value, don't specify a value for the
     *         scheduleFrequency property.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SCHEDULED - Run the job on a daily, weekly, or monthly basis. If you specify this value, use the
     *         scheduleFrequency property to define the recurrence pattern for the job.
     *         </p>
     *         </li>
     * @see JobType
     */
    public final JobType jobType() {
        return JobType.fromValue(jobType);
    }

    /**
     * <p>
     * The schedule for running the job. Valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * ONE_TIME - Run the job only once. If you specify this value, don't specify a value for the scheduleFrequency
     * property.
     * </p>
     * </li>
     * <li>
     * <p>
     * SCHEDULED - Run the job on a daily, weekly, or monthly basis. If you specify this value, use the
     * scheduleFrequency property to define the recurrence pattern for the job.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobType} will
     * return {@link JobType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobTypeAsString}.
     * </p>
     * 
     * @return The schedule for running the job. Valid values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         ONE_TIME - Run the job only once. If you specify this value, don't specify a value for the
     *         scheduleFrequency property.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SCHEDULED - Run the job on a daily, weekly, or monthly basis. If you specify this value, use the
     *         scheduleFrequency property to define the recurrence pattern for the job.
     *         </p>
     *         </li>
     * @see JobType
     */
    public final String jobTypeAsString() {
        return jobType;
    }

    /**
     * For responses, this returns true if the service returned a value for the ManagedDataIdentifierIds property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasManagedDataIdentifierIds() {
        return managedDataIdentifierIds != null && !(managedDataIdentifierIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of unique identifiers, one for each managed data identifier for the job to include (use) or exclude (not
     * use) when it analyzes data. Inclusion or exclusion depends on the managed data identifier selection type that you
     * specify for the job (managedDataIdentifierSelector).
     * </p>
     * <p>
     * To retrieve a list of valid values for this property, use the ListManagedDataIdentifiers operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasManagedDataIdentifierIds} method.
     * </p>
     * 
     * @return An array of unique identifiers, one for each managed data identifier for the job to include (use) or
     *         exclude (not use) when it analyzes data. Inclusion or exclusion depends on the managed data identifier
     *         selection type that you specify for the job (managedDataIdentifierSelector).</p>
     *         <p>
     *         To retrieve a list of valid values for this property, use the ListManagedDataIdentifiers operation.
     */
    public final List<String> managedDataIdentifierIds() {
        return managedDataIdentifierIds;
    }

    /**
     * <p>
     * The selection type to apply when determining which managed data identifiers the job uses to analyze data. Valid
     * values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * ALL - Use all managed data identifiers. If you specify this value, don't specify any values for the
     * managedDataIdentifierIds property.
     * </p>
     * </li>
     * <li>
     * <p>
     * EXCLUDE - Use all managed data identifiers except the ones specified by the managedDataIdentifierIds property.
     * </p>
     * </li>
     * <li>
     * <p>
     * INCLUDE - Use only the managed data identifiers specified by the managedDataIdentifierIds property.
     * </p>
     * </li>
     * <li>
     * <p>
     * NONE - Don't use any managed data identifiers. If you specify this value, specify at least one value for the
     * customDataIdentifierIds property and don't specify any values for the managedDataIdentifierIds property.
     * </p>
     * </li>
     * <li>
     * <p>
     * RECOMMENDED (default) - Use the recommended set of managed data identifiers. If you specify this value, don't
     * specify any values for the managedDataIdentifierIds property.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you don't specify a value for this property, the job uses the recommended set of managed data identifiers.
     * </p>
     * <p>
     * If the job is a recurring job and you specify ALL or EXCLUDE, each job run automatically uses new managed data
     * identifiers that are released. If you don't specify a value for this property or you specify RECOMMENDED for a
     * recurring job, each job run automatically uses all the managed data identifiers that are in the recommended set
     * when the run starts.
     * </p>
     * <p>
     * For information about individual managed data identifiers or to determine which ones are in the recommended set,
     * see <a href="https://docs.aws.amazon.com/macie/latest/user/managed-data-identifiers.html">Using managed data
     * identifiers</a> and <a
     * href="https://docs.aws.amazon.com/macie/latest/user/discovery-jobs-mdis-recommended.html">Recommended managed
     * data identifiers</a> in the <i>Amazon Macie User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #managedDataIdentifierSelector} will return {@link ManagedDataIdentifierSelector#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #managedDataIdentifierSelectorAsString}.
     * </p>
     * 
     * @return The selection type to apply when determining which managed data identifiers the job uses to analyze data.
     *         Valid values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         ALL - Use all managed data identifiers. If you specify this value, don't specify any values for the
     *         managedDataIdentifierIds property.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         EXCLUDE - Use all managed data identifiers except the ones specified by the managedDataIdentifierIds
     *         property.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INCLUDE - Use only the managed data identifiers specified by the managedDataIdentifierIds property.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NONE - Don't use any managed data identifiers. If you specify this value, specify at least one value for
     *         the customDataIdentifierIds property and don't specify any values for the managedDataIdentifierIds
     *         property.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RECOMMENDED (default) - Use the recommended set of managed data identifiers. If you specify this value,
     *         don't specify any values for the managedDataIdentifierIds property.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If you don't specify a value for this property, the job uses the recommended set of managed data
     *         identifiers.
     *         </p>
     *         <p>
     *         If the job is a recurring job and you specify ALL or EXCLUDE, each job run automatically uses new managed
     *         data identifiers that are released. If you don't specify a value for this property or you specify
     *         RECOMMENDED for a recurring job, each job run automatically uses all the managed data identifiers that
     *         are in the recommended set when the run starts.
     *         </p>
     *         <p>
     *         For information about individual managed data identifiers or to determine which ones are in the
     *         recommended set, see <a
     *         href="https://docs.aws.amazon.com/macie/latest/user/managed-data-identifiers.html">Using managed data
     *         identifiers</a> and <a
     *         href="https://docs.aws.amazon.com/macie/latest/user/discovery-jobs-mdis-recommended.html">Recommended
     *         managed data identifiers</a> in the <i>Amazon Macie User Guide</i>.
     * @see ManagedDataIdentifierSelector
     */
    public final ManagedDataIdentifierSelector managedDataIdentifierSelector() {
        return ManagedDataIdentifierSelector.fromValue(managedDataIdentifierSelector);
    }

    /**
     * <p>
     * The selection type to apply when determining which managed data identifiers the job uses to analyze data. Valid
     * values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * ALL - Use all managed data identifiers. If you specify this value, don't specify any values for the
     * managedDataIdentifierIds property.
     * </p>
     * </li>
     * <li>
     * <p>
     * EXCLUDE - Use all managed data identifiers except the ones specified by the managedDataIdentifierIds property.
     * </p>
     * </li>
     * <li>
     * <p>
     * INCLUDE - Use only the managed data identifiers specified by the managedDataIdentifierIds property.
     * </p>
     * </li>
     * <li>
     * <p>
     * NONE - Don't use any managed data identifiers. If you specify this value, specify at least one value for the
     * customDataIdentifierIds property and don't specify any values for the managedDataIdentifierIds property.
     * </p>
     * </li>
     * <li>
     * <p>
     * RECOMMENDED (default) - Use the recommended set of managed data identifiers. If you specify this value, don't
     * specify any values for the managedDataIdentifierIds property.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you don't specify a value for this property, the job uses the recommended set of managed data identifiers.
     * </p>
     * <p>
     * If the job is a recurring job and you specify ALL or EXCLUDE, each job run automatically uses new managed data
     * identifiers that are released. If you don't specify a value for this property or you specify RECOMMENDED for a
     * recurring job, each job run automatically uses all the managed data identifiers that are in the recommended set
     * when the run starts.
     * </p>
     * <p>
     * For information about individual managed data identifiers or to determine which ones are in the recommended set,
     * see <a href="https://docs.aws.amazon.com/macie/latest/user/managed-data-identifiers.html">Using managed data
     * identifiers</a> and <a
     * href="https://docs.aws.amazon.com/macie/latest/user/discovery-jobs-mdis-recommended.html">Recommended managed
     * data identifiers</a> in the <i>Amazon Macie User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #managedDataIdentifierSelector} will return {@link ManagedDataIdentifierSelector#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #managedDataIdentifierSelectorAsString}.
     * </p>
     * 
     * @return The selection type to apply when determining which managed data identifiers the job uses to analyze data.
     *         Valid values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         ALL - Use all managed data identifiers. If you specify this value, don't specify any values for the
     *         managedDataIdentifierIds property.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         EXCLUDE - Use all managed data identifiers except the ones specified by the managedDataIdentifierIds
     *         property.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INCLUDE - Use only the managed data identifiers specified by the managedDataIdentifierIds property.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NONE - Don't use any managed data identifiers. If you specify this value, specify at least one value for
     *         the customDataIdentifierIds property and don't specify any values for the managedDataIdentifierIds
     *         property.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RECOMMENDED (default) - Use the recommended set of managed data identifiers. If you specify this value,
     *         don't specify any values for the managedDataIdentifierIds property.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If you don't specify a value for this property, the job uses the recommended set of managed data
     *         identifiers.
     *         </p>
     *         <p>
     *         If the job is a recurring job and you specify ALL or EXCLUDE, each job run automatically uses new managed
     *         data identifiers that are released. If you don't specify a value for this property or you specify
     *         RECOMMENDED for a recurring job, each job run automatically uses all the managed data identifiers that
     *         are in the recommended set when the run starts.
     *         </p>
     *         <p>
     *         For information about individual managed data identifiers or to determine which ones are in the
     *         recommended set, see <a
     *         href="https://docs.aws.amazon.com/macie/latest/user/managed-data-identifiers.html">Using managed data
     *         identifiers</a> and <a
     *         href="https://docs.aws.amazon.com/macie/latest/user/discovery-jobs-mdis-recommended.html">Recommended
     *         managed data identifiers</a> in the <i>Amazon Macie User Guide</i>.
     * @see ManagedDataIdentifierSelector
     */
    public final String managedDataIdentifierSelectorAsString() {
        return managedDataIdentifierSelector;
    }

    /**
     * <p>
     * A custom name for the job. The name can contain as many as 500 characters.
     * </p>
     * 
     * @return A custom name for the job. The name can contain as many as 500 characters.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The S3 buckets that contain the objects to analyze, and the scope of that analysis.
     * </p>
     * 
     * @return The S3 buckets that contain the objects to analyze, and the scope of that analysis.
     */
    public final S3JobDefinition s3JobDefinition() {
        return s3JobDefinition;
    }

    /**
     * <p>
     * The sampling depth, as a percentage, for the job to apply when processing objects. This value determines the
     * percentage of eligible objects that the job analyzes. If this value is less than 100, Amazon Macie selects the
     * objects to analyze at random, up to the specified percentage, and analyzes all the data in those objects.
     * </p>
     * 
     * @return The sampling depth, as a percentage, for the job to apply when processing objects. This value determines
     *         the percentage of eligible objects that the job analyzes. If this value is less than 100, Amazon Macie
     *         selects the objects to analyze at random, up to the specified percentage, and analyzes all the data in
     *         those objects.
     */
    public final Integer samplingPercentage() {
        return samplingPercentage;
    }

    /**
     * <p>
     * The recurrence pattern for running the job. To run the job only once, don't specify a value for this property and
     * set the value for the jobType property to ONE_TIME.
     * </p>
     * 
     * @return The recurrence pattern for running the job. To run the job only once, don't specify a value for this
     *         property and set the value for the jobType property to ONE_TIME.
     */
    public final JobScheduleFrequency scheduleFrequency() {
        return scheduleFrequency;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of key-value pairs that specifies the tags to associate with the job.
     * </p>
     * <p>
     * A job can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value. The maximum
     * length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A map of key-value pairs that specifies the tags to associate with the job.</p>
     *         <p>
     *         A job can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value. The
     *         maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAllowListIds() ? allowListIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasCustomDataIdentifierIds() ? customDataIdentifierIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(initialRun());
        hashCode = 31 * hashCode + Objects.hashCode(jobTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasManagedDataIdentifierIds() ? managedDataIdentifierIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(managedDataIdentifierSelectorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(s3JobDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(samplingPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(scheduleFrequency());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateClassificationJobRequest)) {
            return false;
        }
        CreateClassificationJobRequest other = (CreateClassificationJobRequest) obj;
        return hasAllowListIds() == other.hasAllowListIds() && Objects.equals(allowListIds(), other.allowListIds())
                && Objects.equals(clientToken(), other.clientToken())
                && hasCustomDataIdentifierIds() == other.hasCustomDataIdentifierIds()
                && Objects.equals(customDataIdentifierIds(), other.customDataIdentifierIds())
                && Objects.equals(description(), other.description()) && Objects.equals(initialRun(), other.initialRun())
                && Objects.equals(jobTypeAsString(), other.jobTypeAsString())
                && hasManagedDataIdentifierIds() == other.hasManagedDataIdentifierIds()
                && Objects.equals(managedDataIdentifierIds(), other.managedDataIdentifierIds())
                && Objects.equals(managedDataIdentifierSelectorAsString(), other.managedDataIdentifierSelectorAsString())
                && Objects.equals(name(), other.name()) && Objects.equals(s3JobDefinition(), other.s3JobDefinition())
                && Objects.equals(samplingPercentage(), other.samplingPercentage())
                && Objects.equals(scheduleFrequency(), other.scheduleFrequency()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateClassificationJobRequest").add("AllowListIds", hasAllowListIds() ? allowListIds() : null)
                .add("ClientToken", clientToken())
                .add("CustomDataIdentifierIds", hasCustomDataIdentifierIds() ? customDataIdentifierIds() : null)
                .add("Description", description()).add("InitialRun", initialRun()).add("JobType", jobTypeAsString())
                .add("ManagedDataIdentifierIds", hasManagedDataIdentifierIds() ? managedDataIdentifierIds() : null)
                .add("ManagedDataIdentifierSelector", managedDataIdentifierSelectorAsString()).add("Name", name())
                .add("S3JobDefinition", s3JobDefinition()).add("SamplingPercentage", samplingPercentage())
                .add("ScheduleFrequency", scheduleFrequency()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "allowListIds":
            return Optional.ofNullable(clazz.cast(allowListIds()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "customDataIdentifierIds":
            return Optional.ofNullable(clazz.cast(customDataIdentifierIds()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "initialRun":
            return Optional.ofNullable(clazz.cast(initialRun()));
        case "jobType":
            return Optional.ofNullable(clazz.cast(jobTypeAsString()));
        case "managedDataIdentifierIds":
            return Optional.ofNullable(clazz.cast(managedDataIdentifierIds()));
        case "managedDataIdentifierSelector":
            return Optional.ofNullable(clazz.cast(managedDataIdentifierSelectorAsString()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "s3JobDefinition":
            return Optional.ofNullable(clazz.cast(s3JobDefinition()));
        case "samplingPercentage":
            return Optional.ofNullable(clazz.cast(samplingPercentage()));
        case "scheduleFrequency":
            return Optional.ofNullable(clazz.cast(scheduleFrequency()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateClassificationJobRequest, T> g) {
        return obj -> g.apply((CreateClassificationJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Macie2Request.Builder, SdkPojo, CopyableBuilder<Builder, CreateClassificationJobRequest> {
        /**
         * <p>
         * An array of unique identifiers, one for each allow list for the job to use when it analyzes data.
         * </p>
         * 
         * @param allowListIds
         *        An array of unique identifiers, one for each allow list for the job to use when it analyzes data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowListIds(Collection<String> allowListIds);

        /**
         * <p>
         * An array of unique identifiers, one for each allow list for the job to use when it analyzes data.
         * </p>
         * 
         * @param allowListIds
         *        An array of unique identifiers, one for each allow list for the job to use when it analyzes data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowListIds(String... allowListIds);

        /**
         * <p>
         * A unique, case-sensitive token that you provide to ensure the idempotency of the request.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive token that you provide to ensure the idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * An array of unique identifiers, one for each custom data identifier for the job to use when it analyzes data.
         * To use only managed data identifiers, don't specify a value for this property and specify a value other than
         * NONE for the managedDataIdentifierSelector property.
         * </p>
         * 
         * @param customDataIdentifierIds
         *        An array of unique identifiers, one for each custom data identifier for the job to use when it
         *        analyzes data. To use only managed data identifiers, don't specify a value for this property and
         *        specify a value other than NONE for the managedDataIdentifierSelector property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customDataIdentifierIds(Collection<String> customDataIdentifierIds);

        /**
         * <p>
         * An array of unique identifiers, one for each custom data identifier for the job to use when it analyzes data.
         * To use only managed data identifiers, don't specify a value for this property and specify a value other than
         * NONE for the managedDataIdentifierSelector property.
         * </p>
         * 
         * @param customDataIdentifierIds
         *        An array of unique identifiers, one for each custom data identifier for the job to use when it
         *        analyzes data. To use only managed data identifiers, don't specify a value for this property and
         *        specify a value other than NONE for the managedDataIdentifierSelector property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customDataIdentifierIds(String... customDataIdentifierIds);

        /**
         * <p>
         * A custom description of the job. The description can contain as many as 200 characters.
         * </p>
         * 
         * @param description
         *        A custom description of the job. The description can contain as many as 200 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * For a recurring job, specifies whether to analyze all existing, eligible objects immediately after the job is
         * created (true). To analyze only those objects that are created or changed after you create the job and before
         * the job's first scheduled run, set this value to false.
         * </p>
         * <p>
         * If you configure the job to run only once, don't specify a value for this property.
         * </p>
         * 
         * @param initialRun
         *        For a recurring job, specifies whether to analyze all existing, eligible objects immediately after the
         *        job is created (true). To analyze only those objects that are created or changed after you create the
         *        job and before the job's first scheduled run, set this value to false.</p>
         *        <p>
         *        If you configure the job to run only once, don't specify a value for this property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initialRun(Boolean initialRun);

        /**
         * <p>
         * The schedule for running the job. Valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * ONE_TIME - Run the job only once. If you specify this value, don't specify a value for the scheduleFrequency
         * property.
         * </p>
         * </li>
         * <li>
         * <p>
         * SCHEDULED - Run the job on a daily, weekly, or monthly basis. If you specify this value, use the
         * scheduleFrequency property to define the recurrence pattern for the job.
         * </p>
         * </li>
         * </ul>
         * 
         * @param jobType
         *        The schedule for running the job. Valid values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        ONE_TIME - Run the job only once. If you specify this value, don't specify a value for the
         *        scheduleFrequency property.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SCHEDULED - Run the job on a daily, weekly, or monthly basis. If you specify this value, use the
         *        scheduleFrequency property to define the recurrence pattern for the job.
         *        </p>
         *        </li>
         * @see JobType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobType
         */
        Builder jobType(String jobType);

        /**
         * <p>
         * The schedule for running the job. Valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * ONE_TIME - Run the job only once. If you specify this value, don't specify a value for the scheduleFrequency
         * property.
         * </p>
         * </li>
         * <li>
         * <p>
         * SCHEDULED - Run the job on a daily, weekly, or monthly basis. If you specify this value, use the
         * scheduleFrequency property to define the recurrence pattern for the job.
         * </p>
         * </li>
         * </ul>
         * 
         * @param jobType
         *        The schedule for running the job. Valid values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        ONE_TIME - Run the job only once. If you specify this value, don't specify a value for the
         *        scheduleFrequency property.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SCHEDULED - Run the job on a daily, weekly, or monthly basis. If you specify this value, use the
         *        scheduleFrequency property to define the recurrence pattern for the job.
         *        </p>
         *        </li>
         * @see JobType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobType
         */
        Builder jobType(JobType jobType);

        /**
         * <p>
         * An array of unique identifiers, one for each managed data identifier for the job to include (use) or exclude
         * (not use) when it analyzes data. Inclusion or exclusion depends on the managed data identifier selection type
         * that you specify for the job (managedDataIdentifierSelector).
         * </p>
         * <p>
         * To retrieve a list of valid values for this property, use the ListManagedDataIdentifiers operation.
         * </p>
         * 
         * @param managedDataIdentifierIds
         *        An array of unique identifiers, one for each managed data identifier for the job to include (use) or
         *        exclude (not use) when it analyzes data. Inclusion or exclusion depends on the managed data identifier
         *        selection type that you specify for the job (managedDataIdentifierSelector).</p>
         *        <p>
         *        To retrieve a list of valid values for this property, use the ListManagedDataIdentifiers operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedDataIdentifierIds(Collection<String> managedDataIdentifierIds);

        /**
         * <p>
         * An array of unique identifiers, one for each managed data identifier for the job to include (use) or exclude
         * (not use) when it analyzes data. Inclusion or exclusion depends on the managed data identifier selection type
         * that you specify for the job (managedDataIdentifierSelector).
         * </p>
         * <p>
         * To retrieve a list of valid values for this property, use the ListManagedDataIdentifiers operation.
         * </p>
         * 
         * @param managedDataIdentifierIds
         *        An array of unique identifiers, one for each managed data identifier for the job to include (use) or
         *        exclude (not use) when it analyzes data. Inclusion or exclusion depends on the managed data identifier
         *        selection type that you specify for the job (managedDataIdentifierSelector).</p>
         *        <p>
         *        To retrieve a list of valid values for this property, use the ListManagedDataIdentifiers operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedDataIdentifierIds(String... managedDataIdentifierIds);

        /**
         * <p>
         * The selection type to apply when determining which managed data identifiers the job uses to analyze data.
         * Valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * ALL - Use all managed data identifiers. If you specify this value, don't specify any values for the
         * managedDataIdentifierIds property.
         * </p>
         * </li>
         * <li>
         * <p>
         * EXCLUDE - Use all managed data identifiers except the ones specified by the managedDataIdentifierIds
         * property.
         * </p>
         * </li>
         * <li>
         * <p>
         * INCLUDE - Use only the managed data identifiers specified by the managedDataIdentifierIds property.
         * </p>
         * </li>
         * <li>
         * <p>
         * NONE - Don't use any managed data identifiers. If you specify this value, specify at least one value for the
         * customDataIdentifierIds property and don't specify any values for the managedDataIdentifierIds property.
         * </p>
         * </li>
         * <li>
         * <p>
         * RECOMMENDED (default) - Use the recommended set of managed data identifiers. If you specify this value, don't
         * specify any values for the managedDataIdentifierIds property.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you don't specify a value for this property, the job uses the recommended set of managed data identifiers.
         * </p>
         * <p>
         * If the job is a recurring job and you specify ALL or EXCLUDE, each job run automatically uses new managed
         * data identifiers that are released. If you don't specify a value for this property or you specify RECOMMENDED
         * for a recurring job, each job run automatically uses all the managed data identifiers that are in the
         * recommended set when the run starts.
         * </p>
         * <p>
         * For information about individual managed data identifiers or to determine which ones are in the recommended
         * set, see <a href="https://docs.aws.amazon.com/macie/latest/user/managed-data-identifiers.html">Using managed
         * data identifiers</a> and <a
         * href="https://docs.aws.amazon.com/macie/latest/user/discovery-jobs-mdis-recommended.html">Recommended managed
         * data identifiers</a> in the <i>Amazon Macie User Guide</i>.
         * </p>
         * 
         * @param managedDataIdentifierSelector
         *        The selection type to apply when determining which managed data identifiers the job uses to analyze
         *        data. Valid values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        ALL - Use all managed data identifiers. If you specify this value, don't specify any values for the
         *        managedDataIdentifierIds property.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        EXCLUDE - Use all managed data identifiers except the ones specified by the managedDataIdentifierIds
         *        property.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INCLUDE - Use only the managed data identifiers specified by the managedDataIdentifierIds property.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        NONE - Don't use any managed data identifiers. If you specify this value, specify at least one value
         *        for the customDataIdentifierIds property and don't specify any values for the managedDataIdentifierIds
         *        property.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RECOMMENDED (default) - Use the recommended set of managed data identifiers. If you specify this
         *        value, don't specify any values for the managedDataIdentifierIds property.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If you don't specify a value for this property, the job uses the recommended set of managed data
         *        identifiers.
         *        </p>
         *        <p>
         *        If the job is a recurring job and you specify ALL or EXCLUDE, each job run automatically uses new
         *        managed data identifiers that are released. If you don't specify a value for this property or you
         *        specify RECOMMENDED for a recurring job, each job run automatically uses all the managed data
         *        identifiers that are in the recommended set when the run starts.
         *        </p>
         *        <p>
         *        For information about individual managed data identifiers or to determine which ones are in the
         *        recommended set, see <a
         *        href="https://docs.aws.amazon.com/macie/latest/user/managed-data-identifiers.html">Using managed data
         *        identifiers</a> and <a
         *        href="https://docs.aws.amazon.com/macie/latest/user/discovery-jobs-mdis-recommended.html">Recommended
         *        managed data identifiers</a> in the <i>Amazon Macie User Guide</i>.
         * @see ManagedDataIdentifierSelector
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ManagedDataIdentifierSelector
         */
        Builder managedDataIdentifierSelector(String managedDataIdentifierSelector);

        /**
         * <p>
         * The selection type to apply when determining which managed data identifiers the job uses to analyze data.
         * Valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * ALL - Use all managed data identifiers. If you specify this value, don't specify any values for the
         * managedDataIdentifierIds property.
         * </p>
         * </li>
         * <li>
         * <p>
         * EXCLUDE - Use all managed data identifiers except the ones specified by the managedDataIdentifierIds
         * property.
         * </p>
         * </li>
         * <li>
         * <p>
         * INCLUDE - Use only the managed data identifiers specified by the managedDataIdentifierIds property.
         * </p>
         * </li>
         * <li>
         * <p>
         * NONE - Don't use any managed data identifiers. If you specify this value, specify at least one value for the
         * customDataIdentifierIds property and don't specify any values for the managedDataIdentifierIds property.
         * </p>
         * </li>
         * <li>
         * <p>
         * RECOMMENDED (default) - Use the recommended set of managed data identifiers. If you specify this value, don't
         * specify any values for the managedDataIdentifierIds property.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you don't specify a value for this property, the job uses the recommended set of managed data identifiers.
         * </p>
         * <p>
         * If the job is a recurring job and you specify ALL or EXCLUDE, each job run automatically uses new managed
         * data identifiers that are released. If you don't specify a value for this property or you specify RECOMMENDED
         * for a recurring job, each job run automatically uses all the managed data identifiers that are in the
         * recommended set when the run starts.
         * </p>
         * <p>
         * For information about individual managed data identifiers or to determine which ones are in the recommended
         * set, see <a href="https://docs.aws.amazon.com/macie/latest/user/managed-data-identifiers.html">Using managed
         * data identifiers</a> and <a
         * href="https://docs.aws.amazon.com/macie/latest/user/discovery-jobs-mdis-recommended.html">Recommended managed
         * data identifiers</a> in the <i>Amazon Macie User Guide</i>.
         * </p>
         * 
         * @param managedDataIdentifierSelector
         *        The selection type to apply when determining which managed data identifiers the job uses to analyze
         *        data. Valid values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        ALL - Use all managed data identifiers. If you specify this value, don't specify any values for the
         *        managedDataIdentifierIds property.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        EXCLUDE - Use all managed data identifiers except the ones specified by the managedDataIdentifierIds
         *        property.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INCLUDE - Use only the managed data identifiers specified by the managedDataIdentifierIds property.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        NONE - Don't use any managed data identifiers. If you specify this value, specify at least one value
         *        for the customDataIdentifierIds property and don't specify any values for the managedDataIdentifierIds
         *        property.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RECOMMENDED (default) - Use the recommended set of managed data identifiers. If you specify this
         *        value, don't specify any values for the managedDataIdentifierIds property.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If you don't specify a value for this property, the job uses the recommended set of managed data
         *        identifiers.
         *        </p>
         *        <p>
         *        If the job is a recurring job and you specify ALL or EXCLUDE, each job run automatically uses new
         *        managed data identifiers that are released. If you don't specify a value for this property or you
         *        specify RECOMMENDED for a recurring job, each job run automatically uses all the managed data
         *        identifiers that are in the recommended set when the run starts.
         *        </p>
         *        <p>
         *        For information about individual managed data identifiers or to determine which ones are in the
         *        recommended set, see <a
         *        href="https://docs.aws.amazon.com/macie/latest/user/managed-data-identifiers.html">Using managed data
         *        identifiers</a> and <a
         *        href="https://docs.aws.amazon.com/macie/latest/user/discovery-jobs-mdis-recommended.html">Recommended
         *        managed data identifiers</a> in the <i>Amazon Macie User Guide</i>.
         * @see ManagedDataIdentifierSelector
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ManagedDataIdentifierSelector
         */
        Builder managedDataIdentifierSelector(ManagedDataIdentifierSelector managedDataIdentifierSelector);

        /**
         * <p>
         * A custom name for the job. The name can contain as many as 500 characters.
         * </p>
         * 
         * @param name
         *        A custom name for the job. The name can contain as many as 500 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The S3 buckets that contain the objects to analyze, and the scope of that analysis.
         * </p>
         * 
         * @param s3JobDefinition
         *        The S3 buckets that contain the objects to analyze, and the scope of that analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3JobDefinition(S3JobDefinition s3JobDefinition);

        /**
         * <p>
         * The S3 buckets that contain the objects to analyze, and the scope of that analysis.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3JobDefinition.Builder} avoiding the
         * need to create one manually via {@link S3JobDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3JobDefinition.Builder#build()} is called immediately and its
         * result is passed to {@link #s3JobDefinition(S3JobDefinition)}.
         * 
         * @param s3JobDefinition
         *        a consumer that will call methods on {@link S3JobDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3JobDefinition(S3JobDefinition)
         */
        default Builder s3JobDefinition(Consumer<S3JobDefinition.Builder> s3JobDefinition) {
            return s3JobDefinition(S3JobDefinition.builder().applyMutation(s3JobDefinition).build());
        }

        /**
         * <p>
         * The sampling depth, as a percentage, for the job to apply when processing objects. This value determines the
         * percentage of eligible objects that the job analyzes. If this value is less than 100, Amazon Macie selects
         * the objects to analyze at random, up to the specified percentage, and analyzes all the data in those objects.
         * </p>
         * 
         * @param samplingPercentage
         *        The sampling depth, as a percentage, for the job to apply when processing objects. This value
         *        determines the percentage of eligible objects that the job analyzes. If this value is less than 100,
         *        Amazon Macie selects the objects to analyze at random, up to the specified percentage, and analyzes
         *        all the data in those objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder samplingPercentage(Integer samplingPercentage);

        /**
         * <p>
         * The recurrence pattern for running the job. To run the job only once, don't specify a value for this property
         * and set the value for the jobType property to ONE_TIME.
         * </p>
         * 
         * @param scheduleFrequency
         *        The recurrence pattern for running the job. To run the job only once, don't specify a value for this
         *        property and set the value for the jobType property to ONE_TIME.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleFrequency(JobScheduleFrequency scheduleFrequency);

        /**
         * <p>
         * The recurrence pattern for running the job. To run the job only once, don't specify a value for this property
         * and set the value for the jobType property to ONE_TIME.
         * </p>
         * This is a convenience method that creates an instance of the {@link JobScheduleFrequency.Builder} avoiding
         * the need to create one manually via {@link JobScheduleFrequency#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link JobScheduleFrequency.Builder#build()} is called immediately and
         * its result is passed to {@link #scheduleFrequency(JobScheduleFrequency)}.
         * 
         * @param scheduleFrequency
         *        a consumer that will call methods on {@link JobScheduleFrequency.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scheduleFrequency(JobScheduleFrequency)
         */
        default Builder scheduleFrequency(Consumer<JobScheduleFrequency.Builder> scheduleFrequency) {
            return scheduleFrequency(JobScheduleFrequency.builder().applyMutation(scheduleFrequency).build());
        }

        /**
         * <p>
         * A map of key-value pairs that specifies the tags to associate with the job.
         * </p>
         * <p>
         * A job can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value. The maximum
         * length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.
         * </p>
         * 
         * @param tags
         *        A map of key-value pairs that specifies the tags to associate with the job.</p>
         *        <p>
         *        A job can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value. The
         *        maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Macie2Request.BuilderImpl implements Builder {
        private List<String> allowListIds = DefaultSdkAutoConstructList.getInstance();

        private String clientToken;

        private List<String> customDataIdentifierIds = DefaultSdkAutoConstructList.getInstance();

        private String description;

        private Boolean initialRun;

        private String jobType;

        private List<String> managedDataIdentifierIds = DefaultSdkAutoConstructList.getInstance();

        private String managedDataIdentifierSelector;

        private String name;

        private S3JobDefinition s3JobDefinition;

        private Integer samplingPercentage;

        private JobScheduleFrequency scheduleFrequency;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateClassificationJobRequest model) {
            super(model);
            allowListIds(model.allowListIds);
            clientToken(model.clientToken);
            customDataIdentifierIds(model.customDataIdentifierIds);
            description(model.description);
            initialRun(model.initialRun);
            jobType(model.jobType);
            managedDataIdentifierIds(model.managedDataIdentifierIds);
            managedDataIdentifierSelector(model.managedDataIdentifierSelector);
            name(model.name);
            s3JobDefinition(model.s3JobDefinition);
            samplingPercentage(model.samplingPercentage);
            scheduleFrequency(model.scheduleFrequency);
            tags(model.tags);
        }

        public final Collection<String> getAllowListIds() {
            if (allowListIds instanceof SdkAutoConstructList) {
                return null;
            }
            return allowListIds;
        }

        public final void setAllowListIds(Collection<String> allowListIds) {
            this.allowListIds = ___listOf__stringCopier.copy(allowListIds);
        }

        @Override
        public final Builder allowListIds(Collection<String> allowListIds) {
            this.allowListIds = ___listOf__stringCopier.copy(allowListIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowListIds(String... allowListIds) {
            allowListIds(Arrays.asList(allowListIds));
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Collection<String> getCustomDataIdentifierIds() {
            if (customDataIdentifierIds instanceof SdkAutoConstructList) {
                return null;
            }
            return customDataIdentifierIds;
        }

        public final void setCustomDataIdentifierIds(Collection<String> customDataIdentifierIds) {
            this.customDataIdentifierIds = ___listOf__stringCopier.copy(customDataIdentifierIds);
        }

        @Override
        public final Builder customDataIdentifierIds(Collection<String> customDataIdentifierIds) {
            this.customDataIdentifierIds = ___listOf__stringCopier.copy(customDataIdentifierIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customDataIdentifierIds(String... customDataIdentifierIds) {
            customDataIdentifierIds(Arrays.asList(customDataIdentifierIds));
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getInitialRun() {
            return initialRun;
        }

        public final void setInitialRun(Boolean initialRun) {
            this.initialRun = initialRun;
        }

        @Override
        public final Builder initialRun(Boolean initialRun) {
            this.initialRun = initialRun;
            return this;
        }

        public final String getJobType() {
            return jobType;
        }

        public final void setJobType(String jobType) {
            this.jobType = jobType;
        }

        @Override
        public final Builder jobType(String jobType) {
            this.jobType = jobType;
            return this;
        }

        @Override
        public final Builder jobType(JobType jobType) {
            this.jobType(jobType == null ? null : jobType.toString());
            return this;
        }

        public final Collection<String> getManagedDataIdentifierIds() {
            if (managedDataIdentifierIds instanceof SdkAutoConstructList) {
                return null;
            }
            return managedDataIdentifierIds;
        }

        public final void setManagedDataIdentifierIds(Collection<String> managedDataIdentifierIds) {
            this.managedDataIdentifierIds = ___listOf__stringCopier.copy(managedDataIdentifierIds);
        }

        @Override
        public final Builder managedDataIdentifierIds(Collection<String> managedDataIdentifierIds) {
            this.managedDataIdentifierIds = ___listOf__stringCopier.copy(managedDataIdentifierIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder managedDataIdentifierIds(String... managedDataIdentifierIds) {
            managedDataIdentifierIds(Arrays.asList(managedDataIdentifierIds));
            return this;
        }

        public final String getManagedDataIdentifierSelector() {
            return managedDataIdentifierSelector;
        }

        public final void setManagedDataIdentifierSelector(String managedDataIdentifierSelector) {
            this.managedDataIdentifierSelector = managedDataIdentifierSelector;
        }

        @Override
        public final Builder managedDataIdentifierSelector(String managedDataIdentifierSelector) {
            this.managedDataIdentifierSelector = managedDataIdentifierSelector;
            return this;
        }

        @Override
        public final Builder managedDataIdentifierSelector(ManagedDataIdentifierSelector managedDataIdentifierSelector) {
            this.managedDataIdentifierSelector(managedDataIdentifierSelector == null ? null : managedDataIdentifierSelector
                    .toString());
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final S3JobDefinition.Builder getS3JobDefinition() {
            return s3JobDefinition != null ? s3JobDefinition.toBuilder() : null;
        }

        public final void setS3JobDefinition(S3JobDefinition.BuilderImpl s3JobDefinition) {
            this.s3JobDefinition = s3JobDefinition != null ? s3JobDefinition.build() : null;
        }

        @Override
        public final Builder s3JobDefinition(S3JobDefinition s3JobDefinition) {
            this.s3JobDefinition = s3JobDefinition;
            return this;
        }

        public final Integer getSamplingPercentage() {
            return samplingPercentage;
        }

        public final void setSamplingPercentage(Integer samplingPercentage) {
            this.samplingPercentage = samplingPercentage;
        }

        @Override
        public final Builder samplingPercentage(Integer samplingPercentage) {
            this.samplingPercentage = samplingPercentage;
            return this;
        }

        public final JobScheduleFrequency.Builder getScheduleFrequency() {
            return scheduleFrequency != null ? scheduleFrequency.toBuilder() : null;
        }

        public final void setScheduleFrequency(JobScheduleFrequency.BuilderImpl scheduleFrequency) {
            this.scheduleFrequency = scheduleFrequency != null ? scheduleFrequency.build() : null;
        }

        @Override
        public final Builder scheduleFrequency(JobScheduleFrequency scheduleFrequency) {
            this.scheduleFrequency = scheduleFrequency;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateClassificationJobRequest build() {
            return new CreateClassificationJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
