/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSensitivityInspectionTemplatesResponse extends Macie2Response implements
        ToCopyableBuilder<ListSensitivityInspectionTemplatesResponse.Builder, ListSensitivityInspectionTemplatesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListSensitivityInspectionTemplatesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<SensitivityInspectionTemplatesEntry>> SENSITIVITY_INSPECTION_TEMPLATES_FIELD = SdkField
            .<List<SensitivityInspectionTemplatesEntry>> builder(MarshallingType.LIST)
            .memberName("sensitivityInspectionTemplates")
            .getter(getter(ListSensitivityInspectionTemplatesResponse::sensitivityInspectionTemplates))
            .setter(setter(Builder::sensitivityInspectionTemplates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sensitivityInspectionTemplates")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SensitivityInspectionTemplatesEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(SensitivityInspectionTemplatesEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            SENSITIVITY_INSPECTION_TEMPLATES_FIELD));

    private final String nextToken;

    private final List<SensitivityInspectionTemplatesEntry> sensitivityInspectionTemplates;

    private ListSensitivityInspectionTemplatesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.sensitivityInspectionTemplates = builder.sensitivityInspectionTemplates;
    }

    /**
     * <p>
     * The string to use in a subsequent request to get the next page of results in a paginated response. This value is
     * null if there are no additional pages.
     * </p>
     * 
     * @return The string to use in a subsequent request to get the next page of results in a paginated response. This
     *         value is null if there are no additional pages.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the SensitivityInspectionTemplates property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSensitivityInspectionTemplates() {
        return sensitivityInspectionTemplates != null && !(sensitivityInspectionTemplates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array that specifies the unique identifier and name of the sensitivity inspection template for the account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSensitivityInspectionTemplates} method.
     * </p>
     * 
     * @return An array that specifies the unique identifier and name of the sensitivity inspection template for the
     *         account.
     */
    public final List<SensitivityInspectionTemplatesEntry> sensitivityInspectionTemplates() {
        return sensitivityInspectionTemplates;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasSensitivityInspectionTemplates() ? sensitivityInspectionTemplates() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSensitivityInspectionTemplatesResponse)) {
            return false;
        }
        ListSensitivityInspectionTemplatesResponse other = (ListSensitivityInspectionTemplatesResponse) obj;
        return Objects.equals(nextToken(), other.nextToken())
                && hasSensitivityInspectionTemplates() == other.hasSensitivityInspectionTemplates()
                && Objects.equals(sensitivityInspectionTemplates(), other.sensitivityInspectionTemplates());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ListSensitivityInspectionTemplatesResponse")
                .add("NextToken", nextToken())
                .add("SensitivityInspectionTemplates",
                        hasSensitivityInspectionTemplates() ? sensitivityInspectionTemplates() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "sensitivityInspectionTemplates":
            return Optional.ofNullable(clazz.cast(sensitivityInspectionTemplates()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSensitivityInspectionTemplatesResponse, T> g) {
        return obj -> g.apply((ListSensitivityInspectionTemplatesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Macie2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, ListSensitivityInspectionTemplatesResponse> {
        /**
         * <p>
         * The string to use in a subsequent request to get the next page of results in a paginated response. This value
         * is null if there are no additional pages.
         * </p>
         * 
         * @param nextToken
         *        The string to use in a subsequent request to get the next page of results in a paginated response.
         *        This value is null if there are no additional pages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * An array that specifies the unique identifier and name of the sensitivity inspection template for the
         * account.
         * </p>
         * 
         * @param sensitivityInspectionTemplates
         *        An array that specifies the unique identifier and name of the sensitivity inspection template for the
         *        account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sensitivityInspectionTemplates(Collection<SensitivityInspectionTemplatesEntry> sensitivityInspectionTemplates);

        /**
         * <p>
         * An array that specifies the unique identifier and name of the sensitivity inspection template for the
         * account.
         * </p>
         * 
         * @param sensitivityInspectionTemplates
         *        An array that specifies the unique identifier and name of the sensitivity inspection template for the
         *        account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sensitivityInspectionTemplates(SensitivityInspectionTemplatesEntry... sensitivityInspectionTemplates);

        /**
         * <p>
         * An array that specifies the unique identifier and name of the sensitivity inspection template for the
         * account.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.macie2.model.SensitivityInspectionTemplatesEntry.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.macie2.model.SensitivityInspectionTemplatesEntry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.macie2.model.SensitivityInspectionTemplatesEntry.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #sensitivityInspectionTemplates(List<SensitivityInspectionTemplatesEntry>)}.
         * 
         * @param sensitivityInspectionTemplates
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.macie2.model.SensitivityInspectionTemplatesEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sensitivityInspectionTemplates(java.util.Collection<SensitivityInspectionTemplatesEntry>)
         */
        Builder sensitivityInspectionTemplates(
                Consumer<SensitivityInspectionTemplatesEntry.Builder>... sensitivityInspectionTemplates);
    }

    static final class BuilderImpl extends Macie2Response.BuilderImpl implements Builder {
        private String nextToken;

        private List<SensitivityInspectionTemplatesEntry> sensitivityInspectionTemplates = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListSensitivityInspectionTemplatesResponse model) {
            super(model);
            nextToken(model.nextToken);
            sensitivityInspectionTemplates(model.sensitivityInspectionTemplates);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<SensitivityInspectionTemplatesEntry.Builder> getSensitivityInspectionTemplates() {
            List<SensitivityInspectionTemplatesEntry.Builder> result = ___listOfSensitivityInspectionTemplatesEntryCopier
                    .copyToBuilder(this.sensitivityInspectionTemplates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSensitivityInspectionTemplates(
                Collection<SensitivityInspectionTemplatesEntry.BuilderImpl> sensitivityInspectionTemplates) {
            this.sensitivityInspectionTemplates = ___listOfSensitivityInspectionTemplatesEntryCopier
                    .copyFromBuilder(sensitivityInspectionTemplates);
        }

        @Override
        public final Builder sensitivityInspectionTemplates(
                Collection<SensitivityInspectionTemplatesEntry> sensitivityInspectionTemplates) {
            this.sensitivityInspectionTemplates = ___listOfSensitivityInspectionTemplatesEntryCopier
                    .copy(sensitivityInspectionTemplates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sensitivityInspectionTemplates(SensitivityInspectionTemplatesEntry... sensitivityInspectionTemplates) {
            sensitivityInspectionTemplates(Arrays.asList(sensitivityInspectionTemplates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sensitivityInspectionTemplates(
                Consumer<SensitivityInspectionTemplatesEntry.Builder>... sensitivityInspectionTemplates) {
            sensitivityInspectionTemplates(Stream.of(sensitivityInspectionTemplates)
                    .map(c -> SensitivityInspectionTemplatesEntry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListSensitivityInspectionTemplatesResponse build() {
            return new ListSensitivityInspectionTemplatesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
