/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides aggregated statistical data for sensitive data discovery metrics that apply to S3 buckets. Each field
 * contains aggregated data for all the buckets that have a sensitivity score (sensitivityScore) of a specified value or
 * within a specified range (BucketStatisticsBySensitivity). If automated sensitive data discovery is currently disabled
 * for your account, the value for each field is 0.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SensitivityAggregations implements SdkPojo, Serializable,
        ToCopyableBuilder<SensitivityAggregations.Builder, SensitivityAggregations> {
    private static final SdkField<Long> CLASSIFIABLE_SIZE_IN_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("classifiableSizeInBytes").getter(getter(SensitivityAggregations::classifiableSizeInBytes))
            .setter(setter(Builder::classifiableSizeInBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("classifiableSizeInBytes").build())
            .build();

    private static final SdkField<Long> PUBLICLY_ACCESSIBLE_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("publiclyAccessibleCount").getter(getter(SensitivityAggregations::publiclyAccessibleCount))
            .setter(setter(Builder::publiclyAccessibleCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publiclyAccessibleCount").build())
            .build();

    private static final SdkField<Long> TOTAL_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("totalCount").getter(getter(SensitivityAggregations::totalCount)).setter(setter(Builder::totalCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalCount").build()).build();

    private static final SdkField<Long> TOTAL_SIZE_IN_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("totalSizeInBytes").getter(getter(SensitivityAggregations::totalSizeInBytes))
            .setter(setter(Builder::totalSizeInBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalSizeInBytes").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CLASSIFIABLE_SIZE_IN_BYTES_FIELD, PUBLICLY_ACCESSIBLE_COUNT_FIELD, TOTAL_COUNT_FIELD, TOTAL_SIZE_IN_BYTES_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long classifiableSizeInBytes;

    private final Long publiclyAccessibleCount;

    private final Long totalCount;

    private final Long totalSizeInBytes;

    private SensitivityAggregations(BuilderImpl builder) {
        this.classifiableSizeInBytes = builder.classifiableSizeInBytes;
        this.publiclyAccessibleCount = builder.publiclyAccessibleCount;
        this.totalCount = builder.totalCount;
        this.totalSizeInBytes = builder.totalSizeInBytes;
    }

    /**
     * <p>
     * The total storage size, in bytes, of all the objects that Amazon Macie can analyze in the buckets. These objects
     * use a supported storage class and have a file name extension for a supported file or storage format.
     * </p>
     * <p>
     * If versioning is enabled for any of the buckets, this value is based on the size of the latest version of each
     * applicable object in the buckets. This value doesn't reflect the storage size of all versions of all applicable
     * objects in the buckets.
     * </p>
     * 
     * @return The total storage size, in bytes, of all the objects that Amazon Macie can analyze in the buckets. These
     *         objects use a supported storage class and have a file name extension for a supported file or storage
     *         format.</p>
     *         <p>
     *         If versioning is enabled for any of the buckets, this value is based on the size of the latest version of
     *         each applicable object in the buckets. This value doesn't reflect the storage size of all versions of all
     *         applicable objects in the buckets.
     */
    public final Long classifiableSizeInBytes() {
        return classifiableSizeInBytes;
    }

    /**
     * <p>
     * The total number of buckets that are publicly accessible due to a combination of permissions settings for each
     * bucket.
     * </p>
     * 
     * @return The total number of buckets that are publicly accessible due to a combination of permissions settings for
     *         each bucket.
     */
    public final Long publiclyAccessibleCount() {
        return publiclyAccessibleCount;
    }

    /**
     * <p>
     * The total number of buckets.
     * </p>
     * 
     * @return The total number of buckets.
     */
    public final Long totalCount() {
        return totalCount;
    }

    /**
     * <p>
     * The total storage size, in bytes, of the buckets.
     * </p>
     * <p>
     * If versioning is enabled for any of the buckets, this value is based on the size of the latest version of each
     * object in the buckets. This value doesn't reflect the storage size of all versions of the objects in the buckets.
     * </p>
     * 
     * @return The total storage size, in bytes, of the buckets.</p>
     *         <p>
     *         If versioning is enabled for any of the buckets, this value is based on the size of the latest version of
     *         each object in the buckets. This value doesn't reflect the storage size of all versions of the objects in
     *         the buckets.
     */
    public final Long totalSizeInBytes() {
        return totalSizeInBytes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(classifiableSizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(publiclyAccessibleCount());
        hashCode = 31 * hashCode + Objects.hashCode(totalCount());
        hashCode = 31 * hashCode + Objects.hashCode(totalSizeInBytes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SensitivityAggregations)) {
            return false;
        }
        SensitivityAggregations other = (SensitivityAggregations) obj;
        return Objects.equals(classifiableSizeInBytes(), other.classifiableSizeInBytes())
                && Objects.equals(publiclyAccessibleCount(), other.publiclyAccessibleCount())
                && Objects.equals(totalCount(), other.totalCount())
                && Objects.equals(totalSizeInBytes(), other.totalSizeInBytes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SensitivityAggregations").add("ClassifiableSizeInBytes", classifiableSizeInBytes())
                .add("PubliclyAccessibleCount", publiclyAccessibleCount()).add("TotalCount", totalCount())
                .add("TotalSizeInBytes", totalSizeInBytes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "classifiableSizeInBytes":
            return Optional.ofNullable(clazz.cast(classifiableSizeInBytes()));
        case "publiclyAccessibleCount":
            return Optional.ofNullable(clazz.cast(publiclyAccessibleCount()));
        case "totalCount":
            return Optional.ofNullable(clazz.cast(totalCount()));
        case "totalSizeInBytes":
            return Optional.ofNullable(clazz.cast(totalSizeInBytes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SensitivityAggregations, T> g) {
        return obj -> g.apply((SensitivityAggregations) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SensitivityAggregations> {
        /**
         * <p>
         * The total storage size, in bytes, of all the objects that Amazon Macie can analyze in the buckets. These
         * objects use a supported storage class and have a file name extension for a supported file or storage format.
         * </p>
         * <p>
         * If versioning is enabled for any of the buckets, this value is based on the size of the latest version of
         * each applicable object in the buckets. This value doesn't reflect the storage size of all versions of all
         * applicable objects in the buckets.
         * </p>
         * 
         * @param classifiableSizeInBytes
         *        The total storage size, in bytes, of all the objects that Amazon Macie can analyze in the buckets.
         *        These objects use a supported storage class and have a file name extension for a supported file or
         *        storage format.</p>
         *        <p>
         *        If versioning is enabled for any of the buckets, this value is based on the size of the latest version
         *        of each applicable object in the buckets. This value doesn't reflect the storage size of all versions
         *        of all applicable objects in the buckets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder classifiableSizeInBytes(Long classifiableSizeInBytes);

        /**
         * <p>
         * The total number of buckets that are publicly accessible due to a combination of permissions settings for
         * each bucket.
         * </p>
         * 
         * @param publiclyAccessibleCount
         *        The total number of buckets that are publicly accessible due to a combination of permissions settings
         *        for each bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publiclyAccessibleCount(Long publiclyAccessibleCount);

        /**
         * <p>
         * The total number of buckets.
         * </p>
         * 
         * @param totalCount
         *        The total number of buckets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalCount(Long totalCount);

        /**
         * <p>
         * The total storage size, in bytes, of the buckets.
         * </p>
         * <p>
         * If versioning is enabled for any of the buckets, this value is based on the size of the latest version of
         * each object in the buckets. This value doesn't reflect the storage size of all versions of the objects in the
         * buckets.
         * </p>
         * 
         * @param totalSizeInBytes
         *        The total storage size, in bytes, of the buckets.</p>
         *        <p>
         *        If versioning is enabled for any of the buckets, this value is based on the size of the latest version
         *        of each object in the buckets. This value doesn't reflect the storage size of all versions of the
         *        objects in the buckets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalSizeInBytes(Long totalSizeInBytes);
    }

    static final class BuilderImpl implements Builder {
        private Long classifiableSizeInBytes;

        private Long publiclyAccessibleCount;

        private Long totalCount;

        private Long totalSizeInBytes;

        private BuilderImpl() {
        }

        private BuilderImpl(SensitivityAggregations model) {
            classifiableSizeInBytes(model.classifiableSizeInBytes);
            publiclyAccessibleCount(model.publiclyAccessibleCount);
            totalCount(model.totalCount);
            totalSizeInBytes(model.totalSizeInBytes);
        }

        public final Long getClassifiableSizeInBytes() {
            return classifiableSizeInBytes;
        }

        public final void setClassifiableSizeInBytes(Long classifiableSizeInBytes) {
            this.classifiableSizeInBytes = classifiableSizeInBytes;
        }

        @Override
        public final Builder classifiableSizeInBytes(Long classifiableSizeInBytes) {
            this.classifiableSizeInBytes = classifiableSizeInBytes;
            return this;
        }

        public final Long getPubliclyAccessibleCount() {
            return publiclyAccessibleCount;
        }

        public final void setPubliclyAccessibleCount(Long publiclyAccessibleCount) {
            this.publiclyAccessibleCount = publiclyAccessibleCount;
        }

        @Override
        public final Builder publiclyAccessibleCount(Long publiclyAccessibleCount) {
            this.publiclyAccessibleCount = publiclyAccessibleCount;
            return this;
        }

        public final Long getTotalCount() {
            return totalCount;
        }

        public final void setTotalCount(Long totalCount) {
            this.totalCount = totalCount;
        }

        @Override
        public final Builder totalCount(Long totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        public final Long getTotalSizeInBytes() {
            return totalSizeInBytes;
        }

        public final void setTotalSizeInBytes(Long totalSizeInBytes) {
            this.totalSizeInBytes = totalSizeInBytes;
        }

        @Override
        public final Builder totalSizeInBytes(Long totalSizeInBytes) {
            this.totalSizeInBytes = totalSizeInBytes;
            return this;
        }

        @Override
        public SensitivityAggregations build() {
            return new SensitivityAggregations(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
