/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies a property-based condition that determines whether an S3 bucket is included or excluded from a
 * classification job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SimpleCriterionForJob implements SdkPojo, Serializable,
        ToCopyableBuilder<SimpleCriterionForJob.Builder, SimpleCriterionForJob> {
    private static final SdkField<String> COMPARATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("comparator").getter(getter(SimpleCriterionForJob::comparatorAsString))
            .setter(setter(Builder::comparator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("comparator").build()).build();

    private static final SdkField<String> KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("key")
            .getter(getter(SimpleCriterionForJob::keyAsString)).setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("key").build()).build();

    private static final SdkField<List<String>> VALUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("values")
            .getter(getter(SimpleCriterionForJob::values))
            .setter(setter(Builder::values))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("values").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPARATOR_FIELD, KEY_FIELD,
            VALUES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String comparator;

    private final String key;

    private final List<String> values;

    private SimpleCriterionForJob(BuilderImpl builder) {
        this.comparator = builder.comparator;
        this.key = builder.key;
        this.values = builder.values;
    }

    /**
     * <p>
     * The operator to use in the condition. Valid values are EQ (equals) and NE (not equals).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #comparator} will
     * return {@link JobComparator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #comparatorAsString}.
     * </p>
     * 
     * @return The operator to use in the condition. Valid values are EQ (equals) and NE (not equals).
     * @see JobComparator
     */
    public final JobComparator comparator() {
        return JobComparator.fromValue(comparator);
    }

    /**
     * <p>
     * The operator to use in the condition. Valid values are EQ (equals) and NE (not equals).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #comparator} will
     * return {@link JobComparator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #comparatorAsString}.
     * </p>
     * 
     * @return The operator to use in the condition. Valid values are EQ (equals) and NE (not equals).
     * @see JobComparator
     */
    public final String comparatorAsString() {
        return comparator;
    }

    /**
     * <p>
     * The property to use in the condition.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #key} will return
     * {@link SimpleCriterionKeyForJob#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #keyAsString}.
     * </p>
     * 
     * @return The property to use in the condition.
     * @see SimpleCriterionKeyForJob
     */
    public final SimpleCriterionKeyForJob key() {
        return SimpleCriterionKeyForJob.fromValue(key);
    }

    /**
     * <p>
     * The property to use in the condition.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #key} will return
     * {@link SimpleCriterionKeyForJob#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #keyAsString}.
     * </p>
     * 
     * @return The property to use in the condition.
     * @see SimpleCriterionKeyForJob
     */
    public final String keyAsString() {
        return key;
    }

    /**
     * For responses, this returns true if the service returned a value for the Values property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasValues() {
        return values != null && !(values instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array that lists one or more values to use in the condition. If you specify multiple values, Amazon Macie uses
     * OR logic to join the values. Valid values for each supported property (key) are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * ACCOUNT_ID - A string that represents the unique identifier for the Amazon Web Services account that owns the
     * bucket.
     * </p>
     * </li>
     * <li>
     * <p>
     * S3_BUCKET_EFFECTIVE_PERMISSION - A string that represents an enumerated value that Macie defines for the <a href=
     * "https://docs.aws.amazon.com/macie/latest/APIReference/datasources-s3.html#datasources-s3-prop-bucketpublicaccess-effectivepermission"
     * >BucketPublicAccess.effectivePermission</a> property of a bucket.
     * </p>
     * </li>
     * <li>
     * <p>
     * S3_BUCKET_NAME - A string that represents the name of a bucket.
     * </p>
     * </li>
     * <li>
     * <p>
     * S3_BUCKET_SHARED_ACCESS - A string that represents an enumerated value that Macie defines for the <a href=
     * "https://docs.aws.amazon.com/macie/latest/APIReference/datasources-s3.html#datasources-s3-prop-bucketmetadata-sharedaccess"
     * >BucketMetadata.sharedAccess</a> property of a bucket.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Values are case sensitive. Also, Macie doesn't support use of partial values or wildcard characters in these
     * values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasValues} method.
     * </p>
     * 
     * @return An array that lists one or more values to use in the condition. If you specify multiple values, Amazon
     *         Macie uses OR logic to join the values. Valid values for each supported property (key) are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         ACCOUNT_ID - A string that represents the unique identifier for the Amazon Web Services account that owns
     *         the bucket.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         S3_BUCKET_EFFECTIVE_PERMISSION - A string that represents an enumerated value that Macie defines for the
     *         <a href=
     *         "https://docs.aws.amazon.com/macie/latest/APIReference/datasources-s3.html#datasources-s3-prop-bucketpublicaccess-effectivepermission"
     *         >BucketPublicAccess.effectivePermission</a> property of a bucket.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         S3_BUCKET_NAME - A string that represents the name of a bucket.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         S3_BUCKET_SHARED_ACCESS - A string that represents an enumerated value that Macie defines for the <a
     *         href=
     *         "https://docs.aws.amazon.com/macie/latest/APIReference/datasources-s3.html#datasources-s3-prop-bucketmetadata-sharedaccess"
     *         >BucketMetadata.sharedAccess</a> property of a bucket.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Values are case sensitive. Also, Macie doesn't support use of partial values or wildcard characters in
     *         these values.
     */
    public final List<String> values() {
        return values;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(comparatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(keyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasValues() ? values() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SimpleCriterionForJob)) {
            return false;
        }
        SimpleCriterionForJob other = (SimpleCriterionForJob) obj;
        return Objects.equals(comparatorAsString(), other.comparatorAsString())
                && Objects.equals(keyAsString(), other.keyAsString()) && hasValues() == other.hasValues()
                && Objects.equals(values(), other.values());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SimpleCriterionForJob").add("Comparator", comparatorAsString()).add("Key", keyAsString())
                .add("Values", hasValues() ? values() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "comparator":
            return Optional.ofNullable(clazz.cast(comparatorAsString()));
        case "key":
            return Optional.ofNullable(clazz.cast(keyAsString()));
        case "values":
            return Optional.ofNullable(clazz.cast(values()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SimpleCriterionForJob, T> g) {
        return obj -> g.apply((SimpleCriterionForJob) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SimpleCriterionForJob> {
        /**
         * <p>
         * The operator to use in the condition. Valid values are EQ (equals) and NE (not equals).
         * </p>
         * 
         * @param comparator
         *        The operator to use in the condition. Valid values are EQ (equals) and NE (not equals).
         * @see JobComparator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobComparator
         */
        Builder comparator(String comparator);

        /**
         * <p>
         * The operator to use in the condition. Valid values are EQ (equals) and NE (not equals).
         * </p>
         * 
         * @param comparator
         *        The operator to use in the condition. Valid values are EQ (equals) and NE (not equals).
         * @see JobComparator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobComparator
         */
        Builder comparator(JobComparator comparator);

        /**
         * <p>
         * The property to use in the condition.
         * </p>
         * 
         * @param key
         *        The property to use in the condition.
         * @see SimpleCriterionKeyForJob
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SimpleCriterionKeyForJob
         */
        Builder key(String key);

        /**
         * <p>
         * The property to use in the condition.
         * </p>
         * 
         * @param key
         *        The property to use in the condition.
         * @see SimpleCriterionKeyForJob
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SimpleCriterionKeyForJob
         */
        Builder key(SimpleCriterionKeyForJob key);

        /**
         * <p>
         * An array that lists one or more values to use in the condition. If you specify multiple values, Amazon Macie
         * uses OR logic to join the values. Valid values for each supported property (key) are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * ACCOUNT_ID - A string that represents the unique identifier for the Amazon Web Services account that owns the
         * bucket.
         * </p>
         * </li>
         * <li>
         * <p>
         * S3_BUCKET_EFFECTIVE_PERMISSION - A string that represents an enumerated value that Macie defines for the <a
         * href=
         * "https://docs.aws.amazon.com/macie/latest/APIReference/datasources-s3.html#datasources-s3-prop-bucketpublicaccess-effectivepermission"
         * >BucketPublicAccess.effectivePermission</a> property of a bucket.
         * </p>
         * </li>
         * <li>
         * <p>
         * S3_BUCKET_NAME - A string that represents the name of a bucket.
         * </p>
         * </li>
         * <li>
         * <p>
         * S3_BUCKET_SHARED_ACCESS - A string that represents an enumerated value that Macie defines for the <a href=
         * "https://docs.aws.amazon.com/macie/latest/APIReference/datasources-s3.html#datasources-s3-prop-bucketmetadata-sharedaccess"
         * >BucketMetadata.sharedAccess</a> property of a bucket.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Values are case sensitive. Also, Macie doesn't support use of partial values or wildcard characters in these
         * values.
         * </p>
         * 
         * @param values
         *        An array that lists one or more values to use in the condition. If you specify multiple values, Amazon
         *        Macie uses OR logic to join the values. Valid values for each supported property (key) are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        ACCOUNT_ID - A string that represents the unique identifier for the Amazon Web Services account that
         *        owns the bucket.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        S3_BUCKET_EFFECTIVE_PERMISSION - A string that represents an enumerated value that Macie defines for
         *        the <a href=
         *        "https://docs.aws.amazon.com/macie/latest/APIReference/datasources-s3.html#datasources-s3-prop-bucketpublicaccess-effectivepermission"
         *        >BucketPublicAccess.effectivePermission</a> property of a bucket.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        S3_BUCKET_NAME - A string that represents the name of a bucket.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        S3_BUCKET_SHARED_ACCESS - A string that represents an enumerated value that Macie defines for the <a
         *        href=
         *        "https://docs.aws.amazon.com/macie/latest/APIReference/datasources-s3.html#datasources-s3-prop-bucketmetadata-sharedaccess"
         *        >BucketMetadata.sharedAccess</a> property of a bucket.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Values are case sensitive. Also, Macie doesn't support use of partial values or wildcard characters in
         *        these values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(Collection<String> values);

        /**
         * <p>
         * An array that lists one or more values to use in the condition. If you specify multiple values, Amazon Macie
         * uses OR logic to join the values. Valid values for each supported property (key) are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * ACCOUNT_ID - A string that represents the unique identifier for the Amazon Web Services account that owns the
         * bucket.
         * </p>
         * </li>
         * <li>
         * <p>
         * S3_BUCKET_EFFECTIVE_PERMISSION - A string that represents an enumerated value that Macie defines for the <a
         * href=
         * "https://docs.aws.amazon.com/macie/latest/APIReference/datasources-s3.html#datasources-s3-prop-bucketpublicaccess-effectivepermission"
         * >BucketPublicAccess.effectivePermission</a> property of a bucket.
         * </p>
         * </li>
         * <li>
         * <p>
         * S3_BUCKET_NAME - A string that represents the name of a bucket.
         * </p>
         * </li>
         * <li>
         * <p>
         * S3_BUCKET_SHARED_ACCESS - A string that represents an enumerated value that Macie defines for the <a href=
         * "https://docs.aws.amazon.com/macie/latest/APIReference/datasources-s3.html#datasources-s3-prop-bucketmetadata-sharedaccess"
         * >BucketMetadata.sharedAccess</a> property of a bucket.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Values are case sensitive. Also, Macie doesn't support use of partial values or wildcard characters in these
         * values.
         * </p>
         * 
         * @param values
         *        An array that lists one or more values to use in the condition. If you specify multiple values, Amazon
         *        Macie uses OR logic to join the values. Valid values for each supported property (key) are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        ACCOUNT_ID - A string that represents the unique identifier for the Amazon Web Services account that
         *        owns the bucket.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        S3_BUCKET_EFFECTIVE_PERMISSION - A string that represents an enumerated value that Macie defines for
         *        the <a href=
         *        "https://docs.aws.amazon.com/macie/latest/APIReference/datasources-s3.html#datasources-s3-prop-bucketpublicaccess-effectivepermission"
         *        >BucketPublicAccess.effectivePermission</a> property of a bucket.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        S3_BUCKET_NAME - A string that represents the name of a bucket.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        S3_BUCKET_SHARED_ACCESS - A string that represents an enumerated value that Macie defines for the <a
         *        href=
         *        "https://docs.aws.amazon.com/macie/latest/APIReference/datasources-s3.html#datasources-s3-prop-bucketmetadata-sharedaccess"
         *        >BucketMetadata.sharedAccess</a> property of a bucket.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Values are case sensitive. Also, Macie doesn't support use of partial values or wildcard characters in
         *        these values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(String... values);
    }

    static final class BuilderImpl implements Builder {
        private String comparator;

        private String key;

        private List<String> values = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SimpleCriterionForJob model) {
            comparator(model.comparator);
            key(model.key);
            values(model.values);
        }

        public final String getComparator() {
            return comparator;
        }

        public final void setComparator(String comparator) {
            this.comparator = comparator;
        }

        @Override
        public final Builder comparator(String comparator) {
            this.comparator = comparator;
            return this;
        }

        @Override
        public final Builder comparator(JobComparator comparator) {
            this.comparator(comparator == null ? null : comparator.toString());
            return this;
        }

        public final String getKey() {
            return key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        @Override
        public final Builder key(SimpleCriterionKeyForJob key) {
            this.key(key == null ? null : key.toString());
            return this;
        }

        public final Collection<String> getValues() {
            if (values instanceof SdkAutoConstructList) {
                return null;
            }
            return values;
        }

        public final void setValues(Collection<String> values) {
            this.values = ___listOf__stringCopier.copy(values);
        }

        @Override
        public final Builder values(Collection<String> values) {
            this.values = ___listOf__stringCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(String... values) {
            values(Arrays.asList(values));
            return this;
        }

        @Override
        public SimpleCriterionForJob build() {
            return new SimpleCriterionForJob(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
