/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAutomatedDiscoveryConfigurationRequest extends Macie2Request implements
        ToCopyableBuilder<UpdateAutomatedDiscoveryConfigurationRequest.Builder, UpdateAutomatedDiscoveryConfigurationRequest> {
    private static final SdkField<String> AUTO_ENABLE_ORGANIZATION_MEMBERS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("autoEnableOrganizationMembers")
            .getter(getter(UpdateAutomatedDiscoveryConfigurationRequest::autoEnableOrganizationMembersAsString))
            .setter(setter(Builder::autoEnableOrganizationMembers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoEnableOrganizationMembers")
                    .build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(UpdateAutomatedDiscoveryConfigurationRequest::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            AUTO_ENABLE_ORGANIZATION_MEMBERS_FIELD, STATUS_FIELD));

    private final String autoEnableOrganizationMembers;

    private final String status;

    private UpdateAutomatedDiscoveryConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.autoEnableOrganizationMembers = builder.autoEnableOrganizationMembers;
        this.status = builder.status;
    }

    /**
     * <p>
     * Specifies whether to automatically enable automated sensitive data discovery for accounts in the organization.
     * Valid values are: ALL (default), enable it for all existing accounts and new member accounts; NEW, enable it only
     * for new member accounts; and, NONE, don't enable it for any accounts.
     * </p>
     * <p>
     * If you specify NEW or NONE, automated sensitive data discovery continues to be enabled for any existing accounts
     * that it's currently enabled for. To enable or disable it for individual member accounts, specify NEW or NONE, and
     * then enable or disable it for each account by using the BatchUpdateAutomatedDiscoveryAccounts operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #autoEnableOrganizationMembers} will return {@link AutoEnableMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #autoEnableOrganizationMembersAsString}.
     * </p>
     * 
     * @return Specifies whether to automatically enable automated sensitive data discovery for accounts in the
     *         organization. Valid values are: ALL (default), enable it for all existing accounts and new member
     *         accounts; NEW, enable it only for new member accounts; and, NONE, don't enable it for any accounts.</p>
     *         <p>
     *         If you specify NEW or NONE, automated sensitive data discovery continues to be enabled for any existing
     *         accounts that it's currently enabled for. To enable or disable it for individual member accounts, specify
     *         NEW or NONE, and then enable or disable it for each account by using the
     *         BatchUpdateAutomatedDiscoveryAccounts operation.
     * @see AutoEnableMode
     */
    public final AutoEnableMode autoEnableOrganizationMembers() {
        return AutoEnableMode.fromValue(autoEnableOrganizationMembers);
    }

    /**
     * <p>
     * Specifies whether to automatically enable automated sensitive data discovery for accounts in the organization.
     * Valid values are: ALL (default), enable it for all existing accounts and new member accounts; NEW, enable it only
     * for new member accounts; and, NONE, don't enable it for any accounts.
     * </p>
     * <p>
     * If you specify NEW or NONE, automated sensitive data discovery continues to be enabled for any existing accounts
     * that it's currently enabled for. To enable or disable it for individual member accounts, specify NEW or NONE, and
     * then enable or disable it for each account by using the BatchUpdateAutomatedDiscoveryAccounts operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #autoEnableOrganizationMembers} will return {@link AutoEnableMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #autoEnableOrganizationMembersAsString}.
     * </p>
     * 
     * @return Specifies whether to automatically enable automated sensitive data discovery for accounts in the
     *         organization. Valid values are: ALL (default), enable it for all existing accounts and new member
     *         accounts; NEW, enable it only for new member accounts; and, NONE, don't enable it for any accounts.</p>
     *         <p>
     *         If you specify NEW or NONE, automated sensitive data discovery continues to be enabled for any existing
     *         accounts that it's currently enabled for. To enable or disable it for individual member accounts, specify
     *         NEW or NONE, and then enable or disable it for each account by using the
     *         BatchUpdateAutomatedDiscoveryAccounts operation.
     * @see AutoEnableMode
     */
    public final String autoEnableOrganizationMembersAsString() {
        return autoEnableOrganizationMembers;
    }

    /**
     * <p>
     * The new status of automated sensitive data discovery for the organization or account. Valid values are: ENABLED,
     * start or resume all automated sensitive data discovery activities; and, DISABLED, stop performing all automated
     * sensitive data discovery activities.
     * </p>
     * <p>
     * If you specify DISABLED for an administrator account, you also disable automated sensitive data discovery for all
     * member accounts in the organization.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AutomatedDiscoveryStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The new status of automated sensitive data discovery for the organization or account. Valid values are:
     *         ENABLED, start or resume all automated sensitive data discovery activities; and, DISABLED, stop
     *         performing all automated sensitive data discovery activities.</p>
     *         <p>
     *         If you specify DISABLED for an administrator account, you also disable automated sensitive data discovery
     *         for all member accounts in the organization.
     * @see AutomatedDiscoveryStatus
     */
    public final AutomatedDiscoveryStatus status() {
        return AutomatedDiscoveryStatus.fromValue(status);
    }

    /**
     * <p>
     * The new status of automated sensitive data discovery for the organization or account. Valid values are: ENABLED,
     * start or resume all automated sensitive data discovery activities; and, DISABLED, stop performing all automated
     * sensitive data discovery activities.
     * </p>
     * <p>
     * If you specify DISABLED for an administrator account, you also disable automated sensitive data discovery for all
     * member accounts in the organization.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AutomatedDiscoveryStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The new status of automated sensitive data discovery for the organization or account. Valid values are:
     *         ENABLED, start or resume all automated sensitive data discovery activities; and, DISABLED, stop
     *         performing all automated sensitive data discovery activities.</p>
     *         <p>
     *         If you specify DISABLED for an administrator account, you also disable automated sensitive data discovery
     *         for all member accounts in the organization.
     * @see AutomatedDiscoveryStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(autoEnableOrganizationMembersAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAutomatedDiscoveryConfigurationRequest)) {
            return false;
        }
        UpdateAutomatedDiscoveryConfigurationRequest other = (UpdateAutomatedDiscoveryConfigurationRequest) obj;
        return Objects.equals(autoEnableOrganizationMembersAsString(), other.autoEnableOrganizationMembersAsString())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateAutomatedDiscoveryConfigurationRequest")
                .add("AutoEnableOrganizationMembers", autoEnableOrganizationMembersAsString()).add("Status", statusAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "autoEnableOrganizationMembers":
            return Optional.ofNullable(clazz.cast(autoEnableOrganizationMembersAsString()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateAutomatedDiscoveryConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateAutomatedDiscoveryConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Macie2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateAutomatedDiscoveryConfigurationRequest> {
        /**
         * <p>
         * Specifies whether to automatically enable automated sensitive data discovery for accounts in the
         * organization. Valid values are: ALL (default), enable it for all existing accounts and new member accounts;
         * NEW, enable it only for new member accounts; and, NONE, don't enable it for any accounts.
         * </p>
         * <p>
         * If you specify NEW or NONE, automated sensitive data discovery continues to be enabled for any existing
         * accounts that it's currently enabled for. To enable or disable it for individual member accounts, specify NEW
         * or NONE, and then enable or disable it for each account by using the BatchUpdateAutomatedDiscoveryAccounts
         * operation.
         * </p>
         * 
         * @param autoEnableOrganizationMembers
         *        Specifies whether to automatically enable automated sensitive data discovery for accounts in the
         *        organization. Valid values are: ALL (default), enable it for all existing accounts and new member
         *        accounts; NEW, enable it only for new member accounts; and, NONE, don't enable it for any
         *        accounts.</p>
         *        <p>
         *        If you specify NEW or NONE, automated sensitive data discovery continues to be enabled for any
         *        existing accounts that it's currently enabled for. To enable or disable it for individual member
         *        accounts, specify NEW or NONE, and then enable or disable it for each account by using the
         *        BatchUpdateAutomatedDiscoveryAccounts operation.
         * @see AutoEnableMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoEnableMode
         */
        Builder autoEnableOrganizationMembers(String autoEnableOrganizationMembers);

        /**
         * <p>
         * Specifies whether to automatically enable automated sensitive data discovery for accounts in the
         * organization. Valid values are: ALL (default), enable it for all existing accounts and new member accounts;
         * NEW, enable it only for new member accounts; and, NONE, don't enable it for any accounts.
         * </p>
         * <p>
         * If you specify NEW or NONE, automated sensitive data discovery continues to be enabled for any existing
         * accounts that it's currently enabled for. To enable or disable it for individual member accounts, specify NEW
         * or NONE, and then enable or disable it for each account by using the BatchUpdateAutomatedDiscoveryAccounts
         * operation.
         * </p>
         * 
         * @param autoEnableOrganizationMembers
         *        Specifies whether to automatically enable automated sensitive data discovery for accounts in the
         *        organization. Valid values are: ALL (default), enable it for all existing accounts and new member
         *        accounts; NEW, enable it only for new member accounts; and, NONE, don't enable it for any
         *        accounts.</p>
         *        <p>
         *        If you specify NEW or NONE, automated sensitive data discovery continues to be enabled for any
         *        existing accounts that it's currently enabled for. To enable or disable it for individual member
         *        accounts, specify NEW or NONE, and then enable or disable it for each account by using the
         *        BatchUpdateAutomatedDiscoveryAccounts operation.
         * @see AutoEnableMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoEnableMode
         */
        Builder autoEnableOrganizationMembers(AutoEnableMode autoEnableOrganizationMembers);

        /**
         * <p>
         * The new status of automated sensitive data discovery for the organization or account. Valid values are:
         * ENABLED, start or resume all automated sensitive data discovery activities; and, DISABLED, stop performing
         * all automated sensitive data discovery activities.
         * </p>
         * <p>
         * If you specify DISABLED for an administrator account, you also disable automated sensitive data discovery for
         * all member accounts in the organization.
         * </p>
         * 
         * @param status
         *        The new status of automated sensitive data discovery for the organization or account. Valid values
         *        are: ENABLED, start or resume all automated sensitive data discovery activities; and, DISABLED, stop
         *        performing all automated sensitive data discovery activities.</p>
         *        <p>
         *        If you specify DISABLED for an administrator account, you also disable automated sensitive data
         *        discovery for all member accounts in the organization.
         * @see AutomatedDiscoveryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutomatedDiscoveryStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The new status of automated sensitive data discovery for the organization or account. Valid values are:
         * ENABLED, start or resume all automated sensitive data discovery activities; and, DISABLED, stop performing
         * all automated sensitive data discovery activities.
         * </p>
         * <p>
         * If you specify DISABLED for an administrator account, you also disable automated sensitive data discovery for
         * all member accounts in the organization.
         * </p>
         * 
         * @param status
         *        The new status of automated sensitive data discovery for the organization or account. Valid values
         *        are: ENABLED, start or resume all automated sensitive data discovery activities; and, DISABLED, stop
         *        performing all automated sensitive data discovery activities.</p>
         *        <p>
         *        If you specify DISABLED for an administrator account, you also disable automated sensitive data
         *        discovery for all member accounts in the organization.
         * @see AutomatedDiscoveryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutomatedDiscoveryStatus
         */
        Builder status(AutomatedDiscoveryStatus status);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Macie2Request.BuilderImpl implements Builder {
        private String autoEnableOrganizationMembers;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAutomatedDiscoveryConfigurationRequest model) {
            super(model);
            autoEnableOrganizationMembers(model.autoEnableOrganizationMembers);
            status(model.status);
        }

        public final String getAutoEnableOrganizationMembers() {
            return autoEnableOrganizationMembers;
        }

        public final void setAutoEnableOrganizationMembers(String autoEnableOrganizationMembers) {
            this.autoEnableOrganizationMembers = autoEnableOrganizationMembers;
        }

        @Override
        public final Builder autoEnableOrganizationMembers(String autoEnableOrganizationMembers) {
            this.autoEnableOrganizationMembers = autoEnableOrganizationMembers;
            return this;
        }

        @Override
        public final Builder autoEnableOrganizationMembers(AutoEnableMode autoEnableOrganizationMembers) {
            this.autoEnableOrganizationMembers(autoEnableOrganizationMembers == null ? null : autoEnableOrganizationMembers
                    .toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AutomatedDiscoveryStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAutomatedDiscoveryConfigurationRequest build() {
            return new UpdateAutomatedDiscoveryConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
