/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies an S3 bucket to store data classification results in, and the encryption settings to use when storing
 * results in that bucket.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3Destination implements SdkPojo, Serializable, ToCopyableBuilder<S3Destination.Builder, S3Destination> {
    private static final SdkField<String> BUCKET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("bucketName").getter(getter(S3Destination::bucketName)).setter(setter(Builder::bucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketName").build()).build();

    private static final SdkField<String> KEY_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("keyPrefix").getter(getter(S3Destination::keyPrefix)).setter(setter(Builder::keyPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyPrefix").build()).build();

    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kmsKeyArn").getter(getter(S3Destination::kmsKeyArn)).setter(setter(Builder::kmsKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_NAME_FIELD,
            KEY_PREFIX_FIELD, KMS_KEY_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String bucketName;

    private final String keyPrefix;

    private final String kmsKeyArn;

    private S3Destination(BuilderImpl builder) {
        this.bucketName = builder.bucketName;
        this.keyPrefix = builder.keyPrefix;
        this.kmsKeyArn = builder.kmsKeyArn;
    }

    /**
     * <p>
     * The name of the bucket. This must be the name of an existing general purpose bucket.
     * </p>
     * 
     * @return The name of the bucket. This must be the name of an existing general purpose bucket.
     */
    public final String bucketName() {
        return bucketName;
    }

    /**
     * <p>
     * The path prefix to use in the path to the location in the bucket. This prefix specifies where to store
     * classification results in the bucket.
     * </p>
     * 
     * @return The path prefix to use in the path to the location in the bucket. This prefix specifies where to store
     *         classification results in the bucket.
     */
    public final String keyPrefix() {
        return keyPrefix;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the customer managed KMS key to use for encryption of the results. This must be
     * the ARN of an existing, symmetric encryption KMS key that's enabled in the same Amazon Web Services Region as the
     * bucket.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the customer managed KMS key to use for encryption of the results. This
     *         must be the ARN of an existing, symmetric encryption KMS key that's enabled in the same Amazon Web
     *         Services Region as the bucket.
     */
    public final String kmsKeyArn() {
        return kmsKeyArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bucketName());
        hashCode = 31 * hashCode + Objects.hashCode(keyPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Destination)) {
            return false;
        }
        S3Destination other = (S3Destination) obj;
        return Objects.equals(bucketName(), other.bucketName()) && Objects.equals(keyPrefix(), other.keyPrefix())
                && Objects.equals(kmsKeyArn(), other.kmsKeyArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3Destination").add("BucketName", bucketName()).add("KeyPrefix", keyPrefix())
                .add("KmsKeyArn", kmsKeyArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "bucketName":
            return Optional.ofNullable(clazz.cast(bucketName()));
        case "keyPrefix":
            return Optional.ofNullable(clazz.cast(keyPrefix()));
        case "kmsKeyArn":
            return Optional.ofNullable(clazz.cast(kmsKeyArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3Destination, T> g) {
        return obj -> g.apply((S3Destination) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3Destination> {
        /**
         * <p>
         * The name of the bucket. This must be the name of an existing general purpose bucket.
         * </p>
         * 
         * @param bucketName
         *        The name of the bucket. This must be the name of an existing general purpose bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketName(String bucketName);

        /**
         * <p>
         * The path prefix to use in the path to the location in the bucket. This prefix specifies where to store
         * classification results in the bucket.
         * </p>
         * 
         * @param keyPrefix
         *        The path prefix to use in the path to the location in the bucket. This prefix specifies where to store
         *        classification results in the bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyPrefix(String keyPrefix);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the customer managed KMS key to use for encryption of the results. This
         * must be the ARN of an existing, symmetric encryption KMS key that's enabled in the same Amazon Web Services
         * Region as the bucket.
         * </p>
         * 
         * @param kmsKeyArn
         *        The Amazon Resource Name (ARN) of the customer managed KMS key to use for encryption of the results.
         *        This must be the ARN of an existing, symmetric encryption KMS key that's enabled in the same Amazon
         *        Web Services Region as the bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyArn(String kmsKeyArn);
    }

    static final class BuilderImpl implements Builder {
        private String bucketName;

        private String keyPrefix;

        private String kmsKeyArn;

        private BuilderImpl() {
        }

        private BuilderImpl(S3Destination model) {
            bucketName(model.bucketName);
            keyPrefix(model.keyPrefix);
            kmsKeyArn(model.kmsKeyArn);
        }

        public final String getBucketName() {
            return bucketName;
        }

        public final void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        @Override
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public final String getKeyPrefix() {
            return keyPrefix;
        }

        public final void setKeyPrefix(String keyPrefix) {
            this.keyPrefix = keyPrefix;
        }

        @Override
        public final Builder keyPrefix(String keyPrefix) {
            this.keyPrefix = keyPrefix;
            return this;
        }

        public final String getKmsKeyArn() {
            return kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        @Override
        public S3Destination build() {
            return new S3Destination(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
