/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateSensitivityInspectionTemplateRequest extends Macie2Request implements
        ToCopyableBuilder<UpdateSensitivityInspectionTemplateRequest.Builder, UpdateSensitivityInspectionTemplateRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateSensitivityInspectionTemplateRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<SensitivityInspectionTemplateExcludes> EXCLUDES_FIELD = SdkField
            .<SensitivityInspectionTemplateExcludes> builder(MarshallingType.SDK_POJO).memberName("excludes")
            .getter(getter(UpdateSensitivityInspectionTemplateRequest::excludes)).setter(setter(Builder::excludes))
            .constructor(SensitivityInspectionTemplateExcludes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("excludes").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(UpdateSensitivityInspectionTemplateRequest::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("id").build()).build();

    private static final SdkField<SensitivityInspectionTemplateIncludes> INCLUDES_FIELD = SdkField
            .<SensitivityInspectionTemplateIncludes> builder(MarshallingType.SDK_POJO).memberName("includes")
            .getter(getter(UpdateSensitivityInspectionTemplateRequest::includes)).setter(setter(Builder::includes))
            .constructor(SensitivityInspectionTemplateIncludes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includes").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            EXCLUDES_FIELD, ID_FIELD, INCLUDES_FIELD));

    private final String description;

    private final SensitivityInspectionTemplateExcludes excludes;

    private final String id;

    private final SensitivityInspectionTemplateIncludes includes;

    private UpdateSensitivityInspectionTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.excludes = builder.excludes;
        this.id = builder.id;
        this.includes = builder.includes;
    }

    /**
     * <p>
     * A custom description of the template. The description can contain as many as 200 characters.
     * </p>
     * 
     * @return A custom description of the template. The description can contain as many as 200 characters.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The managed data identifiers to explicitly exclude (not use) when performing automated sensitive data discovery.
     * </p>
     * <p>
     * To exclude an allow list or custom data identifier that's currently included by the template, update the values
     * for the SensitivityInspectionTemplateIncludes.allowListIds and
     * SensitivityInspectionTemplateIncludes.customDataIdentifierIds properties, respectively.
     * </p>
     * 
     * @return <p>
     *         The managed data identifiers to explicitly exclude (not use) when performing automated sensitive data
     *         discovery.
     *         </p>
     *         <p>
     *         To exclude an allow list or custom data identifier that's currently included by the template, update the
     *         values for the SensitivityInspectionTemplateIncludes.allowListIds and
     *         SensitivityInspectionTemplateIncludes.customDataIdentifierIds properties, respectively.
     *         </p>
     */
    public final SensitivityInspectionTemplateExcludes excludes() {
        return excludes;
    }

    /**
     * <p>
     * The unique identifier for the Amazon Macie resource that the request applies to.
     * </p>
     * 
     * @return The unique identifier for the Amazon Macie resource that the request applies to.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The allow lists, custom data identifiers, and managed data identifiers to explicitly include (use) when
     * performing automated sensitive data discovery.
     * </p>
     * 
     * @return The allow lists, custom data identifiers, and managed data identifiers to explicitly include (use) when
     *         performing automated sensitive data discovery.
     */
    public final SensitivityInspectionTemplateIncludes includes() {
        return includes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(excludes());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(includes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSensitivityInspectionTemplateRequest)) {
            return false;
        }
        UpdateSensitivityInspectionTemplateRequest other = (UpdateSensitivityInspectionTemplateRequest) obj;
        return Objects.equals(description(), other.description()) && Objects.equals(excludes(), other.excludes())
                && Objects.equals(id(), other.id()) && Objects.equals(includes(), other.includes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateSensitivityInspectionTemplateRequest").add("Description", description())
                .add("Excludes", excludes()).add("Id", id()).add("Includes", includes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "excludes":
            return Optional.ofNullable(clazz.cast(excludes()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "includes":
            return Optional.ofNullable(clazz.cast(includes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateSensitivityInspectionTemplateRequest, T> g) {
        return obj -> g.apply((UpdateSensitivityInspectionTemplateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Macie2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateSensitivityInspectionTemplateRequest> {
        /**
         * <p>
         * A custom description of the template. The description can contain as many as 200 characters.
         * </p>
         * 
         * @param description
         *        A custom description of the template. The description can contain as many as 200 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The managed data identifiers to explicitly exclude (not use) when performing automated sensitive data
         * discovery.
         * </p>
         * <p>
         * To exclude an allow list or custom data identifier that's currently included by the template, update the
         * values for the SensitivityInspectionTemplateIncludes.allowListIds and
         * SensitivityInspectionTemplateIncludes.customDataIdentifierIds properties, respectively.
         * </p>
         * 
         * @param excludes
         *        <p>
         *        The managed data identifiers to explicitly exclude (not use) when performing automated sensitive data
         *        discovery.
         *        </p>
         *        <p>
         *        To exclude an allow list or custom data identifier that's currently included by the template, update
         *        the values for the SensitivityInspectionTemplateIncludes.allowListIds and
         *        SensitivityInspectionTemplateIncludes.customDataIdentifierIds properties, respectively.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludes(SensitivityInspectionTemplateExcludes excludes);

        /**
         * <p>
         * The managed data identifiers to explicitly exclude (not use) when performing automated sensitive data
         * discovery.
         * </p>
         * <p>
         * To exclude an allow list or custom data identifier that's currently included by the template, update the
         * values for the SensitivityInspectionTemplateIncludes.allowListIds and
         * SensitivityInspectionTemplateIncludes.customDataIdentifierIds properties, respectively.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link SensitivityInspectionTemplateExcludes.Builder} avoiding the need to create one manually via
         * {@link SensitivityInspectionTemplateExcludes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SensitivityInspectionTemplateExcludes.Builder#build()} is called
         * immediately and its result is passed to {@link #excludes(SensitivityInspectionTemplateExcludes)}.
         * 
         * @param excludes
         *        a consumer that will call methods on {@link SensitivityInspectionTemplateExcludes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #excludes(SensitivityInspectionTemplateExcludes)
         */
        default Builder excludes(Consumer<SensitivityInspectionTemplateExcludes.Builder> excludes) {
            return excludes(SensitivityInspectionTemplateExcludes.builder().applyMutation(excludes).build());
        }

        /**
         * <p>
         * The unique identifier for the Amazon Macie resource that the request applies to.
         * </p>
         * 
         * @param id
         *        The unique identifier for the Amazon Macie resource that the request applies to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The allow lists, custom data identifiers, and managed data identifiers to explicitly include (use) when
         * performing automated sensitive data discovery.
         * </p>
         * 
         * @param includes
         *        The allow lists, custom data identifiers, and managed data identifiers to explicitly include (use)
         *        when performing automated sensitive data discovery.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includes(SensitivityInspectionTemplateIncludes includes);

        /**
         * <p>
         * The allow lists, custom data identifiers, and managed data identifiers to explicitly include (use) when
         * performing automated sensitive data discovery.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link SensitivityInspectionTemplateIncludes.Builder} avoiding the need to create one manually via
         * {@link SensitivityInspectionTemplateIncludes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SensitivityInspectionTemplateIncludes.Builder#build()} is called
         * immediately and its result is passed to {@link #includes(SensitivityInspectionTemplateIncludes)}.
         * 
         * @param includes
         *        a consumer that will call methods on {@link SensitivityInspectionTemplateIncludes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #includes(SensitivityInspectionTemplateIncludes)
         */
        default Builder includes(Consumer<SensitivityInspectionTemplateIncludes.Builder> includes) {
            return includes(SensitivityInspectionTemplateIncludes.builder().applyMutation(includes).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Macie2Request.BuilderImpl implements Builder {
        private String description;

        private SensitivityInspectionTemplateExcludes excludes;

        private String id;

        private SensitivityInspectionTemplateIncludes includes;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSensitivityInspectionTemplateRequest model) {
            super(model);
            description(model.description);
            excludes(model.excludes);
            id(model.id);
            includes(model.includes);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final SensitivityInspectionTemplateExcludes.Builder getExcludes() {
            return excludes != null ? excludes.toBuilder() : null;
        }

        public final void setExcludes(SensitivityInspectionTemplateExcludes.BuilderImpl excludes) {
            this.excludes = excludes != null ? excludes.build() : null;
        }

        @Override
        public final Builder excludes(SensitivityInspectionTemplateExcludes excludes) {
            this.excludes = excludes;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final SensitivityInspectionTemplateIncludes.Builder getIncludes() {
            return includes != null ? includes.toBuilder() : null;
        }

        public final void setIncludes(SensitivityInspectionTemplateIncludes.BuilderImpl includes) {
            this.includes = includes != null ? includes.build() : null;
        }

        @Override
        public final Builder includes(SensitivityInspectionTemplateIncludes includes) {
            this.includes = includes;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSensitivityInspectionTemplateRequest build() {
            return new UpdateSensitivityInspectionTemplateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
