/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies managed data identifiers to exclude (not use) when performing automated sensitive data discovery. For
 * information about the managed data identifiers that Amazon Macie currently provides, see <a
 * href="https://docs.aws.amazon.com/macie/latest/user/managed-data-identifiers.html">Using managed data identifiers</a>
 * in the <i>Amazon Macie User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SensitivityInspectionTemplateExcludes implements SdkPojo, Serializable,
        ToCopyableBuilder<SensitivityInspectionTemplateExcludes.Builder, SensitivityInspectionTemplateExcludes> {
    private static final SdkField<List<String>> MANAGED_DATA_IDENTIFIER_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("managedDataIdentifierIds")
            .getter(getter(SensitivityInspectionTemplateExcludes::managedDataIdentifierIds))
            .setter(setter(Builder::managedDataIdentifierIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managedDataIdentifierIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(MANAGED_DATA_IDENTIFIER_IDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> managedDataIdentifierIds;

    private SensitivityInspectionTemplateExcludes(BuilderImpl builder) {
        this.managedDataIdentifierIds = builder.managedDataIdentifierIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the ManagedDataIdentifierIds property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasManagedDataIdentifierIds() {
        return managedDataIdentifierIds != null && !(managedDataIdentifierIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of unique identifiers, one for each managed data identifier to exclude. To retrieve a list of valid
     * values, use the ListManagedDataIdentifiers operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasManagedDataIdentifierIds} method.
     * </p>
     * 
     * @return An array of unique identifiers, one for each managed data identifier to exclude. To retrieve a list of
     *         valid values, use the ListManagedDataIdentifiers operation.
     */
    public final List<String> managedDataIdentifierIds() {
        return managedDataIdentifierIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasManagedDataIdentifierIds() ? managedDataIdentifierIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SensitivityInspectionTemplateExcludes)) {
            return false;
        }
        SensitivityInspectionTemplateExcludes other = (SensitivityInspectionTemplateExcludes) obj;
        return hasManagedDataIdentifierIds() == other.hasManagedDataIdentifierIds()
                && Objects.equals(managedDataIdentifierIds(), other.managedDataIdentifierIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SensitivityInspectionTemplateExcludes")
                .add("ManagedDataIdentifierIds", hasManagedDataIdentifierIds() ? managedDataIdentifierIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "managedDataIdentifierIds":
            return Optional.ofNullable(clazz.cast(managedDataIdentifierIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SensitivityInspectionTemplateExcludes, T> g) {
        return obj -> g.apply((SensitivityInspectionTemplateExcludes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SensitivityInspectionTemplateExcludes> {
        /**
         * <p>
         * An array of unique identifiers, one for each managed data identifier to exclude. To retrieve a list of valid
         * values, use the ListManagedDataIdentifiers operation.
         * </p>
         * 
         * @param managedDataIdentifierIds
         *        An array of unique identifiers, one for each managed data identifier to exclude. To retrieve a list of
         *        valid values, use the ListManagedDataIdentifiers operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedDataIdentifierIds(Collection<String> managedDataIdentifierIds);

        /**
         * <p>
         * An array of unique identifiers, one for each managed data identifier to exclude. To retrieve a list of valid
         * values, use the ListManagedDataIdentifiers operation.
         * </p>
         * 
         * @param managedDataIdentifierIds
         *        An array of unique identifiers, one for each managed data identifier to exclude. To retrieve a list of
         *        valid values, use the ListManagedDataIdentifiers operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedDataIdentifierIds(String... managedDataIdentifierIds);
    }

    static final class BuilderImpl implements Builder {
        private List<String> managedDataIdentifierIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SensitivityInspectionTemplateExcludes model) {
            managedDataIdentifierIds(model.managedDataIdentifierIds);
        }

        public final Collection<String> getManagedDataIdentifierIds() {
            if (managedDataIdentifierIds instanceof SdkAutoConstructList) {
                return null;
            }
            return managedDataIdentifierIds;
        }

        public final void setManagedDataIdentifierIds(Collection<String> managedDataIdentifierIds) {
            this.managedDataIdentifierIds = ___listOf__stringCopier.copy(managedDataIdentifierIds);
        }

        @Override
        public final Builder managedDataIdentifierIds(Collection<String> managedDataIdentifierIds) {
            this.managedDataIdentifierIds = ___listOf__stringCopier.copy(managedDataIdentifierIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder managedDataIdentifierIds(String... managedDataIdentifierIds) {
            managedDataIdentifierIds(Arrays.asList(managedDataIdentifierIds));
            return this;
        }

        @Override
        public SensitivityInspectionTemplateExcludes build() {
            return new SensitivityInspectionTemplateExcludes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
