/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about a request that failed to change the status of automated sensitive data discovery for an
 * Amazon Macie account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutomatedDiscoveryAccountUpdateError implements SdkPojo, Serializable,
        ToCopyableBuilder<AutomatedDiscoveryAccountUpdateError.Builder, AutomatedDiscoveryAccountUpdateError> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accountId").getter(getter(AutomatedDiscoveryAccountUpdateError::accountId))
            .setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()).build();

    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorCode").getter(getter(AutomatedDiscoveryAccountUpdateError::errorCodeAsString))
            .setter(setter(Builder::errorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorCode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            ERROR_CODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("accountId", ACCOUNT_ID_FIELD);
                    put("errorCode", ERROR_CODE_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String accountId;

    private final String errorCode;

    private AutomatedDiscoveryAccountUpdateError(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.errorCode = builder.errorCode;
    }

    /**
     * <p>
     * The Amazon Web Services account ID for the account that the request applied to.
     * </p>
     * 
     * @return The Amazon Web Services account ID for the account that the request applied to.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The error code for the error that caused the request to fail for the account (accountId). Possible values are:
     * ACCOUNT_NOT_FOUND, the account doesn’t exist or you're not the Amazon Macie administrator for the account; and,
     * ACCOUNT_PAUSED, Macie isn’t enabled for the account in the current Amazon Web Services Region.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #errorCode} will
     * return {@link AutomatedDiscoveryAccountUpdateErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #errorCodeAsString}.
     * </p>
     * 
     * @return The error code for the error that caused the request to fail for the account (accountId). Possible values
     *         are: ACCOUNT_NOT_FOUND, the account doesn’t exist or you're not the Amazon Macie administrator for the
     *         account; and, ACCOUNT_PAUSED, Macie isn’t enabled for the account in the current Amazon Web Services
     *         Region.
     * @see AutomatedDiscoveryAccountUpdateErrorCode
     */
    public final AutomatedDiscoveryAccountUpdateErrorCode errorCode() {
        return AutomatedDiscoveryAccountUpdateErrorCode.fromValue(errorCode);
    }

    /**
     * <p>
     * The error code for the error that caused the request to fail for the account (accountId). Possible values are:
     * ACCOUNT_NOT_FOUND, the account doesn’t exist or you're not the Amazon Macie administrator for the account; and,
     * ACCOUNT_PAUSED, Macie isn’t enabled for the account in the current Amazon Web Services Region.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #errorCode} will
     * return {@link AutomatedDiscoveryAccountUpdateErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #errorCodeAsString}.
     * </p>
     * 
     * @return The error code for the error that caused the request to fail for the account (accountId). Possible values
     *         are: ACCOUNT_NOT_FOUND, the account doesn’t exist or you're not the Amazon Macie administrator for the
     *         account; and, ACCOUNT_PAUSED, Macie isn’t enabled for the account in the current Amazon Web Services
     *         Region.
     * @see AutomatedDiscoveryAccountUpdateErrorCode
     */
    public final String errorCodeAsString() {
        return errorCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(errorCodeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomatedDiscoveryAccountUpdateError)) {
            return false;
        }
        AutomatedDiscoveryAccountUpdateError other = (AutomatedDiscoveryAccountUpdateError) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(errorCodeAsString(), other.errorCodeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutomatedDiscoveryAccountUpdateError").add("AccountId", accountId())
                .add("ErrorCode", errorCodeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "errorCode":
            return Optional.ofNullable(clazz.cast(errorCodeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AutomatedDiscoveryAccountUpdateError, T> g) {
        return obj -> g.apply((AutomatedDiscoveryAccountUpdateError) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutomatedDiscoveryAccountUpdateError> {
        /**
         * <p>
         * The Amazon Web Services account ID for the account that the request applied to.
         * </p>
         * 
         * @param accountId
         *        The Amazon Web Services account ID for the account that the request applied to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The error code for the error that caused the request to fail for the account (accountId). Possible values
         * are: ACCOUNT_NOT_FOUND, the account doesn’t exist or you're not the Amazon Macie administrator for the
         * account; and, ACCOUNT_PAUSED, Macie isn’t enabled for the account in the current Amazon Web Services Region.
         * </p>
         * 
         * @param errorCode
         *        The error code for the error that caused the request to fail for the account (accountId). Possible
         *        values are: ACCOUNT_NOT_FOUND, the account doesn’t exist or you're not the Amazon Macie administrator
         *        for the account; and, ACCOUNT_PAUSED, Macie isn’t enabled for the account in the current Amazon Web
         *        Services Region.
         * @see AutomatedDiscoveryAccountUpdateErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutomatedDiscoveryAccountUpdateErrorCode
         */
        Builder errorCode(String errorCode);

        /**
         * <p>
         * The error code for the error that caused the request to fail for the account (accountId). Possible values
         * are: ACCOUNT_NOT_FOUND, the account doesn’t exist or you're not the Amazon Macie administrator for the
         * account; and, ACCOUNT_PAUSED, Macie isn’t enabled for the account in the current Amazon Web Services Region.
         * </p>
         * 
         * @param errorCode
         *        The error code for the error that caused the request to fail for the account (accountId). Possible
         *        values are: ACCOUNT_NOT_FOUND, the account doesn’t exist or you're not the Amazon Macie administrator
         *        for the account; and, ACCOUNT_PAUSED, Macie isn’t enabled for the account in the current Amazon Web
         *        Services Region.
         * @see AutomatedDiscoveryAccountUpdateErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutomatedDiscoveryAccountUpdateErrorCode
         */
        Builder errorCode(AutomatedDiscoveryAccountUpdateErrorCode errorCode);
    }

    static final class BuilderImpl implements Builder {
        private String accountId;

        private String errorCode;

        private BuilderImpl() {
        }

        private BuilderImpl(AutomatedDiscoveryAccountUpdateError model) {
            accountId(model.accountId);
            errorCode(model.errorCode);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getErrorCode() {
            return errorCode;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        @Override
        public final Builder errorCode(AutomatedDiscoveryAccountUpdateErrorCode errorCode) {
            this.errorCode(errorCode == null ? null : errorCode.toString());
            return this;
        }

        @Override
        public AutomatedDiscoveryAccountUpdateError build() {
            return new AutomatedDiscoveryAccountUpdateError(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
