/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateFindingsFilterRequest extends Macie2Request implements
        ToCopyableBuilder<CreateFindingsFilterRequest.Builder, CreateFindingsFilterRequest> {
    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("action")
            .getter(getter(CreateFindingsFilterRequest::actionAsString)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateFindingsFilterRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateFindingsFilterRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<FindingCriteria> FINDING_CRITERIA_FIELD = SdkField
            .<FindingCriteria> builder(MarshallingType.SDK_POJO).memberName("findingCriteria")
            .getter(getter(CreateFindingsFilterRequest::findingCriteria)).setter(setter(Builder::findingCriteria))
            .constructor(FindingCriteria::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingCriteria").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateFindingsFilterRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Integer> POSITION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("position").getter(getter(CreateFindingsFilterRequest::position)).setter(setter(Builder::position))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("position").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateFindingsFilterRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD,
            CLIENT_TOKEN_FIELD, DESCRIPTION_FIELD, FINDING_CRITERIA_FIELD, NAME_FIELD, POSITION_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("action", ACTION_FIELD);
                    put("clientToken", CLIENT_TOKEN_FIELD);
                    put("description", DESCRIPTION_FIELD);
                    put("findingCriteria", FINDING_CRITERIA_FIELD);
                    put("name", NAME_FIELD);
                    put("position", POSITION_FIELD);
                    put("tags", TAGS_FIELD);
                }
            });

    private final String action;

    private final String clientToken;

    private final String description;

    private final FindingCriteria findingCriteria;

    private final String name;

    private final Integer position;

    private final Map<String, String> tags;

    private CreateFindingsFilterRequest(BuilderImpl builder) {
        super(builder);
        this.action = builder.action;
        this.clientToken = builder.clientToken;
        this.description = builder.description;
        this.findingCriteria = builder.findingCriteria;
        this.name = builder.name;
        this.position = builder.position;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The action to perform on findings that match the filter criteria (findingCriteria). Valid values are: ARCHIVE,
     * suppress (automatically archive) the findings; and, NOOP, don't perform any action on the findings.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link FindingsFilterAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #actionAsString}.
     * </p>
     * 
     * @return The action to perform on findings that match the filter criteria (findingCriteria). Valid values are:
     *         ARCHIVE, suppress (automatically archive) the findings; and, NOOP, don't perform any action on the
     *         findings.
     * @see FindingsFilterAction
     */
    public final FindingsFilterAction action() {
        return FindingsFilterAction.fromValue(action);
    }

    /**
     * <p>
     * The action to perform on findings that match the filter criteria (findingCriteria). Valid values are: ARCHIVE,
     * suppress (automatically archive) the findings; and, NOOP, don't perform any action on the findings.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link FindingsFilterAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #actionAsString}.
     * </p>
     * 
     * @return The action to perform on findings that match the filter criteria (findingCriteria). Valid values are:
     *         ARCHIVE, suppress (automatically archive) the findings; and, NOOP, don't perform any action on the
     *         findings.
     * @see FindingsFilterAction
     */
    public final String actionAsString() {
        return action;
    }

    /**
     * <p>
     * A unique, case-sensitive token that you provide to ensure the idempotency of the request.
     * </p>
     * 
     * @return A unique, case-sensitive token that you provide to ensure the idempotency of the request.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * A custom description of the filter. The description can contain as many as 512 characters.
     * </p>
     * <p>
     * We strongly recommend that you avoid including any sensitive data in the description of a filter. Other users of
     * your account might be able to see this description, depending on the actions that they're allowed to perform in
     * Amazon Macie.
     * </p>
     * 
     * @return A custom description of the filter. The description can contain as many as 512 characters.</p>
     *         <p>
     *         We strongly recommend that you avoid including any sensitive data in the description of a filter. Other
     *         users of your account might be able to see this description, depending on the actions that they're
     *         allowed to perform in Amazon Macie.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The criteria to use to filter findings.
     * </p>
     * 
     * @return The criteria to use to filter findings.
     */
    public final FindingCriteria findingCriteria() {
        return findingCriteria;
    }

    /**
     * <p>
     * A custom name for the filter. The name must contain at least 3 characters and can contain as many as 64
     * characters.
     * </p>
     * <p>
     * We strongly recommend that you avoid including any sensitive data in the name of a filter. Other users of your
     * account might be able to see this name, depending on the actions that they're allowed to perform in Amazon Macie.
     * </p>
     * 
     * @return A custom name for the filter. The name must contain at least 3 characters and can contain as many as 64
     *         characters.</p>
     *         <p>
     *         We strongly recommend that you avoid including any sensitive data in the name of a filter. Other users of
     *         your account might be able to see this name, depending on the actions that they're allowed to perform in
     *         Amazon Macie.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The position of the filter in the list of saved filters on the Amazon Macie console. This value also determines
     * the order in which the filter is applied to findings, relative to other filters that are also applied to the
     * findings.
     * </p>
     * 
     * @return The position of the filter in the list of saved filters on the Amazon Macie console. This value also
     *         determines the order in which the filter is applied to findings, relative to other filters that are also
     *         applied to the findings.
     */
    public final Integer position() {
        return position;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of key-value pairs that specifies the tags to associate with the filter.
     * </p>
     * <p>
     * A findings filter can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value. The
     * maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A map of key-value pairs that specifies the tags to associate with the filter.</p>
     *         <p>
     *         A findings filter can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag
     *         value. The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256
     *         characters.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(findingCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(position());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFindingsFilterRequest)) {
            return false;
        }
        CreateFindingsFilterRequest other = (CreateFindingsFilterRequest) obj;
        return Objects.equals(actionAsString(), other.actionAsString()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(description(), other.description())
                && Objects.equals(findingCriteria(), other.findingCriteria()) && Objects.equals(name(), other.name())
                && Objects.equals(position(), other.position()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateFindingsFilterRequest").add("Action", actionAsString()).add("ClientToken", clientToken())
                .add("Description", description()).add("FindingCriteria", findingCriteria()).add("Name", name())
                .add("Position", position()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "action":
            return Optional.ofNullable(clazz.cast(actionAsString()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "findingCriteria":
            return Optional.ofNullable(clazz.cast(findingCriteria()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "position":
            return Optional.ofNullable(clazz.cast(position()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateFindingsFilterRequest, T> g) {
        return obj -> g.apply((CreateFindingsFilterRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Macie2Request.Builder, SdkPojo, CopyableBuilder<Builder, CreateFindingsFilterRequest> {
        /**
         * <p>
         * The action to perform on findings that match the filter criteria (findingCriteria). Valid values are:
         * ARCHIVE, suppress (automatically archive) the findings; and, NOOP, don't perform any action on the findings.
         * </p>
         * 
         * @param action
         *        The action to perform on findings that match the filter criteria (findingCriteria). Valid values are:
         *        ARCHIVE, suppress (automatically archive) the findings; and, NOOP, don't perform any action on the
         *        findings.
         * @see FindingsFilterAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FindingsFilterAction
         */
        Builder action(String action);

        /**
         * <p>
         * The action to perform on findings that match the filter criteria (findingCriteria). Valid values are:
         * ARCHIVE, suppress (automatically archive) the findings; and, NOOP, don't perform any action on the findings.
         * </p>
         * 
         * @param action
         *        The action to perform on findings that match the filter criteria (findingCriteria). Valid values are:
         *        ARCHIVE, suppress (automatically archive) the findings; and, NOOP, don't perform any action on the
         *        findings.
         * @see FindingsFilterAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FindingsFilterAction
         */
        Builder action(FindingsFilterAction action);

        /**
         * <p>
         * A unique, case-sensitive token that you provide to ensure the idempotency of the request.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive token that you provide to ensure the idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * A custom description of the filter. The description can contain as many as 512 characters.
         * </p>
         * <p>
         * We strongly recommend that you avoid including any sensitive data in the description of a filter. Other users
         * of your account might be able to see this description, depending on the actions that they're allowed to
         * perform in Amazon Macie.
         * </p>
         * 
         * @param description
         *        A custom description of the filter. The description can contain as many as 512 characters.</p>
         *        <p>
         *        We strongly recommend that you avoid including any sensitive data in the description of a filter.
         *        Other users of your account might be able to see this description, depending on the actions that
         *        they're allowed to perform in Amazon Macie.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The criteria to use to filter findings.
         * </p>
         * 
         * @param findingCriteria
         *        The criteria to use to filter findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingCriteria(FindingCriteria findingCriteria);

        /**
         * <p>
         * The criteria to use to filter findings.
         * </p>
         * This is a convenience method that creates an instance of the {@link FindingCriteria.Builder} avoiding the
         * need to create one manually via {@link FindingCriteria#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FindingCriteria.Builder#build()} is called immediately and its
         * result is passed to {@link #findingCriteria(FindingCriteria)}.
         * 
         * @param findingCriteria
         *        a consumer that will call methods on {@link FindingCriteria.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #findingCriteria(FindingCriteria)
         */
        default Builder findingCriteria(Consumer<FindingCriteria.Builder> findingCriteria) {
            return findingCriteria(FindingCriteria.builder().applyMutation(findingCriteria).build());
        }

        /**
         * <p>
         * A custom name for the filter. The name must contain at least 3 characters and can contain as many as 64
         * characters.
         * </p>
         * <p>
         * We strongly recommend that you avoid including any sensitive data in the name of a filter. Other users of
         * your account might be able to see this name, depending on the actions that they're allowed to perform in
         * Amazon Macie.
         * </p>
         * 
         * @param name
         *        A custom name for the filter. The name must contain at least 3 characters and can contain as many as
         *        64 characters.</p>
         *        <p>
         *        We strongly recommend that you avoid including any sensitive data in the name of a filter. Other users
         *        of your account might be able to see this name, depending on the actions that they're allowed to
         *        perform in Amazon Macie.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The position of the filter in the list of saved filters on the Amazon Macie console. This value also
         * determines the order in which the filter is applied to findings, relative to other filters that are also
         * applied to the findings.
         * </p>
         * 
         * @param position
         *        The position of the filter in the list of saved filters on the Amazon Macie console. This value also
         *        determines the order in which the filter is applied to findings, relative to other filters that are
         *        also applied to the findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder position(Integer position);

        /**
         * <p>
         * A map of key-value pairs that specifies the tags to associate with the filter.
         * </p>
         * <p>
         * A findings filter can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value.
         * The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.
         * </p>
         * 
         * @param tags
         *        A map of key-value pairs that specifies the tags to associate with the filter.</p>
         *        <p>
         *        A findings filter can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag
         *        value. The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256
         *        characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Macie2Request.BuilderImpl implements Builder {
        private String action;

        private String clientToken;

        private String description;

        private FindingCriteria findingCriteria;

        private String name;

        private Integer position;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFindingsFilterRequest model) {
            super(model);
            action(model.action);
            clientToken(model.clientToken);
            description(model.description);
            findingCriteria(model.findingCriteria);
            name(model.name);
            position(model.position);
            tags(model.tags);
        }

        public final String getAction() {
            return action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(FindingsFilterAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final FindingCriteria.Builder getFindingCriteria() {
            return findingCriteria != null ? findingCriteria.toBuilder() : null;
        }

        public final void setFindingCriteria(FindingCriteria.BuilderImpl findingCriteria) {
            this.findingCriteria = findingCriteria != null ? findingCriteria.build() : null;
        }

        @Override
        public final Builder findingCriteria(FindingCriteria findingCriteria) {
            this.findingCriteria = findingCriteria;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Integer getPosition() {
            return position;
        }

        public final void setPosition(Integer position) {
            this.position = position;
        }

        @Override
        public final Builder position(Integer position) {
            this.position = position;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateFindingsFilterRequest build() {
            return new CreateFindingsFilterRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
