/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateInvitationsRequest extends Macie2Request implements
        ToCopyableBuilder<CreateInvitationsRequest.Builder, CreateInvitationsRequest> {
    private static final SdkField<List<String>> ACCOUNT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("accountIds")
            .getter(getter(CreateInvitationsRequest::accountIds))
            .setter(setter(Builder::accountIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> DISABLE_EMAIL_NOTIFICATION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("disableEmailNotification").getter(getter(CreateInvitationsRequest::disableEmailNotification))
            .setter(setter(Builder::disableEmailNotification))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("disableEmailNotification").build())
            .build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("message")
            .getter(getter(CreateInvitationsRequest::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_IDS_FIELD,
            DISABLE_EMAIL_NOTIFICATION_FIELD, MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("accountIds", ACCOUNT_IDS_FIELD);
                    put("disableEmailNotification", DISABLE_EMAIL_NOTIFICATION_FIELD);
                    put("message", MESSAGE_FIELD);
                }
            });

    private final List<String> accountIds;

    private final Boolean disableEmailNotification;

    private final String message;

    private CreateInvitationsRequest(BuilderImpl builder) {
        super(builder);
        this.accountIds = builder.accountIds;
        this.disableEmailNotification = builder.disableEmailNotification;
        this.message = builder.message;
    }

    /**
     * For responses, this returns true if the service returned a value for the AccountIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAccountIds() {
        return accountIds != null && !(accountIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array that lists Amazon Web Services account IDs, one for each account to send the invitation to.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccountIds} method.
     * </p>
     * 
     * @return An array that lists Amazon Web Services account IDs, one for each account to send the invitation to.
     */
    public final List<String> accountIds() {
        return accountIds;
    }

    /**
     * <p>
     * Specifies whether to send the invitation as an email message. If this value is false, Amazon Macie sends the
     * invitation (as an email message) to the email address that you specified for the recipient's account when you
     * associated the account with your account. The default value is false.
     * </p>
     * 
     * @return Specifies whether to send the invitation as an email message. If this value is false, Amazon Macie sends
     *         the invitation (as an email message) to the email address that you specified for the recipient's account
     *         when you associated the account with your account. The default value is false.
     */
    public final Boolean disableEmailNotification() {
        return disableEmailNotification;
    }

    /**
     * <p>
     * Custom text to include in the email message that contains the invitation. The text can contain as many as 80
     * alphanumeric characters.
     * </p>
     * 
     * @return Custom text to include in the email message that contains the invitation. The text can contain as many as
     *         80 alphanumeric characters.
     */
    public final String message() {
        return message;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAccountIds() ? accountIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(disableEmailNotification());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInvitationsRequest)) {
            return false;
        }
        CreateInvitationsRequest other = (CreateInvitationsRequest) obj;
        return hasAccountIds() == other.hasAccountIds() && Objects.equals(accountIds(), other.accountIds())
                && Objects.equals(disableEmailNotification(), other.disableEmailNotification())
                && Objects.equals(message(), other.message());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateInvitationsRequest").add("AccountIds", hasAccountIds() ? accountIds() : null)
                .add("DisableEmailNotification", disableEmailNotification()).add("Message", message()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accountIds":
            return Optional.ofNullable(clazz.cast(accountIds()));
        case "disableEmailNotification":
            return Optional.ofNullable(clazz.cast(disableEmailNotification()));
        case "message":
            return Optional.ofNullable(clazz.cast(message()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateInvitationsRequest, T> g) {
        return obj -> g.apply((CreateInvitationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Macie2Request.Builder, SdkPojo, CopyableBuilder<Builder, CreateInvitationsRequest> {
        /**
         * <p>
         * An array that lists Amazon Web Services account IDs, one for each account to send the invitation to.
         * </p>
         * 
         * @param accountIds
         *        An array that lists Amazon Web Services account IDs, one for each account to send the invitation to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountIds(Collection<String> accountIds);

        /**
         * <p>
         * An array that lists Amazon Web Services account IDs, one for each account to send the invitation to.
         * </p>
         * 
         * @param accountIds
         *        An array that lists Amazon Web Services account IDs, one for each account to send the invitation to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountIds(String... accountIds);

        /**
         * <p>
         * Specifies whether to send the invitation as an email message. If this value is false, Amazon Macie sends the
         * invitation (as an email message) to the email address that you specified for the recipient's account when you
         * associated the account with your account. The default value is false.
         * </p>
         * 
         * @param disableEmailNotification
         *        Specifies whether to send the invitation as an email message. If this value is false, Amazon Macie
         *        sends the invitation (as an email message) to the email address that you specified for the recipient's
         *        account when you associated the account with your account. The default value is false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disableEmailNotification(Boolean disableEmailNotification);

        /**
         * <p>
         * Custom text to include in the email message that contains the invitation. The text can contain as many as 80
         * alphanumeric characters.
         * </p>
         * 
         * @param message
         *        Custom text to include in the email message that contains the invitation. The text can contain as many
         *        as 80 alphanumeric characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Macie2Request.BuilderImpl implements Builder {
        private List<String> accountIds = DefaultSdkAutoConstructList.getInstance();

        private Boolean disableEmailNotification;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateInvitationsRequest model) {
            super(model);
            accountIds(model.accountIds);
            disableEmailNotification(model.disableEmailNotification);
            message(model.message);
        }

        public final Collection<String> getAccountIds() {
            if (accountIds instanceof SdkAutoConstructList) {
                return null;
            }
            return accountIds;
        }

        public final void setAccountIds(Collection<String> accountIds) {
            this.accountIds = ___listOf__stringCopier.copy(accountIds);
        }

        @Override
        public final Builder accountIds(Collection<String> accountIds) {
            this.accountIds = ___listOf__stringCopier.copy(accountIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountIds(String... accountIds) {
            accountIds(Arrays.asList(accountIds));
            return this;
        }

        public final Boolean getDisableEmailNotification() {
            return disableEmailNotification;
        }

        public final void setDisableEmailNotification(Boolean disableEmailNotification) {
            this.disableEmailNotification = disableEmailNotification;
        }

        @Override
        public final Builder disableEmailNotification(Boolean disableEmailNotification) {
            this.disableEmailNotification = disableEmailNotification;
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateInvitationsRequest build() {
            return new CreateInvitationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
