/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about custom data identifiers that produced a sensitive data finding, and the number of
 * occurrences of the data that they detected for the finding.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomDataIdentifiers implements SdkPojo, Serializable,
        ToCopyableBuilder<CustomDataIdentifiers.Builder, CustomDataIdentifiers> {
    private static final SdkField<List<CustomDetection>> DETECTIONS_FIELD = SdkField
            .<List<CustomDetection>> builder(MarshallingType.LIST)
            .memberName("detections")
            .getter(getter(CustomDataIdentifiers::detections))
            .setter(setter(Builder::detections))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detections").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CustomDetection> builder(MarshallingType.SDK_POJO)
                                            .constructor(CustomDetection::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Long> TOTAL_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("totalCount").getter(getter(CustomDataIdentifiers::totalCount)).setter(setter(Builder::totalCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTIONS_FIELD,
            TOTAL_COUNT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("detections", DETECTIONS_FIELD);
                    put("totalCount", TOTAL_COUNT_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final List<CustomDetection> detections;

    private final Long totalCount;

    private CustomDataIdentifiers(BuilderImpl builder) {
        this.detections = builder.detections;
        this.totalCount = builder.totalCount;
    }

    /**
     * For responses, this returns true if the service returned a value for the Detections property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDetections() {
        return detections != null && !(detections instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The custom data identifiers that detected the data, and the number of occurrences of the data that each
     * identifier detected.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDetections} method.
     * </p>
     * 
     * @return The custom data identifiers that detected the data, and the number of occurrences of the data that each
     *         identifier detected.
     */
    public final List<CustomDetection> detections() {
        return detections;
    }

    /**
     * <p>
     * The total number of occurrences of the data that was detected by the custom data identifiers and produced the
     * finding.
     * </p>
     * 
     * @return The total number of occurrences of the data that was detected by the custom data identifiers and produced
     *         the finding.
     */
    public final Long totalCount() {
        return totalCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasDetections() ? detections() : null);
        hashCode = 31 * hashCode + Objects.hashCode(totalCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomDataIdentifiers)) {
            return false;
        }
        CustomDataIdentifiers other = (CustomDataIdentifiers) obj;
        return hasDetections() == other.hasDetections() && Objects.equals(detections(), other.detections())
                && Objects.equals(totalCount(), other.totalCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomDataIdentifiers").add("Detections", hasDetections() ? detections() : null)
                .add("TotalCount", totalCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "detections":
            return Optional.ofNullable(clazz.cast(detections()));
        case "totalCount":
            return Optional.ofNullable(clazz.cast(totalCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CustomDataIdentifiers, T> g) {
        return obj -> g.apply((CustomDataIdentifiers) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomDataIdentifiers> {
        /**
         * <p>
         * The custom data identifiers that detected the data, and the number of occurrences of the data that each
         * identifier detected.
         * </p>
         * 
         * @param detections
         *        The custom data identifiers that detected the data, and the number of occurrences of the data that
         *        each identifier detected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detections(Collection<CustomDetection> detections);

        /**
         * <p>
         * The custom data identifiers that detected the data, and the number of occurrences of the data that each
         * identifier detected.
         * </p>
         * 
         * @param detections
         *        The custom data identifiers that detected the data, and the number of occurrences of the data that
         *        each identifier detected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detections(CustomDetection... detections);

        /**
         * <p>
         * The custom data identifiers that detected the data, and the number of occurrences of the data that each
         * identifier detected.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.macie2.model.CustomDetection.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.macie2.model.CustomDetection#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.macie2.model.CustomDetection.Builder#build()} is called immediately
         * and its result is passed to {@link #detections(List<CustomDetection>)}.
         * 
         * @param detections
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.macie2.model.CustomDetection.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #detections(java.util.Collection<CustomDetection>)
         */
        Builder detections(Consumer<CustomDetection.Builder>... detections);

        /**
         * <p>
         * The total number of occurrences of the data that was detected by the custom data identifiers and produced the
         * finding.
         * </p>
         * 
         * @param totalCount
         *        The total number of occurrences of the data that was detected by the custom data identifiers and
         *        produced the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalCount(Long totalCount);
    }

    static final class BuilderImpl implements Builder {
        private List<CustomDetection> detections = DefaultSdkAutoConstructList.getInstance();

        private Long totalCount;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomDataIdentifiers model) {
            detections(model.detections);
            totalCount(model.totalCount);
        }

        public final List<CustomDetection.Builder> getDetections() {
            List<CustomDetection.Builder> result = CustomDetectionsCopier.copyToBuilder(this.detections);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDetections(Collection<CustomDetection.BuilderImpl> detections) {
            this.detections = CustomDetectionsCopier.copyFromBuilder(detections);
        }

        @Override
        public final Builder detections(Collection<CustomDetection> detections) {
            this.detections = CustomDetectionsCopier.copy(detections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder detections(CustomDetection... detections) {
            detections(Arrays.asList(detections));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder detections(Consumer<CustomDetection.Builder>... detections) {
            detections(Stream.of(detections).map(c -> CustomDetection.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Long getTotalCount() {
            return totalCount;
        }

        public final void setTotalCount(Long totalCount) {
            this.totalCount = totalCount;
        }

        @Override
        public final Builder totalCount(Long totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        @Override
        public CustomDataIdentifiers build() {
            return new CustomDataIdentifiers(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
