/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeOrganizationConfigurationResponse extends Macie2Response implements
        ToCopyableBuilder<DescribeOrganizationConfigurationResponse.Builder, DescribeOrganizationConfigurationResponse> {
    private static final SdkField<Boolean> AUTO_ENABLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("autoEnable").getter(getter(DescribeOrganizationConfigurationResponse::autoEnable))
            .setter(setter(Builder::autoEnable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoEnable").build()).build();

    private static final SdkField<Boolean> MAX_ACCOUNT_LIMIT_REACHED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("maxAccountLimitReached")
            .getter(getter(DescribeOrganizationConfigurationResponse::maxAccountLimitReached))
            .setter(setter(Builder::maxAccountLimitReached))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxAccountLimitReached").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_ENABLE_FIELD,
            MAX_ACCOUNT_LIMIT_REACHED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("autoEnable", AUTO_ENABLE_FIELD);
                    put("maxAccountLimitReached", MAX_ACCOUNT_LIMIT_REACHED_FIELD);
                }
            });

    private final Boolean autoEnable;

    private final Boolean maxAccountLimitReached;

    private DescribeOrganizationConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.autoEnable = builder.autoEnable;
        this.maxAccountLimitReached = builder.maxAccountLimitReached;
    }

    /**
     * <p>
     * Specifies whether Amazon Macie is enabled automatically for accounts that are added to the organization.
     * </p>
     * 
     * @return Specifies whether Amazon Macie is enabled automatically for accounts that are added to the organization.
     */
    public final Boolean autoEnable() {
        return autoEnable;
    }

    /**
     * <p>
     * Specifies whether the maximum number of Amazon Macie member accounts are part of the organization.
     * </p>
     * 
     * @return Specifies whether the maximum number of Amazon Macie member accounts are part of the organization.
     */
    public final Boolean maxAccountLimitReached() {
        return maxAccountLimitReached;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(autoEnable());
        hashCode = 31 * hashCode + Objects.hashCode(maxAccountLimitReached());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeOrganizationConfigurationResponse)) {
            return false;
        }
        DescribeOrganizationConfigurationResponse other = (DescribeOrganizationConfigurationResponse) obj;
        return Objects.equals(autoEnable(), other.autoEnable())
                && Objects.equals(maxAccountLimitReached(), other.maxAccountLimitReached());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeOrganizationConfigurationResponse").add("AutoEnable", autoEnable())
                .add("MaxAccountLimitReached", maxAccountLimitReached()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "autoEnable":
            return Optional.ofNullable(clazz.cast(autoEnable()));
        case "maxAccountLimitReached":
            return Optional.ofNullable(clazz.cast(maxAccountLimitReached()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeOrganizationConfigurationResponse, T> g) {
        return obj -> g.apply((DescribeOrganizationConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Macie2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeOrganizationConfigurationResponse> {
        /**
         * <p>
         * Specifies whether Amazon Macie is enabled automatically for accounts that are added to the organization.
         * </p>
         * 
         * @param autoEnable
         *        Specifies whether Amazon Macie is enabled automatically for accounts that are added to the
         *        organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoEnable(Boolean autoEnable);

        /**
         * <p>
         * Specifies whether the maximum number of Amazon Macie member accounts are part of the organization.
         * </p>
         * 
         * @param maxAccountLimitReached
         *        Specifies whether the maximum number of Amazon Macie member accounts are part of the organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxAccountLimitReached(Boolean maxAccountLimitReached);
    }

    static final class BuilderImpl extends Macie2Response.BuilderImpl implements Builder {
        private Boolean autoEnable;

        private Boolean maxAccountLimitReached;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeOrganizationConfigurationResponse model) {
            super(model);
            autoEnable(model.autoEnable);
            maxAccountLimitReached(model.maxAccountLimitReached);
        }

        public final Boolean getAutoEnable() {
            return autoEnable;
        }

        public final void setAutoEnable(Boolean autoEnable) {
            this.autoEnable = autoEnable;
        }

        @Override
        public final Builder autoEnable(Boolean autoEnable) {
            this.autoEnable = autoEnable;
            return this;
        }

        public final Boolean getMaxAccountLimitReached() {
            return maxAccountLimitReached;
        }

        public final void setMaxAccountLimitReached(Boolean maxAccountLimitReached) {
            this.maxAccountLimitReached = maxAccountLimitReached;
        }

        @Override
        public final Builder maxAccountLimitReached(Boolean maxAccountLimitReached) {
            this.maxAccountLimitReached = maxAccountLimitReached;
            return this;
        }

        @Override
        public DescribeOrganizationConfigurationResponse build() {
            return new DescribeOrganizationConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
