/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about a type of sensitive data that Amazon Macie found in an S3 bucket while performing
 * automated sensitive data discovery for an account. The information also specifies the custom or managed data
 * identifier that detected the data. This information is available only if automated sensitive data discovery has been
 * enabled for the account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Detection implements SdkPojo, Serializable, ToCopyableBuilder<Detection.Builder, Detection> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(Detection::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<Long> COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("count")
            .getter(getter(Detection::count)).setter(setter(Builder::count))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("count").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(Detection::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(Detection::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Boolean> SUPPRESSED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("suppressed").getter(getter(Detection::suppressed)).setter(setter(Builder::suppressed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suppressed").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(Detection::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, COUNT_FIELD,
            ID_FIELD, NAME_FIELD, SUPPRESSED_FIELD, TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("arn", ARN_FIELD);
                    put("count", COUNT_FIELD);
                    put("id", ID_FIELD);
                    put("name", NAME_FIELD);
                    put("suppressed", SUPPRESSED_FIELD);
                    put("type", TYPE_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final Long count;

    private final String id;

    private final String name;

    private final Boolean suppressed;

    private final String type;

    private Detection(BuilderImpl builder) {
        this.arn = builder.arn;
        this.count = builder.count;
        this.id = builder.id;
        this.name = builder.name;
        this.suppressed = builder.suppressed;
        this.type = builder.type;
    }

    /**
     * <p>
     * If the sensitive data was detected by a custom data identifier, the Amazon Resource Name (ARN) of the custom data
     * identifier that detected the data. Otherwise, this value is null.
     * </p>
     * 
     * @return If the sensitive data was detected by a custom data identifier, the Amazon Resource Name (ARN) of the
     *         custom data identifier that detected the data. Otherwise, this value is null.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The total number of occurrences of the sensitive data.
     * </p>
     * 
     * @return The total number of occurrences of the sensitive data.
     */
    public final Long count() {
        return count;
    }

    /**
     * <p>
     * The unique identifier for the custom data identifier or managed data identifier that detected the sensitive data.
     * For additional details about a specified managed data identifier, see <a
     * href="https://docs.aws.amazon.com/macie/latest/user/managed-data-identifiers.html">Using managed data
     * identifiers</a> in the <i>Amazon Macie User Guide</i>.
     * </p>
     * 
     * @return The unique identifier for the custom data identifier or managed data identifier that detected the
     *         sensitive data. For additional details about a specified managed data identifier, see <a
     *         href="https://docs.aws.amazon.com/macie/latest/user/managed-data-identifiers.html">Using managed data
     *         identifiers</a> in the <i>Amazon Macie User Guide</i>.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the custom data identifier or managed data identifier that detected the sensitive data. For a managed
     * data identifier, this value is the same as the unique identifier (id).
     * </p>
     * 
     * @return The name of the custom data identifier or managed data identifier that detected the sensitive data. For a
     *         managed data identifier, this value is the same as the unique identifier (id).
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Specifies whether occurrences of this type of sensitive data are excluded (true) or included (false) in the
     * bucket's sensitivity score.
     * </p>
     * 
     * @return Specifies whether occurrences of this type of sensitive data are excluded (true) or included (false) in
     *         the bucket's sensitivity score.
     */
    public final Boolean suppressed() {
        return suppressed;
    }

    /**
     * <p>
     * The type of data identifier that detected the sensitive data. Possible values are: CUSTOM, for a custom data
     * identifier; and, MANAGED, for a managed data identifier.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link DataIdentifierType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of data identifier that detected the sensitive data. Possible values are: CUSTOM, for a custom
     *         data identifier; and, MANAGED, for a managed data identifier.
     * @see DataIdentifierType
     */
    public final DataIdentifierType type() {
        return DataIdentifierType.fromValue(type);
    }

    /**
     * <p>
     * The type of data identifier that detected the sensitive data. Possible values are: CUSTOM, for a custom data
     * identifier; and, MANAGED, for a managed data identifier.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link DataIdentifierType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of data identifier that detected the sensitive data. Possible values are: CUSTOM, for a custom
     *         data identifier; and, MANAGED, for a managed data identifier.
     * @see DataIdentifierType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(count());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(suppressed());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Detection)) {
            return false;
        }
        Detection other = (Detection) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(count(), other.count()) && Objects.equals(id(), other.id())
                && Objects.equals(name(), other.name()) && Objects.equals(suppressed(), other.suppressed())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Detection").add("Arn", arn()).add("Count", count()).add("Id", id()).add("Name", name())
                .add("Suppressed", suppressed()).add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "count":
            return Optional.ofNullable(clazz.cast(count()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "suppressed":
            return Optional.ofNullable(clazz.cast(suppressed()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Detection, T> g) {
        return obj -> g.apply((Detection) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Detection> {
        /**
         * <p>
         * If the sensitive data was detected by a custom data identifier, the Amazon Resource Name (ARN) of the custom
         * data identifier that detected the data. Otherwise, this value is null.
         * </p>
         * 
         * @param arn
         *        If the sensitive data was detected by a custom data identifier, the Amazon Resource Name (ARN) of the
         *        custom data identifier that detected the data. Otherwise, this value is null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The total number of occurrences of the sensitive data.
         * </p>
         * 
         * @param count
         *        The total number of occurrences of the sensitive data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder count(Long count);

        /**
         * <p>
         * The unique identifier for the custom data identifier or managed data identifier that detected the sensitive
         * data. For additional details about a specified managed data identifier, see <a
         * href="https://docs.aws.amazon.com/macie/latest/user/managed-data-identifiers.html">Using managed data
         * identifiers</a> in the <i>Amazon Macie User Guide</i>.
         * </p>
         * 
         * @param id
         *        The unique identifier for the custom data identifier or managed data identifier that detected the
         *        sensitive data. For additional details about a specified managed data identifier, see <a
         *        href="https://docs.aws.amazon.com/macie/latest/user/managed-data-identifiers.html">Using managed data
         *        identifiers</a> in the <i>Amazon Macie User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the custom data identifier or managed data identifier that detected the sensitive data. For a
         * managed data identifier, this value is the same as the unique identifier (id).
         * </p>
         * 
         * @param name
         *        The name of the custom data identifier or managed data identifier that detected the sensitive data.
         *        For a managed data identifier, this value is the same as the unique identifier (id).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Specifies whether occurrences of this type of sensitive data are excluded (true) or included (false) in the
         * bucket's sensitivity score.
         * </p>
         * 
         * @param suppressed
         *        Specifies whether occurrences of this type of sensitive data are excluded (true) or included (false)
         *        in the bucket's sensitivity score.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suppressed(Boolean suppressed);

        /**
         * <p>
         * The type of data identifier that detected the sensitive data. Possible values are: CUSTOM, for a custom data
         * identifier; and, MANAGED, for a managed data identifier.
         * </p>
         * 
         * @param type
         *        The type of data identifier that detected the sensitive data. Possible values are: CUSTOM, for a
         *        custom data identifier; and, MANAGED, for a managed data identifier.
         * @see DataIdentifierType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataIdentifierType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of data identifier that detected the sensitive data. Possible values are: CUSTOM, for a custom data
         * identifier; and, MANAGED, for a managed data identifier.
         * </p>
         * 
         * @param type
         *        The type of data identifier that detected the sensitive data. Possible values are: CUSTOM, for a
         *        custom data identifier; and, MANAGED, for a managed data identifier.
         * @see DataIdentifierType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataIdentifierType
         */
        Builder type(DataIdentifierType type);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private Long count;

        private String id;

        private String name;

        private Boolean suppressed;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(Detection model) {
            arn(model.arn);
            count(model.count);
            id(model.id);
            name(model.name);
            suppressed(model.suppressed);
            type(model.type);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Long getCount() {
            return count;
        }

        public final void setCount(Long count) {
            this.count = count;
        }

        @Override
        public final Builder count(Long count) {
            this.count = count;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Boolean getSuppressed() {
            return suppressed;
        }

        public final void setSuppressed(Boolean suppressed) {
            this.suppressed = suppressed;
        }

        @Override
        public final Builder suppressed(Boolean suppressed) {
            this.suppressed = suppressed;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(DataIdentifierType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public Detection build() {
            return new Detection(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
