/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetFindingStatisticsRequest extends Macie2Request implements
        ToCopyableBuilder<GetFindingStatisticsRequest.Builder, GetFindingStatisticsRequest> {
    private static final SdkField<FindingCriteria> FINDING_CRITERIA_FIELD = SdkField
            .<FindingCriteria> builder(MarshallingType.SDK_POJO).memberName("findingCriteria")
            .getter(getter(GetFindingStatisticsRequest::findingCriteria)).setter(setter(Builder::findingCriteria))
            .constructor(FindingCriteria::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingCriteria").build()).build();

    private static final SdkField<String> GROUP_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("groupBy").getter(getter(GetFindingStatisticsRequest::groupByAsString)).setter(setter(Builder::groupBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupBy").build()).build();

    private static final SdkField<Integer> SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("size")
            .getter(getter(GetFindingStatisticsRequest::size)).setter(setter(Builder::size))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("size").build()).build();

    private static final SdkField<FindingStatisticsSortCriteria> SORT_CRITERIA_FIELD = SdkField
            .<FindingStatisticsSortCriteria> builder(MarshallingType.SDK_POJO).memberName("sortCriteria")
            .getter(getter(GetFindingStatisticsRequest::sortCriteria)).setter(setter(Builder::sortCriteria))
            .constructor(FindingStatisticsSortCriteria::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortCriteria").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FINDING_CRITERIA_FIELD,
            GROUP_BY_FIELD, SIZE_FIELD, SORT_CRITERIA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("findingCriteria", FINDING_CRITERIA_FIELD);
                    put("groupBy", GROUP_BY_FIELD);
                    put("size", SIZE_FIELD);
                    put("sortCriteria", SORT_CRITERIA_FIELD);
                }
            });

    private final FindingCriteria findingCriteria;

    private final String groupBy;

    private final Integer size;

    private final FindingStatisticsSortCriteria sortCriteria;

    private GetFindingStatisticsRequest(BuilderImpl builder) {
        super(builder);
        this.findingCriteria = builder.findingCriteria;
        this.groupBy = builder.groupBy;
        this.size = builder.size;
        this.sortCriteria = builder.sortCriteria;
    }

    /**
     * <p>
     * The criteria to use to filter the query results.
     * </p>
     * 
     * @return The criteria to use to filter the query results.
     */
    public final FindingCriteria findingCriteria() {
        return findingCriteria;
    }

    /**
     * <p>
     * The finding property to use to group the query results. Valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * classificationDetails.jobId - The unique identifier for the classification job that produced the finding.
     * </p>
     * </li>
     * <li>
     * <p>
     * resourcesAffected.s3Bucket.name - The name of the S3 bucket that the finding applies to.
     * </p>
     * </li>
     * <li>
     * <p>
     * severity.description - The severity level of the finding, such as High or Medium.
     * </p>
     * </li>
     * <li>
     * <p>
     * type - The type of finding, such as Policy:IAMUser/S3BucketPublic and SensitiveData:S3Object/Personal.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #groupBy} will
     * return {@link GroupBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #groupByAsString}.
     * </p>
     * 
     * @return The finding property to use to group the query results. Valid values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         classificationDetails.jobId - The unique identifier for the classification job that produced the finding.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         resourcesAffected.s3Bucket.name - The name of the S3 bucket that the finding applies to.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         severity.description - The severity level of the finding, such as High or Medium.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         type - The type of finding, such as Policy:IAMUser/S3BucketPublic and SensitiveData:S3Object/Personal.
     *         </p>
     *         </li>
     * @see GroupBy
     */
    public final GroupBy groupBy() {
        return GroupBy.fromValue(groupBy);
    }

    /**
     * <p>
     * The finding property to use to group the query results. Valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * classificationDetails.jobId - The unique identifier for the classification job that produced the finding.
     * </p>
     * </li>
     * <li>
     * <p>
     * resourcesAffected.s3Bucket.name - The name of the S3 bucket that the finding applies to.
     * </p>
     * </li>
     * <li>
     * <p>
     * severity.description - The severity level of the finding, such as High or Medium.
     * </p>
     * </li>
     * <li>
     * <p>
     * type - The type of finding, such as Policy:IAMUser/S3BucketPublic and SensitiveData:S3Object/Personal.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #groupBy} will
     * return {@link GroupBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #groupByAsString}.
     * </p>
     * 
     * @return The finding property to use to group the query results. Valid values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         classificationDetails.jobId - The unique identifier for the classification job that produced the finding.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         resourcesAffected.s3Bucket.name - The name of the S3 bucket that the finding applies to.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         severity.description - The severity level of the finding, such as High or Medium.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         type - The type of finding, such as Policy:IAMUser/S3BucketPublic and SensitiveData:S3Object/Personal.
     *         </p>
     *         </li>
     * @see GroupBy
     */
    public final String groupByAsString() {
        return groupBy;
    }

    /**
     * <p>
     * The maximum number of items to include in each page of the response.
     * </p>
     * 
     * @return The maximum number of items to include in each page of the response.
     */
    public final Integer size() {
        return size;
    }

    /**
     * <p>
     * The criteria to use to sort the query results.
     * </p>
     * 
     * @return The criteria to use to sort the query results.
     */
    public final FindingStatisticsSortCriteria sortCriteria() {
        return sortCriteria;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(findingCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(groupByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(size());
        hashCode = 31 * hashCode + Objects.hashCode(sortCriteria());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFindingStatisticsRequest)) {
            return false;
        }
        GetFindingStatisticsRequest other = (GetFindingStatisticsRequest) obj;
        return Objects.equals(findingCriteria(), other.findingCriteria())
                && Objects.equals(groupByAsString(), other.groupByAsString()) && Objects.equals(size(), other.size())
                && Objects.equals(sortCriteria(), other.sortCriteria());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetFindingStatisticsRequest").add("FindingCriteria", findingCriteria())
                .add("GroupBy", groupByAsString()).add("Size", size()).add("SortCriteria", sortCriteria()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "findingCriteria":
            return Optional.ofNullable(clazz.cast(findingCriteria()));
        case "groupBy":
            return Optional.ofNullable(clazz.cast(groupByAsString()));
        case "size":
            return Optional.ofNullable(clazz.cast(size()));
        case "sortCriteria":
            return Optional.ofNullable(clazz.cast(sortCriteria()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetFindingStatisticsRequest, T> g) {
        return obj -> g.apply((GetFindingStatisticsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Macie2Request.Builder, SdkPojo, CopyableBuilder<Builder, GetFindingStatisticsRequest> {
        /**
         * <p>
         * The criteria to use to filter the query results.
         * </p>
         * 
         * @param findingCriteria
         *        The criteria to use to filter the query results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingCriteria(FindingCriteria findingCriteria);

        /**
         * <p>
         * The criteria to use to filter the query results.
         * </p>
         * This is a convenience method that creates an instance of the {@link FindingCriteria.Builder} avoiding the
         * need to create one manually via {@link FindingCriteria#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FindingCriteria.Builder#build()} is called immediately and its
         * result is passed to {@link #findingCriteria(FindingCriteria)}.
         * 
         * @param findingCriteria
         *        a consumer that will call methods on {@link FindingCriteria.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #findingCriteria(FindingCriteria)
         */
        default Builder findingCriteria(Consumer<FindingCriteria.Builder> findingCriteria) {
            return findingCriteria(FindingCriteria.builder().applyMutation(findingCriteria).build());
        }

        /**
         * <p>
         * The finding property to use to group the query results. Valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * classificationDetails.jobId - The unique identifier for the classification job that produced the finding.
         * </p>
         * </li>
         * <li>
         * <p>
         * resourcesAffected.s3Bucket.name - The name of the S3 bucket that the finding applies to.
         * </p>
         * </li>
         * <li>
         * <p>
         * severity.description - The severity level of the finding, such as High or Medium.
         * </p>
         * </li>
         * <li>
         * <p>
         * type - The type of finding, such as Policy:IAMUser/S3BucketPublic and SensitiveData:S3Object/Personal.
         * </p>
         * </li>
         * </ul>
         * 
         * @param groupBy
         *        The finding property to use to group the query results. Valid values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        classificationDetails.jobId - The unique identifier for the classification job that produced the
         *        finding.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        resourcesAffected.s3Bucket.name - The name of the S3 bucket that the finding applies to.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        severity.description - The severity level of the finding, such as High or Medium.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        type - The type of finding, such as Policy:IAMUser/S3BucketPublic and SensitiveData:S3Object/Personal.
         *        </p>
         *        </li>
         * @see GroupBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GroupBy
         */
        Builder groupBy(String groupBy);

        /**
         * <p>
         * The finding property to use to group the query results. Valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * classificationDetails.jobId - The unique identifier for the classification job that produced the finding.
         * </p>
         * </li>
         * <li>
         * <p>
         * resourcesAffected.s3Bucket.name - The name of the S3 bucket that the finding applies to.
         * </p>
         * </li>
         * <li>
         * <p>
         * severity.description - The severity level of the finding, such as High or Medium.
         * </p>
         * </li>
         * <li>
         * <p>
         * type - The type of finding, such as Policy:IAMUser/S3BucketPublic and SensitiveData:S3Object/Personal.
         * </p>
         * </li>
         * </ul>
         * 
         * @param groupBy
         *        The finding property to use to group the query results. Valid values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        classificationDetails.jobId - The unique identifier for the classification job that produced the
         *        finding.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        resourcesAffected.s3Bucket.name - The name of the S3 bucket that the finding applies to.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        severity.description - The severity level of the finding, such as High or Medium.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        type - The type of finding, such as Policy:IAMUser/S3BucketPublic and SensitiveData:S3Object/Personal.
         *        </p>
         *        </li>
         * @see GroupBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GroupBy
         */
        Builder groupBy(GroupBy groupBy);

        /**
         * <p>
         * The maximum number of items to include in each page of the response.
         * </p>
         * 
         * @param size
         *        The maximum number of items to include in each page of the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder size(Integer size);

        /**
         * <p>
         * The criteria to use to sort the query results.
         * </p>
         * 
         * @param sortCriteria
         *        The criteria to use to sort the query results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sortCriteria(FindingStatisticsSortCriteria sortCriteria);

        /**
         * <p>
         * The criteria to use to sort the query results.
         * </p>
         * This is a convenience method that creates an instance of the {@link FindingStatisticsSortCriteria.Builder}
         * avoiding the need to create one manually via {@link FindingStatisticsSortCriteria#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FindingStatisticsSortCriteria.Builder#build()} is called
         * immediately and its result is passed to {@link #sortCriteria(FindingStatisticsSortCriteria)}.
         * 
         * @param sortCriteria
         *        a consumer that will call methods on {@link FindingStatisticsSortCriteria.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sortCriteria(FindingStatisticsSortCriteria)
         */
        default Builder sortCriteria(Consumer<FindingStatisticsSortCriteria.Builder> sortCriteria) {
            return sortCriteria(FindingStatisticsSortCriteria.builder().applyMutation(sortCriteria).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Macie2Request.BuilderImpl implements Builder {
        private FindingCriteria findingCriteria;

        private String groupBy;

        private Integer size;

        private FindingStatisticsSortCriteria sortCriteria;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFindingStatisticsRequest model) {
            super(model);
            findingCriteria(model.findingCriteria);
            groupBy(model.groupBy);
            size(model.size);
            sortCriteria(model.sortCriteria);
        }

        public final FindingCriteria.Builder getFindingCriteria() {
            return findingCriteria != null ? findingCriteria.toBuilder() : null;
        }

        public final void setFindingCriteria(FindingCriteria.BuilderImpl findingCriteria) {
            this.findingCriteria = findingCriteria != null ? findingCriteria.build() : null;
        }

        @Override
        public final Builder findingCriteria(FindingCriteria findingCriteria) {
            this.findingCriteria = findingCriteria;
            return this;
        }

        public final String getGroupBy() {
            return groupBy;
        }

        public final void setGroupBy(String groupBy) {
            this.groupBy = groupBy;
        }

        @Override
        public final Builder groupBy(String groupBy) {
            this.groupBy = groupBy;
            return this;
        }

        @Override
        public final Builder groupBy(GroupBy groupBy) {
            this.groupBy(groupBy == null ? null : groupBy.toString());
            return this;
        }

        public final Integer getSize() {
            return size;
        }

        public final void setSize(Integer size) {
            this.size = size;
        }

        @Override
        public final Builder size(Integer size) {
            this.size = size;
            return this;
        }

        public final FindingStatisticsSortCriteria.Builder getSortCriteria() {
            return sortCriteria != null ? sortCriteria.toBuilder() : null;
        }

        public final void setSortCriteria(FindingStatisticsSortCriteria.BuilderImpl sortCriteria) {
            this.sortCriteria = sortCriteria != null ? sortCriteria.build() : null;
        }

        @Override
        public final Builder sortCriteria(FindingStatisticsSortCriteria sortCriteria) {
            this.sortCriteria = sortCriteria;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetFindingStatisticsRequest build() {
            return new GetFindingStatisticsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
