/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetMasterAccountResponse extends Macie2Response implements
        ToCopyableBuilder<GetMasterAccountResponse.Builder, GetMasterAccountResponse> {
    private static final SdkField<Invitation> MASTER_FIELD = SdkField.<Invitation> builder(MarshallingType.SDK_POJO)
            .memberName("master").getter(getter(GetMasterAccountResponse::master)).setter(setter(Builder::master))
            .constructor(Invitation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("master").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MASTER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("master", MASTER_FIELD);
                }
            });

    private final Invitation master;

    private GetMasterAccountResponse(BuilderImpl builder) {
        super(builder);
        this.master = builder.master;
    }

    /**
     * <p>
     * (Deprecated) The Amazon Web Services account ID for the administrator account. If the accounts are associated by
     * a Macie membership invitation, this object also provides details about the invitation that was sent to establish
     * the relationship between the accounts.
     * </p>
     * 
     * @return (Deprecated) The Amazon Web Services account ID for the administrator account. If the accounts are
     *         associated by a Macie membership invitation, this object also provides details about the invitation that
     *         was sent to establish the relationship between the accounts.
     */
    public final Invitation master() {
        return master;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(master());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMasterAccountResponse)) {
            return false;
        }
        GetMasterAccountResponse other = (GetMasterAccountResponse) obj;
        return Objects.equals(master(), other.master());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetMasterAccountResponse").add("Master", master()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "master":
            return Optional.ofNullable(clazz.cast(master()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetMasterAccountResponse, T> g) {
        return obj -> g.apply((GetMasterAccountResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Macie2Response.Builder, SdkPojo, CopyableBuilder<Builder, GetMasterAccountResponse> {
        /**
         * <p>
         * (Deprecated) The Amazon Web Services account ID for the administrator account. If the accounts are associated
         * by a Macie membership invitation, this object also provides details about the invitation that was sent to
         * establish the relationship between the accounts.
         * </p>
         * 
         * @param master
         *        (Deprecated) The Amazon Web Services account ID for the administrator account. If the accounts are
         *        associated by a Macie membership invitation, this object also provides details about the invitation
         *        that was sent to establish the relationship between the accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder master(Invitation master);

        /**
         * <p>
         * (Deprecated) The Amazon Web Services account ID for the administrator account. If the accounts are associated
         * by a Macie membership invitation, this object also provides details about the invitation that was sent to
         * establish the relationship between the accounts.
         * </p>
         * This is a convenience method that creates an instance of the {@link Invitation.Builder} avoiding the need to
         * create one manually via {@link Invitation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Invitation.Builder#build()} is called immediately and its result
         * is passed to {@link #master(Invitation)}.
         * 
         * @param master
         *        a consumer that will call methods on {@link Invitation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #master(Invitation)
         */
        default Builder master(Consumer<Invitation.Builder> master) {
            return master(Invitation.builder().applyMutation(master).build());
        }
    }

    static final class BuilderImpl extends Macie2Response.BuilderImpl implements Builder {
        private Invitation master;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMasterAccountResponse model) {
            super(model);
            master(model.master);
        }

        public final Invitation.Builder getMaster() {
            return master != null ? master.toBuilder() : null;
        }

        public final void setMaster(Invitation.BuilderImpl master) {
            this.master = master != null ? master.build() : null;
        }

        @Override
        public final Builder master(Invitation master) {
            this.master = master;
            return this;
        }

        @Override
        public GetMasterAccountResponse build() {
            return new GetMasterAccountResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
