/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetUsageTotalsRequest extends Macie2Request implements
        ToCopyableBuilder<GetUsageTotalsRequest.Builder, GetUsageTotalsRequest> {
    private static final SdkField<String> TIME_RANGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("timeRange").getter(getter(GetUsageTotalsRequest::timeRange)).setter(setter(Builder::timeRange))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("timeRange").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIME_RANGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("timeRange", TIME_RANGE_FIELD);
                }
            });

    private final String timeRange;

    private GetUsageTotalsRequest(BuilderImpl builder) {
        super(builder);
        this.timeRange = builder.timeRange;
    }

    /**
     * <p>
     * The inclusive time period to retrieve the data for. Valid values are: MONTH_TO_DATE, for the current calendar
     * month to date; and, PAST_30_DAYS, for the preceding 30 days. If you don't specify a value for this parameter,
     * Amazon Macie provides aggregated usage data for the preceding 30 days.
     * </p>
     * 
     * @return The inclusive time period to retrieve the data for. Valid values are: MONTH_TO_DATE, for the current
     *         calendar month to date; and, PAST_30_DAYS, for the preceding 30 days. If you don't specify a value for
     *         this parameter, Amazon Macie provides aggregated usage data for the preceding 30 days.
     */
    public final String timeRange() {
        return timeRange;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(timeRange());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetUsageTotalsRequest)) {
            return false;
        }
        GetUsageTotalsRequest other = (GetUsageTotalsRequest) obj;
        return Objects.equals(timeRange(), other.timeRange());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetUsageTotalsRequest").add("TimeRange", timeRange()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "timeRange":
            return Optional.ofNullable(clazz.cast(timeRange()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetUsageTotalsRequest, T> g) {
        return obj -> g.apply((GetUsageTotalsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Macie2Request.Builder, SdkPojo, CopyableBuilder<Builder, GetUsageTotalsRequest> {
        /**
         * <p>
         * The inclusive time period to retrieve the data for. Valid values are: MONTH_TO_DATE, for the current calendar
         * month to date; and, PAST_30_DAYS, for the preceding 30 days. If you don't specify a value for this parameter,
         * Amazon Macie provides aggregated usage data for the preceding 30 days.
         * </p>
         * 
         * @param timeRange
         *        The inclusive time period to retrieve the data for. Valid values are: MONTH_TO_DATE, for the current
         *        calendar month to date; and, PAST_30_DAYS, for the preceding 30 days. If you don't specify a value for
         *        this parameter, Amazon Macie provides aggregated usage data for the preceding 30 days.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeRange(String timeRange);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Macie2Request.BuilderImpl implements Builder {
        private String timeRange;

        private BuilderImpl() {
        }

        private BuilderImpl(GetUsageTotalsRequest model) {
            super(model);
            timeRange(model.timeRange);
        }

        public final String getTimeRange() {
            return timeRange;
        }

        public final void setTimeRange(String timeRange) {
            this.timeRange = timeRange;
        }

        @Override
        public final Builder timeRange(String timeRange) {
            this.timeRange = timeRange;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetUsageTotalsRequest build() {
            return new GetUsageTotalsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
