/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides statistical data and other information about an Amazon Web Services resource that Amazon Macie monitors and
 * analyzes for your account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MatchingResource implements SdkPojo, Serializable,
        ToCopyableBuilder<MatchingResource.Builder, MatchingResource> {
    private static final SdkField<MatchingBucket> MATCHING_BUCKET_FIELD = SdkField
            .<MatchingBucket> builder(MarshallingType.SDK_POJO).memberName("matchingBucket")
            .getter(getter(MatchingResource::matchingBucket)).setter(setter(Builder::matchingBucket))
            .constructor(MatchingBucket::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("matchingBucket").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MATCHING_BUCKET_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("matchingBucket", MATCHING_BUCKET_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final MatchingBucket matchingBucket;

    private MatchingResource(BuilderImpl builder) {
        this.matchingBucket = builder.matchingBucket;
    }

    /**
     * <p>
     * The details of an S3 bucket that Amazon Macie monitors and analyzes.
     * </p>
     * 
     * @return The details of an S3 bucket that Amazon Macie monitors and analyzes.
     */
    public final MatchingBucket matchingBucket() {
        return matchingBucket;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(matchingBucket());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MatchingResource)) {
            return false;
        }
        MatchingResource other = (MatchingResource) obj;
        return Objects.equals(matchingBucket(), other.matchingBucket());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MatchingResource").add("MatchingBucket", matchingBucket()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "matchingBucket":
            return Optional.ofNullable(clazz.cast(matchingBucket()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<MatchingResource, T> g) {
        return obj -> g.apply((MatchingResource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MatchingResource> {
        /**
         * <p>
         * The details of an S3 bucket that Amazon Macie monitors and analyzes.
         * </p>
         * 
         * @param matchingBucket
         *        The details of an S3 bucket that Amazon Macie monitors and analyzes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchingBucket(MatchingBucket matchingBucket);

        /**
         * <p>
         * The details of an S3 bucket that Amazon Macie monitors and analyzes.
         * </p>
         * This is a convenience method that creates an instance of the {@link MatchingBucket.Builder} avoiding the need
         * to create one manually via {@link MatchingBucket#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MatchingBucket.Builder#build()} is called immediately and its
         * result is passed to {@link #matchingBucket(MatchingBucket)}.
         * 
         * @param matchingBucket
         *        a consumer that will call methods on {@link MatchingBucket.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #matchingBucket(MatchingBucket)
         */
        default Builder matchingBucket(Consumer<MatchingBucket.Builder> matchingBucket) {
            return matchingBucket(MatchingBucket.builder().applyMutation(matchingBucket).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private MatchingBucket matchingBucket;

        private BuilderImpl() {
        }

        private BuilderImpl(MatchingResource model) {
            matchingBucket(model.matchingBucket);
        }

        public final MatchingBucket.Builder getMatchingBucket() {
            return matchingBucket != null ? matchingBucket.toBuilder() : null;
        }

        public final void setMatchingBucket(MatchingBucket.BuilderImpl matchingBucket) {
            this.matchingBucket = matchingBucket != null ? matchingBucket.build() : null;
        }

        @Override
        public final Builder matchingBucket(MatchingBucket matchingBucket) {
            this.matchingBucket = matchingBucket;
            return this;
        }

        @Override
        public MatchingResource build() {
            return new MatchingResource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
