/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about the access method and settings that are used to retrieve occurrences of sensitive data
 * reported by findings.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RetrievalConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<RetrievalConfiguration.Builder, RetrievalConfiguration> {
    private static final SdkField<String> EXTERNAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("externalId").getter(getter(RetrievalConfiguration::externalId)).setter(setter(Builder::externalId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalId").build()).build();

    private static final SdkField<String> RETRIEVAL_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("retrievalMode").getter(getter(RetrievalConfiguration::retrievalModeAsString))
            .setter(setter(Builder::retrievalMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retrievalMode").build()).build();

    private static final SdkField<String> ROLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleName").getter(getter(RetrievalConfiguration::roleName)).setter(setter(Builder::roleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXTERNAL_ID_FIELD,
            RETRIEVAL_MODE_FIELD, ROLE_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("externalId", EXTERNAL_ID_FIELD);
                    put("retrievalMode", RETRIEVAL_MODE_FIELD);
                    put("roleName", ROLE_NAME_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String externalId;

    private final String retrievalMode;

    private final String roleName;

    private RetrievalConfiguration(BuilderImpl builder) {
        this.externalId = builder.externalId;
        this.retrievalMode = builder.retrievalMode;
        this.roleName = builder.roleName;
    }

    /**
     * <p>
     * The external ID to specify in the trust policy for the IAM role to assume when retrieving sensitive data from
     * affected S3 objects (roleName). This value is null if the value for retrievalMode is CALLER_CREDENTIALS.
     * </p>
     * <p>
     * This ID is a unique alphanumeric string that Amazon Macie generates automatically after you configure it to
     * assume an IAM role. For a Macie administrator to retrieve sensitive data from an affected S3 object for a member
     * account, the trust policy for the role in the member account must include an sts:ExternalId condition that
     * requires this ID.
     * </p>
     * 
     * @return The external ID to specify in the trust policy for the IAM role to assume when retrieving sensitive data
     *         from affected S3 objects (roleName). This value is null if the value for retrievalMode is
     *         CALLER_CREDENTIALS.</p>
     *         <p>
     *         This ID is a unique alphanumeric string that Amazon Macie generates automatically after you configure it
     *         to assume an IAM role. For a Macie administrator to retrieve sensitive data from an affected S3 object
     *         for a member account, the trust policy for the role in the member account must include an sts:ExternalId
     *         condition that requires this ID.
     */
    public final String externalId() {
        return externalId;
    }

    /**
     * <p>
     * The access method that's used to retrieve sensitive data from affected S3 objects. Valid values are: ASSUME_ROLE,
     * assume an IAM role that is in the affected Amazon Web Services account and delegates access to Amazon Macie
     * (roleName); and, CALLER_CREDENTIALS, use the credentials of the IAM user who requests the sensitive data.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #retrievalMode}
     * will return {@link RetrievalMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #retrievalModeAsString}.
     * </p>
     * 
     * @return The access method that's used to retrieve sensitive data from affected S3 objects. Valid values are:
     *         ASSUME_ROLE, assume an IAM role that is in the affected Amazon Web Services account and delegates access
     *         to Amazon Macie (roleName); and, CALLER_CREDENTIALS, use the credentials of the IAM user who requests the
     *         sensitive data.
     * @see RetrievalMode
     */
    public final RetrievalMode retrievalMode() {
        return RetrievalMode.fromValue(retrievalMode);
    }

    /**
     * <p>
     * The access method that's used to retrieve sensitive data from affected S3 objects. Valid values are: ASSUME_ROLE,
     * assume an IAM role that is in the affected Amazon Web Services account and delegates access to Amazon Macie
     * (roleName); and, CALLER_CREDENTIALS, use the credentials of the IAM user who requests the sensitive data.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #retrievalMode}
     * will return {@link RetrievalMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #retrievalModeAsString}.
     * </p>
     * 
     * @return The access method that's used to retrieve sensitive data from affected S3 objects. Valid values are:
     *         ASSUME_ROLE, assume an IAM role that is in the affected Amazon Web Services account and delegates access
     *         to Amazon Macie (roleName); and, CALLER_CREDENTIALS, use the credentials of the IAM user who requests the
     *         sensitive data.
     * @see RetrievalMode
     */
    public final String retrievalModeAsString() {
        return retrievalMode;
    }

    /**
     * <p>
     * The name of the IAM role that is in the affected Amazon Web Services account and Amazon Macie is allowed to
     * assume when retrieving sensitive data from affected S3 objects for the account. This value is null if the value
     * for retrievalMode is CALLER_CREDENTIALS.
     * </p>
     * 
     * @return The name of the IAM role that is in the affected Amazon Web Services account and Amazon Macie is allowed
     *         to assume when retrieving sensitive data from affected S3 objects for the account. This value is null if
     *         the value for retrievalMode is CALLER_CREDENTIALS.
     */
    public final String roleName() {
        return roleName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(externalId());
        hashCode = 31 * hashCode + Objects.hashCode(retrievalModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(roleName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetrievalConfiguration)) {
            return false;
        }
        RetrievalConfiguration other = (RetrievalConfiguration) obj;
        return Objects.equals(externalId(), other.externalId())
                && Objects.equals(retrievalModeAsString(), other.retrievalModeAsString())
                && Objects.equals(roleName(), other.roleName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RetrievalConfiguration").add("ExternalId", externalId())
                .add("RetrievalMode", retrievalModeAsString()).add("RoleName", roleName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "externalId":
            return Optional.ofNullable(clazz.cast(externalId()));
        case "retrievalMode":
            return Optional.ofNullable(clazz.cast(retrievalModeAsString()));
        case "roleName":
            return Optional.ofNullable(clazz.cast(roleName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RetrievalConfiguration, T> g) {
        return obj -> g.apply((RetrievalConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RetrievalConfiguration> {
        /**
         * <p>
         * The external ID to specify in the trust policy for the IAM role to assume when retrieving sensitive data from
         * affected S3 objects (roleName). This value is null if the value for retrievalMode is CALLER_CREDENTIALS.
         * </p>
         * <p>
         * This ID is a unique alphanumeric string that Amazon Macie generates automatically after you configure it to
         * assume an IAM role. For a Macie administrator to retrieve sensitive data from an affected S3 object for a
         * member account, the trust policy for the role in the member account must include an sts:ExternalId condition
         * that requires this ID.
         * </p>
         * 
         * @param externalId
         *        The external ID to specify in the trust policy for the IAM role to assume when retrieving sensitive
         *        data from affected S3 objects (roleName). This value is null if the value for retrievalMode is
         *        CALLER_CREDENTIALS.</p>
         *        <p>
         *        This ID is a unique alphanumeric string that Amazon Macie generates automatically after you configure
         *        it to assume an IAM role. For a Macie administrator to retrieve sensitive data from an affected S3
         *        object for a member account, the trust policy for the role in the member account must include an
         *        sts:ExternalId condition that requires this ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalId(String externalId);

        /**
         * <p>
         * The access method that's used to retrieve sensitive data from affected S3 objects. Valid values are:
         * ASSUME_ROLE, assume an IAM role that is in the affected Amazon Web Services account and delegates access to
         * Amazon Macie (roleName); and, CALLER_CREDENTIALS, use the credentials of the IAM user who requests the
         * sensitive data.
         * </p>
         * 
         * @param retrievalMode
         *        The access method that's used to retrieve sensitive data from affected S3 objects. Valid values are:
         *        ASSUME_ROLE, assume an IAM role that is in the affected Amazon Web Services account and delegates
         *        access to Amazon Macie (roleName); and, CALLER_CREDENTIALS, use the credentials of the IAM user who
         *        requests the sensitive data.
         * @see RetrievalMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RetrievalMode
         */
        Builder retrievalMode(String retrievalMode);

        /**
         * <p>
         * The access method that's used to retrieve sensitive data from affected S3 objects. Valid values are:
         * ASSUME_ROLE, assume an IAM role that is in the affected Amazon Web Services account and delegates access to
         * Amazon Macie (roleName); and, CALLER_CREDENTIALS, use the credentials of the IAM user who requests the
         * sensitive data.
         * </p>
         * 
         * @param retrievalMode
         *        The access method that's used to retrieve sensitive data from affected S3 objects. Valid values are:
         *        ASSUME_ROLE, assume an IAM role that is in the affected Amazon Web Services account and delegates
         *        access to Amazon Macie (roleName); and, CALLER_CREDENTIALS, use the credentials of the IAM user who
         *        requests the sensitive data.
         * @see RetrievalMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RetrievalMode
         */
        Builder retrievalMode(RetrievalMode retrievalMode);

        /**
         * <p>
         * The name of the IAM role that is in the affected Amazon Web Services account and Amazon Macie is allowed to
         * assume when retrieving sensitive data from affected S3 objects for the account. This value is null if the
         * value for retrievalMode is CALLER_CREDENTIALS.
         * </p>
         * 
         * @param roleName
         *        The name of the IAM role that is in the affected Amazon Web Services account and Amazon Macie is
         *        allowed to assume when retrieving sensitive data from affected S3 objects for the account. This value
         *        is null if the value for retrievalMode is CALLER_CREDENTIALS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleName(String roleName);
    }

    static final class BuilderImpl implements Builder {
        private String externalId;

        private String retrievalMode;

        private String roleName;

        private BuilderImpl() {
        }

        private BuilderImpl(RetrievalConfiguration model) {
            externalId(model.externalId);
            retrievalMode(model.retrievalMode);
            roleName(model.roleName);
        }

        public final String getExternalId() {
            return externalId;
        }

        public final void setExternalId(String externalId) {
            this.externalId = externalId;
        }

        @Override
        public final Builder externalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        public final String getRetrievalMode() {
            return retrievalMode;
        }

        public final void setRetrievalMode(String retrievalMode) {
            this.retrievalMode = retrievalMode;
        }

        @Override
        public final Builder retrievalMode(String retrievalMode) {
            this.retrievalMode = retrievalMode;
            return this;
        }

        @Override
        public final Builder retrievalMode(RetrievalMode retrievalMode) {
            this.retrievalMode(retrievalMode == null ? null : retrievalMode.toString());
            return this;
        }

        public final String getRoleName() {
            return roleName;
        }

        public final void setRoleName(String roleName) {
            this.roleName = roleName;
        }

        @Override
        public final Builder roleName(String roleName) {
            this.roleName = roleName;
            return this;
        }

        @Override
        public RetrievalConfiguration build() {
            return new RetrievalConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
