/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the names of the S3 buckets that are excluded from automated sensitive data discovery.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3ClassificationScopeExclusion implements SdkPojo, Serializable,
        ToCopyableBuilder<S3ClassificationScopeExclusion.Builder, S3ClassificationScopeExclusion> {
    private static final SdkField<List<String>> BUCKET_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("bucketNames")
            .getter(getter(S3ClassificationScopeExclusion::bucketNames))
            .setter(setter(Builder::bucketNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_NAMES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("bucketNames", BUCKET_NAMES_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final List<String> bucketNames;

    private S3ClassificationScopeExclusion(BuilderImpl builder) {
        this.bucketNames = builder.bucketNames;
    }

    /**
     * For responses, this returns true if the service returned a value for the BucketNames property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBucketNames() {
        return bucketNames != null && !(bucketNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of strings, one for each S3 bucket that is excluded. Each string is the full name of an excluded bucket.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBucketNames} method.
     * </p>
     * 
     * @return An array of strings, one for each S3 bucket that is excluded. Each string is the full name of an excluded
     *         bucket.
     */
    public final List<String> bucketNames() {
        return bucketNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasBucketNames() ? bucketNames() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3ClassificationScopeExclusion)) {
            return false;
        }
        S3ClassificationScopeExclusion other = (S3ClassificationScopeExclusion) obj;
        return hasBucketNames() == other.hasBucketNames() && Objects.equals(bucketNames(), other.bucketNames());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3ClassificationScopeExclusion").add("BucketNames", hasBucketNames() ? bucketNames() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "bucketNames":
            return Optional.ofNullable(clazz.cast(bucketNames()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<S3ClassificationScopeExclusion, T> g) {
        return obj -> g.apply((S3ClassificationScopeExclusion) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3ClassificationScopeExclusion> {
        /**
         * <p>
         * An array of strings, one for each S3 bucket that is excluded. Each string is the full name of an excluded
         * bucket.
         * </p>
         * 
         * @param bucketNames
         *        An array of strings, one for each S3 bucket that is excluded. Each string is the full name of an
         *        excluded bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketNames(Collection<String> bucketNames);

        /**
         * <p>
         * An array of strings, one for each S3 bucket that is excluded. Each string is the full name of an excluded
         * bucket.
         * </p>
         * 
         * @param bucketNames
         *        An array of strings, one for each S3 bucket that is excluded. Each string is the full name of an
         *        excluded bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketNames(String... bucketNames);
    }

    static final class BuilderImpl implements Builder {
        private List<String> bucketNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(S3ClassificationScopeExclusion model) {
            bucketNames(model.bucketNames);
        }

        public final Collection<String> getBucketNames() {
            if (bucketNames instanceof SdkAutoConstructList) {
                return null;
            }
            return bucketNames;
        }

        public final void setBucketNames(Collection<String> bucketNames) {
            this.bucketNames = ___listOfS3BucketNameCopier.copy(bucketNames);
        }

        @Override
        public final Builder bucketNames(Collection<String> bucketNames) {
            this.bucketNames = ___listOfS3BucketNameCopier.copy(bucketNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bucketNames(String... bucketNames) {
            bucketNames(Arrays.asList(bucketNames));
            return this;
        }

        @Override
        public S3ClassificationScopeExclusion build() {
            return new S3ClassificationScopeExclusion(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
