/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateClassificationScopeRequest extends Macie2Request implements
        ToCopyableBuilder<UpdateClassificationScopeRequest.Builder, UpdateClassificationScopeRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(UpdateClassificationScopeRequest::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("id").build()).build();

    private static final SdkField<S3ClassificationScopeUpdate> S3_FIELD = SdkField
            .<S3ClassificationScopeUpdate> builder(MarshallingType.SDK_POJO).memberName("s3")
            .getter(getter(UpdateClassificationScopeRequest::s3)).setter(setter(Builder::s3))
            .constructor(S3ClassificationScopeUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, S3_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("id", ID_FIELD);
                    put("s3", S3_FIELD);
                }
            });

    private final String id;

    private final S3ClassificationScopeUpdate s3;

    private UpdateClassificationScopeRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.s3 = builder.s3;
    }

    /**
     * <p>
     * The unique identifier for the Amazon Macie resource that the request applies to.
     * </p>
     * 
     * @return The unique identifier for the Amazon Macie resource that the request applies to.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The S3 buckets to add or remove from the exclusion list defined by the classification scope.
     * </p>
     * 
     * @return The S3 buckets to add or remove from the exclusion list defined by the classification scope.
     */
    public final S3ClassificationScopeUpdate s3() {
        return s3;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(s3());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateClassificationScopeRequest)) {
            return false;
        }
        UpdateClassificationScopeRequest other = (UpdateClassificationScopeRequest) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(s3(), other.s3());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateClassificationScopeRequest").add("Id", id()).add("S3", s3()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "s3":
            return Optional.ofNullable(clazz.cast(s3()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateClassificationScopeRequest, T> g) {
        return obj -> g.apply((UpdateClassificationScopeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Macie2Request.Builder, SdkPojo, CopyableBuilder<Builder, UpdateClassificationScopeRequest> {
        /**
         * <p>
         * The unique identifier for the Amazon Macie resource that the request applies to.
         * </p>
         * 
         * @param id
         *        The unique identifier for the Amazon Macie resource that the request applies to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The S3 buckets to add or remove from the exclusion list defined by the classification scope.
         * </p>
         * 
         * @param s3
         *        The S3 buckets to add or remove from the exclusion list defined by the classification scope.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3(S3ClassificationScopeUpdate s3);

        /**
         * <p>
         * The S3 buckets to add or remove from the exclusion list defined by the classification scope.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3ClassificationScopeUpdate.Builder}
         * avoiding the need to create one manually via {@link S3ClassificationScopeUpdate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3ClassificationScopeUpdate.Builder#build()} is called
         * immediately and its result is passed to {@link #s3(S3ClassificationScopeUpdate)}.
         * 
         * @param s3
         *        a consumer that will call methods on {@link S3ClassificationScopeUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3(S3ClassificationScopeUpdate)
         */
        default Builder s3(Consumer<S3ClassificationScopeUpdate.Builder> s3) {
            return s3(S3ClassificationScopeUpdate.builder().applyMutation(s3).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Macie2Request.BuilderImpl implements Builder {
        private String id;

        private S3ClassificationScopeUpdate s3;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateClassificationScopeRequest model) {
            super(model);
            id(model.id);
            s3(model.s3);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final S3ClassificationScopeUpdate.Builder getS3() {
            return s3 != null ? s3.toBuilder() : null;
        }

        public final void setS3(S3ClassificationScopeUpdate.BuilderImpl s3) {
            this.s3 = s3 != null ? s3.build() : null;
        }

        @Override
        public final Builder s3(S3ClassificationScopeUpdate s3) {
            this.s3 = s3;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateClassificationScopeRequest build() {
            return new UpdateClassificationScopeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
