/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateResourceProfileDetectionsRequest extends Macie2Request implements
        ToCopyableBuilder<UpdateResourceProfileDetectionsRequest.Builder, UpdateResourceProfileDetectionsRequest> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceArn").getter(getter(UpdateResourceProfileDetectionsRequest::resourceArn))
            .setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("resourceArn").build()).build();

    private static final SdkField<List<SuppressDataIdentifier>> SUPPRESS_DATA_IDENTIFIERS_FIELD = SdkField
            .<List<SuppressDataIdentifier>> builder(MarshallingType.LIST)
            .memberName("suppressDataIdentifiers")
            .getter(getter(UpdateResourceProfileDetectionsRequest::suppressDataIdentifiers))
            .setter(setter(Builder::suppressDataIdentifiers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suppressDataIdentifiers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SuppressDataIdentifier> builder(MarshallingType.SDK_POJO)
                                            .constructor(SuppressDataIdentifier::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD,
            SUPPRESS_DATA_IDENTIFIERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("resourceArn", RESOURCE_ARN_FIELD);
                    put("suppressDataIdentifiers", SUPPRESS_DATA_IDENTIFIERS_FIELD);
                }
            });

    private final String resourceArn;

    private final List<SuppressDataIdentifier> suppressDataIdentifiers;

    private UpdateResourceProfileDetectionsRequest(BuilderImpl builder) {
        super(builder);
        this.resourceArn = builder.resourceArn;
        this.suppressDataIdentifiers = builder.suppressDataIdentifiers;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the S3 bucket that the request applies to.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the S3 bucket that the request applies to.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the SuppressDataIdentifiers property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSuppressDataIdentifiers() {
        return suppressDataIdentifiers != null && !(suppressDataIdentifiers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects, one for each custom data identifier or managed data identifier that detected the type of
     * sensitive data to start excluding or including in the bucket's score. To start including all sensitive data types
     * in the score, don't specify any values for this array.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSuppressDataIdentifiers} method.
     * </p>
     * 
     * @return An array of objects, one for each custom data identifier or managed data identifier that detected the
     *         type of sensitive data to start excluding or including in the bucket's score. To start including all
     *         sensitive data types in the score, don't specify any values for this array.
     */
    public final List<SuppressDataIdentifier> suppressDataIdentifiers() {
        return suppressDataIdentifiers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasSuppressDataIdentifiers() ? suppressDataIdentifiers() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateResourceProfileDetectionsRequest)) {
            return false;
        }
        UpdateResourceProfileDetectionsRequest other = (UpdateResourceProfileDetectionsRequest) obj;
        return Objects.equals(resourceArn(), other.resourceArn())
                && hasSuppressDataIdentifiers() == other.hasSuppressDataIdentifiers()
                && Objects.equals(suppressDataIdentifiers(), other.suppressDataIdentifiers());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateResourceProfileDetectionsRequest").add("ResourceArn", resourceArn())
                .add("SuppressDataIdentifiers", hasSuppressDataIdentifiers() ? suppressDataIdentifiers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "suppressDataIdentifiers":
            return Optional.ofNullable(clazz.cast(suppressDataIdentifiers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateResourceProfileDetectionsRequest, T> g) {
        return obj -> g.apply((UpdateResourceProfileDetectionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Macie2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateResourceProfileDetectionsRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the S3 bucket that the request applies to.
         * </p>
         * 
         * @param resourceArn
         *        The Amazon Resource Name (ARN) of the S3 bucket that the request applies to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * An array of objects, one for each custom data identifier or managed data identifier that detected the type of
         * sensitive data to start excluding or including in the bucket's score. To start including all sensitive data
         * types in the score, don't specify any values for this array.
         * </p>
         * 
         * @param suppressDataIdentifiers
         *        An array of objects, one for each custom data identifier or managed data identifier that detected the
         *        type of sensitive data to start excluding or including in the bucket's score. To start including all
         *        sensitive data types in the score, don't specify any values for this array.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suppressDataIdentifiers(Collection<SuppressDataIdentifier> suppressDataIdentifiers);

        /**
         * <p>
         * An array of objects, one for each custom data identifier or managed data identifier that detected the type of
         * sensitive data to start excluding or including in the bucket's score. To start including all sensitive data
         * types in the score, don't specify any values for this array.
         * </p>
         * 
         * @param suppressDataIdentifiers
         *        An array of objects, one for each custom data identifier or managed data identifier that detected the
         *        type of sensitive data to start excluding or including in the bucket's score. To start including all
         *        sensitive data types in the score, don't specify any values for this array.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suppressDataIdentifiers(SuppressDataIdentifier... suppressDataIdentifiers);

        /**
         * <p>
         * An array of objects, one for each custom data identifier or managed data identifier that detected the type of
         * sensitive data to start excluding or including in the bucket's score. To start including all sensitive data
         * types in the score, don't specify any values for this array.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.macie2.model.SuppressDataIdentifier.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.macie2.model.SuppressDataIdentifier#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.macie2.model.SuppressDataIdentifier.Builder#build()} is called
         * immediately and its result is passed to {@link #suppressDataIdentifiers(List<SuppressDataIdentifier>)}.
         * 
         * @param suppressDataIdentifiers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.macie2.model.SuppressDataIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #suppressDataIdentifiers(java.util.Collection<SuppressDataIdentifier>)
         */
        Builder suppressDataIdentifiers(Consumer<SuppressDataIdentifier.Builder>... suppressDataIdentifiers);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Macie2Request.BuilderImpl implements Builder {
        private String resourceArn;

        private List<SuppressDataIdentifier> suppressDataIdentifiers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateResourceProfileDetectionsRequest model) {
            super(model);
            resourceArn(model.resourceArn);
            suppressDataIdentifiers(model.suppressDataIdentifiers);
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final List<SuppressDataIdentifier.Builder> getSuppressDataIdentifiers() {
            List<SuppressDataIdentifier.Builder> result = ___listOfSuppressDataIdentifierCopier
                    .copyToBuilder(this.suppressDataIdentifiers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSuppressDataIdentifiers(Collection<SuppressDataIdentifier.BuilderImpl> suppressDataIdentifiers) {
            this.suppressDataIdentifiers = ___listOfSuppressDataIdentifierCopier.copyFromBuilder(suppressDataIdentifiers);
        }

        @Override
        public final Builder suppressDataIdentifiers(Collection<SuppressDataIdentifier> suppressDataIdentifiers) {
            this.suppressDataIdentifiers = ___listOfSuppressDataIdentifierCopier.copy(suppressDataIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suppressDataIdentifiers(SuppressDataIdentifier... suppressDataIdentifiers) {
            suppressDataIdentifiers(Arrays.asList(suppressDataIdentifiers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suppressDataIdentifiers(Consumer<SuppressDataIdentifier.Builder>... suppressDataIdentifiers) {
            suppressDataIdentifiers(Stream.of(suppressDataIdentifiers)
                    .map(c -> SuppressDataIdentifier.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateResourceProfileDetectionsRequest build() {
            return new UpdateResourceProfileDetectionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
